/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.threadly.concurrent.future.AbstractCompletedListenableFuture;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.InternalFutureUtils;
import org.threadly.concurrent.future.ListenableFuture;

public class ImmediateFailureListenableFuture<T>
extends AbstractCompletedListenableFuture<T> {
    protected final Throwable failure;

    public ImmediateFailureListenableFuture(Throwable failure) {
        this.failure = failure != null ? failure : new Exception();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return true;
    }

    @Override
    public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            callback.handleFailure(this.failure);
        } else {
            executor.execute(() -> callback.handleFailure(this.failure));
        }
        return this;
    }

    @Override
    public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        return this;
    }

    @Override
    public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            callback.accept(this.failure);
        } else {
            executor.execute(() -> callback.accept(this.failure));
        }
        return this;
    }

    @Override
    public T get() throws ExecutionException {
        throw new ExecutionException(this.failure);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        throw new ExecutionException(this.failure);
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public Throwable getFailure(long timeout, TimeUnit unit) {
        return this.failure;
    }
}

