/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threadly.concurrent.future.ListenableFutureTask;

public class ExecuteOnGetFutureTask<T>
extends ListenableFutureTask<T> {
    private final AtomicBoolean executionStarted = new AtomicBoolean(false);

    public ExecuteOnGetFutureTask(Runnable task) {
        super(task);
    }

    public ExecuteOnGetFutureTask(Runnable task, T result) {
        super(task, result);
    }

    public ExecuteOnGetFutureTask(Callable<T> task) {
        super(task);
    }

    protected void executeIfNotStarted() {
        if (!this.executionStarted.getPlain() && this.executionStarted.compareAndSet(false, true)) {
            super.run();
        }
    }

    @Override
    public void run() {
        this.executeIfNotStarted();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.executeIfNotStarted();
        return (T)super.get();
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.executeIfNotStarted();
        return super.getFailure();
    }
}

