/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionHandler;

public class ThreadReferencingThreadFactory
extends ConfigurableThreadFactory {
    private static final int REFERENCE_QUEUE_CHECK_INTERVAL_MILLIS = 10000;
    private final Collection<WeakReference<Thread>> threads = new ConcurrentLinkedQueue<WeakReference<Thread>>();
    private volatile long lastCleanupTime = Clock.lastKnownForwardProgressingMillis();

    public static ThreadReferencingThreadFactoryBuilder builder() {
        return new ThreadReferencingThreadFactoryBuilder();
    }

    public ThreadReferencingThreadFactory() {
        this(null, true, false, 5, null, null, null);
    }

    public ThreadReferencingThreadFactory(String threadNamePrefix, boolean appendPoolIdToPrefix) {
        this(threadNamePrefix, appendPoolIdToPrefix, false, 5, null, null, null);
    }

    public ThreadReferencingThreadFactory(boolean useDaemonThreads) {
        this(null, true, useDaemonThreads, 5, null, null, null);
    }

    public ThreadReferencingThreadFactory(int threadPriority) {
        this(null, true, false, threadPriority, null, null, null);
    }

    public ThreadReferencingThreadFactory(Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler) {
        this(null, true, false, 5, defaultUncaughtExceptionHandler, null, null);
    }

    public ThreadReferencingThreadFactory(ExceptionHandler defaultThreadlyExceptionHandler) {
        this(null, true, false, 5, null, defaultThreadlyExceptionHandler, null);
    }

    public ThreadReferencingThreadFactory(Consumer<Thread> notifyThreadCreation) {
        this(null, true, false, 5, null, null, notifyThreadCreation);
    }

    public ThreadReferencingThreadFactory(String threadNamePrefix, boolean appendPoolIdToPrefix, boolean useDaemonThreads, int threadPriority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ExceptionHandler defaultThreadlyExceptionHandler, Consumer<Thread> notifyThreadCreation) {
        super(threadNamePrefix, appendPoolIdToPrefix, useDaemonThreads, threadPriority, uncaughtExceptionHandler, defaultThreadlyExceptionHandler, notifyThreadCreation);
    }

    public List<Thread> getThreads(boolean requireAlive) {
        ArrayList<Thread> result = new ArrayList<Thread>(this.threads.size());
        Iterator<WeakReference<Thread>> it = this.threads.iterator();
        while (it.hasNext()) {
            Thread t = (Thread)it.next().get();
            if (t == null) {
                it.remove();
                continue;
            }
            if (requireAlive && !t.isAlive()) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread result = super.newThread(r);
        if (Clock.lastKnownForwardProgressingMillis() - this.lastCleanupTime > 10000L) {
            this.lastCleanupTime = Clock.lastKnownForwardProgressingMillis();
            Iterator<WeakReference<Thread>> it = this.threads.iterator();
            while (it.hasNext()) {
                if (it.next().get() != null) continue;
                it.remove();
            }
        }
        this.threads.add(new WeakReference<Thread>(result));
        return result;
    }

    public static class ThreadReferencingThreadFactoryBuilder
    extends ConfigurableThreadFactory.ConfigurableThreadFactoryBuilder {
        @Override
        public ThreadReferencingThreadFactoryBuilder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        @Override
        public ThreadReferencingThreadFactoryBuilder appendPoolIdToPrefix(boolean appendPoolIdToPrefix) {
            this.appendPoolIdToPrefix = appendPoolIdToPrefix;
            return this;
        }

        @Override
        public ThreadReferencingThreadFactoryBuilder useDaemonThreads(boolean useDaemonThreads) {
            this.useDaemonThreads = useDaemonThreads;
            return this;
        }

        @Override
        public ThreadReferencingThreadFactoryBuilder threadPriority(int threadPriority) {
            this.threadPriority = threadPriority;
            return this;
        }

        @Override
        public ThreadReferencingThreadFactoryBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.threadlyExceptionHandler = exceptionHandler;
            return this;
        }

        @Override
        public ConfigurableThreadFactory.ConfigurableThreadFactoryBuilder onThreadCreation(Consumer<Thread> notifyThreadCreation) {
            this.notifyThreadCreation = notifyThreadCreation;
            return this;
        }

        @Override
        public ThreadReferencingThreadFactory build() {
            return new ThreadReferencingThreadFactory(this.threadNamePrefix, this.appendPoolIdToPrefix, this.useDaemonThreads, this.threadPriority, null, this.threadlyExceptionHandler, this.notifyThreadCreation);
        }
    }
}

