/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.TaskPriority;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;

public class PriorityScheduler
extends AbstractPriorityScheduler {
    protected static final boolean DEFAULT_NEW_THREADS_DAEMON = true;
    protected static final boolean DEFAULT_STARVABLE_STARTS_THREADS = false;
    protected final WorkerPool workerPool;
    protected final AbstractPriorityScheduler.QueueManager queueManager;

    public PriorityScheduler(int poolSize) {
        this(poolSize, null, 500L, true);
    }

    public PriorityScheduler(int poolSize, boolean useDaemonThreads) {
        this(poolSize, null, 500L, useDaemonThreads);
    }

    public PriorityScheduler(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, true);
    }

    public PriorityScheduler(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean useDaemonThreads) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, false, new ConfigurableThreadFactory(PriorityScheduler.class.getSimpleName() + "-", true, useDaemonThreads, 5, null, null, null));
    }

    public PriorityScheduler(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, false, threadFactory);
    }

    public PriorityScheduler(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean stavableStartsThreads, ThreadFactory threadFactory) {
        this(new WorkerPool(threadFactory, poolSize, stavableStartsThreads), defaultPriority, maxWaitForLowPriorityInMs);
    }

    protected PriorityScheduler(WorkerPool workerPool, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        super(defaultPriority);
        this.workerPool = workerPool;
        this.queueManager = new AbstractPriorityScheduler.QueueManager(workerPool, maxWaitForLowPriorityInMs);
        workerPool.start(this.queueManager);
    }

    public int getMaxPoolSize() {
        return this.workerPool.getMaxPoolSize();
    }

    public int getCurrentPoolSize() {
        return this.workerPool.getCurrentPoolSize();
    }

    public void setPoolSize(int newPoolSize) {
        this.workerPool.setPoolSize(newPoolSize);
    }

    public void adjustPoolSize(int delta) {
        this.workerPool.adjustPoolSize(delta);
    }

    @Override
    public int getActiveTaskCount() {
        return this.workerPool.getActiveTaskCount();
    }

    public void prestartAllThreads() {
        this.workerPool.prestartAllThreads();
    }

    @Override
    public boolean isShutdown() {
        return this.workerPool.isShutdownStarted();
    }

    public void shutdown() {
        this.workerPool.startShutdown();
    }

    public List<Runnable> shutdownNow() {
        this.workerPool.startShutdown();
        List<Runnable> awaitingTasks = this.queueManager.clearQueue();
        this.workerPool.finishShutdown();
        return awaitingTasks;
    }

    public void awaitTermination() throws InterruptedException {
        this.awaitTermination(Long.MAX_VALUE);
    }

    public boolean awaitTermination(long timeoutMillis) throws InterruptedException {
        return this.workerPool.awaitTermination(timeoutMillis);
    }

    @Override
    public int getQueuedTaskCount() {
        return super.getQueuedTaskCount() - 1;
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return super.getQueuedTaskCount(priority) - (priority == TaskPriority.Starvable ? 1 : 0);
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        AbstractPriorityScheduler.OneTimeTaskWrapper result;
        if (delayInMillis == 0L) {
            AbstractPriorityScheduler.QueueSet queueSet = this.queueManager.getQueueSet(priority);
            result = new AbstractPriorityScheduler.ImmediateTaskWrapper(task, queueSet.executeQueue);
            this.queueExecute(queueSet, result);
        } else if (priority == TaskPriority.High) {
            result = new AbstractPriorityScheduler.AccurateOneTimeTaskWrapper(task, this.queueManager.highPriorityQueueSet.scheduleQueue, Clock.accurateForwardProgressingMillis() + delayInMillis);
            this.queueScheduled(this.queueManager.highPriorityQueueSet, result);
        } else if (priority == TaskPriority.Low) {
            result = new AbstractPriorityScheduler.GuessOneTimeTaskWrapper(task, this.queueManager.lowPriorityQueueSet.scheduleQueue, Clock.accurateForwardProgressingMillis() + delayInMillis);
            this.queueScheduled(this.queueManager.lowPriorityQueueSet, result);
        } else {
            result = new AbstractPriorityScheduler.GuessOneTimeTaskWrapper(task, this.queueManager.starvablePriorityQueueSet.scheduleQueue, Clock.accurateForwardProgressingMillis() + delayInMillis);
            this.queueScheduled(this.queueManager.starvablePriorityQueueSet, result);
        }
        return result;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertNotNegative(recurringDelay, "recurringDelay");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        if (priority == TaskPriority.High) {
            this.queueScheduled(this.queueManager.highPriorityQueueSet, new AbstractPriorityScheduler.AccurateRecurringDelayTaskWrapper(task, this.queueManager.highPriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, recurringDelay));
        } else if (priority == TaskPriority.Low) {
            this.queueScheduled(this.queueManager.lowPriorityQueueSet, new AbstractPriorityScheduler.GuessRecurringDelayTaskWrapper(task, this.queueManager.lowPriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, recurringDelay));
        } else {
            this.queueScheduled(this.queueManager.starvablePriorityQueueSet, new AbstractPriorityScheduler.GuessRecurringDelayTaskWrapper(task, this.queueManager.starvablePriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, recurringDelay));
        }
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertGreaterThanZero(period, "period");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        if (priority == TaskPriority.High) {
            this.queueScheduled(this.queueManager.highPriorityQueueSet, new AbstractPriorityScheduler.AccurateRecurringRateTaskWrapper(task, this.queueManager.highPriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, period));
        } else if (priority == TaskPriority.Low) {
            this.queueScheduled(this.queueManager.lowPriorityQueueSet, new AbstractPriorityScheduler.GuessRecurringRateTaskWrapper(task, this.queueManager.lowPriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, period));
        } else {
            this.queueScheduled(this.queueManager.starvablePriorityQueueSet, new AbstractPriorityScheduler.GuessRecurringRateTaskWrapper(task, this.queueManager.starvablePriorityQueueSet, Clock.accurateForwardProgressingMillis() + initialDelay, period));
        }
    }

    protected void queueExecute(AbstractPriorityScheduler.QueueSet queueSet, AbstractPriorityScheduler.OneTimeTaskWrapper task) {
        if (this.workerPool.isShutdownStarted()) {
            throw new RejectedExecutionException("Thread pool shutdown");
        }
        queueSet.addExecute(task);
    }

    protected void queueScheduled(AbstractPriorityScheduler.QueueSet queueSet, AbstractPriorityScheduler.TaskWrapper task) {
        if (this.workerPool.isShutdownStarted()) {
            throw new RejectedExecutionException("Thread pool shutdown");
        }
        queueSet.addScheduled(task);
    }

    protected void finalize() {
        this.shutdown();
    }

    @Override
    protected AbstractPriorityScheduler.QueueManager getQueueManager() {
        return this.queueManager;
    }

    protected static final class ShutdownRunnable
    implements AbstractPriorityScheduler.InternalRunnable {
        private final WorkerPool wm;

        protected ShutdownRunnable(WorkerPool wm) {
            this.wm = wm;
        }

        @Override
        public void run() {
            this.wm.finishShutdown();
        }
    }

    protected static class Worker
    implements Runnable {
        protected final WorkerPool workerPool;
        protected final Thread thread;
        protected volatile Worker nextIdleWorker = null;
        protected volatile boolean waitingForUnpark;
        private volatile boolean running;

        public Worker(WorkerPool workerPool, ThreadFactory threadFactory) {
            this.workerPool = workerPool;
            this.thread = threadFactory.newThread(this);
            if (this.thread.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }

        public void startWorker() {
            this.running = true;
            this.thread.start();
        }

        public void stopWorker() {
            this.running = false;
            LockSupport.unpark(this.thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                AbstractPriorityScheduler.TaskWrapper nextTask = this.workerPool.workerIdle(this);
                if (nextTask == null) continue;
                nextTask.runTask();
            }
            Object object = this.workerPool.workerStopNotifyLock;
            synchronized (object) {
                this.workerPool.workerStopNotifyLock.notifyAll();
            }
        }
    }

    protected static class WorkerPool
    implements AbstractPriorityScheduler.QueueSetListener {
        private final AbstractPriorityScheduler.InternalRunnable poolSizeChangeTask = new AbstractPriorityScheduler.InternalRunnable(){

            @Override
            public void run() {
                if (currentPoolSize.get() > maxPoolSize) {
                    this.addPoolStateChangeTask(this);
                }
            }
        };
        protected final ThreadFactory threadFactory;
        protected final boolean stavableStartsThreads;
        protected final Object poolSizeChangeLock;
        protected final Object idleWorkerDequeLock;
        protected final LongAdder idleWorkerCount;
        protected final AtomicReference<Worker> idleWorker;
        protected final AtomicInteger currentPoolSize;
        protected final Object workerStopNotifyLock;
        private final AtomicBoolean shutdownStarted;
        private volatile int maxPoolSize;
        private volatile long workerTimedParkRunTime;
        private AbstractPriorityScheduler.QueueManager queueManager;

        public WorkerPool(ThreadFactory threadFactory, int poolSize, boolean stavableStartsThreads) {
            ArgumentVerifier.assertGreaterThanZero(poolSize, "poolSize");
            if (threadFactory == null) {
                threadFactory = new ConfigurableThreadFactory(PriorityScheduler.class.getSimpleName() + "-", true);
            }
            this.poolSizeChangeLock = new Object();
            this.idleWorkerDequeLock = new Object();
            this.idleWorkerCount = new LongAdder();
            this.idleWorker = new AtomicReference<Object>(null);
            this.currentPoolSize = new AtomicInteger(0);
            this.workerStopNotifyLock = new Object();
            this.threadFactory = threadFactory;
            this.stavableStartsThreads = stavableStartsThreads;
            this.maxPoolSize = poolSize;
            this.workerTimedParkRunTime = Long.MAX_VALUE;
            this.shutdownStarted = new AtomicBoolean(false);
        }

        public void start(AbstractPriorityScheduler.QueueManager queueManager) {
            if (this.currentPoolSize.get() != 0) {
                throw new IllegalStateException();
            }
            this.queueManager = queueManager;
            AbstractPriorityScheduler.InternalRunnable doNothingRunnable = new AbstractPriorityScheduler.InternalRunnable(){

                @Override
                public void run() {
                }
            };
            queueManager.starvablePriorityQueueSet.scheduleQueue.add(new AbstractPriorityScheduler.GuessRecurringRateTaskWrapper(doNothingRunnable, queueManager.starvablePriorityQueueSet, Clock.lastKnownForwardProgressingMillis() + Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        public boolean isShutdownStarted() {
            return this.shutdownStarted.get();
        }

        public boolean startShutdown() {
            if (this.shutdownStarted.getAndSet(true)) {
                return false;
            }
            this.queueManager.lowPriorityQueueSet.addExecute(new AbstractPriorityScheduler.ImmediateTaskWrapper(new ShutdownRunnable(this), this.queueManager.lowPriorityQueueSet.executeQueue));
            return true;
        }

        public boolean isShutdownFinished() {
            return this.maxPoolSize == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishShutdown() {
            Object object = this.poolSizeChangeLock;
            synchronized (object) {
                this.maxPoolSize = 0;
            }
            this.handleMaxPoolSizeChange(false);
        }

        private void addPoolStateChangeTask(AbstractPriorityScheduler.InternalRunnable task) {
            this.queueManager.starvablePriorityQueueSet.addExecute(new AbstractPriorityScheduler.ImmediateTaskWrapper(task, this.queueManager.starvablePriorityQueueSet.executeQueue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean awaitTermination(long timeoutMillis) throws InterruptedException {
            long start = timeoutMillis < Long.MAX_VALUE ? Clock.accurateForwardProgressingMillis() : Clock.lastKnownForwardProgressingMillis();
            Object object = this.workerStopNotifyLock;
            synchronized (object) {
                long remainingMillis;
                while ((this.maxPoolSize > 0 || this.currentPoolSize.get() > 0) && (remainingMillis = timeoutMillis - (Clock.lastKnownForwardProgressingMillis() - start)) > 0L) {
                    this.workerStopNotifyLock.wait(remainingMillis);
                }
            }
            return this.maxPoolSize == 0 && this.currentPoolSize.get() == 0;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPoolSize(int newPoolSize) {
            boolean poolSizeIncrease;
            ArgumentVerifier.assertGreaterThanZero(newPoolSize, "newPoolSize");
            if (newPoolSize == this.maxPoolSize) {
                return;
            }
            Object object = this.poolSizeChangeLock;
            synchronized (object) {
                if (this.maxPoolSize == 0) {
                    throw new IllegalStateException("Can not adjust pool size during or after shutdown");
                }
                poolSizeIncrease = newPoolSize > this.maxPoolSize;
                this.maxPoolSize = newPoolSize;
            }
            this.handleMaxPoolSizeChange(poolSizeIncrease);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustPoolSize(int delta) {
            if (delta == 0) {
                return;
            }
            Object object = this.poolSizeChangeLock;
            synchronized (object) {
                if (this.maxPoolSize == 0) {
                    throw new IllegalStateException("Can not adjust pool size during or after shutdown");
                }
                if (this.maxPoolSize + delta < 1) {
                    throw new IllegalStateException(this.maxPoolSize + " " + delta + " must be at least 1");
                }
                this.maxPoolSize += delta;
            }
            this.handleMaxPoolSizeChange(delta > 0);
        }

        protected void handleMaxPoolSizeChange(boolean poolSizeIncrease) {
            if (poolSizeIncrease) {
                this.handleQueueUpdate();
            } else if (this.currentPoolSize.get() > this.maxPoolSize) {
                this.addPoolStateChangeTask(this.poolSizeChangeTask);
            }
        }

        public int getCurrentPoolSize() {
            return this.currentPoolSize.get();
        }

        public int getActiveTaskCount() {
            int result;
            int poolSize;
            do {
                poolSize = this.currentPoolSize.get();
                result = poolSize - this.idleWorkerCount.intValue();
            } while (poolSize != this.currentPoolSize.get());
            return result;
        }

        public void prestartAllThreads() {
            int casPoolSize;
            while ((casPoolSize = this.currentPoolSize.get()) < this.maxPoolSize) {
                if (!this.currentPoolSize.weakCompareAndSetVolatile(casPoolSize, casPoolSize + 1)) continue;
                this.makeNewWorker();
            }
        }

        protected void makeNewWorker() {
            Worker w = new Worker(this, this.threadFactory);
            w.startWorker();
        }

        protected void addWorkerToIdleChain(Worker worker) {
            this.idleWorkerCount.increment();
            worker.waitingForUnpark = false;
            Worker casWorker = this.idleWorker.get();
            while (true) {
                worker.nextIdleWorker = casWorker;
                Worker exchangeWorker = this.idleWorker.compareAndExchange(casWorker, worker);
                if (exchangeWorker == casWorker) break;
                casWorker = exchangeWorker;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeWorkerFromIdleChain(Worker worker) {
            this.idleWorkerCount.decrement();
            Object object = this.idleWorkerDequeLock;
            synchronized (object) {
                Worker holdingWorker = this.idleWorker.get();
                if (holdingWorker == worker && (holdingWorker = this.idleWorker.compareAndExchange(worker, worker.nextIdleWorker)) == worker) {
                    worker.nextIdleWorker = null;
                    return;
                }
                while (holdingWorker.nextIdleWorker != worker) {
                    holdingWorker = holdingWorker.nextIdleWorker;
                }
                holdingWorker.nextIdleWorker = worker.nextIdleWorker;
                worker.nextIdleWorker = null;
            }
        }

        public AbstractPriorityScheduler.TaskWrapper workerIdle(Worker worker) {
            int casPoolSize;
            while ((casPoolSize = this.currentPoolSize.get()) > this.maxPoolSize) {
                if (!this.currentPoolSize.weakCompareAndSetVolatile(casPoolSize, casPoolSize - 1)) continue;
                worker.stopWorker();
                return null;
            }
            boolean queued = false;
            block5: while (true) {
                while (true) {
                    AbstractPriorityScheduler.TaskWrapper nextTask;
                    if ((nextTask = this.queueManager.getNextTask(this.stavableStartsThreads || casPoolSize == 1 || this.currentPoolSize.get() >= this.maxPoolSize || worker.nextIdleWorker != null || this.shutdownStarted.get())) == null) {
                        if (queued) {
                            Thread.interrupted();
                            LockSupport.park();
                            worker.waitingForUnpark = false;
                            continue;
                        }
                        this.addWorkerToIdleChain(worker);
                        queued = true;
                        continue block5;
                    }
                    short executeReference = nextTask.getExecuteReference();
                    long taskDelay = nextTask.getScheduleDelay();
                    if (taskDelay > 0L) {
                        if (taskDelay == Long.MAX_VALUE) continue;
                        if (queued) {
                            Thread.interrupted();
                            if (nextTask.getPureRunTime() < this.workerTimedParkRunTime) {
                                this.workerTimedParkRunTime = nextTask.getPureRunTime();
                                LockSupport.parkNanos(1000000L * taskDelay);
                                worker.waitingForUnpark = false;
                                this.workerTimedParkRunTime = Long.MAX_VALUE;
                                continue;
                            }
                            LockSupport.park();
                            worker.waitingForUnpark = false;
                            continue;
                        }
                        this.addWorkerToIdleChain(worker);
                        queued = true;
                        continue block5;
                    }
                    if (nextTask.canExecute(executeReference)) {
                        AbstractPriorityScheduler.TaskWrapper taskWrapper = nextTask;
                        return taskWrapper;
                    }
                    Thread.yield();
                }
                break;
            }
            finally {
                if (queued) {
                    this.removeWorkerFromIdleChain(worker);
                }
                this.handleQueueUpdate();
                Thread.interrupted();
            }
        }

        @Override
        public void handleQueueUpdate() {
            block1: {
                Worker nextIdleWorker;
                while ((nextIdleWorker = this.idleWorker.get()) == null) {
                    int casSize = this.currentPoolSize.get();
                    if (casSize >= this.maxPoolSize) break block1;
                    if (!this.currentPoolSize.weakCompareAndSetVolatile(casSize, casSize + 1)) continue;
                    this.makeNewWorker();
                    break block1;
                }
                if (nextIdleWorker.waitingForUnpark) break block1;
                nextIdleWorker.waitingForUnpark = true;
                LockSupport.unpark(nextIdleWorker.thread);
            }
        }
    }
}

