/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Callable;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;

public abstract class AbstractSubmitterExecutor
implements SubmitterExecutor {
    protected abstract void doExecute(Runnable var1);

    @Override
    public void execute(Runnable task) {
        ArgumentVerifier.assertNotNull(task, "task");
        this.doExecute(task);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.submit(RunnableCallableAdapter.adapt(task, result));
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.doExecute(lft);
        return lft;
    }
}

