/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.DeathWaypointEvent;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.WaypointProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class DeathPointHandler {
    class_310 mc = class_310.method_1551();

    public void handlePlayerDeath() {
        if (JourneymapClient.getInstance().enabled() && this.mc.field_1724 != null) {
            this.createDeathpoint();
        }
    }

    private void createDeathpoint() {
        try {
            class_746 player = this.mc.field_1724;
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
            boolean enabled = waypointProperties.managerEnabled.get() != false && waypointProperties.createDeathpoints.get() != false && JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints();
            boolean cancelled = false;
            int buildMinY = player.method_37908().method_8597().comp_651() + 2;
            double playerY = Math.max(class_3532.method_15357((double)player.method_23318()), buildMinY);
            class_2338 pos = class_2338.method_49637((double)player.method_23317(), (double)playerY, (double)player.method_23321());
            if (enabled) {
                class_5321 dim = class_310.method_1551().field_1724.method_37908().method_27983();
                DeathWaypointEvent event = new DeathWaypointEvent(pos, dim);
                EventBus.post(event);
                if (!event.isCancelled()) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            Thread.sleep(3000L);
                            WaypointFactoryImpl.createDeathPoint(pos, dim.method_29177().toString());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }, (Executor)class_156.method_18349());
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.method_5477().getString(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }
}

