/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.client.impl.DisplayUpdateEventThrottle;
import journeymap.api.client.impl.PluginWrapper;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.DisplayUpdateEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.client.JourneymapClient;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
public class ClientEventManager {
    private final DisplayUpdateEventThrottle displayUpdateEventThrottle = new DisplayUpdateEventThrottle();
    private final Collection<PluginWrapper> plugins;

    public ClientEventManager(Collection<PluginWrapper> plugins) {
        this.plugins = plugins;
    }

    public void fireMappingEvent(boolean started, class_5321<class_1937> dimension) {
        MappingEvent.Stage type;
        MappingEvent.Stage stage = type = started ? MappingEvent.Stage.MAPPING_STARTED : MappingEvent.Stage.MAPPING_STOPPED;
        if (started) {
            ClientAPI.INSTANCE.refreshDataPathCache(false);
        }
        MappingEvent mappingEvent = new MappingEvent(type, dimension, JourneymapClient.getInstance().getCurrentWorldId());
        EventBus.post(mappingEvent);
        if (!started) {
            ClientAPI.INSTANCE.refreshDataPathCache(true);
        } else {
            JourneymapClient.getInstance().setCurrentWorldId(mappingEvent.getWorldId());
        }
    }

    public void queueDisplayUpdateEvent(DisplayUpdateEvent clientEvent) {
        try {
            this.displayUpdateEventThrottle.add(clientEvent);
        }
        catch (Throwable t) {
            ClientAPI.INSTANCE.logError("Error in fireDisplayUpdateEvent(): " + String.valueOf(clientEvent), t);
        }
    }

    public void fireNextClientEvents() {
        if (!this.plugins.isEmpty() && this.displayUpdateEventThrottle.isReady()) {
            Iterator<DisplayUpdateEvent> iterator = this.displayUpdateEventThrottle.iterator();
            while (iterator.hasNext()) {
                DisplayUpdateEvent event = iterator.next();
                iterator.remove();
                try {
                    EventBus.post(event);
                }
                catch (Throwable t) {
                    ClientAPI.INSTANCE.logError("Error in fireDeathpointEvent(): " + String.valueOf(event), t);
                }
            }
        }
    }

    void purge() {
        this.plugins.clear();
    }
}

