/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api;

import com.blamejared.searchables.api.SearchablesConstants;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class SearchableComponent<T> {
    private final String key;
    private final Function<T, Optional<String>> toString;
    private final BiPredicate<T, String> filter;

    private SearchableComponent(String key, Function<T, Optional<String>> toString, BiPredicate<T, String> filter) {
        this.key = key;
        this.toString = toString.andThen(s -> s.filter(SearchablesConstants.VALID_SUGGESTION));
        this.filter = filter;
    }

    public static <T> SearchableComponent<T> create(String key, BiPredicate<T, String> filter) {
        return SearchableComponent.create(key, t -> Optional.empty(), filter);
    }

    public static <T> SearchableComponent<T> create(String key, Function<T, Optional<String>> toString, BiPredicate<T, String> filter) {
        return new SearchableComponent<T>(key, toString, filter);
    }

    public static <T> SearchableComponent<T> create(String key, Function<T, Optional<String>> toString) {
        return new SearchableComponent<Object>(key, toString, (t, search) -> ((Optional)toString.apply(t)).map(tStr -> StringUtils.containsIgnoreCase((CharSequence)tStr, (CharSequence)search)).orElse(false));
    }

    public String key() {
        return this.key;
    }

    public BiPredicate<T, String> filter() {
        return this.filter;
    }

    public Function<T, Optional<String>> getToString() {
        return this.toString;
    }

    public String toString() {
        return new StringJoiner(", ", SearchableComponent.class.getSimpleName() + "[", "]").add("key='" + this.key + "'").toString();
    }
}

