/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.Content;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public record ConfiguratorComponent(class_2338 bound, boolean isBound, boolean selecting, boolean showInvBox, boolean massSelect, class_2338 boxStart, List<class_2338> selection, long lastAction) {
    private static final ConfiguratorComponent EMPTY = new ConfiguratorComponent(class_2338.field_10980, false, false, false, false, class_2338.field_10980, Collections.emptyList(), 0L);
    public static final Codec<ConfiguratorComponent> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)class_2338.field_25064.fieldOf("bound").forGetter(ConfiguratorComponent::bound), (App)Codec.BOOL.fieldOf("is_bound").forGetter(ConfiguratorComponent::isBound), (App)Codec.BOOL.fieldOf("selecting").forGetter(ConfiguratorComponent::selecting), (App)Codec.BOOL.fieldOf("show_inv_box").forGetter(ConfiguratorComponent::showInvBox), (App)Codec.BOOL.fieldOf("mass_select").forGetter(ConfiguratorComponent::massSelect), (App)class_2338.field_25064.fieldOf("box_start").forGetter(ConfiguratorComponent::boxStart), (App)Codec.list((Codec)class_2338.field_25064).fieldOf("selection").forGetter(ConfiguratorComponent::selection), (App)Codec.LONG.fieldOf("last_action").forGetter(ConfiguratorComponent::lastAction)).apply((Applicative)b, ConfiguratorComponent::new)).codec();

    public static ConfiguratorComponent empty() {
        return EMPTY;
    }

    public ConfiguratorComponent hiddenItem(long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, false, false, this.boxStart, this.selection, actionTime);
    }

    public ConfiguratorComponent showInv(List<class_2338> sel, long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, true, this.massSelect, this.boxStart, sel, actionTime);
    }

    public ConfiguratorComponent massSelectStart(class_2338 pos, long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, true, pos, this.selection, actionTime);
    }

    public ConfiguratorComponent massSelectEnd(long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, false, class_2338.field_10980, this.selection, actionTime);
    }

    public ConfiguratorComponent massSelectEnd(List<class_2338> sel, long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, false, class_2338.field_10980, sel, actionTime);
    }

    public ConfiguratorComponent setSelection(List<class_2338> sel, long actionTime) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, this.massSelect, this.boxStart, sel, actionTime);
    }

    public static class Configurator {
        private class_1799 stack;
        private ConfiguratorComponent comp;
        private long actionTime;

        public Configurator(class_1799 stack, long actionTime) {
            this.stack = stack;
            this.comp = (ConfiguratorComponent)stack.method_58694(Content.configuratorComponent.get());
            this.actionTime = actionTime;
        }

        public boolean debounce() {
            return this.actionTime - this.comp.lastAction() < 3L;
        }

        public class_2338 bound() {
            return this.comp.bound();
        }

        public class_2338 boxStart() {
            return this.comp.boxStart();
        }

        public boolean isBound() {
            return this.comp.isBound();
        }

        public boolean massSelect() {
            return this.comp.massSelect();
        }

        public boolean selecting() {
            return this.comp.selecting();
        }

        public List<class_2338> selection() {
            return this.comp.selection();
        }

        public boolean showInvBox() {
            return this.comp.showInvBox();
        }

        public void massSelectStart(class_2338 pos) {
            this.set(this.comp.massSelectStart(pos, this.actionTime));
        }

        public void massSelectEnd() {
            this.set(this.comp.massSelectEnd(this.actionTime));
        }

        public void clear() {
            this.set(EMPTY);
        }

        public void showInvBox(Collection<class_2338> sel) {
            this.set(this.comp.showInv(new ArrayList<class_2338>(sel), this.actionTime));
        }

        public void massSelectEnd(Collection<class_2338> sel) {
            this.set(this.comp.massSelectEnd(new ArrayList<class_2338>(sel), this.actionTime));
        }

        public void setSelection(Collection<class_2338> sel) {
            this.set(this.comp.setSelection(new ArrayList<class_2338>(sel), this.actionTime));
        }

        public void startSelection(class_2338 bind, Collection<class_2338> sel) {
            this.set(new ConfiguratorComponent(bind, true, true, false, false, class_2338.field_10980, new ArrayList<class_2338>(sel), this.actionTime));
        }

        private void set(ConfiguratorComponent c) {
            this.comp = c;
            this.stack.method_57379(Content.configuratorComponent.get(), (Object)c);
        }
    }
}

