/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_7764;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityDrawersRenderer
implements class_827<BlockEntityDrawers> {
    private final class_1799[] renderStacks = new class_1799[4];
    private class_918 itemRenderer;
    private class_10444 itemRenderState = new class_10444();
    private class_5819 randomSource = class_5819.method_43047();
    private final class_5614.class_5615 context;
    private static final int TEXT_COLOR_TRANSPARENT = class_9848.method_61324((int)0, (int)255, (int)255, (int)255);
    private static final Matrix3f ITEM_LIGHT_ROTATION_3D = new Matrix3f().rotationYXZ(0.36f, -0.36f, -0.014f);
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final class_2960 TEXTURE_IND_1 = ModConstants.loc("block/indicator/indicator_1_on");
    public static final class_2960 TEXTURE_IND_2 = ModConstants.loc("block/indicator/indicator_2_on");
    public static final class_2960 TEXTURE_IND_4 = ModConstants.loc("block/indicator/indicator_4_on");
    public static final class_2960 TEXTURE_IND_COMP_3 = ModConstants.loc("block/indicator/indicator_comp_on");
    public static final class_2960 TEXTURE_IND_COMP_2 = ModConstants.loc("block/indicator/indicator_comp2_on");

    public BlockEntityDrawersRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityDrawers blockEntityDrawers, float partialTickTime, @NotNull class_4587 matrix, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay, class_243 camPosition) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1937 level = blockEntityDrawers.method_10997();
        if (level == null) {
            return;
        }
        class_2680 state = blockEntityDrawers.method_11010();
        if (!(state.method_26204() instanceof BlockDrawers)) {
            return;
        }
        class_2350 side = (class_2350)state.method_11654((class_2769)BlockDrawers.field_11177);
        if (this.playerBehindBlock(blockEntityDrawers.method_11016(), side)) {
            return;
        }
        float distance = (float)Math.sqrt(blockEntityDrawers.method_11016().method_19770((class_2374)player.method_19538()));
        double renderDistance = (Double)ModClientConfig.INSTANCE.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        this.itemRenderer = class_310.method_1551().method_1480();
        int enforcedLightLevel = blockEntityDrawers.upgrades().hasIlluminationUpgrade() ? (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.illuminationLevel.get() : (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.minIlluminationLevel.get();
        int blockLight = Math.max(combinedLight % 65536, enforcedLightLevel * 16);
        combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        if (!blockEntityDrawers.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(blockEntityDrawers, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime, distance);
        }
        if (blockEntityDrawers.getDrawerAttributes().hasFillLevel()) {
            this.renderIndicator((BlockDrawers)state.method_26204(), blockEntityDrawers, matrix, buffer, (class_2350)state.method_11654((class_2769)BlockDrawers.field_11177), combinedLight, combinedOverlay);
        }
    }

    private boolean playerBehindBlock(class_2338 blockPos, class_2350 facing) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_2338 playerPos = player.method_24515();
        return switch (facing) {
            case class_2350.field_11043 -> {
                if (playerPos.method_10260() > blockPos.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (playerPos.method_10260() < blockPos.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (playerPos.method_10263() > blockPos.method_10263()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (playerPos.method_10263() < blockPos.method_10263()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderFastItemSet(BlockEntityDrawers blockEntityDrawers, class_2680 state, class_4587 matrix, class_4597 buffer, int combinedLight, int combinedOverlay, class_2350 side, float partialTickTime, float distance) {
        int i;
        int drawerCount = blockEntityDrawers.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            class_1799 itemStack;
            this.renderStacks[i] = class_1799.field_8037;
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
        }
        for (i = 0; i < drawerCount; ++i) {
            class_1799 itemStack = this.renderStacks[i];
            if (itemStack.method_7960()) continue;
            this.renderFastItem(itemStack, state, i, matrix, buffer, combinedLight, combinedOverlay, side);
        }
        if (blockEntityDrawers.getDrawerAttributes().isShowingQuantity()) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ModClientConfig.INSTANCE.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ModClientConfig.INSTANCE.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.context.method_32143(), blockEntityDrawers.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, buffer, combinedLight, side, alpha);
                }
            }
        }
    }

    private void renderText(String text, class_2680 state, int slot, class_4587 matrix, class_4597 buffer, int combinedLight, class_2350 side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        class_327 fontRenderer = this.context.method_32143();
        BlockDrawers block = (BlockDrawers)state.method_26204();
        class_238 labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.method_1727(text);
        float x = (float)(labelGeometry.field_1323 + labelGeometry.method_17939() / 2.0);
        float y = 16.0f - (float)labelGeometry.field_1322 - (float)labelGeometry.method_17940();
        float z = (float)labelGeometry.field_1321 * 0.0625f - 0.01f;
        matrix.method_22903();
        this.alignRendering(matrix, side);
        matrix.method_46416(x / 16.0f, 1.0f - y / 16.0f, 1.0f - z);
        matrix.method_22905(0.0078125f, -0.0078125f, 1.0f);
        int color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        fontRenderer.method_27521(text, (float)(-textWidth) / 2.0f, 0.0f, color, false, matrix.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, 0, combinedLight);
        matrix.method_22909();
    }

    private void renderFastItem(@NotNull class_1799 itemStack, class_2680 state, int slot, class_4587 matrix, class_4597 buffer, int combinedLight, int combinedOverlay, class_2350 side) {
        BlockDrawers block = (BlockDrawers)state.method_26204();
        class_238 labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.method_17939() / 16.0f;
        float scaleY = (float)labelGeometry.method_17940() / 16.0f;
        float moveX = (float)labelGeometry.field_1323 + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.field_1325 + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.field_1321 * 0.0625f - 0.0025f;
        matrix.method_22903();
        this.alignRendering(matrix, side);
        matrix.method_46416(moveX / 16.0f, 1.0f - moveY / 16.0f, 1.0f - moveZ);
        matrix.method_34425((Matrix4fc)new Matrix4f().scale(scaleX, scaleY, 0.001f));
        matrix.method_23760().field_48930 = true;
        try {
            this.context.method_65558().method_65598(this.itemRenderState, itemStack, class_811.field_4317, this.context.method_32139().field_4348, null, 0);
            matrix.method_23760().method_23762().rotateYXZ(-this.getRotationYForSide2D(side), 0.0f, 0.0f).mul((Matrix3fc)ITEM_LIGHT_ROTATION_3D);
            this.itemRenderState.method_65604(matrix, buffer, combinedLight, combinedOverlay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.method_22909();
    }

    private void alignRendering(class_4587 matrix, class_2350 side) {
        matrix.method_46416(0.5f, 0.0f, 0.5f);
        matrix.method_34425((Matrix4fc)new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        matrix.method_46416(-0.5f, 0.0f, -0.5f);
    }

    private float getRotationYForSide2D(class_2350 side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    private void renderIndicator(BlockDrawers block, BlockEntityDrawers blockEntityDrawers, class_4587 matrixStack, class_4597 buffer, class_2350 side, int combinedLight, int combinedOverlay) {
        int count = blockEntityDrawers instanceof BlockEntityDrawersComp ? 1 : block.getDrawerCount();
        class_2960 resource = TEXTURE_IND_1;
        if (blockEntityDrawers instanceof BlockEntityDrawersComp) {
            resource = block.getDrawerCount() == 2 ? TEXTURE_IND_COMP_2 : TEXTURE_IND_COMP_3;
        } else if (count == 2) {
            resource = TEXTURE_IND_2;
        } else if (count == 4) {
            resource = TEXTURE_IND_4;
        }
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(resource);
        class_7764 contents = sprite.method_45851();
        float u1 = sprite.method_4594();
        float u2 = sprite.method_4577();
        float v1 = sprite.method_4593();
        float v2 = sprite.method_4575();
        float pxW = contents.method_45807();
        float pxH = contents.method_45815();
        float unit = 0.0625f;
        float divU = unit * (u2 - u1);
        float divV = unit * (v2 - v1);
        matrixStack.method_22903();
        this.alignRendering(matrixStack, side);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (drawer == Drawers.DISABLED || blockEntityDrawers.getDrawerAttributes().isConcealed()) continue;
            class_238 bb = block.indGeometry[i];
            class_238 bbbase = block.indBaseGeometry[i];
            float x1 = unit * (float)bb.field_1323;
            float x2 = unit * (float)bb.field_1320;
            float xb2 = unit * (float)bbbase.field_1320;
            float y1 = unit * (float)bb.field_1322;
            float y2 = unit * (float)bb.field_1325;
            float yb2 = unit * (float)bbbase.field_1325;
            float z = 1.0f - unit * (float)bb.field_1321;
            float su1 = u1 + (float)bb.field_1323 * divU;
            float su2 = u1 + (float)bb.field_1320 * divU;
            float sv1 = v2 - (float)bb.field_1322 * divV;
            float sv2 = v2 - (float)bb.field_1325 * divV;
            int stepX = (int)((x2 - xb2) * pxW);
            int stepY = (int)((y2 - yb2) * pxH);
            float xCur = stepX == 0 ? x2 : this.getIndEnd(blockEntityDrawers, i, x1, x2 - xb2, stepX);
            float xFrac = x2 == xb2 ? 1.0f : (xCur - x1) / (x2 - xb2);
            float uCur = su1 + xFrac * (su2 - su1);
            float yCur = stepY == 0 ? y2 : this.getIndEnd(blockEntityDrawers, i, y1, y2 - yb2, stepY);
            float yFrac = y2 == yb2 ? 1.0f : (yCur - y1) / (y2 - yb2);
            float vCur = sv1 + yFrac * (sv2 - sv1);
            if (!(xCur > x1) || !(yCur > y1)) continue;
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            class_4588 builder = buffer.getBuffer(class_1921.method_23577());
            BlockEntityDrawersRenderer.addQuad(matrix, matrixStack.method_23760(), builder, combinedLight, combinedOverlay, x1, xCur, y1, yCur, z, uCur, su1, sv1, vCur);
        }
        matrixStack.method_22909();
    }

    public static void addQuad(Matrix4f matrix, class_4587.class_4665 normal, class_4588 buffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y1, z, u1, v1);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y2, z, u1, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y2, z, u2, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y1, z, u2, v1);
    }

    private static void addVertex(Matrix4f matrix, class_4587.class_4665 normal, class_4588 buffer, int combinedLight, int combinedOverlay, float x, float y, float z, float u, float v) {
        buffer.method_22918(matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22922(combinedOverlay).method_60803(combinedLight).method_60831(normal, 0.0f, 1.0f, 0.0f);
    }

    private float getIndEnd(BlockEntityDrawers blockEntityDrawers, int slot, float x, float w, int step) {
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(slot);
        if (drawer == Drawers.DISABLED) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * fillAmt;
    }
}

