/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.RenderDataProvider;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityControllerIO
extends BaseBlockEntity
implements IDrawerGroup,
IControlGroup,
IFramedBlockEntity,
RenderDataProvider {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    public final MaterialData materialData = new MaterialData();
    private final ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();

    public BlockEntityControllerIO(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.injectData(this.controllerData);
        this.injectPortableData(this.materialData);
    }

    public BlockEntityControllerIO(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.CONTROLLER_IO.get(), pos, state);
    }

    @Override
    public IDrawerGroup getDrawerGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return null;
        }
        return controller.getDrawerGroup();
    }

    @Override
    public IDrawerAttributesGroupControl getGroupControllableAttributes(class_1657 player) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return null;
        }
        return controller.getGroupControllableAttributes(player);
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return null;
        }
        return controller;
    }

    @Override
    public boolean isSoftBindingValid(class_2338 pos, IDrawerGroup node) {
        IControlGroup group = this.getBoundControlGroup();
        if (group != null) {
            return group.isSoftBindingValid(pos, node);
        }
        return false;
    }

    @Override
    public List<INetworked> getBoundRemoteNodes() {
        return List.of();
    }

    @Override
    public void validateRemoteNode(INetworked node) {
    }

    @Override
    public void invalidateRemoteNode(INetworked node) {
    }

    @Override
    public boolean addRemoteNode(INetworked node) {
        return false;
    }

    @Override
    public boolean isGroupValid() {
        return !this.method_11015();
    }

    public void bindController(class_2338 coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.method_5431();
        }
    }

    public class_2338 getControllerPos() {
        return this.controllerData.getCoord();
    }

    public BlockEntityController getController() {
        return this.controllerData.getController(this);
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.method_11016())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void method_5431() {
        BlockEntityController controller = this.getController();
        if (controller != null && controller.isValidIO(this.method_11016())) {
            controller.method_5431();
        }
        super.method_5431();
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.field_11863 == null) {
            return null;
        }
        return capability.getCapability(this.field_11863, this.method_11016());
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    @Override
    @Nullable
    public Object getRenderData() {
        return FramedModelProperties.getModelData(this);
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @NotNull
        public class_2371<IItemRepository.ItemRecord> getAllItems() {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return class_2371.method_10211();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @NotNull
        public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate, Predicate<class_1799> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @NotNull
        public class_1799 extractItem(@NotNull class_1799 stack, int amount, boolean simulate, Predicate<class_1799> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return class_1799.field_8037;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.method_11016())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

