/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.framed;

import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramedCompDrawers
extends BlockCompDrawers
implements IFramedBlock {
    public BlockFramedCompDrawers(int drawerCount, boolean halfDepth, IDrawerConfig drawerConfig, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, drawerConfig, properties);
    }

    @Deprecated
    public BlockFramedCompDrawers(int drawerCount, boolean halfDepth, int storageUnits, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    @Deprecated
    public BlockFramedCompDrawers(int drawerCount, boolean halfDepth, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, properties);
    }

    @Override
    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 entity, @NotNull class_1799 stack) {
        super.method_9567(world, pos, state, entity, stack);
        BlockEntityDrawersComp blockEntity = WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawersComp.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.material().read(stack);
        blockEntity.method_5431();
    }

    @Override
    protected class_1799 getMainDrop(class_2680 state, BlockEntityDrawers tile) {
        class_1799 drop = super.getMainDrop(state, tile);
        if (!tile.material().isEmpty()) {
            drop.method_57379((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return drop;
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 stack = super.method_9574(level, pos, state, includeData);
        BlockEntityDrawers tile = WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityDrawers.class);
        if (tile != null && !tile.material().isEmpty()) {
            stack.method_57379((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return stack;
    }

    @Override
    public IFramedBlockEntity getFramedBlockEntity(@NotNull class_1937 world, @NotNull class_2338 pos) {
        return WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawersComp.class);
    }

    @Override
    public boolean supportsFrameMaterial(FrameMaterial material) {
        return true;
    }

    protected float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
        if (this.isHalfDepth()) {
            return 1.0f;
        }
        BlockEntityDrawersComp tile = WorldUtils.getBlockEntity(level, pos, BlockEntityDrawersComp.class);
        if (tile == null) {
            return 1.0f;
        }
        MaterialData data = tile.material();
        if (data == null) {
            return 1.0f;
        }
        return data.allMatOpaque() ? 0.8f : 1.0f;
    }
}

