/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.storage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class Drawers {
    public static final IDrawer DISABLED = new DisabledDrawer();
    public static final IFractionalDrawer DISABLED_FRACTIONAL = new DisabledFractionalDrawer();

    private static class DisabledDrawer
    implements IDrawer {
        private DisabledDrawer() {
        }

        @Override
        @NotNull
        public class_1799 getStoredItemPrototype() {
            return class_1799.field_8037;
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
            return this;
        }

        @Override
        public int getStoredItemCount() {
            return 0;
        }

        @Override
        public void setStoredItemCount(int amount) {
        }

        @Override
        public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
            return 0;
        }

        @Override
        public int getRemainingCapacity() {
            return 0;
        }

        @Override
        public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return false;
        }

        @Override
        public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public IDrawer copy() {
            return this;
        }
    }

    private static class DisabledFractionalDrawer
    extends DisabledDrawer
    implements IFractionalDrawer {
        private DisabledFractionalDrawer() {
        }

        @Override
        public int getConversionRate() {
            return 0;
        }

        @Override
        public int getStoredItemRemainder() {
            return 0;
        }

        @Override
        public boolean isSmallestUnit() {
            return false;
        }

        @Override
        public IFractionalDrawer copy() {
            return this;
        }
    }

    public static class WrappedFractionalDrawer
    extends WrappedDrawer
    implements IFractionalDrawer {
        private IFractionalDrawer wrapped;

        public WrappedFractionalDrawer(IFractionalDrawer drawer) {
            super(drawer);
            this.wrapped = drawer;
        }

        @Override
        public int getConversionRate() {
            return this.wrapped.getConversionRate();
        }

        @Override
        public int getStoredItemRemainder() {
            return this.wrapped.getStoredItemRemainder();
        }

        @Override
        public boolean isSmallestUnit() {
            return this.wrapped.isSmallestUnit();
        }

        @Override
        public IFractionalDrawer copy() {
            return new WrappedFractionalDrawer(this.wrapped);
        }
    }

    public static class WrappedDrawer
    implements IDrawer {
        private IDrawer wrapped;

        public WrappedDrawer(IDrawer drawer) {
            this.wrapped = drawer;
        }

        @Override
        @NotNull
        public class_1799 getStoredItemPrototype() {
            return this.wrapped.getStoredItemPrototype();
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
            return this.wrapped.setStoredItem(itemPrototype);
        }

        @Override
        public int getStoredItemCount() {
            return this.wrapped.getStoredItemCount();
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.wrapped.setStoredItemCount(amount);
        }

        @Override
        public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
            return this.wrapped.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            return this.wrapped.getRemainingCapacity();
        }

        @Override
        public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.wrapped.canItemBeStored(itemPrototype, matchPredicate);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.wrapped.canItemBeExtracted(itemPrototype, matchPredicate);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean isEnabled() {
            return this.wrapped.isEnabled();
        }

        @Override
        @NotNull
        public IDrawerAttributes getAttributes() {
            return this.wrapped.getAttributes();
        }

        @Override
        public IDrawer copy() {
            return new WrappedDrawer(this.wrapped);
        }
    }
}

