/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_4208;
import net.pneumono.gravestones.api.PositionValidationCallback;
import net.pneumono.gravestones.api.RedirectGravestonePositionCallback;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.multiversion.VersionUtil;
import org.jetbrains.annotations.Nullable;

public class GravestonePlacement
extends GravestoneManager {
    public static final int RADIUS = 2;

    public static class_4208 getRedirectableValidPos(class_3218 world, class_1657 player, class_4208 deathPos) {
        class_4208 redirected = ((RedirectGravestonePositionCallback)RedirectGravestonePositionCallback.EVENT.invoker()).redirectPosition(world, player, deathPos);
        if (redirected != null) {
            return redirected;
        }
        class_2338 validPos = GravestonePlacement.getValidPos((class_1937)world, VersionUtil.getPos(deathPos), 2);
        if (validPos == null) {
            return null;
        }
        return VersionUtil.createGlobalPos(VersionUtil.getDimension(deathPos), validPos);
    }

    @Nullable
    public static class_2338 getValidPos(class_1937 world, class_2338 originalPos, int radius) {
        if (GravestonePlacement.getCost(world, originalPos, originalPos) == 0.0) {
            return originalPos;
        }
        double bestCost = -1.0;
        class_2338.class_2339 bestPos = null;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutable.method_10101((class_2382)originalPos.method_10069(x, y, z));
                    double cost = GravestonePlacement.getCost(world, (class_2338)mutable, originalPos);
                    if (!(cost < bestCost) && (bestCost != -1.0 || cost == -1.0)) continue;
                    bestCost = cost;
                    bestPos = mutable.method_25503();
                }
            }
        }
        if (bestCost == -1.0) {
            return null;
        }
        return bestPos;
    }

    public static boolean isInvalid(class_2680 state) {
        class_2248 block = state.method_26204();
        return block.method_36555() < 0.0f || block.method_9520() >= 3600000.0f || block == class_2246.field_10243 || state.method_26164(GravestonesRegistry.BLOCK_GRAVESTONE_IRREPLACEABLE);
    }

    private static double getCost(class_1937 world, class_2338 newPos, class_2338 origin) {
        class_2680 state = world.method_8320(newPos);
        if (GravestonePlacement.isInvalid(state) || !((PositionValidationCallback)PositionValidationCallback.EVENT.invoker()).isPositionValid(world, state, newPos)) {
            return -1.0;
        }
        double cost = 0.0;
        if (!state.method_26227().method_15769()) {
            cost = state.method_26227().method_15767(class_3486.field_15517) ? (cost += 1.5) : (cost += 5.0);
        }
        if (!state.method_26215()) {
            cost += state.method_45474() ? 0.5 : 5.0;
        }
        if (world.method_8320(newPos.method_10074()).method_26215()) {
            cost += 1.5;
        }
        return cost += origin.method_10262((class_2382)newPos);
    }
}

