/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class TrimmableToolsHelper {
    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static List<Path> findPaths(String name) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            mod.findPath(name).ifPresent(paths::add);
        }
        return paths;
    }

    public static Map<String, Path> findFolders(String name) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            String modId = mod.getMetadata().getId();
            mod.findPath(name.formatted(modId)).ifPresent(path -> paths.put(modId, (Path)path));
        }
        return paths;
    }
}

