/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MatchBlockConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchBlockConnectionPredicate> SERIALIZER = new Serializer<MatchBlockConnectionPredicate>(){

        @Override
        public MatchBlockConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match block predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            class_2960 identifier = class_2960.method_60654((String)json.get("block").getAsString());
            Optional block = class_7923.field_41175.method_17966(identifier);
            if (block.isEmpty()) {
                throw new JsonParseException("Unknown block '" + String.valueOf(identifier) + "'!");
            }
            return new MatchBlockConnectionPredicate((class_2248)block.get());
        }

        @Override
        public JsonObject serialize(MatchBlockConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", class_7923.field_41175.method_10221((Object)value.block).toString());
            return json;
        }
    };
    private final class_2248 block;

    public MatchBlockConnectionPredicate(class_2248 block) {
        this.block = block;
    }

    @Override
    public boolean shouldConnect(class_2350 side, @Nullable class_2680 ownState, class_2680 otherState, class_2680 blockInFront, ConnectionDirection direction) {
        return otherState.method_26204() == this.block;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchBlockConnectionPredicate)) {
            return false;
        }
        MatchBlockConnectionPredicate that = (MatchBlockConnectionPredicate)o;
        return this.block.equals(that.block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

