/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.util;

import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1493;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class WolfInventoryProvider {
    private final List<class_1799> inventoryContents;
    private final class_1493 entity;
    private final WolfEntityProvider armoredWolf;

    public WolfInventoryProvider(@NotNull class_1493 wolf) {
        this.entity = wolf;
        this.armoredWolf = (WolfEntityProvider)wolf;
        this.inventoryContents = new ArrayList<class_1799>();
    }

    public void refreshInventoryContents(class_1263 invBasic) {
        this.inventoryContents.clear();
        for (int slotIndex = 1; slotIndex < invBasic.method_5439(); ++slotIndex) {
            this.inventoryContents.add(invBasic.method_5438(slotIndex));
        }
    }

    public void inventoryInit(class_1265 listener) {
        this.armoredWolf.getInventory().method_5488(listener);
        this.armoredWolf.getInventory().method_5489(listener);
        this.refreshInventoryContents((class_1263)this.armoredWolf.getInventory());
    }

    public static boolean isBreedingItem(class_1799 stack) {
        return stack.method_31573(class_3489.field_49936);
    }

    public static boolean canPlayerEat(class_1799 itemStack) {
        return !itemStack.method_7960() && itemStack.method_57826(class_9334.field_50075);
    }

    public static boolean canEat(class_1799 itemStack) {
        return WolfInventoryProvider.canPlayerEat(itemStack) && WolfInventoryProvider.isBreedingItem(itemStack);
    }

    public boolean canEat_(class_1799 itemStack) {
        return !itemStack.method_7960() && this.entity.method_6481(itemStack) && itemStack.method_57826(class_9334.field_50075);
    }

    @NotNull
    public class_1799 findFood() {
        float healthDiff = this.entity.method_6063() - this.entity.method_6032();
        return this.inventoryContents.stream().filter(this::canEat_).min(Comparator.comparing(itemStack -> Float.valueOf(Math.abs(healthDiff - (float)((class_4174)itemStack.method_58694(class_9334.field_50075)).comp_2491())))).orElse(class_1799.field_8037);
    }

    public long getFoodCount() {
        return this.inventoryContents.stream().filter(this::canEat_).mapToInt(class_1799::method_7947).sum();
    }

    public boolean hasSpace() {
        Iterator it = this.armoredWolf.getInventory().field_5828.iterator();
        class_1799 itemStack = class_1802.field_8567.method_7854();
        while (it.hasNext()) {
            if (itemStack.method_7960()) {
                return true;
            }
            itemStack = (class_1799)it.next();
        }
        return false;
    }

    public boolean onlyFood(class_1792 item) {
        return this.inventoryContents.stream().filter(this::canEat_).noneMatch(e -> !e.method_31574(item) && !e.method_7960());
    }
}

