/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.goals;

import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.util.Pair;
import github.meloweh.wolfcompanion.util.WolfInventoryHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_10691;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1493;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class RescueOwnerFromLavaGoal
extends class_1352
implements class_1265 {
    private final class_1321 wolf;
    @Nullable
    private class_1309 owner;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;
    private final WolfEntityProvider armoredWolf;
    private final List<class_1799> inventoryContents;
    private int shootCooldown;
    private int teleportCooldown;
    private static final int TP_COOLDOWN = 45;
    private static final int SHOOT_COOLDOWN = 20;
    private Pair<class_1799, class_6880<class_1842>> usingPotion = Pair.of(class_1799.field_8037, class_1847.field_8999);

    public RescueOwnerFromLavaGoal(class_1493 wolf, double speed, float minDistance, float maxDistance) {
        this.wolf = wolf;
        this.speed = speed;
        this.navigation = wolf.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.shootCooldown = 20;
        this.teleportCooldown = 45;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(wolf.method_5942() instanceof class_1409) && !(wolf.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
        this.armoredWolf = (WolfEntityProvider)wolf;
        this.inventoryContents = new ArrayList<class_1799>();
    }

    private void refreshInventoryContents(class_1263 invBasic) {
        this.inventoryContents.clear();
        for (int slotIndex = 1; slotIndex < 16; ++slotIndex) {
            this.inventoryContents.add(invBasic.method_5438(slotIndex));
        }
    }

    public void method_5453(class_1263 sender) {
        this.refreshInventoryContents(sender);
    }

    private void inventoryInit() {
        this.armoredWolf.getInventory().method_5488((class_1265)this);
        this.armoredWolf.getInventory().method_5489((class_1265)this);
        this.refreshInventoryContents((class_1263)this.armoredWolf.getInventory());
    }

    public boolean method_6264() {
        boolean wouldStart;
        if (!this.armoredWolf.hasChestEquipped()) {
            return false;
        }
        this.owner = this.wolf.method_35057();
        if (this.wolf.method_6118(class_1304.field_6173).method_57826(class_9334.field_49651)) {
            this.wolf.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        boolean bl = wouldStart = this.wolf.method_6181() && this.armoredWolf.hasChestEquipped() && this.owner != null && !this.owner.method_7325() && !this.owner.method_56992();
        if (wouldStart) {
            this.refreshInventoryContents((class_1263)this.armoredWolf.getInventory());
            if (WolfInventoryHelper.hasFittingLifesavingEffect(this.owner, this.inventoryContents)) {
                return false;
            }
        }
        return wouldStart;
    }

    public boolean method_6266() {
        return this.shootCooldown > 0;
    }

    public void method_6269() {
        this.inventoryInit();
        this.shootCooldown = 20;
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.wolf.method_5944(class_7.field_18);
        this.wolf.method_5941(class_7.field_18, 0.0f);
        this.teleportCooldown = 45;
        this.wolf.method_24346(false);
        this.usingPotion = this.nextPotion();
        if (((class_1799)this.usingPotion.first).method_7960()) {
            return;
        }
        this.wolf.method_5673(class_1304.field_6173, (class_1799)this.usingPotion.first);
        this.shootCooldown = 20;
    }

    public void method_6270() {
        this.shootCooldown = 20;
        this.owner = null;
        this.navigation.method_6340();
        this.wolf.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
        this.teleportCooldown = 45;
        this.wolf.method_5673(class_1304.field_6173, class_1799.field_8037);
        this.inventoryInit();
    }

    public void method_6268() {
        if (!this.wolf.method_37908().field_9236 && this.wolf.method_5805() && this.wolf.method_66249()) {
            this.wolf.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.wolf.method_5978());
            Pair<class_1799, class_6880<class_1842>> itemStack = this.usingPotion;
            --this.shootCooldown;
            if (WolfInventoryHelper.hasFittingLifesavingEffect(this.owner, this.inventoryContents)) {
                return;
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            if (--this.updateCountdownTicks <= 0) {
                this.updateCountdownTicks = this.method_38847(10);
                if (this.teleportCooldown <= 0) {
                    this.wolf.method_60713();
                    this.teleportCooldown = this.wolf.method_59922().method_39332(22, 67);
                } else {
                    this.navigation.method_6335((class_1297)this.owner, this.speed);
                }
            }
            if (!((class_1799)itemStack.first).method_7960()) {
                this.wolf.method_5673(class_1304.field_6173, (class_1799)itemStack.first);
                if (this.wolf.method_5858((class_1297)this.owner) <= (double)(this.maxDistance * this.maxDistance) && this.wolf.method_6057((class_1297)this.owner) && this.wolf.method_6118(class_1304.field_6173) == itemStack.first) {
                    this.shoot(itemStack);
                    this.wolf.method_5673(class_1304.field_6173, (class_1799)this.nextPotion().first);
                }
            }
        }
    }

    private Pair<class_1799, class_6880<class_1842>> nextPotion() {
        Pair<class_1799, class_6880<class_1842>> itemStack = WolfInventoryHelper.findLifesavingPotions(this.inventoryContents, this.owner);
        this.wolf.method_5673(class_1304.field_6173, (class_1799)itemStack.first);
        return itemStack;
    }

    public void shoot(Pair<class_1799, class_6880<class_1842>> itemStack) {
        class_243 vec3d = this.owner.method_18798();
        double d = this.owner.method_23317() + vec3d.field_1352 - this.wolf.method_23317();
        double e = this.owner.method_23320() - (double)1.1f - this.wolf.method_23318();
        double f = this.owner.method_23321() + vec3d.field_1350 - this.wolf.method_23321();
        double g = Math.sqrt(d * d + f * f);
        class_6880 registryEntry = (class_6880)itemStack.second;
        class_10691 potionEntity = new class_10691(this.wolf.method_37908(), (class_1309)this.wolf, (class_1799)itemStack.first);
        potionEntity.method_16940(class_1844.method_57400((class_1792)class_1802.field_8436, (class_6880)registryEntry));
        potionEntity.method_36457(potionEntity.method_36455() - -20.0f);
        potionEntity.method_7485(d, e + g * 0.2, f, 0.75f, 0.0f);
        this.wolf.method_37908().method_43128(null, this.wolf.method_23317(), this.wolf.method_23318(), this.wolf.method_23321(), class_3417.field_14910, this.wolf.method_5634(), 1.0f, 0.4f + this.wolf.method_59922().method_43057() * 0.4f);
        this.wolf.method_37908().method_8649((class_1297)potionEntity);
        ((class_1799)itemStack.first).method_7934(1);
        class_1799 itemStack2 = ((class_1799)itemStack.first).method_7910(this.wolf.method_37908(), (class_1309)this.wolf);
        if (!itemStack2.method_7960()) {
            this.wolf.method_5673(class_1304.field_6173, itemStack2);
        }
    }
}

