/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.generator.LootTableGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class RegistrationLootTableGenerator
extends LootTableGenerator {
    private final RechiseledRegistrationImpl registration;

    public RegistrationLootTableGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().stream().map(Pair::right).forEach(type -> {
            if (type.hasRegularVariant()) {
                this.addLootTable(type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addLootTable(type.getConnectingBlock());
            }
        });
    }

    private void addLootTable(class_2248 block) {
        class_2960 identifier = Registries.BLOCKS.getIdentifier((Object)block);
        class_2960 lootTable = block.method_26162().map(class_5321::method_29177).orElse(null);
        if (lootTable != null && lootTable.method_12836().equals(identifier.method_12836()) && lootTable.method_12832().equals("block/" + identifier.method_12832())) {
            return;
        }
        this.dropSelf(block);
    }

    public String getName() {
        return "Registration Loot Table Generator: " + this.modName;
    }
}

