/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata.layer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerType;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_790;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LBGLayerMetadata {
    public final class_2960 id;
    private final LBGLayerType layerType;
    private final boolean layerModel;
    @Nullable
    private final Vector3f offset;
    private final Map<class_2680, class_1087.class_9979> variantModels;

    public LBGLayerMetadata(class_2960 id, @Nullable LBGLayerType layerType, JsonObject json, class_2689<class_2248, class_2680> stateDefinition) {
        this.id = id;
        this.layerType = layerType;
        this.layerModel = json.has("layer") ? json.get("layer").getAsBoolean() : false;
        if (json.has("offset")) {
            JsonElement offsetJson = json.get("offset");
            if (offsetJson.isJsonArray()) {
                JsonArray offsetArray = offsetJson.getAsJsonArray();
                this.offset = new Vector3f(offsetArray.get(0).getAsFloat(), offsetArray.get(1).getAsFloat(), offsetArray.get(2).getAsFloat());
            } else {
                this.offset = null;
            }
        } else {
            this.offset = null;
        }
        if (json.has("block_state")) {
            class_790 blockModelDefinition = (class_790)class_790.field_56928.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("block_state")).getOrThrow(JsonParseException::new);
            this.variantModels = blockModelDefinition.method_62327(stateDefinition, () -> ((class_2960)id).toString());
        } else {
            this.variantModels = null;
        }
    }

    @NotNull
    public LBGLayerType layerType() {
        return this.layerType;
    }

    public boolean hasLayerModel() {
        return this.layerModel;
    }

    @Nullable
    public Vector3f offset() {
        return this.offset;
    }

    public LayerUnbakedModels getCustomUnbakedModel(class_2680 state) {
        if (this.variantModels == null) {
            return new LayerUnbakedModels(null);
        }
        return new LayerUnbakedModels(this.variantModels.get(state));
    }

    public String toString() {
        return "LBGLayerMetadata{id=" + String.valueOf(this.id) + ", layerType=" + String.valueOf(this.layerType) + ", layerModel=" + this.layerModel + ", variantModels=" + String.valueOf(this.variantModels) + "}";
    }

    public record LayerUnbakedModels(@Nullable class_1087.class_9979 alternateModel) {
        public boolean isEmpty() {
            return this.alternateModel() == null;
        }
    }
}

