/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2196;
import net.minecraft.class_2561;

public class ShareCommand
implements Command<FabricClientCommandSource> {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode shareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:share").executes((Command)new ShareCommand())).build();
        LiteralCommandNode constellationShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.constellations).executes(ShareCommand::shareConstellation))).build();
        LiteralCommandNode starShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.stars).executes(ShareCommand::shareStar))).build();
        LiteralCommandNode orbitingBodyShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.orbitingBodies).executes(ShareCommand::shareOrbitingBody))).build();
        shareNode.addChild((CommandNode)constellationShareNode);
        shareNode.addChild((CommandNode)starShareNode);
        shareNode.addChild((CommandNode)orbitingBodyShareNode);
        return shareNode;
    }

    public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        if (Constellation.selected != null) {
            ShareCommand.share(Constellation.selected);
            return 1;
        }
        if (Star.selected != null) {
            ShareCommand.share(Star.selected);
            return 1;
        }
        if (OrbitingBody.selected != null) {
            ShareCommand.share(OrbitingBody.selected);
            return 1;
        }
        SpyglassAstronomyClient.say("commands.share.nothingselected", new Object[0]);
        return -1;
    }

    private static int shareConstellation(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = SpyglassAstronomyCommands.getConstellation(context);
        if (constellation == null) {
            return -1;
        }
        ShareCommand.share(constellation);
        return 1;
    }

    private static int shareStar(CommandContext<FabricClientCommandSource> context) {
        Star star = SpyglassAstronomyCommands.getStar(context);
        if (star == null) {
            return -1;
        }
        ShareCommand.share(star);
        return 1;
    }

    private static int shareOrbitingBody(CommandContext<FabricClientCommandSource> context) {
        OrbitingBody orbitingBody = SpyglassAstronomyCommands.getOrbitingBody(context);
        if (orbitingBody == null) {
            return -1;
        }
        ShareCommand.share(orbitingBody);
        return 1;
    }

    private static void share(Constellation constellation) {
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share.constellation", "sga:c_" + SpaceDataManager.encodeConstellation(null, constellation).replace(" | ", "|") + "|", false, constellation.name);
        SpyglassAstronomyClient.sayText(text);
    }

    private static void share(Star star) {
        String starName = star.isUnnamed() ? "Unnamed" : star.name;
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share.star", "sga:s_" + starName + "|" + star.index + "|", false, starName);
        SpyglassAstronomyClient.sayText(text);
    }

    private static void share(OrbitingBody orbitingBody) {
        String orbitingBodyName = orbitingBody.isUnnamed() ? "Unnamed" : orbitingBody.name;
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share." + (orbitingBody.isPlanet ? "planet" : "comet"), "sga:p_" + orbitingBodyName + "|" + SpyglassAstronomyClient.orbitingBodies.indexOf(orbitingBody) + "|", false, orbitingBodyName);
        SpyglassAstronomyClient.sayText(text);
    }
}

