/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpaceRenderingManager;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class Star {
    public final int index;
    private final float xCoord;
    private final float yCoord;
    private final float zCoord;
    private final float longitudeSin;
    private final float longitudeCos;
    private final float latitudeSin;
    private final float latitudeCos;
    private final int r;
    private final int g;
    private final int b;
    private final float alpha;
    private float angle;
    private float size;
    private final float rotationSpeed;
    private final float twinkleSpeed;
    private int currentAlpha;
    private int connectedStars = 0;
    public static Star selected;
    private boolean isSelected;
    public String name;

    public Star(int index, float posX, float posY, float posZ, float size, float rotationSpeed, int[] color, float alpha, float twinkleSpeed) {
        this.index = index;
        this.xCoord = posX;
        this.yCoord = posY;
        this.zCoord = posZ;
        this.r = color[0];
        this.g = color[1];
        this.b = color[2];
        this.alpha = alpha;
        double polarAngle = Math.atan2(posX, posZ);
        this.longitudeSin = (float)Math.sin(polarAngle);
        this.longitudeCos = (float)Math.cos(polarAngle);
        double proj = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
        this.latitudeSin = (float)Math.sin(proj);
        this.latitudeCos = (float)Math.cos(proj);
        this.size = size;
        this.angle = rotationSpeed * (float)Math.PI;
        this.rotationSpeed = rotationSpeed * 0.005f;
        this.twinkleSpeed = twinkleSpeed;
    }

    public void update(int ticks) {
        this.angle = (this.angle + this.rotationSpeed) % 90.0f;
        float twinkle = 1.0f - 2.5f * Math.max(class_3532.method_15374((float)((float)ticks * this.twinkleSpeed)) - 0.75f, 0.0f);
        this.currentAlpha = (int)(this.getCurrentNonTwinkledAlpha() * twinkle * 255.0f);
    }

    public float getCurrentNonTwinkledAlpha() {
        float heightScale = SpaceRenderingManager.getHeightScale();
        float brightness = heightScale * Math.max(this.alpha / 2.0f + heightScale / 2.0f, 2.0f * this.alpha - 1.0f) + (1.0f - heightScale) * this.alpha * this.alpha * this.alpha;
        if (this.connectedStars == 0) {
            return brightness;
        }
        return (brightness + (0.5f * this.alpha + 0.5f)) / 2.0f;
    }

    public void setVertices(class_287 bufferBuilder) {
        float angleSin = class_3532.method_15374((float)this.angle);
        float angleCos = class_3532.method_15362((float)this.angle);
        int colorMult = this.isSelected ? 1 : 0;
        for (int corner = 0; corner < 4; ++corner) {
            float x = (float)((corner & 2) - 1) * this.size;
            float y = (float)((corner + 1 & 2) - 1) * this.size;
            float rotatedA = x * angleCos - y * angleSin;
            float rotatedB = y * angleCos + x * angleSin;
            float rotatedALat = rotatedA * this.latitudeSin;
            float rotatedBLat = -(rotatedA * this.latitudeCos);
            float vertexPosX = rotatedBLat * this.longitudeSin - rotatedB * this.longitudeCos;
            float vertexPosZ = rotatedB * this.longitudeSin + rotatedBLat * this.longitudeCos;
            bufferBuilder.method_22912(this.xCoord * 100.0f + vertexPosX, this.yCoord * 100.0f + rotatedALat, this.zCoord * 100.0f + vertexPosZ).method_1336(this.r >> colorMult, this.g << colorMult, this.b >> colorMult, this.currentAlpha);
        }
    }

    public Vector3f getRenderedPosition() {
        return new Vector3f(this.xCoord * 100.0f, this.yCoord * 100.0f, this.zCoord * 100.0f);
    }

    public int[] getColor() {
        return new int[]{this.r, this.g, this.b, (int)((0.5f * this.alpha + 0.5f) * 255.0f)};
    }

    public float[] getPosition() {
        return new float[]{this.xCoord, this.yCoord, this.zCoord};
    }

    public Vector3f getPositionAsVector3f() {
        return new Vector3f(this.xCoord, this.yCoord, this.zCoord);
    }

    public void connect() {
        ++this.connectedStars;
    }

    public void disconnect() {
        if (this.connectedStars > 0) {
            this.connectedStars -= 2;
        }
    }

    public void clearAllConnections() {
        this.connectedStars = 0;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void select() {
        Constellation.deselect();
        OrbitingBody.deselect();
        if (selected != null) {
            Star.selected.isSelected = false;
        }
        this.isSelected = true;
        selected = this;
    }

    public static void deselect() {
        if (selected != null) {
            Star.selected.isSelected = false;
        }
        selected = null;
    }

    public boolean isUnnamed() {
        return this.name == null;
    }
}

