/*
 * Decompiled with CFR 0.152.
 */
package dhyces.compostbag.item;

import dhyces.compostbag.platform.Services;
import dhyces.compostbag.tooltip.CompostBagTooltip;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2769;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3962;
import net.minecraft.class_481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_638;

public class CompostBagItem
extends class_1792 {
    public static final String TAG_LEVEL = "Level";
    public static final String TAG_COUNT = "Count";
    public static final Supplier<Integer> MAX_BONEMEAL_COUNT = Services.PLATFORM.maxBonemeal();
    public static final int MAX_LEVEL = 7;
    public static final class_2357 DISPENSE_BEHAVIOR = new class_2969(){

        protected class_1799 method_10135(class_2342 blockSource, class_1799 stack) {
            this.method_27955(true);
            class_3218 level = blockSource.method_10207();
            class_2338 blockPos = blockSource.method_10122().method_10093((class_2350)blockSource.method_10120().method_11654((class_2769)class_2315.field_10918));
            class_1799 bonemeal = CompostBagItem.getTagItem(stack);
            if (bonemeal.method_7960() || !class_1752.method_7720((class_1799)bonemeal, (class_1937)level, (class_2338)blockPos) && !class_1752.method_7719((class_1799)bonemeal, (class_1937)level, (class_2338)blockPos, (class_2350)null)) {
                this.method_27955(false);
            } else if (!level.field_9236) {
                level.method_20290(1505, blockPos, 0);
                CompostBagItem.setBonemealCount(stack, bonemeal.method_7947());
            }
            return stack;
        }
    };

    public CompostBagItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 bonemeal = CompostBagItem.getTagItem(context.method_8041());
        class_1937 level = context.method_8045();
        class_2338 blockpos = context.method_8037();
        if (!bonemeal.method_7960() && Services.PLATFORM.bonemeal(bonemeal, level, blockpos, context.method_8036())) {
            CompostBagItem.setBonemealCount(context.method_8041(), bonemeal.method_7947());
            this.playBonemealSound(level, blockpos);
            level.method_20290(1505, blockpos, 0);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    public static float getFullnessDisplay(class_1799 bag, class_638 level, class_1309 livingEntity, int seed) {
        return (float)CompostBagItem.getBonemealCount(bag) / (float)MAX_BONEMEAL_COUNT.get().intValue();
    }

    public boolean method_31567(class_1799 bag) {
        return CompostBagItem.getBonemealCount(bag) > 0;
    }

    public int method_31569(class_1799 bag) {
        return 1 + (int)((float)CompostBagItem.getBonemealCount(bag) / (float)MAX_BONEMEAL_COUNT.get().intValue() * 13.0f - 1.0f);
    }

    public int method_31571(class_1799 bag) {
        return CompostBagItem.getBonemealCount(bag) < MAX_BONEMEAL_COUNT.get() ? 0x6666FF : 0xFF3737;
    }

    public boolean method_31565(class_1799 bag, class_1735 slot, class_5536 clickAction, class_1657 player) {
        if (!slot.method_32754(player)) {
            return false;
        }
        if (clickAction == class_5536.field_27014) {
            if (!player.method_37908().field_9236 || player.field_7512 instanceof class_481.class_483) {
                if (slot.method_7681()) {
                    class_1799 slotItem = slot.method_7677();
                    if (this.isCompostable(slotItem)) {
                        this.compostAll(bag, slotItem, player);
                    }
                    if (slotItem.method_31574(class_1802.field_8324) && CompostBagItem.getBonemealCount(bag) < MAX_BONEMEAL_COUNT.get()) {
                        this.insertBonemeal(bag, slotItem);
                        this.playInsertSound(player);
                    }
                } else {
                    this.remove(bag, 64).ifPresent(c -> {
                        this.playRemoveSound(player);
                        slot.method_7673(c);
                    });
                }
            }
            return true;
        }
        return super.method_31565(bag, slot, clickAction, player);
    }

    private void compostAll(class_1799 bag, class_1799 slotItem, class_1657 player) {
        int shrinkBy = 0;
        while (shrinkBy != slotItem.method_7947() && !this.isBagFull(bag)) {
            class_1271<class_1799> result = this.simulateCompost(bag, slotItem, player);
            if (!result.method_5467().method_23665()) continue;
            if (!((class_1799)result.method_5466()).method_7960()) {
                this.setLevel(bag, 0);
                this.growBonemealCount(bag, 1);
            } else if (result.method_5467().equals((Object)class_1269.field_5812)) {
                this.growLevel(bag, 1);
            }
            ++shrinkBy;
        }
        if (shrinkBy > 0) {
            this.playReadySound(player);
        }
        this.playFillSound(player);
        slotItem.method_7934(shrinkBy);
    }

    public boolean method_31566(class_1799 bag, class_1799 otherItem, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (!slot.method_32754(player)) {
            return false;
        }
        if (clickAction == class_5536.field_27014) {
            if (!player.method_37908().field_9236 || player.field_7512 instanceof class_481.class_483) {
                if (!otherItem.method_7960()) {
                    class_1271<class_1799> result;
                    int count = CompostBagItem.getBonemealCount(bag);
                    if (this.isCompostable(otherItem) && !this.isBagFull(bag) && (result = this.simulateCompost(bag, otherItem, player)).method_5467().method_23665()) {
                        if (!((class_1799)result.method_5466()).method_7960()) {
                            this.setLevel(bag, 0);
                            this.growBonemealCount(bag, 1);
                            this.playReadySound(player);
                        } else if (result.method_5467().equals((Object)class_1269.field_5812)) {
                            this.growLevel(bag, 1);
                            this.playFillSuccessSound(player);
                        }
                        this.playFillSound(player);
                        otherItem.method_7934(1);
                    }
                    if (otherItem.method_31574(class_1802.field_8324) && count < MAX_BONEMEAL_COUNT.get()) {
                        this.insertBonemeal(bag, otherItem);
                        this.playInsertSound(player);
                    }
                } else {
                    this.remove(bag, 64).ifPresent(c -> {
                        this.playRemoveSound(player);
                        slotAccess.method_32332(c);
                    });
                }
            }
            return true;
        }
        return super.method_31566(bag, otherItem, slot, clickAction, player, slotAccess);
    }

    private class_1271<class_1799> simulateCompost(class_1799 bag, class_1799 item, class_1657 player) {
        float compostable = this.getCompostable(item);
        if (compostable == 0.0f) {
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        int lvl = this.getLevel(bag);
        if (!(lvl == 0 && compostable < 0.0f || player.method_37908().method_8409().method_43058() < (double)compostable)) {
            return class_1271.method_22428((Object)class_1799.field_8037);
        }
        if (lvl < 7) {
            return class_1271.method_22427((Object)class_1799.field_8037);
        }
        return class_1271.method_22427((Object)new class_1799((class_1935)class_1802.field_8324));
    }

    private boolean isBagFull(class_1799 stack) {
        return CompostBagItem.getBonemealCount(stack) >= MAX_BONEMEAL_COUNT.get() && this.getLevel(stack) >= 7;
    }

    private boolean isCompostable(class_1799 stack) {
        return class_3962.field_17566.containsKey((Object)stack.method_7909());
    }

    private float getCompostable(class_1799 stack) {
        return class_3962.field_17566.getOrDefault((Object)stack.method_7909(), 0.0f);
    }

    public Optional<class_5632> method_32346(class_1799 item) {
        return Optional.of(new CompostBagTooltip(this.getLevel(item), CompostBagItem.getBonemealCount(item)));
    }

    private class_1799 insertBonemeal(class_1799 bag, class_1799 bonemeal) {
        if (bonemeal.method_7960() || !(bonemeal.method_7909() instanceof class_1752)) {
            return bonemeal;
        }
        int max = Math.min(bonemeal.method_7947(), MAX_BONEMEAL_COUNT.get() - CompostBagItem.getBonemealCount(bag));
        this.growBonemealCount(bag, max);
        bonemeal.method_7934(max);
        return bonemeal;
    }

    private Optional<class_1799> remove(class_1799 bag, int amount) {
        int count = Math.min(CompostBagItem.getBonemealCount(bag), amount);
        if (count == 0) {
            return Optional.empty();
        }
        class_1799 item = Services.PLATFORM.copyWithSize(class_1802.field_8324.method_7854(), count);
        this.growBonemealCount(bag, -count);
        return Optional.of(item);
    }

    private static class_1799 getTagItem(class_1799 bag) {
        class_1799 stack = class_1802.field_8324.method_7854().method_7972();
        stack.method_7939(CompostBagItem.getBonemealCount(bag));
        if (stack.method_7947() == 0) {
            stack = class_1799.field_8037;
        }
        return stack;
    }

    private void growBonemealCount(class_1799 bag, int amount) {
        CompostBagItem.setBonemealCount(bag, CompostBagItem.getBonemealCount(bag) + amount);
    }

    private static void setBonemealCount(class_1799 bag, int count) {
        if (count == 0) {
            bag.method_7983(TAG_COUNT);
            return;
        }
        bag.method_7948().method_10569(TAG_COUNT, count);
    }

    private static int getBonemealCount(class_1799 bag) {
        return bag.method_7948().method_10550(TAG_COUNT);
    }

    private void growLevel(class_1799 bag, int amount) {
        this.setLevel(bag, this.getLevel(bag) + amount);
    }

    private void setLevel(class_1799 bag, int lvl) {
        if (lvl == 0) {
            bag.method_7983(TAG_LEVEL);
            return;
        }
        bag.method_7948().method_10569(TAG_LEVEL, lvl);
    }

    private int getLevel(class_1799 bag) {
        return bag.method_7948().method_10550(TAG_LEVEL);
    }

    private void playBonemealSound(class_1937 level, class_2338 pos) {
        level.method_8396((class_1657)null, pos, class_3417.field_33433, class_3419.field_15248, 0.8f, 0.8f + level.method_8409().method_43057() * 0.4f);
    }

    private void playFillSound(class_1657 player) {
        this.playerSound(player, class_3417.field_17607, 0.8f);
    }

    private void playFillSuccessSound(class_1657 player) {
        this.playerSound(player, class_3417.field_17608, 0.8f);
    }

    private void playReadySound(class_1657 player) {
        this.playerSound(player, class_3417.field_17609, 0.8f);
    }

    private void playRemoveSound(class_1657 player) {
        this.playerSound(player, class_3417.field_34377, 0.8f);
    }

    private void playInsertSound(class_1657 player) {
        this.playerSound(player, class_3417.field_34376, 0.8f);
        this.playerSound(player, class_3417.field_33433, 0.4f);
    }

    private void playerSound(class_1657 player, class_3414 event, float volume) {
        float randPitch = 0.8f + player.method_37908().field_9229.method_43057() * 0.4f;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_17356(event, class_3419.field_15248, volume, randPitch);
        } else {
            player.method_5783(event, volume, randPitch);
        }
    }
}

