/*
 * Decompiled with CFR 0.152.
 */
package gay.solonovamax.beaconsoverhaul.mixin;

import ca.solostudios.guava.kotlin.collect.MultisetsKt;
import ca.solostudios.guava.kotlin.collect.MutableMultiset;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import gay.solonovamax.beaconsoverhaul.block.beacon.OverhauledBeacon;
import gay.solonovamax.beaconsoverhaul.block.beacon.OverhauledBeaconPropertyDelegate;
import gay.solonovamax.beaconsoverhaul.block.beacon.blockentity.OverhauledBeaconBlockEntityKt;
import gay.solonovamax.beaconsoverhaul.config.BeaconOverhaulConfigManager;
import java.util.Collections;
import java.util.List;
import kotlinx.datetime.Instant;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3954;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2580.class})
abstract class BeaconBlockEntityMixin
extends class_2586
implements ExtendedScreenHandlerFactory,
OverhauledBeacon,
class_3954 {
    @Unique
    @NotNull
    private final List<class_3222> listeningPlayers = Lists.newArrayList();
    @Shadow
    int field_11803;
    @Shadow
    @Nullable
    class_1291 field_11795;
    @Shadow
    @Nullable
    class_1291 field_11799;
    @Shadow
    @NotNull
    List<class_2580.class_2581> field_19177;
    @Unique
    @NotNull
    private Instant lastUpdate = Instant.Companion.getDISTANT_PAST();
    @Unique
    @NotNull
    private MutableMultiset<class_2248> baseBlocks = MultisetsKt.mutableMultisetOf();
    @Final
    @Shadow
    @Mutable
    @NotNull
    private class_3913 field_17378;
    @Shadow
    private int field_19179;
    @Shadow
    private List<class_2580.class_2581> field_19178;
    @Unique
    private double beaconPoints = 0.0;
    @Unique
    private boolean didRedirection = false;

    BeaconBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Redirect(method={"tick"}, at=@At(target="Lnet/minecraft/block/entity/BeaconBlockEntity;updateLevel(Lnet/minecraft/world/World;III)I", value="INVOKE"))
    private static int updateLevel(class_1937 world, int x, int y, int z) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(new class_2338(x, y, z));
        assert (beacon != null);
        return beacon.getLevel();
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="CONSTANT", args={"intValue=0"}, ordinal=0)})
    private static int constructBeamSegments(int original, class_1937 level, class_2338 pos, class_2680 state, class_2580 beacon) {
        OverhauledBeaconBlockEntityKt.constructBeamSegments((OverhauledBeacon)beacon);
        return Integer.MAX_VALUE;
    }

    @Inject(method={"tick"}, at={@At(target="Lnet/minecraft/block/entity/BeaconBlockEntity;level:I", shift=At.Shift.BY, by=2, value="FIELD", opcode=184, ordinal=0)})
    private static void updateTier(class_1937 world, class_2338 pos, class_2680 beaconState, class_2580 beacon, CallbackInfo ci) {
        OverhauledBeaconBlockEntityKt.updateTier((OverhauledBeacon)beacon, world, pos);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getNonSpectatingEntities(Ljava/lang/Class;Lnet/minecraft/util/math/Box;)Ljava/util/List;"))
    private static <T> List<T> disableAdvancementTrigger(class_1937 instance, Class<T> aClass, class_238 box) {
        return List.of();
    }

    @ModifyVariable(method={"applyPlayerEffects"}, at=@At(value="STORE", opcode=57, ordinal=0), index=5, require=1, allow=1)
    private static double modifyRange(double radius, class_1937 world, class_2338 pos) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(pos);
        assert (beacon != null);
        return beacon.getRange();
    }

    @ModifyVariable(method={"applyPlayerEffects"}, at=@At(value="STORE", opcode=54, ordinal=0), index=7, require=1, allow=1)
    private static int modifyPrimaryAmplifier(int primaryAmplifier, class_1937 world, class_2338 pos, int levels, @Nullable class_1291 primaryEffect) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(pos);
        assert (beacon != null);
        if (!BeaconOverhaulConfigManager.getConfig().getLevelOneStatusEffects().contains(primaryEffect)) {
            return beacon.getPrimaryAmplifier() - 1;
        }
        return 0;
    }

    @ModifyVariable(method={"applyPlayerEffects"}, at=@At(value="STORE", opcode=54, ordinal=1), index=7, require=1, allow=1)
    private static int modifyPotentPrimaryAmplifier(int primaryAmplifier, class_1937 world, class_2338 pos, int levels, @Nullable class_1291 primaryEffect, @Nullable class_1291 secondaryEffect) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(pos);
        assert (beacon != null);
        if (!BeaconOverhaulConfigManager.getConfig().getLevelOneStatusEffects().contains(primaryEffect)) {
            return beacon.getPrimaryAmplifierPotent() - 1;
        }
        return 0;
    }

    @ModifyConstant(method={"applyPlayerEffects"}, constant={@Constant(ordinal=1)}, require=1, allow=1)
    private static int modifySecondaryAmplifier(int secondaryAmplifier, class_1937 world, class_2338 pos, int levels, @Nullable class_1291 primaryEffect, @Nullable class_1291 secondaryEffect) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(pos);
        assert (beacon != null);
        if (!BeaconOverhaulConfigManager.getConfig().getLevelOneStatusEffects().contains(secondaryEffect)) {
            return beacon.getSecondaryAmplifier() - 1;
        }
        return 0;
    }

    @ModifyVariable(method={"applyPlayerEffects"}, at=@At(value="STORE", opcode=54, ordinal=0), index=8, require=1, allow=1)
    private static int modifyDuration(int duration, class_1937 world, class_2338 pos, int levels) {
        OverhauledBeacon beacon = (OverhauledBeacon)world.method_8321(pos);
        assert (beacon != null);
        return beacon.getDuration();
    }

    @Redirect(method={"applyPlayerEffects"}, at=@At(value="NEW", target="(Lnet/minecraft/entity/effect/StatusEffect;IIZZ)Lnet/minecraft/entity/effect/StatusEffectInstance;"), expect=2)
    private static class_1293 disableEffectParticles(class_1291 type, int duration, int amplifier, boolean ambient, boolean visible) {
        return new class_1293(type, duration, amplifier, ambient, BeaconOverhaulConfigManager.getConfig().getEffectParticles());
    }

    @Inject(method={"<init>(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo info) {
        this.field_17378 = new OverhauledBeaconPropertyDelegate(this);
    }

    @Inject(method={"createMenu"}, at={@At(value="NEW", target="(ILnet/minecraft/inventory/Inventory;Lnet/minecraft/screen/PropertyDelegate;Lnet/minecraft/screen/ScreenHandlerContext;)Lnet/minecraft/screen/BeaconScreenHandler;")}, cancellable=true)
    private void createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity, CallbackInfoReturnable<class_1703> cir) {
        cir.setReturnValue((Object)OverhauledBeaconBlockEntityKt.createMenu(this, syncId, playerEntity));
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void readOverhauledNbt(class_2487 nbt, CallbackInfo ci) {
        String secondaryIdentifier;
        this.field_11803 = nbt.method_10550("Levels");
        this.beaconPoints = nbt.method_10574("BeaconPoints");
        this.didRedirection = nbt.method_10577("DidRedirection");
        String primaryIdentifier = nbt.method_10558("Primary");
        if (!primaryIdentifier.isBlank()) {
            this.field_11795 = (class_1291)class_7923.field_41174.method_10223(new class_2960(primaryIdentifier));
        }
        if (!(secondaryIdentifier = nbt.method_10558("Secondary")).isBlank()) {
            this.field_11799 = (class_1291)class_7923.field_41174.method_10223(new class_2960(secondaryIdentifier));
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void writeOverhauledNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10549("BeaconPoints", this.beaconPoints);
        nbt.method_10556("DidRedirection", this.didRedirection);
        class_2960 primaryId = class_7923.field_41174.method_10221((Object)this.field_11795);
        if (this.field_11795 != null && primaryId != null) {
            nbt.method_10582("Primary", primaryId.toString());
        }
        class_2960 secondaryId = class_7923.field_41174.method_10221((Object)this.field_11799);
        if (this.field_11799 != null && secondaryId != null) {
            nbt.method_10582("Secondary", secondaryId.toString());
        }
    }

    @Unique
    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        OverhauledBeaconBlockEntityKt.writeScreenOpeningData(this, player, buf);
    }

    @Override
    public int getMinY() {
        return this.field_19179;
    }

    @Override
    public void setMinY(int minY) {
        this.field_19179 = minY;
    }

    @Override
    @Unique
    @NotNull
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    @Unique
    public void setLastUpdate(@NotNull Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    @Unique
    @NotNull
    public MutableMultiset<class_2248> getBaseBlocks() {
        return this.baseBlocks;
    }

    @Override
    @Unique
    public void setBaseBlocks(@NotNull MutableMultiset<class_2248> baseBlocks) {
        this.baseBlocks = baseBlocks;
    }

    @Override
    @Unique
    public int getLevel() {
        return this.field_11803;
    }

    @Override
    @Unique
    public void setLevel(int level) {
        this.field_11803 = level;
    }

    @Override
    @Unique
    public double getBeaconPoints() {
        return this.beaconPoints;
    }

    @Override
    @Unique
    public void setBeaconPoints(double beaconPoints) {
        this.beaconPoints = beaconPoints;
    }

    @Override
    @Unique
    @NotNull
    public OverhauledBeaconPropertyDelegate getPropertyDelegate() {
        return (OverhauledBeaconPropertyDelegate)this.field_17378;
    }

    @Override
    @Unique
    public int getRange() {
        return BeaconOverhaulConfigManager.getConfig().calculateRange(this.beaconPoints);
    }

    @Override
    @Unique
    public int getDuration() {
        return BeaconOverhaulConfigManager.getConfig().calculateDuration(this.beaconPoints);
    }

    @Override
    @Unique
    @Nullable
    public class_1291 getPrimaryEffect() {
        return this.field_11795;
    }

    @Override
    @Unique
    public void setPrimaryEffect(@Nullable class_1291 primaryEffect) {
        this.field_11795 = primaryEffect;
    }

    @Override
    @Unique
    @Nullable
    public class_1291 getSecondaryEffect() {
        return this.field_11799;
    }

    @Override
    @Unique
    public void setSecondaryEffect(@Nullable class_1291 secondaryEffect) {
        this.field_11799 = secondaryEffect;
    }

    @Override
    @Unique
    @Nullable
    public class_1937 method_10997() {
        return this.field_11863;
    }

    @Override
    @Unique
    @NotNull
    public class_2338 method_11016() {
        return this.field_11867;
    }

    @Override
    @Unique
    @NotNull
    public List<class_2580.class_2581> getBeamSegments() {
        return this.field_19177;
    }

    @Override
    @Unique
    @NotNull
    public List<class_2580.class_2581> getBeamSegmentsToCheck() {
        return this.field_19178;
    }

    @Override
    @Unique
    public void setBeamSegmentsToCheck(@NotNull List<? extends class_2580.class_2581> beamSegmentsToCheck) {
        this.field_19178 = beamSegmentsToCheck;
    }

    @Override
    public boolean getDidRedirection() {
        return this.didRedirection;
    }

    @Override
    public void setDidRedirection(boolean didRedirection) {
        this.didRedirection = didRedirection;
    }

    @Override
    @Unique
    public int getPrimaryAmplifier() {
        return BeaconOverhaulConfigManager.getConfig().calculatePrimaryAmplifier(this.beaconPoints, false);
    }

    @Override
    @Unique
    public int getPrimaryAmplifierPotent() {
        return BeaconOverhaulConfigManager.getConfig().calculatePrimaryAmplifier(this.beaconPoints, true);
    }

    @Override
    @Unique
    public int getSecondaryAmplifier() {
        return BeaconOverhaulConfigManager.getConfig().calculateSecondaryAmplifier(this.beaconPoints);
    }

    @Override
    @Unique
    @NotNull
    public List<class_3222> getListeningPlayers() {
        return Collections.unmodifiableList(this.listeningPlayers);
    }

    @Override
    @Unique
    public void addUpdateListener(@NotNull class_3222 player) {
        this.listeningPlayers.add(player);
    }

    @Override
    @Unique
    public void removeUpdateListener(@NotNull class_1657 player) {
        this.listeningPlayers.remove(player);
    }

    @Override
    @Unique
    public boolean canApplyEffect(@NotNull class_1291 effect) {
        return OverhauledBeaconBlockEntityKt.canApplyEffect(this, effect);
    }
}

