/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import team.reborn.energy.api.EnergyStorage;

public abstract class AbstractStorageMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    protected final EnergyComponent energy;
    private final RedstoneControlComponent redstoneControl;
    protected final MIEnergyStorage insertable;
    protected final MIEnergyStorage extractable;
    protected final long euCapacity;
    protected final CableTier from;
    protected final CableTier to;
    protected boolean extractableOnOutputDirection;

    public AbstractStorageMachineBlockEntity(BEP bep, CableTier from, CableTier to, String name, long euCapacity) {
        this(bep, from, to, name, euCapacity, true);
    }

    public AbstractStorageMachineBlockEntity(BEP bep, CableTier from, CableTier to, String name, long euCapacity, boolean extractableOnOutputDirection) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(true, false, false));
        this.from = from;
        this.to = to;
        this.euCapacity = euCapacity;
        this.energy = new EnergyComponent((class_2586)this, euCapacity);
        this.redstoneControl = new RedstoneControlComponent();
        this.insertable = this.energy.buildInsertable(tier -> tier == from);
        this.extractable = this.energy.buildExtractable(tier -> tier == to && this.redstoneControl.doAllowNormalOperation(this));
        this.registerComponents(this.energy, this.redstoneControl);
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[2];
        serverArray[0] = new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        serverArray[1] = new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl);
        this.registerGuiComponent(serverArray);
        this.extractableOnOutputDirection = extractableOnOutputDirection;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public static MachineCasing getCasingFromTier(CableTier from, CableTier to) {
        if (from.eu > to.eu) {
            return from.casing;
        }
        return to.casing;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (!this.field_11863.method_8608()) {
            if (this.extractableOnOutputDirection) {
                EnergyHelper.autoOutput((MachineBlockEntity)this, this.orientation, this.to, this.extractable);
            } else {
                for (class_2350 side : class_2350.values()) {
                    if (side == this.orientation.outputDirection) continue;
                    EnergyHelper.autoOutput((MachineBlockEntity)this, side, this.to, this.extractable);
                }
            }
        }
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        EnergyStorage energyItem = (EnergyStorage)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand).find(EnergyApi.ITEM);
        if (energyItem != null) {
            if (!player.method_37908().method_8608()) {
                Transaction transaction;
                int i;
                boolean insertedSomething = false;
                for (i = 0; i < 10000; ++i) {
                    transaction = Transaction.openOuter();
                    try {
                        long inserted = energyItem.insert(this.energy.getEu(), (TransactionContext)transaction);
                        if (inserted == 0L) break;
                        insertedSomething = true;
                        this.energy.consumeEu(inserted, Simulation.ACT);
                        transaction.commit();
                        continue;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                }
                if (!insertedSomething) {
                    for (i = 0; i < 10000; ++i) {
                        transaction = Transaction.openOuter();
                        try {
                            long extracted = energyItem.extract(this.energy.getRemainingCapacity(), (TransactionContext)transaction);
                            if (extracted == 0L) break;
                            this.energy.insertEu(extracted, Simulation.ACT);
                            transaction.commit();
                            continue;
                        }
                        finally {
                            if (transaction != null) {
                                transaction.close();
                            }
                        }
                    }
                }
            }
            return class_1269.method_29236((boolean)player.method_37908().method_8608());
        }
        return super.onUse(player, hand, face);
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.SIDED.registerForBlockEntities((be, direction) -> {
            AbstractStorageMachineBlockEntity abe = (AbstractStorageMachineBlockEntity)be;
            if (abe.extractableOnOutputDirection) {
                if (abe.orientation.outputDirection == direction) {
                    return abe.extractable;
                }
                return abe.insertable;
            }
            if (abe.orientation.outputDirection == direction) {
                return abe.insertable;
            }
            return abe.extractable;
        }, new class_2591[]{bet});
    }
}

