/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.DynamicEnchantmentItem;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.draylar.magna.Magna;
import dev.draylar.magna.api.MagnaTool;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5251;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.Nullable;

public class SteamDrillItem
extends class_1792
implements DynamicToolItem,
MagnaTool,
DynamicEnchantmentItem,
ItemContainingItemHelper {
    public static final StorageBehaviour<ItemVariant> DRILL_BEHAVIOUR = new StorageBehaviour<ItemVariant>(){

        @Override
        public long getCapacityForResource(ItemVariant resource) {
            return resource.getItem().method_7882();
        }

        @Override
        public boolean canInsert(ItemVariant item) {
            Integer burnTicks = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.getItem());
            return burnTicks != null && burnTicks > 0;
        }
    };
    private static final int FULL_WATER = 18000;

    public SteamDrillItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7894(class_1814.field_8907));
    }

    private static boolean isNotSilkTouch(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577("nosilk");
    }

    private static void setSilkTouch(class_1799 stack, boolean silkTouch) {
        if (silkTouch) {
            stack.method_7983("nosilk");
        } else {
            stack.method_7948().method_10556("nosilk", true);
        }
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return this.canUse(newStack);
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        int requiredLevel = MiningLevelManager.getRequiredMiningLevel((class_2680)state);
        return requiredLevel <= 4 && this.canUse(stack) && this.isSupportedBlock(stack, state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (this.canUse(stack)) {
            if (this.isSuitableFor(stack, state)) {
                float speed = 4.0f;
                class_1657 player = CommonProxy.INSTANCE.findUser(stack);
                if (Magna.CONFIG.breakSingleBlockWhenSneaking && player != null && player.method_5715()) {
                    speed *= 4.0f;
                }
                return speed;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173 && this.canUse(stack)) {
            return ItemHelper.createToolModifiers(5.0);
        }
        return ImmutableMultimap.of();
    }

    public int getRadius(class_1799 stack) {
        return 1;
    }

    public boolean playBreakEffects() {
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        this.useFuel(stack, miner);
        return true;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        this.useFuel(stack, attacker);
        return true;
    }

    private void useFuel(class_1799 stack, @Nullable class_1309 entity) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10550("water") > 0 && tag.method_10550("burnTicks") == 0) {
            int burnTicks = this.consumeFuel(stack, Simulation.ACT);
            tag = stack.method_7948();
            tag.method_10569("burnTicks", burnTicks);
            tag.method_10569("maxBurnTicks", burnTicks);
            if (burnTicks > 0 && entity != null) {
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14993, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5808 && user.method_5715()) {
            class_1799 stack = user.method_5998(hand);
            SteamDrillItem.setSilkTouch(stack, SteamDrillItem.isNotSilkTouch(stack));
            if (!world.field_9236) {
                user.method_7353((class_2561)(SteamDrillItem.isNotSilkTouch(stack) ? MIText.ToolSwitchedNoSilkTouch.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
        }
        class_1799 itemStack = user.method_5998(hand);
        class_3965 hitResult = SteamDrillItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1347);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemStack);
        }
        class_3610 fluidState = world.method_8316(hitResult.method_17777());
        if (fluidState.method_15772() == class_3612.field_15910 || fluidState.method_15772() == class_3612.field_15909) {
            this.fillWater(user, itemStack);
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return super.method_7836(world, user, hand);
    }

    private void fillWater(class_1657 player, class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10550("water") != 18000) {
            tag.method_10569("water", 18000);
            player.method_17356(class_3417.field_15126, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2487 tag = stack.method_7948();
        int burnTicks = tag.method_10550("burnTicks");
        if (burnTicks > 0) {
            NbtHelper.putNonzeroInt(tag, "burnTicks", Math.max(0, burnTicks - 5));
            NbtHelper.putNonzeroInt(tag, "water", Math.max(0, tag.method_10550("water") - 5));
        }
        if (tag.method_10550("burnTicks") == 0) {
            tag.method_10551("maxBurnTicks");
        }
        if (tag.method_10550("water") == 0 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1661 inv = player.method_31548();
            for (int i = 0; i < inv.method_5439() && !this.tryFillWater(player, stack, inv.method_5438(i)); ++i) {
            }
        }
    }

    public boolean canUse(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || tag.method_10550("water") == 0) {
            return false;
        }
        return tag.method_10550("burnTicks") > 0 || this.consumeFuel(stack, Simulation.SIMULATE) > 0;
    }

    private int consumeFuel(class_1799 stack, Simulation simulation) {
        Integer burnTicks = (Integer)FuelRegistry.INSTANCE.get((class_1935)this.getResource(stack).getItem());
        if (burnTicks != null && burnTicks > 0) {
            if (simulation.isActing()) {
                class_1792 burnt = this.getResource(stack).getItem();
                this.setAmount(stack, this.getAmount(stack) - 1L);
                if (burnt.method_7857()) {
                    try (Transaction tx = Transaction.openOuter();){
                        ContainerItem.GenericItemStorage<ItemVariant> storage = ContainerItem.GenericItemStorage.of(stack, this);
                        storage.insert(ItemVariant.of((class_1935)burnt.method_7858()), 1L, (TransactionContext)tx, true, true);
                        tx.commit();
                    }
                }
            }
            return burnTicks;
        }
        return 0;
    }

    @Override
    public Reference2IntMap<class_1887> getEnchantments(class_1799 stack) {
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        if (!SteamDrillItem.isNotSilkTouch(stack)) {
            map.put((Object)class_1893.field_9099, 1);
        }
        return map;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            return Optional.of(new SteamDrillTooltipData(tag.method_10550("water") * 100 / 18000, tag.method_10550("burnTicks"), tag.method_10550("maxBurnTicks"), this.getResource(stack), this.getAmount(stack)));
        }
        return Optional.of(new SteamDrillTooltipData(0, 0, 1, ItemVariant.blank(), 0L));
    }

    public boolean method_31565(class_1799 stackBarrel, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stackBarrel, class_1799 itemStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.handleOtherStackedOnMe(stackBarrel, itemStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public boolean handleClick(class_1657 player, class_1799 barrelLike, Mutable<class_1799> otherStack) {
        if (this.tryFillWater(player, barrelLike, (class_1799)otherStack.getValue())) {
            return true;
        }
        return ItemContainingItemHelper.super.handleClick(player, barrelLike, otherStack);
    }

    private boolean tryFillWater(class_1657 player, class_1799 barrelLike, class_1799 fillSource) {
        Storage otherStorage = (Storage)ContainerItemContext.withConstant((class_1799)fillSource).find(FluidStorage.ITEM);
        if (otherStorage != null) {
            long totalWater = 0L;
            for (StorageView view : otherStorage) {
                if (!((FluidVariant)view.getResource()).isOf((Object)class_3612.field_15910)) continue;
                totalWater += view.getAmount();
            }
            if (totalWater * (long)fillSource.method_7947() >= 81000L) {
                this.fillWater(player, barrelLike);
                return true;
            }
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        SteamDrillTooltipData data = (SteamDrillTooltipData)this.method_32346(stack).get();
        tooltip.add((class_2561)MIText.WaterPercent.text(data.waterLevel).method_10862(TextHelper.WATER_TEXT));
        int barWater = (int)Math.ceil((double)data.waterLevel / 5.0);
        int barVoid = 20 - barWater;
        tooltip.add((class_2561)class_2561.method_43470((String)"|".repeat(barWater)).method_10862(TextHelper.WATER_TEXT).method_10852((class_2561)class_2561.method_43470((String)"|".repeat(barVoid)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0x6B6B6B)))));
        if (data.burnTicks > 0) {
            tooltip.add((class_2561)MIText.SecondsLeft.text(data.burnTicks / 100).method_10862(TextHelper.GRAY_TEXT));
        }
    }

    @Override
    public StorageBehaviour<ItemVariant> getBehaviour() {
        return DRILL_BEHAVIOUR;
    }

    public record SteamDrillTooltipData(int waterLevel, int burnTicks, int maxBurnTicks, ItemVariant variant, long amount) implements class_5632
    {
    }
}

