/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import team.reborn.energy.api.base.SimpleEnergyItem;

public class PortableStorageUnit
extends class_1792
implements ItemContainingItemHelper {
    public static final Reference2LongMap<class_1792> CAPACITY_PER_BATTERY = new Reference2LongOpenHashMap();
    private static final int MAX_BATTERY_COUNT = 10000;

    public PortableStorageUnit(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    @Override
    public void onChange(class_1799 stack) {
        this.setStoredEnergy(stack, Math.min(this.getEnergyCapacity(stack), this.getStoredEnergy(stack)));
    }

    public long getEnergyCapacity(class_1799 stack) {
        if (this.isEmpty(stack)) {
            return 0L;
        }
        return CAPACITY_PER_BATTERY.getLong((Object)this.getResource(stack).getItem()) * this.getAmount(stack);
    }

    public long getEnergyMaxInput(class_1799 stack) {
        return Long.MAX_VALUE;
    }

    public long getEnergyMaxOutput(class_1799 stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public StorageBehaviour<ItemVariant> getBehaviour() {
        return new StorageBehaviour<ItemVariant>(){

            @Override
            public long getCapacityForResource(ItemVariant resource) {
                return 10000L;
            }

            @Override
            public boolean canInsert(ItemVariant maybeBattery) {
                return CAPACITY_PER_BATTERY.containsKey((Object)maybeBattery.getItem());
            }
        };
    }

    public boolean method_31565(class_1799 stackBarrel, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.handleOtherStackedOnMe(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!this.isEmpty(stack)) {
            return Optional.of(new BarrelTooltipData(this.getResource(stack), this.getAmount(stack), 10000L, false));
        }
        return Optional.empty();
    }

    public boolean method_31567(class_1799 stack) {
        return this.getEnergyCapacity(stack) > 0L;
    }

    public int method_31569(class_1799 stack) {
        if (this.getEnergyCapacity(stack) > 0L) {
            return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.getEnergyCapacity(stack) * 13.0);
        }
        return 0;
    }

    public long getStoredEnergy(class_1799 stack) {
        return SimpleEnergyItem.getStoredEnergyUnchecked((class_1799)stack);
    }

    public void setStoredEnergy(class_1799 stack, long newAmount) {
        SimpleEnergyItem.setStoredEnergyUnchecked((class_1799)stack, (long)newAmount);
    }
}

