/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_2540;

public class SlotPositions {
    private final int[] x;
    private final int[] y;

    private SlotPositions(int[] x, int[] y) {
        this.x = x;
        this.y = y;
    }

    public int getX(int index) {
        return this.x[index];
    }

    public int getY(int index) {
        return this.y[index];
    }

    public int size() {
        return this.x.length;
    }

    public void write(class_2540 buf) {
        buf.method_10806(this.x);
        buf.method_10806(this.y);
    }

    public SlotPositions sublist(int start, int end) {
        return new SlotPositions(Arrays.copyOfRange(this.x, start, end), Arrays.copyOfRange(this.y, start, end));
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        for (int i = 0; i < this.x.length; ++i) {
            builder.addSlot(this.x[i], this.y[i]);
        }
        return builder;
    }

    public static SlotPositions read(class_2540 buf) {
        int[] x = buf.method_10787();
        int[] y = buf.method_10787();
        return new SlotPositions(x, y);
    }

    public static SlotPositions empty() {
        return new SlotPositions(new int[0], new int[0]);
    }

    public static class Builder {
        private final ArrayList<Integer> x = new ArrayList();
        private final ArrayList<Integer> y = new ArrayList();

        public Builder addSlot(int x, int y) {
            this.x.add(x);
            this.y.add(y);
            return this;
        }

        public Builder addSlots(int x, int y, int columns, int rows) {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    this.addSlot(x + j * 18, y + i * 18);
                }
            }
            return this;
        }

        public SlotPositions build() {
            return new SlotPositions(this.x.stream().mapToInt(x -> x).toArray(), this.y.stream().mapToInt(y -> y).toArray());
        }

        public SlotPositions buildWithConsumer(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this.build();
        }
    }
}

