/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class TagsToGenerate {
    static final Map<String, List<class_1792>> tagToItemMap = new HashMap<String, List<class_1792>>();
    static final Set<String> optionalTags = new HashSet<String>();
    public static final Map<String, String> tagTranslations = new HashMap<String, String>();
    static final Map<String, Set<String>> tagToBeAddedToAnotherTag = new HashMap<String, Set<String>>();

    private static void addTranslation(String tag, String tagEnglishName) {
        class_2960 tagId = new class_2960(tag);
        tagTranslations.put("tag.%s.%s".formatted(tagId.method_12836(), tagId.method_12832()).replace('/', '.'), tagEnglishName);
    }

    public static void generateTag(String tag, class_1792 item, String tagEnglishName) {
        if (tag.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tag);
        }
        tagToItemMap.computeIfAbsent(tag, t -> new ArrayList()).add(item);
        TagsToGenerate.addTranslation(tag, tagEnglishName);
    }

    public static void addTagToTag(String tagTobeAdded, String tagTarget, String targetEnglishName) {
        if (tagTobeAdded.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTobeAdded);
        }
        if (tagTarget.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTarget);
        }
        tagToBeAddedToAnotherTag.computeIfAbsent(tagTarget, t -> new TreeSet()).add(tagTobeAdded);
        TagsToGenerate.addTranslation(tagTarget, targetEnglishName);
    }

    public static void generateTag(class_6862<class_1792> tag, class_1792 item, String tagEnglishName) {
        TagsToGenerate.generateTag(tag.comp_327().toString(), item, tagEnglishName);
    }

    public static void markTagOptional(class_6862<class_1792> tag) {
        optionalTags.add(tag.comp_327().toString());
    }
}

