/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.mixins.WalkAnimationStateAccessor;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5131;
import net.minecraft.class_6025;

public class PetInfo {
    private class_1309 petEntity;
    private class_1309 alivePetSnapshot;
    private class_1309 deadPetSnapshot;
    private boolean inAltar;
    private boolean inItem;
    private boolean isAlive;
    private String ownerName;
    private class_5131 attributeMap;

    public PetInfo(class_1309 entity) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(entity)) {
                isException = true;
                this.ownerName = DawnEraHelper.getOwnerName(entity);
            }
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(entity)) {
                isException = true;
                this.ownerName = DomesticationHelper.getOwnerName(entity);
            }
        }
        if (!isException) {
            this.ownerName = ((class_6025)entity).method_35057().method_5476().getString();
        }
        this.attributeMap = entity.method_6127();
        this.setupSnapshots();
    }

    public PetInfo(class_1309 entity, String ownerName) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        this.ownerName = ownerName;
        this.attributeMap = entity.method_6127();
        this.setupSnapshots();
    }

    public PetInfo() {
    }

    public void setInAltar(boolean flag) {
        this.inAltar = flag;
    }

    public boolean isInAltar() {
        return this.inAltar;
    }

    public void setInItem(boolean flag) {
        this.inItem = flag;
    }

    public boolean isInItem() {
        return this.inItem;
    }

    public class_1309 getPetEntity() {
        return this.petEntity;
    }

    public class_2499 getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.method_26855();
        }
        return new class_2499();
    }

    public class_1309 getRender() {
        return this.isAlive ? this.alivePetSnapshot : this.deadPetSnapshot;
    }

    public String getOwner() {
        return this.ownerName;
    }

    public void updateEntity(class_1309 newEntity) {
        this.petEntity = newEntity;
    }

    public void updateAttributes(class_1309 entity) {
        this.attributeMap = entity.method_6127();
    }

    public void markDead() {
        this.isAlive = false;
    }

    public void revive() {
        this.isAlive = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public class_2487 save(class_2487 tag) {
        if (this.petEntity != null) {
            tag = this.petEntity.method_5647(tag);
            tag.method_10582("pp_type", class_1299.method_5890((class_1299)this.petEntity.method_5864()).toString());
            tag.method_10556("pp_altar", this.inAltar);
            tag.method_10556("pp_item", this.inItem);
            tag.method_10556("pp_alive", this.isAlive);
            tag.method_10582("pp_owner", this.ownerName);
            if (this.attributeMap != null) {
                tag.method_10566("pp_attributes", (class_2520)this.attributeMap.method_26855());
            }
        }
        return tag;
    }

    public void load(UUID petId, class_2487 tag, class_1937 level) {
        if (!tag.method_10545("pp_type")) {
            return;
        }
        Optional entityType = class_1299.method_5898((String)tag.method_10558("pp_type"));
        if (entityType.isEmpty()) {
            return;
        }
        this.petEntity = (class_1309)((class_1299)entityType.get()).method_5883(level);
        if (this.petEntity == null) {
            return;
        }
        this.petEntity.method_5651(tag);
        this.petEntity.method_5826(petId);
        this.inAltar = tag.method_10545("pp_altar") && tag.method_10577("pp_altar");
        this.inItem = tag.method_10545("pp_item") && tag.method_10577("pp_item");
        this.isAlive = tag.method_10545("pp_alive") && tag.method_10577("pp_alive");
        String string = this.ownerName = tag.method_10545("pp_owner") ? tag.method_10558("pp_owner") : "";
        if (tag.method_10545("pp_attributes")) {
            this.attributeMap = this.petEntity.method_6127();
            this.attributeMap.method_26850(tag.method_10554("pp_attributes", 10));
        }
        this.setupSnapshots();
        level.method_16107().method_15407();
    }

    private void setupSnapshots() {
        this.alivePetSnapshot = (class_1309)this.petEntity.method_5864().method_5883(this.petEntity.method_37908());
        if (this.alivePetSnapshot != null) {
            this.alivePetSnapshot.method_5878((class_1297)this.petEntity);
            this.alivePetSnapshot.method_5826(this.petEntity.method_5667());
            this.alivePetSnapshot.field_6283 = 0.0f;
            this.alivePetSnapshot.field_6220 = 0.0f;
            this.alivePetSnapshot.field_5982 = 0.0f;
            this.alivePetSnapshot.field_6004 = 0.0f;
            this.alivePetSnapshot.method_36456(0.0f);
            this.alivePetSnapshot.method_36457(0.0f);
            this.alivePetSnapshot.field_6241 = 0.0f;
            this.alivePetSnapshot.field_6259 = 0.0f;
            this.alivePetSnapshot.field_6213 = 0;
            ((WalkAnimationStateAccessor)this.alivePetSnapshot.field_42108).setSpeedOld(0.0f);
            this.alivePetSnapshot.method_6125(0.0f);
            ((WalkAnimationStateAccessor)this.alivePetSnapshot.field_42108).setPosition(0.0f);
            this.alivePetSnapshot.field_6014 = 0.0;
            this.alivePetSnapshot.field_5969 = 0.0;
            this.alivePetSnapshot.field_6251 = 0.0f;
            this.petEntity.method_37908().method_16107().method_15407();
        }
        this.deadPetSnapshot = (class_1309)this.petEntity.method_5864().method_5883(this.petEntity.method_37908());
        if (this.deadPetSnapshot != null) {
            this.deadPetSnapshot.method_5878((class_1297)this.petEntity);
            this.deadPetSnapshot.method_5826(this.petEntity.method_5667());
            this.deadPetSnapshot.field_6283 = 0.0f;
            this.deadPetSnapshot.field_6220 = 0.0f;
            this.deadPetSnapshot.field_5982 = 0.0f;
            this.deadPetSnapshot.field_6004 = 0.0f;
            this.deadPetSnapshot.method_36456(0.0f);
            this.deadPetSnapshot.method_36457(0.0f);
            this.deadPetSnapshot.field_6241 = 0.0f;
            this.deadPetSnapshot.field_6259 = 0.0f;
            this.deadPetSnapshot.field_6213 = 20;
            ((WalkAnimationStateAccessor)this.deadPetSnapshot.field_42108).setSpeedOld(0.0f);
            this.deadPetSnapshot.method_6125(0.0f);
            ((WalkAnimationStateAccessor)this.deadPetSnapshot.field_42108).setPosition(0.0f);
            this.deadPetSnapshot.field_6014 = 0.0;
            this.deadPetSnapshot.field_5969 = 0.0;
            this.deadPetSnapshot.field_6251 = 0.0f;
            this.petEntity.method_37908().method_16107().method_15407();
        }
    }
}

