/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.items;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.blocks.ReviveAltarBlock;
import com.shiftthedev.pickablepets.blocks.blockentities.ReviveAltarBlockEntity;
import com.shiftthedev.pickablepets.utils.CachedPets;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PetItem
extends class_1792 {
    public static final int VERSION = 2;

    public PetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 ctx) {
        if (!(ctx.method_8036() instanceof class_3222)) {
            return class_1269.field_5812;
        }
        class_1937 level = ctx.method_8045();
        if (ctx.method_20287() != class_1268.field_5808) {
            return class_1269.field_5814;
        }
        class_1799 itemStack = ctx.method_8041();
        class_2487 tag = itemStack.method_7911("pet_info");
        if (CachedPets.getOwner(tag.method_25926("UUID")).isEmpty()) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = ctx.method_8037();
        class_2350 direction = ctx.method_8038();
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_26204() instanceof ReviveAltarBlock) {
            return this.configureAltar(ctx.method_8045(), blockPos, tag);
        }
        return this.placePet(ctx.method_8036(), level, blockState, blockPos, direction, itemStack, tag);
    }

    private class_1269 configureAltar(class_1937 level, class_2338 blockPos, class_2487 tag) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof ReviveAltarBlockEntity)) {
            return class_1269.field_5814;
        }
        ReviveAltarBlockEntity reviveAltarBlockEntity = (ReviveAltarBlockEntity)blockEntity;
        if (!tag.method_25928("UUID")) {
            return class_1269.field_5814;
        }
        if (CachedPets.isInAltar(tag.method_25926("UUID"))) {
            return class_1269.field_5814;
        }
        if (reviveAltarBlockEntity.hasPet()) {
            return class_1269.field_5814;
        }
        reviveAltarBlockEntity.setPet(tag.method_25926("UUID"));
        CachedPets.sendPetsToPlayers(level, tag.method_25926("UUID"));
        level.method_16107().method_15407();
        return class_1269.field_21466;
    }

    private class_1269 placePet(class_1657 player, class_1937 level, class_2680 blockState, class_2338 blockPos, class_2350 direction, class_1799 itemStack, class_2487 tag) {
        class_1309 pet;
        UUID petUUID = tag.method_25926("UUID");
        class_1309 cachedPet = CachedPets.getPet(petUUID);
        if (cachedPet == null) {
            return class_1269.field_5814;
        }
        if (!blockState.method_26220((class_1922)level, blockPos).method_1110()) {
            blockPos = direction == class_2350.field_11033 ? blockPos.method_10079(direction, 2) : blockPos.method_10093(direction);
        }
        if ((pet = (class_1309)cachedPet.method_5864().method_5883(level)) == null) {
            return class_1269.field_5814;
        }
        pet.method_5878((class_1297)cachedPet);
        pet.method_6127().method_26850(CachedPets.getPetAttributes(petUUID));
        pet.method_33574(class_243.method_24953((class_2382)blockPos));
        if (!level.method_8649((class_1297)pet)) {
            return class_1269.field_5814;
        }
        if (player.method_7337()) {
            player.method_31548().method_7378(itemStack);
        } else {
            itemStack.method_7939(0);
        }
        CachedPets.setPetItem(petUUID, false);
        CachedPets.sendPetsToPlayers(level, petUUID);
        level.method_16107().method_15407();
        return class_1269.field_5812;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        if (itemStack.method_7938()) {
            return itemStack.method_7964();
        }
        return class_2561.method_43471((String)itemStack.method_7911("pet_info").method_10558("pet_default_name"));
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, list, tooltipFlag);
        class_2487 tag = itemStack.method_7911("pet_info");
        if (!tag.method_10545("UUID")) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablepets.empty"));
            return;
        }
        list.add((class_2561)class_2561.method_43469((String)"tooltip.pickablepets.owner", (Object[])new Object[]{CachedPets.getOwner(tag.method_25926("UUID"))}));
        if (PickablePets.CONFIG.ReviveAltar) {
            list.add((class_2561)class_2561.method_43469((String)"tooltip.pickablepets.altar", (Object[])new Object[]{CachedPets.isInAltar(tag.method_25926("UUID")) ? "\u00a72Yes" : "\u00a74No"}));
        }
    }
}

