/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import wile.redstonepen.libmc.Auxiliaries;

@Environment(value=EnvType.CLIENT)
public class TooltipDisplay {
    private static long default_delay = 450L;
    private static int default_max_deviation = 1;
    private List<TipRange> ranges = new ArrayList<TipRange>();
    private long delay = default_delay;
    private int max_deviation = default_max_deviation;
    private int x_last;
    private int y_last;
    private long t = System.currentTimeMillis();
    private final class_327 font;
    private static boolean had_render_exception = false;

    public static void config(int delay, int max_deviation) {
        default_delay = class_3532.method_15340((int)delay, (int)500, (int)5000);
        default_max_deviation = class_3532.method_15340((int)max_deviation, (int)1, (int)5);
    }

    public TooltipDisplay() {
        this.font = class_310.method_1551().field_1772;
    }

    public TooltipDisplay init(List<TipRange> ranges, long delay_ms, int max_deviation_xy) {
        this.ranges = ranges;
        this.delay = delay_ms;
        this.max_deviation = max_deviation_xy;
        this.t = System.currentTimeMillis();
        this.y_last = 0;
        this.x_last = 0;
        return this;
    }

    public TooltipDisplay init(List<TipRange> ranges) {
        return this.init(ranges, default_delay, default_max_deviation);
    }

    public TooltipDisplay init(TipRange ... ranges) {
        return this.init(Arrays.asList(ranges), default_delay, default_max_deviation);
    }

    public TooltipDisplay delay(int ms) {
        this.delay = ms <= 0 ? default_delay : (long)ms;
        return this;
    }

    public void resetTimer() {
        this.t = System.currentTimeMillis();
    }

    public <T extends class_1703> boolean render(class_332 gg, class_465<T> gui, int x, int y) {
        if (had_render_exception) {
            return false;
        }
        if (Math.abs(x - this.x_last) > this.max_deviation || Math.abs(y - this.y_last) > this.max_deviation) {
            this.x_last = x;
            this.y_last = y;
            this.resetTimer();
            return false;
        }
        if (Math.abs(System.currentTimeMillis() - this.t) < this.delay) {
            return false;
        }
        if (this.ranges.stream().noneMatch(tip -> {
            if (x < tip.x0 || x > tip.x1 || y < tip.y0 || y > tip.y1) {
                return false;
            }
            class_2561 tip_component = tip.text.get();
            if (tip_component.getString().isEmpty()) {
                return false;
            }
            try {
                List<class_2561> lines = Auxiliaries.wrapText(tip_component, 80);
                gg.method_51437(this.font, lines, Optional.empty(), x, y);
            }
            catch (Exception ex) {
                had_render_exception = true;
                Auxiliaries.logError("Tooltip rendering disabled due to exception: '" + ex.getMessage() + "'");
                return false;
            }
            return true;
        })) {
            this.resetTimer();
            return false;
        }
        return true;
    }

    public static class TipRange {
        public final int x0;
        public final int y0;
        public final int x1;
        public final int y1;
        public final Supplier<class_2561> text;

        public TipRange(int x, int y, int w, int h, class_2561 text) {
            this(x, y, w, h, () -> text);
        }

        public TipRange(int x, int y, int w, int h, Supplier<class_2561> text) {
            this.text = text;
            this.x0 = x;
            this.y0 = y;
            this.x1 = this.x0 + w - 1;
            this.y1 = this.y0 + h - 1;
        }
    }
}

