/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_6862;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import wile.redstonepen.libmc.Auxiliaries;

public class Registries {
    private static final String modid = "redstonepen";
    private static final Map<String, class_6862<class_2248>> registered_block_tag_keys = new HashMap<String, class_6862<class_2248>>();
    private static final Map<String, class_6862<class_1792>> registered_item_tag_keys = new HashMap<String, class_6862<class_1792>>();
    private static final List<class_3545<String, Supplier<? extends class_2248>>> block_suppliers = new ArrayList<class_3545<String, Supplier<? extends class_2248>>>();
    private static final List<class_3545<String, Supplier<? extends class_1792>>> item_suppliers = new ArrayList<class_3545<String, Supplier<? extends class_1792>>>();
    private static final List<class_3545<String, Supplier<? extends class_2591<?>>>> block_entity_type_suppliers = new ArrayList();
    private static final List<class_3545<String, Supplier<? extends class_1299<?>>>> entity_type_suppliers = new ArrayList();
    private static final List<class_3545<String, Supplier<? extends class_3917<?>>>> menu_type_suppliers = new ArrayList();
    private static final List<class_3545<String, Supplier<? extends class_1865<?>>>> recipe_serializers_suppliers = new ArrayList();
    private static final List<String> block_item_order = new ArrayList<String>();
    private static final Map<String, class_2248> registered_blocks = new HashMap<String, class_2248>();
    private static final Map<String, class_1792> registered_items = new HashMap<String, class_1792>();
    private static final Map<String, class_2591<?>> registered_block_entity_types = new HashMap();
    private static final Map<String, class_1299<?>> registered_entity_types = new HashMap();
    private static final Map<String, class_3917<?>> registered_menu_types = new HashMap();
    private static final Map<String, class_1865<?>> registered_recipe_serializers = new HashMap();

    public static void init() {
    }

    public static void instantiateAll() {
        registered_blocks.clear();
        block_suppliers.forEach(reg -> {
            registered_blocks.put((String)reg.method_15442(), (class_2248)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(modid, (String)reg.method_15442()), (Object)registered_blocks.get(reg.method_15442()));
        });
        registered_items.clear();
        item_suppliers.forEach(reg -> {
            registered_items.put((String)reg.method_15442(), (class_1792)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(modid, (String)reg.method_15442()), (Object)registered_items.get(reg.method_15442()));
        });
        registered_block_entity_types.clear();
        block_entity_type_suppliers.forEach(reg -> {
            registered_block_entity_types.put((String)reg.method_15442(), (class_2591)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960(modid, (String)reg.method_15442()), registered_block_entity_types.get(reg.method_15442()));
        });
        registered_entity_types.clear();
        entity_type_suppliers.forEach(reg -> {
            registered_entity_types.put((String)reg.method_15442(), (class_1299)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(modid, (String)reg.method_15442()), registered_entity_types.get(reg.method_15442()));
        });
        registered_menu_types.clear();
        menu_type_suppliers.forEach(reg -> {
            registered_menu_types.put((String)reg.method_15442(), (class_3917)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(modid, (String)reg.method_15442()), registered_menu_types.get(reg.method_15442()));
        });
        registered_recipe_serializers.clear();
        recipe_serializers_suppliers.forEach(reg -> {
            registered_recipe_serializers.put((String)reg.method_15442(), (class_1865)((Supplier)reg.method_15441()).get());
            class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)new class_2960(modid, (String)reg.method_15442()), registered_recipe_serializers.get(reg.method_15442()));
        });
    }

    public static class_2248 getBlock(String block_name) {
        return registered_blocks.get(block_name);
    }

    public static class_1792 getItem(String name) {
        return registered_items.get(name);
    }

    public static class_1299<?> getEntityType(String name) {
        return registered_entity_types.get(name);
    }

    public static class_2591<?> getBlockEntityType(String block_name) {
        return registered_block_entity_types.get(block_name);
    }

    public static class_3917<?> getMenuType(String name) {
        return registered_menu_types.get(name);
    }

    public static class_1865<?> getRecipeSerializer(String name) {
        return registered_recipe_serializers.get(name);
    }

    public static class_2591<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityType("tet_" + block_name);
    }

    public static class_2591<?> getBlockEntityTypeOfBlock(class_2248 block) {
        return Registries.getBlockEntityTypeOfBlock(class_7923.field_41175.method_10221((Object)block).method_12832());
    }

    public static class_3917<?> getMenuTypeOfBlock(String name) {
        return Registries.getMenuType("ct_" + name);
    }

    public static class_3917<?> getMenuTypeOfBlock(class_2248 block) {
        return Registries.getMenuTypeOfBlock(class_7923.field_41175.method_10221((Object)block).method_12832());
    }

    public static class_6862<class_2248> getBlockTagKey(String name) {
        return registered_block_tag_keys.get(name);
    }

    public static class_6862<class_1792> getItemTagKey(String name) {
        return registered_item_tag_keys.get(name);
    }

    public static List<class_2248> getRegisteredBlocks() {
        return registered_blocks.values().stream().toList();
    }

    public static List<class_1792> getRegisteredItems() {
        return registered_items.values().stream().toList();
    }

    public static List<class_2591<?>> getRegisteredBlockEntityTypes() {
        return registered_block_entity_types.values().stream().toList();
    }

    public static List<class_1299<?>> getRegisteredEntityTypes() {
        return registered_entity_types.values().stream().toList();
    }

    public static <T extends class_1792> void addItem(String registry_name, Supplier<T> supplier) {
        item_suppliers.add((class_3545<String, Supplier<? extends class_1792>>)new class_3545((Object)registry_name, supplier));
    }

    public static <T extends class_2248> void addBlock(String registry_name, Supplier<T> block_supplier) {
        block_suppliers.add((class_3545<String, Supplier<? extends class_2248>>)new class_3545((Object)registry_name, block_supplier));
        item_suppliers.add((class_3545<String, Supplier<? extends class_1792>>)new class_3545((Object)registry_name, () -> new class_1747(registered_blocks.get(registry_name), new class_1792.class_1793())));
    }

    public static <TB extends class_2248, TI extends class_1792> void addBlock(String registry_name, Supplier<TB> block_supplier, Supplier<TI> item_supplier) {
        block_suppliers.add((class_3545<String, Supplier<? extends class_2248>>)new class_3545((Object)registry_name, block_supplier));
        item_suppliers.add((class_3545<String, Supplier<? extends class_1792>>)new class_3545((Object)registry_name, item_supplier));
    }

    public static <T extends class_2586> void addBlockEntityType(String registry_name, FabricBlockEntityTypeBuilder.Factory<T> ctor, String ... block_names) {
        block_entity_type_suppliers.add(new class_3545((Object)registry_name, () -> {
            class_2248[] blocks = Arrays.stream(block_names).map(s -> {
                class_2248 b = registered_blocks.get(s);
                if (b == null) {
                    Auxiliaries.logError("registered_blocks does not encompass '" + s + "'");
                }
                return b;
            }).filter(Objects::nonNull).toList().toArray(new class_2248[0]);
            return FabricBlockEntityTypeBuilder.create((FabricBlockEntityTypeBuilder.Factory)ctor, (class_2248[])blocks).build(null);
        }));
    }

    public static <T extends class_1299<?>> void addEntityType(String registry_name, Supplier<class_1299<?>> supplier) {
        entity_type_suppliers.add(new class_3545((Object)registry_name, supplier));
    }

    public static <T extends class_3917<?>> void addMenuType(String registry_name, class_3917.class_3918<?> supplier) {
        menu_type_suppliers.add(new class_3545((Object)registry_name, () -> new class_3917(supplier, class_7699.method_45397())));
    }

    public static void addRecipeSerializer(String registry_name, Supplier<? extends class_1865<?>> serializer_supplier) {
        recipe_serializers_suppliers.add(new class_3545((Object)registry_name, serializer_supplier));
    }

    public static <TB extends class_2248, TI extends class_1792> void addBlock(String registry_name, Supplier<TB> block_supplier, BiFunction<class_2248, class_1792.class_1793, class_1792> item_builder) {
        Registries.addBlock(registry_name, block_supplier, () -> (class_1792)item_builder.apply(registered_blocks.get(registry_name), new class_1792.class_1793()));
    }

    public static void addBlock(String registry_name, Supplier<? extends class_2248> block_supplier, FabricBlockEntityTypeBuilder.Factory<?> block_entity_ctor) {
        Registries.addBlock(registry_name, block_supplier);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
    }

    public static void addBlock(String registry_name, Supplier<? extends class_2248> block_supplier, BiFunction<class_2248, class_1792.class_1793, class_1792> item_builder, FabricBlockEntityTypeBuilder.Factory<?> block_entity_ctor, class_3917.class_3918<?> menu_type_supplier) {
        Registries.addBlock(registry_name, block_supplier, item_builder);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }

    public static void addBlock(String registry_name, Supplier<? extends class_2248> block_supplier, FabricBlockEntityTypeBuilder.Factory<?> block_entity_ctor, class_3917.class_3918<?> menu_type_supplier) {
        Registries.addBlock(registry_name, block_supplier, block_entity_ctor);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }
}

