/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import wile.redstonepen.libmc.Auxiliaries;

public class ExtendedShapelessRecipe
extends class_1867
implements class_3955 {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_2487 aspects;
    private final class_2960 resultTag;
    private final class_1799 resultItem;

    public ExtendedShapelessRecipe(class_2960 id, String group, class_7710 cat, class_1799 output, class_2371<class_1856> ingredients, class_2487 aspects, class_2960 resultTag) {
        super(id, group, cat, output, ingredients);
        this.aspects = aspects;
        this.resultTag = resultTag;
        this.resultItem = output;
    }

    public class_2487 getAspects() {
        return this.aspects.method_10553();
    }

    private int getToolDamage() {
        if (this.aspects.method_10545("tool_repair")) {
            return -class_3532.method_15340((int)this.aspects.method_10550("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.method_10545("tool_damage")) {
            return class_3532.method_15340((int)this.aspects.method_10550("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private class_3545<class_1799, class_2371<class_1799>> getRepaired(class_8566 inv) {
        class_1799 stack;
        int i;
        String tool_name = this.aspects.method_10558("tool");
        HashMap<class_1792, Integer> repair_items = new HashMap<class_1792, Integer>();
        class_2371 remaining = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        class_1799 tool_item = class_1799.field_8037;
        for (int i2 = 0; i2 < inv.method_5439(); ++i2) {
            class_1799 stack2 = inv.method_5438(i2);
            if (stack2.method_7960()) continue;
            if (Auxiliaries.getResourceLocation(stack2.method_7909()).toString().equals(tool_name)) {
                tool_item = stack2.method_7972();
                continue;
            }
            remaining.set(i2, (Object)stack2.method_7972());
            repair_items.put(stack2.method_7909(), stack2.method_7947() + repair_items.getOrDefault(stack2.method_7909(), 0));
        }
        if (tool_item.method_7960()) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        if (!tool_item.method_7963()) {
            Auxiliaries.logWarn("Repairing '" + Auxiliaries.getResourceLocation(tool_item.method_7909()) + "' can't work, the item is not damageable.");
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int dmg = tool_item.method_7919();
        if (dmg <= 0 && !this.aspects.method_10577("over_repair")) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new class_3545((Object)class_1799.field_8037, (Object)remaining);
        }
        int single_repair_dur = this.aspects.method_10577("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.method_7936() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (class_1792 ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.method_7974(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.method_5438(i);
            if (stack.method_7960() || Auxiliaries.getResourceLocation(stack.method_7909()).toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.method_7909().method_7857() ? new class_1799((class_1935)stack.method_7909().method_7858(), stack.method_7947()) : stack.method_7972()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (class_1799)remaining.get(i);
            class_1792 item = stack.method_7909();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.method_7947() >= n) {
                stack.method_7934(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.method_7947());
            remaining.set(i, (Object)class_1799.field_8037);
        }
        if (tool_item.method_7909() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.method_7909()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.method_7919());
        }
        return new class_3545((Object)tool_item, (Object)remaining);
    }

    public boolean method_8118() {
        return this.isRepair() || this.aspects.method_10577("dynamic");
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        if (this.isRepair()) {
            class_2371 remaining = (class_2371)this.getRepaired(inv).method_15441();
            for (int i = 0; i < remaining.size(); ++i) {
                class_1799 rem_stack = (class_1799)remaining.get(i);
                class_1799 inv_stack = inv.method_5438(i);
                if (inv_stack.method_7960() || !rem_stack.method_7960() && !inv.method_5438(i).method_31574(rem_stack.method_7909())) continue;
                remaining.set(i, (Object)class_1799.field_8037);
                rem_stack.method_7933(1);
                inv.method_5447(i, rem_stack);
            }
            return remaining;
        }
        String tool_name = this.aspects.method_10558("tool");
        int tool_damage = this.getToolDamage();
        class_2371 remaining = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < remaining.size(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (Auxiliaries.getResourceLocation(stack.method_7909()).toString().equals(tool_name)) {
                if (!stack.method_7963()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                class_1799 rstack = stack.method_7972();
                rstack.method_7974(rstack.method_7919() + tool_damage);
                if (rstack.method_7919() >= rstack.method_7936()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.method_7909().method_7857()) continue;
            remaining.set(i, (Object)new class_1799((class_1935)stack.method_7909().method_7858(), stack.method_7947()));
        }
        return remaining;
    }

    public class_1799 method_17729(class_8566 inv, class_5455 ra) {
        int dmg;
        if (this.isRepair()) {
            return (class_1799)this.getRepaired(inv).method_15442();
        }
        class_1799 rstack = super.method_17729(inv, ra);
        if (rstack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.aspects.method_10550("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.method_7936() - this.aspects.method_10550("initial_durability"));
            if (dmg2 > 0) {
                rstack.method_7974(dmg2);
            }
        } else if (this.aspects.method_10550("initial_damage") > 0 && (dmg = Math.min(this.aspects.method_10550("initial_damage"), rstack.method_7936())) > 0) {
            rstack.method_7974(dmg);
        }
        return rstack;
    }

    public class_1799 method_8110(class_5455 ra) {
        return this.method_8118() ? class_1799.field_8037 : this.resultItem;
    }

    public static interface IRepairableToolItem {
        public class_1799 onShapelessRecipeRepaired(class_1799 var1, int var2, int var3);
    }

    public static class Serializer
    implements class_1865<ExtendedShapelessRecipe> {
        private static final int MAX_WIDTH = 3;
        private static final int MAX_HEIGHT = 3;

        public ExtendedShapelessRecipe fromJson(class_2960 recipeId, JsonObject json) {
            JsonObject aspects;
            class_2960 resultTag = new class_2960("libmc", "none");
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371 list = class_2371.method_10211();
            JsonArray ingredients = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)ingredients.get(i));
                if (ingredient.method_8103()) continue;
                list.add((Object)ingredient);
            }
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for " + recipeId.method_12832() + " recipe");
            }
            if (list.size() > 9) {
                throw new JsonParseException("Too many ingredients for crafting_tool_shapeless recipe the max is 9");
            }
            class_2487 aspects_nbt = new class_2487();
            if (json.get("aspects") != null && (aspects = class_3518.method_15296((JsonObject)json, (String)"aspects")).size() > 0) {
                try {
                    aspects_nbt = class_2522.method_10718((String)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)aspects));
                }
                catch (Exception ex) {
                    throw new JsonParseException(recipeId.method_12832() + ": Failed to parse the 'aspects' object:" + ex.getMessage());
                }
            }
            JsonObject res = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 result_stack = class_1869.method_35228((JsonObject)res);
            return new ExtendedShapelessRecipe(recipeId, group, class_7710.field_40251, result_stack, (class_2371<class_1856>)list, aspects_nbt, resultTag);
        }

        public ExtendedShapelessRecipe fromNetwork(class_2960 recipeId, class_2540 pkt) {
            String group = pkt.method_10800(Short.MAX_VALUE);
            int size = pkt.method_10816();
            class_2371 list = class_2371.method_10213((int)size, (Object)class_1856.field_9017);
            list.replaceAll(ignored -> class_1856.method_8086((class_2540)pkt));
            class_1799 stack = pkt.method_10819();
            class_2487 aspects = pkt.method_10798();
            class_2960 resultTag = pkt.method_10810();
            return new ExtendedShapelessRecipe(recipeId, group, class_7710.field_40251, stack, (class_2371<class_1856>)list, aspects, resultTag);
        }

        public void toNetwork(class_2540 pkt, ExtendedShapelessRecipe recipe) {
            pkt.method_10814(recipe.method_8112());
            pkt.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(pkt);
            }
            pkt.method_10793(recipe.resultItem);
            pkt.method_10794(recipe.getAspects());
            pkt.method_10812(recipe.resultTag);
        }
    }
}

