/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3728;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Auxiliaries {
    private static final Logger logger = LogUtils.getLogger();

    public static void init() {
    }

    public static String modid() {
        return "redstonepen";
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isModLoaded(String registry_name) {
        return false;
    }

    public static boolean isDevelopmentMode() {
        return class_155.field_1125;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isShiftDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isCtrlDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)341) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)345);
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<String> getClipboard() {
        return Optional.of(class_3728.method_27556((class_310)class_310.method_1551()));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean setClipboard(String text) {
        class_3728.method_27551((class_310)class_310.method_1551(), (String)text);
        return true;
    }

    public static void logInfo(String msg) {
        logger.info(msg);
    }

    public static void logWarn(String msg) {
        logger.warn(msg);
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static class_5250 localizable(String modtrkey, Object ... args) {
        return class_2561.method_43469((String)(modtrkey.startsWith("block.") || modtrkey.startsWith("item.") ? modtrkey : Auxiliaries.modid() + "." + modtrkey), (Object[])args);
    }

    public static class_5250 localizable(String modtrkey, @Nullable class_124 color, Object ... args) {
        class_5250 tr = class_2561.method_43469((String)(Auxiliaries.modid() + "." + modtrkey), (Object[])args);
        if (color != null) {
            tr.method_10866().method_27706(color);
        }
        return tr;
    }

    public static class_5250 localizable(String modtrkey) {
        return Auxiliaries.localizable(modtrkey, new Object[0]);
    }

    public static class_5250 localizable_block_key(String blocksubkey) {
        return class_2561.method_43471((String)("block." + Auxiliaries.modid() + "." + blocksubkey));
    }

    @Environment(value=EnvType.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        class_5250 tr = class_2561.method_43469((String)translationKey, (Object[])args);
        tr.method_10866().method_27706(class_124.field_1070);
        String ft = tr.getString().trim();
        return ft;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean hasTranslation(String key) {
        return class_1074.method_4663((String)key);
    }

    @Environment(value=EnvType.CLIENT)
    public static List<class_2561> wrapText(class_2561 text, int max_width_percent) {
        int max_width = (class_310.method_1551().method_22683().method_4486() - 10) * max_width_percent / 100;
        return class_310.method_1551().field_1772.method_27527().method_27495((class_5348)text, max_width, class_2583.field_24360).stream().map(ft -> class_2561.method_43470((String)ft.getString())).collect(Collectors.toList());
    }

    public static class_5250 join(Collection<? extends class_2561> components, String separator) {
        return class_2564.method_36332(components, (class_2561)class_2561.method_43470((String)separator), Function.identity());
    }

    public static class_5250 join(class_2561 ... components) {
        class_5250 tc = class_2561.method_43473();
        for (class_2561 c : components) {
            tc.method_10852(c);
        }
        return tc;
    }

    public static boolean isEmpty(class_2561 component) {
        return component.method_10855().isEmpty() && component.getString().isEmpty();
    }

    public static void playerChatMessage(class_1657 player, String message) {
        player.method_7353((class_2561)class_2561.method_43471((String)message.trim()), true);
    }

    @Nullable
    public static class_2561 unserializeTextComponent(String serialized) {
        return class_2561.class_2562.method_10877((String)serialized);
    }

    public static String serializeTextComponent(class_2561 tc) {
        return tc == null ? "" : class_2561.class_2562.method_10867((class_2561)tc);
    }

    public static class_2960 getResourceLocation(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static class_2960 getResourceLocation(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    @Nullable
    public static class_2561 getItemLabel(class_1799 stack) {
        class_2487 nbt = stack.method_7941("display");
        if (nbt != null && nbt.method_10573("Name", 8)) {
            try {
                class_2561 tc = Auxiliaries.unserializeTextComponent(nbt.method_10558("Name"));
                if (tc != null) {
                    return tc;
                }
                nbt.method_10551("Name");
            }
            catch (Exception e) {
                nbt.method_10551("Name");
            }
        }
        return null;
    }

    public static class_1799 setItemLabel(class_1799 stack, @Nullable class_2561 name) {
        if (name != null) {
            class_2487 nbt = stack.method_7911("display");
            nbt.method_10582("Name", Auxiliaries.serializeTextComponent(name));
        } else if (stack.method_7985()) {
            stack.method_7983("display");
        }
        return stack;
    }

    public static boolean isWaterLogged(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12508) && (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false;
    }

    public static class_238 getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new class_238(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static class_238 getRotatedAABB(class_238 bb, class_2350 new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static class_238[] getRotatedAABB(class_238[] bb, class_2350 new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static class_238 getRotatedAABB(class_238 bb, class_2350 new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.method_10146()) {
                case 0: {
                    return new class_238(1.0 - bb.field_1320, bb.field_1321, bb.field_1322, 1.0 - bb.field_1323, bb.field_1324, bb.field_1325);
                }
                case 1: {
                    return new class_238(1.0 - bb.field_1320, 1.0 - bb.field_1324, 1.0 - bb.field_1325, 1.0 - bb.field_1323, 1.0 - bb.field_1321, 1.0 - bb.field_1322);
                }
                case 2: {
                    return new class_238(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
                case 3: {
                    return new class_238(1.0 - bb.field_1320, bb.field_1322, 1.0 - bb.field_1324, 1.0 - bb.field_1323, bb.field_1325, 1.0 - bb.field_1321);
                }
                case 4: {
                    return new class_238(bb.field_1321, bb.field_1322, 1.0 - bb.field_1320, bb.field_1324, bb.field_1325, 1.0 - bb.field_1323);
                }
                case 5: {
                    return new class_238(1.0 - bb.field_1324, bb.field_1322, bb.field_1323, 1.0 - bb.field_1321, bb.field_1325, bb.field_1320);
                }
            }
        } else {
            switch (new_facing.method_10146()) {
                case 0: {
                    return new class_238(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
                case 1: {
                    return new class_238(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
                case 2: {
                    return new class_238(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
                case 3: {
                    return new class_238(1.0 - bb.field_1320, bb.field_1322, 1.0 - bb.field_1324, 1.0 - bb.field_1323, bb.field_1325, 1.0 - bb.field_1321);
                }
                case 4: {
                    return new class_238(bb.field_1321, bb.field_1322, 1.0 - bb.field_1320, bb.field_1324, bb.field_1325, 1.0 - bb.field_1323);
                }
                case 5: {
                    return new class_238(1.0 - bb.field_1324, bb.field_1322, bb.field_1323, 1.0 - bb.field_1321, bb.field_1325, bb.field_1320);
                }
            }
        }
        return bb;
    }

    public static class_238[] getRotatedAABB(class_238[] bbs, class_2350 new_facing, boolean horizontal_rotation) {
        class_238[] transformed = new class_238[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static class_238 getYRotatedAABB(class_238 bb, int clockwise_90deg_steps) {
        class_2350[] direction_map = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
        return Auxiliaries.getRotatedAABB(bb, direction_map[clockwise_90deg_steps + 4096 & 3], true);
    }

    public static class_238[] getYRotatedAABB(class_238[] bbs, int clockwise_90deg_steps) {
        class_238[] transformed = new class_238[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getYRotatedAABB(bbs[i], clockwise_90deg_steps);
        }
        return transformed;
    }

    public static class_238 getMirroredAABB(class_238 bb, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new class_238(1.0 - bb.field_1320, bb.field_1322, bb.field_1321, 1.0 - bb.field_1323, bb.field_1325, bb.field_1324);
            case class_2350.class_2351.field_11052 -> new class_238(bb.field_1323, 1.0 - bb.field_1325, bb.field_1321, bb.field_1320, 1.0 - bb.field_1322, bb.field_1324);
            case class_2350.class_2351.field_11051 -> new class_238(bb.field_1323, bb.field_1322, 1.0 - bb.field_1324, bb.field_1320, bb.field_1325, 1.0 - bb.field_1321);
        };
    }

    public static class_238[] getMirroredAABB(class_238[] bbs, class_2350.class_2351 axis) {
        class_238[] transformed = new class_238[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getMirroredAABB(bbs[i], axis);
        }
        return transformed;
    }

    public static class_265 getUnionShape(class_238 ... aabbs) {
        class_265 shape2 = class_259.method_1073();
        for (class_238 aabb : aabbs) {
            shape2 = class_259.method_1082((class_265)shape2, (class_265)class_259.method_1078((class_238)aabb), (class_247)class_247.field_1366);
        }
        return shape2;
    }

    public static class_265 getUnionShape(class_238[] ... aabb_list) {
        class_265 shape2 = class_259.method_1073();
        class_238[][] class_238Array = aabb_list;
        int n = class_238Array.length;
        for (int i = 0; i < n; ++i) {
            class_238[] aabbs;
            for (class_238 aabb : aabbs = class_238Array[i]) {
                shape2 = class_259.method_1082((class_265)shape2, (class_265)class_259.method_1078((class_238)aabb), (class_247)class_247.field_1366);
            }
        }
        return shape2;
    }

    public static class_238[] getMappedAABB(class_238[] bbs, Function<class_238, class_238> mapper) {
        class_238[] transformed = new class_238[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = mapper.apply(bbs[i]);
        }
        return transformed;
    }

    public static String loadResourceText(InputStream is) {
        try {
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String loadResourceText(String path) {
        return Auxiliaries.loadResourceText(Auxiliaries.class.getResourceAsStream(path));
    }

    public static void logGitVersion() {
        try {
            String version = Auxiliaries.loadResourceText("/.gitversion-redstonepen").trim();
            Auxiliaries.logInfo("Redstone Pen" + (String)(version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final class BlockPosRange
    implements Iterable<class_2338> {
        private final int x0;
        private final int x1;
        private final int y0;
        private final int y1;
        private final int z0;
        private final int z1;

        public BlockPosRange(int x0, int y0, int z0, int x1, int y1, int z1) {
            this.x0 = Math.min(x0, x1);
            this.x1 = Math.max(x0, x1);
            this.y0 = Math.min(y0, y1);
            this.y1 = Math.max(y0, y1);
            this.z0 = Math.min(z0, z1);
            this.z1 = Math.max(z0, z1);
        }

        public static BlockPosRange of(class_238 range) {
            return new BlockPosRange((int)Math.floor(range.field_1323), (int)Math.floor(range.field_1322), (int)Math.floor(range.field_1321), (int)Math.floor(range.field_1320 - 0.0625), (int)Math.floor(range.field_1325 - 0.0625), (int)Math.floor(range.field_1324 - 0.0625));
        }

        public int getXSize() {
            return this.x1 - this.x0 + 1;
        }

        public int getYSize() {
            return this.y1 - this.y0 + 1;
        }

        public int getZSize() {
            return this.z1 - this.z0 + 1;
        }

        public int getArea() {
            return this.getXSize() * this.getZSize();
        }

        public int getHeight() {
            return this.getYSize();
        }

        public int getVolume() {
            return this.getXSize() * this.getYSize() * this.getZSize();
        }

        public class_2338 byXZYIndex(int xyz_index) {
            int xsz = this.getXSize();
            int ysz = this.getYSize();
            int zsz = this.getZSize();
            int y = (xyz_index %= xsz * ysz * zsz) / (xsz * zsz);
            int z = (xyz_index -= y * (xsz * zsz)) / xsz;
            int x = xyz_index -= z * xsz;
            return new class_2338(this.x0 + x, this.y0 + y, this.z0 + z);
        }

        public class_2338 byXZIndex(int xz_index, int y_offset) {
            int xsz = this.getXSize();
            int zsz = this.getZSize();
            int z = (xz_index %= xsz * zsz) / xsz;
            int x = xz_index -= z * xsz;
            return new class_2338(this.x0 + x, this.y0 + y_offset, this.z0 + z);
        }

        public BlockRangeIterator iterator() {
            return new BlockRangeIterator(this);
        }

        public Stream<class_2338> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public static final class BlockRangeIterator
        implements Iterator<class_2338> {
            private final BlockPosRange range_;
            private int x;
            private int y;
            private int z;

            public BlockRangeIterator(BlockPosRange range) {
                this.range_ = range;
                this.x = range.x0;
                this.y = range.y0;
                this.z = range.z0;
            }

            @Override
            public boolean hasNext() {
                return this.z <= this.range_.z1;
            }

            @Override
            public class_2338 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                class_2338 pos = new class_2338(this.x, this.y, this.z);
                ++this.x;
                if (this.x > this.range_.x1) {
                    this.x = this.range_.x0;
                    ++this.y;
                    if (this.y > this.range_.y1) {
                        this.y = this.range_.y0;
                        ++this.z;
                    }
                }
                return pos;
            }
        }
    }

    public static final class Tooltip {
        @Environment(value=EnvType.CLIENT)
        public static boolean extendedTipCondition() {
            return Auxiliaries.isShiftDown();
        }

        @Environment(value=EnvType.CLIENT)
        public static boolean helpCondition() {
            return Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown();
        }

        @Environment(value=EnvType.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<class_2561> tooltip, class_1836 flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            class_5250 tip_text = class_2561.method_43473();
            if (Tooltip.helpCondition()) {
                if (help_available) {
                    tip_text = class_2561.method_43470((String)Auxiliaries.localize(helpTranslationKey + ".help", new Object[0]));
                }
            } else if (Tooltip.extendedTipCondition()) {
                if (tip_available) {
                    tip_text = class_2561.method_43470((String)Auxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]));
                }
            } else if (addAdvancedTooltipHints) {
                if (tip_available) {
                    tip_text = class_2561.method_43470((String)(Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.extended", new Object[0]) + (help_available ? " " : "")));
                }
                if (help_available) {
                    tip_text.method_10852((class_2561)class_2561.method_43470((String)Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.help", new Object[0])));
                }
            }
            if (Auxiliaries.isEmpty((class_2561)tip_text)) {
                return false;
            }
            tooltip.addAll(Auxiliaries.wrapText((class_2561)tip_text, 50));
            return true;
        }

        @Environment(value=EnvType.CLIENT)
        public static boolean addInformation(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.method_7922(), stack.method_7922(), tooltip, flag, addAdvancedTooltipHints);
        }
    }

    public static interface IExperimentalFeature {
    }
}

