/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2665;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wile.redstonepen.ModContent;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.Registries;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardBlocks;
import wile.redstonepen.libmc.StandardEntityBlocks;

public class RedstoneTrack {

    public static class TrackBlockEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements Networking.IPacketTileNotifyReceiver {
        private long state_flags_ = 0L;
        private final List<TrackNet> nets_ = new ArrayList<TrackNet>();
        private final class_2248[] block_change_tracking_ = new class_2248[]{class_2246.field_10124, class_2246.field_10124, class_2246.field_10124, class_2246.field_10124, class_2246.field_10124, class_2246.field_10124};
        private boolean trace_ = false;
        private static final List<class_2382> updatepower_order = new ArrayList<class_2382>();

        public TrackBlockEntity(class_2338 pos, class_2680 state) {
            super(Registries.getBlockEntityTypeOfBlock(state.method_26204()), pos, state);
        }

        public class_2487 readnbt(class_2487 nbt) {
            this.state_flags_ = nbt.method_10537("sflags");
            this.nets_.clear();
            if (nbt.method_10573("nets", 9)) {
                class_2499 lst = nbt.method_10554("nets", 10);
                try {
                    for (int i = 0; i < lst.size(); ++i) {
                        class_2487 route_nbt = lst.method_10602(i);
                        this.nets_.add(new TrackNet(Arrays.stream(route_nbt.method_10565("npos")).mapToObj(class_2338::method_10092).collect(Collectors.toList()), Arrays.stream(route_nbt.method_10561("nsid")).mapToObj(class_2350::method_10143).collect(Collectors.toList()), Arrays.stream(route_nbt.method_10561("ifac")).mapToObj(class_2350::method_10143).collect(Collectors.toList()), Arrays.stream(route_nbt.method_10561("pfac")).mapToObj(class_2350::method_10143).collect(Collectors.toList()), route_nbt.method_10550("power")));
                    }
                }
                catch (Throwable ex) {
                    this.nets_.clear();
                    Auxiliaries.logError("Dropped invalid NBT for Redstone Track at pos " + this.method_11016());
                }
            }
            return nbt;
        }

        private class_2487 writenbt(class_2487 nbt) {
            return this.writenbt(nbt, false);
        }

        private class_2487 writenbt(class_2487 nbt, boolean sync_packet) {
            nbt.method_10544("sflags", this.state_flags_);
            if (sync_packet) {
                return nbt;
            }
            if (!this.nets_.isEmpty()) {
                class_2499 lst = new class_2499();
                for (TrackNet net : this.nets_) {
                    class_2487 route_nbt = new class_2487();
                    route_nbt.method_10569("power", net.power);
                    route_nbt.method_10566("npos", (class_2520)new class_2501(net.neighbour_positions.stream().map(class_2338::method_10063).collect(Collectors.toList())));
                    route_nbt.method_10566("nsid", (class_2520)new class_2495(net.neighbour_sides.stream().map(class_2350::method_10146).collect(Collectors.toList())));
                    route_nbt.method_10566("ifac", (class_2520)new class_2495(net.internal_sides.stream().map(class_2350::method_10146).collect(Collectors.toList())));
                    route_nbt.method_10566("pfac", (class_2520)new class_2495(net.power_sides.stream().map(class_2350::method_10146).collect(Collectors.toList())));
                    lst.add((Object)route_nbt);
                }
                nbt.method_10566("nets", (class_2520)lst);
            }
            return nbt;
        }

        public void method_11014(class_2487 nbt) {
            super.method_11014(nbt);
            this.readnbt(nbt);
        }

        protected void method_11007(class_2487 nbt) {
            super.method_11007(nbt);
            this.writenbt(nbt);
        }

        public class_2487 method_16887() {
            class_2487 nbt = super.method_16887();
            this.writenbt(nbt, true);
            return nbt;
        }

        @Override
        public void onDataPacket(class_2535 net, class_2622 pkt) {
            this.readnbt(pkt.method_11290());
            super.onDataPacket(net, pkt);
        }

        @Override
        public void handleUpdateTag(class_2487 tag) {
            this.method_11014(tag);
        }

        @Override
        public void onServerPacketReceived(class_2487 nbt) {
            this.readnbt(nbt);
        }

        @Override
        public void onClientPacketReceived(class_1657 player, class_2487 nbt) {
        }

        @Environment(value=EnvType.CLIENT)
        public double getViewDistance() {
            return 64.0;
        }

        public boolean sync(boolean schedule) {
            if (this.field_11863.method_8608()) {
                return true;
            }
            this.method_5431();
            if (schedule && !this.method_10997().method_8397().method_8674(this.method_11016(), (Object)ModContent.references.TRACK_BLOCK)) {
                this.method_10997().method_39279(this.method_11016(), (class_2248)ModContent.references.TRACK_BLOCK, 1);
            } else {
                Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new class_2487(), true));
            }
            return true;
        }

        public long getStateFlags() {
            return this.state_flags_;
        }

        public int addWireFlags(long flags) {
            int n_added = 0;
            for (int i = 0; i < this.getWireFlagCount(); ++i) {
                long mask = 1L << i;
                if ((flags & mask) == 0L || (this.state_flags_ & mask) != 0L) continue;
                this.state_flags_ |= mask;
                ++n_added;
            }
            return n_added;
        }

        public int getWireFlags() {
            return (int)((this.state_flags_ & 0xFFFFFFL) >> 0);
        }

        public boolean getWireFlag(int index) {
            return (this.state_flags_ & 1L << 0 + index) != 0L;
        }

        public int getWireFlagCount() {
            return 24;
        }

        public int getConnectionFlags() {
            return (int)((this.state_flags_ & 0x3F000000L) >> 24);
        }

        public boolean getConnectionFlag(int index) {
            return (this.state_flags_ & 1L << 24 + index) != 0L;
        }

        public int getConnectionFlagCount() {
            return 6;
        }

        public int getSidePower(class_2350 side) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            return (int)(this.state_flags_ >> shift & 0xFL);
        }

        public void setSidePower(class_2350 side, int p) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            this.state_flags_ = this.state_flags_ & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)(p & 0xF) << shift;
        }

        public boolean hasVanillaRedstoneConnection(class_2350 side) {
            return defs.connections.hasVanillaWireConnection(this.getStateFlags(), side) || (this.state_flags_ & defs.connections.getBulkConnectorBit(side)) != 0L;
        }

        public int getRedstonePower(class_2350 redstone_side, boolean weak) {
            class_2350 own_side = redstone_side.method_10153();
            int p = 0;
            for (TrackNet net : this.nets_) {
                if (!net.power_sides.contains(own_side) || (p = Math.max(p, net.power)) < 15) continue;
                break;
            }
            int n = p = p <= 0 || !this.method_10997().method_8320(this.method_11016().method_10093(own_side)).method_27852(class_2246.field_10091) ? p : p - 1;
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("POWR: %s @%s==%d", this.posstr(this.method_11016()), redstone_side, p));
            }
            return p;
        }

        public int getRedstoneDustCount() {
            int i;
            int n = 0;
            int rem = this.getWireFlags();
            for (i = 0; rem != 0 && i < 24; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            rem = this.getConnectionFlags();
            for (i = 0; rem != 0 && i < 6; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            return n;
        }

        public void toggle_trace(@Nullable class_1657 player) {
            boolean bl = this.trace_ = !this.trace_;
            if (player != null) {
                Auxiliaries.playerChatMessage(player, "Trace: " + this.trace_);
            }
        }

        public int handleActivation(class_2338 pos, class_1657 player, class_1268 hand, class_2350 clicked_face, class_243 hitvec, boolean remove_only) {
            class_1799 used_stack = player.method_5998(hand);
            if (!used_stack.method_7960() && used_stack.method_7909() != class_1802.field_8725 && !RedstonePenItem.isPen(used_stack)) {
                return 0;
            }
            class_2350 face = clicked_face.method_10153();
            class_243 hit_r = hitvec.method_1020(class_243.method_24953((class_2382)pos));
            class_243 hit = switch (clicked_face) {
                case class_2350.field_11034, class_2350.field_11039 -> hit_r.method_18805(0.0, 1.0, 1.0);
                case class_2350.field_11043, class_2350.field_11035 -> hit_r.method_18805(1.0, 1.0, 0.0);
                default -> hit_r.method_18805(1.0, 0.0, 1.0);
            };
            class_2350[] dir = class_2350.method_10142((double)hit.method_10216(), (double)hit.method_10214(), (double)hit.method_10215());
            long flip_mask = hit.method_1033() < 0.12 && (!remove_only || this.getConnectionFlags() != 0) ? (((long)this.getWireFlags() & defs.connections.getAllElementsOnFace(face)) != 0L ? defs.connections.getBulkConnectorBit(face) : defs.connections.getWireBit(face, (class_2350)dir)) : defs.connections.getWireBit(face, (class_2350)dir);
            int material_use = 0;
            if ((this.state_flags_ & flip_mask) != 0L) {
                this.state_flags_ &= flip_mask ^ 0xFFFFFFFFFFFFFFFFL;
                --material_use;
                long bc = defs.connections.getBulkConnectorBit(face);
                if ((this.state_flags_ & defs.connections.getAllElementsOnFace(face)) == bc) {
                    this.state_flags_ &= bc ^ 0xFFFFFFFFFFFFFFFFL;
                    --material_use;
                }
                if (this.getWireFlags() == 0) {
                    material_use -= this.getRedstoneDustCount();
                    this.state_flags_ = 0L;
                }
            } else if (!used_stack.method_7960() && !remove_only) {
                boolean can_place = false;
                for (class_2350 side : class_2350.values()) {
                    if ((defs.connections.getAllElementsOnFace(side) & flip_mask) == 0L) continue;
                    can_place = true;
                    break;
                }
                if (can_place) {
                    this.state_flags_ |= flip_mask;
                    ++material_use;
                }
            }
            if (material_use != 0) {
                int initial_side_power = this.getSidePower(face);
                this.setSidePower(face, 0);
                Map<class_2338, class_2338> change_notifications_before = this.updateAllPowerValuesFromAdjacent();
                Set net_neighbours_before = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                this.updateConnections(1);
                this.setSidePower(face, 0);
                Map<class_2338, class_2338> change_notifications_after = this.updateAllPowerValuesFromAdjacent();
                List<class_2338> disconnected = change_notifications_before.keySet().stream().filter(p -> !change_notifications_after.containsKey(p)).collect(Collectors.toList());
                List<class_2338> connected = change_notifications_after.keySet().stream().filter(p -> !change_notifications_before.containsKey(p)).collect(Collectors.toList());
                if (connected.isEmpty() && disconnected.isEmpty() && defs.connections.hasBulkConnection(this.getStateFlags(), face)) {
                    Set net_neighbours_after = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                    for (class_2338 p2 : net_neighbours_after) {
                        if (net_neighbours_before.contains(p2)) continue;
                        connected.add(p2);
                    }
                    for (class_2338 p2 : net_neighbours_before) {
                        if (net_neighbours_after.contains(p2)) continue;
                        disconnected.add(p2);
                    }
                }
                if (connected.isEmpty() && disconnected.isEmpty()) {
                    this.setSidePower(face, initial_side_power);
                } else {
                    this.setSidePower(face, 0);
                    this.nets_.forEach(net -> {
                        if (net.internal_sides.contains(face)) {
                            net.power = 0;
                        }
                    });
                    disconnected.forEach(p -> {
                        class_2586 te = this.method_10997().method_8321(p);
                        this.method_10997().method_8320(p).method_26181(this.method_10997(), p, (class_2248)this.getBlock(), pos, false);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                    });
                    connected.forEach(p -> {
                        class_2586 te = this.method_10997().method_8321(p);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                        this.method_10997().method_8320(p).method_26181(this.method_10997(), p, (class_2248)this.getBlock(), pos, false);
                        this.getBlock().method_9612(this.method_11010(), this.method_10997(), this.method_11016(), this.getBlock(), (class_2338)p, false);
                    });
                }
                this.sync(true);
            }
            return material_use;
        }

        public Map<class_2338, class_2338> updateAllPowerValuesFromAdjacent() {
            if (updatepower_order.isEmpty()) {
                for (class_2350 side : class_2350.values()) {
                    updatepower_order.add(new class_2382(0, 0, 0).method_23226(side, 1));
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 2) continue;
                            updatepower_order.add(new class_2382(x, y, z));
                        }
                    }
                }
            }
            HashMap<class_2338, class_2338> all_change_notifications = new HashMap<class_2338, class_2338>();
            for (class_2382 ofs : updatepower_order) {
                this.handleNeighborChanged(this.method_11016().method_10081(ofs)).forEach(all_change_notifications::putIfAbsent);
            }
            return all_change_notifications;
        }

        private void spawnRedsoneItems(int count) {
            if (count <= 0) {
                return;
            }
            class_1542 e = new class_1542(this.method_10997(), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, new class_1799((class_1935)class_1802.field_8725, count));
            e.method_6988();
            e.method_18799(new class_243(this.method_10997().method_8409().method_43058() - 0.5, this.method_10997().method_8409().method_43058() - 0.5, this.method_10997().method_8409().method_43058()).method_1021(0.1));
            this.method_10997().method_8649((class_1297)e);
        }

        private RedstoneTrackBlock getBlock() {
            return ModContent.references.TRACK_BLOCK;
        }

        public boolean handlePostPlacement(class_2350 facing, class_2680 facingState, class_2338 fromPos) {
            class_2248 bltv;
            long to_remove;
            long new_flags;
            boolean update_neighbours = false;
            if (!RedstoneTrackBlock.canBePlacedOnFace(facingState, this.method_10997(), fromPos, facing.method_10153()) && (new_flags = this.state_flags_ & ((to_remove = defs.connections.getAllElementsOnFace(facing)) ^ 0xFFFFFFFFFFFFFFFFL)) != this.state_flags_) {
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("SHUP: %s <-%s(=%s) removed.", this.posstr(this.method_11016()), this.posstr(fromPos), facingState.method_26204().method_9539()));
                }
                int count = this.getRedstoneDustCount();
                this.state_flags_ = new_flags;
                this.spawnRedsoneItems(count -= this.getRedstoneDustCount());
                this.updateConnections(1);
                update_neighbours = true;
            }
            if ((bltv = this.block_change_tracking_[facing.method_10146()]) != facingState.method_26204()) {
                if (bltv == null) {
                    bltv = class_2246.field_10124;
                }
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("SHUP: %s <-%s changed (%s->%s).", this.posstr(this.method_11016()), this.posstr(fromPos), bltv.method_9539(), facingState.method_26204().method_9539()));
                }
                this.block_change_tracking_[facing.method_10146()] = facingState.method_26204();
                update_neighbours = true;
            }
            if (update_neighbours) {
                class_1937 world = this.method_10997();
                RedstoneTrackBlock block = this.getBlock();
                this.handleNeighborChanged(fromPos).forEach((chpos, frpos) -> world.method_8492(chpos, block, frpos));
            }
            return this.getWireFlags() != 0;
        }

        private int getNonWireSignal(class_1937 world, class_2338 pos, class_2350 redstone_side) {
            int p_in;
            class_2350 rs_side;
            class_2338 side_pos;
            class_2680 side_state;
            int p;
            this.getBlock().disablePower(true);
            class_2680 state = world.method_8320(pos);
            int n = p = !state.method_27852(class_2246.field_10091) && !state.method_27852((class_2248)this.getBlock()) ? state.method_26195((class_1922)world, pos, redstone_side) : 0;
            if (!RsSignals.canEmitWeakPower(state, world, pos, redstone_side)) {
                this.getBlock().disablePower(false);
                return p;
            }
            class_2350[] class_2350Array = class_2350.values();
            int n2 = class_2350Array.length;
            for (int i = 0; i < n2 && ((side_state = world.method_8320(side_pos = pos.method_10093(rs_side = class_2350Array[i]))).method_27852(class_2246.field_10091) || side_state.method_27852((class_2248)this.getBlock()) || (p_in = side_state.method_26203((class_1922)world, side_pos, rs_side)) <= p || (p = p_in) < 15); ++i) {
            }
            this.getBlock().disablePower(false);
            return p;
        }

        public Map<class_2338, class_2338> handleNeighborChanged(class_2338 fromPos) {
            class_1937 world = this.method_10997();
            LinkedHashMap<class_2338, class_2338> change_notifications = new LinkedHashMap<class_2338, class_2338>();
            boolean power_changed = false;
            for (TrackNet net : this.nets_) {
                if (!net.neighbour_positions.contains(fromPos)) continue;
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("NBCH: %s from %s", this.posstr(this.method_11016()), this.posstr(fromPos)));
                }
                int pmax = 0;
                for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                    class_2338 ext_pos = net.neighbour_positions.get(i);
                    change_notifications.put(ext_pos, this.method_11016());
                    class_2350 ext_side = net.neighbour_sides.get(i);
                    class_2680 ext_state = this.field_11863.method_8320(ext_pos);
                    if (ext_state.method_27852(class_2246.field_10091)) {
                        if (pmax >= 15) continue;
                        int p_vanilla_wire = Math.max(0, (Integer)ext_state.method_11654((class_2769)class_2457.field_11432) - 1);
                        pmax = Math.max(pmax, p_vanilla_wire);
                        continue;
                    }
                    if (ext_state.method_27852((class_2248)this.getBlock())) {
                        if (pmax >= 15) continue;
                        int p_track = RedstoneTrackBlock.tile((class_1922)world, ext_pos).map(te -> Math.max(0, te.getSidePower(ext_side) - 1)).orElse(0);
                        pmax = Math.max(pmax, p_track);
                        continue;
                    }
                    class_2350 eside = ext_side.method_10153();
                    int p_nowire = this.getNonWireSignal(world, ext_pos, eside);
                    pmax = Math.max(pmax, p_nowire);
                    if (ext_state.method_26219() || p_nowire != 0 || !ext_state.method_26212((class_1922)world, ext_pos)) continue;
                    for (class_2350 update_direction : defs.REDSTONE_UPDATE_DIRECTIONS) {
                        if (ext_side == update_direction) continue;
                        change_notifications.putIfAbsent(ext_pos.method_10093(update_direction), ext_pos);
                    }
                }
                if (net.power != pmax) {
                    if (this.trace_) {
                        Auxiliaries.logWarn(String.format("NBCH: %s net power %d->%d", this.posstr(this.method_11016()), net.power, pmax));
                    }
                    net.power = pmax;
                    power_changed = true;
                }
                for (class_2350 side : net.internal_sides) {
                    if (this.getSidePower(side) == pmax) continue;
                    this.setSidePower(side, pmax);
                    power_changed = true;
                }
            }
            if (power_changed) {
                if (this.trace_ && change_notifications.size() > 0) {
                    Auxiliaries.logWarn(String.format("NBCH: %s updates: [%s]", this.posstr(this.method_11016()), change_notifications.entrySet().stream().map(kv -> this.posstr((class_2338)kv.getKey()) + ">" + this.posstr((class_2338)kv.getValue())).collect(Collectors.joining(" ; "))));
                }
                this.sync(true);
                return change_notifications;
            }
            return Collections.emptyMap();
        }

        private String posstr(class_2338 pos) {
            return "[" + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + "]";
        }

        private boolean isRedstoneInsulator(class_2680 state, class_2338 pos) {
            return state.method_27852(class_2246.field_10033);
        }

        private void updateConnections(int recursion_left) {
            HashSet all_neighbours = new HashSet();
            int[] current_side_powers = new int[]{0, 0, 0, 0, 0, 0};
            this.nets_.forEach(net -> {
                net.internal_sides.forEach(ps -> {
                    current_side_powers[ps.ordinal()] = net.power;
                });
                all_neighbours.addAll(net.neighbour_positions);
            });
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s SIDPW: [%01x %01x %01x %01x %01x %01x]", this.posstr(this.method_11016()), current_side_powers[0], current_side_powers[1], current_side_powers[2], current_side_powers[3], current_side_powers[4], current_side_powers[5]));
            }
            this.nets_.clear();
            HashSet<TrackBlockEntity> track_connection_updates = new HashSet<TrackBlockEntity>();
            long[] internal_connected_sides = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long[] external_connected_routes = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long external_connection_flags = this.getStateFlags() & 0x3FFFFFFFL;
            for (Map.Entry kv : defs.connections.INTERNAL_EDGE_CONNECTION_MAPPING.entrySet()) {
                long wire_bit_pair = (Long)kv.getKey();
                if ((this.getStateFlags() & wire_bit_pair) != wire_bit_pair) continue;
                external_connection_flags &= wire_bit_pair ^ 0xFFFFFFFFFFFFFFFFL;
                for (int i = 0; i < 6; ++i) {
                    if ((15L << 4 * i & wire_bit_pair) == 0L) continue;
                    int n = i;
                    internal_connected_sides[n] = internal_connected_sides[n] | wire_bit_pair;
                }
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s CONFL: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.method_11016()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 6; ++i) {
                    if (internal_connected_sides[i] == 0L) continue;
                    for (int j = i + 1; j < 6; ++j) {
                        if ((internal_connected_sides[i] & internal_connected_sides[j]) == 0L) continue;
                        int n = i;
                        internal_connected_sides[n] = internal_connected_sides[n] | internal_connected_sides[j];
                        internal_connected_sides[j] = 0L;
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (internal_connected_sides[i] != 0L) {
                    for (int j = i; j < 6; ++j) {
                        long mask = 15L << 4 * j;
                        if ((internal_connected_sides[i] & mask) == 0L) continue;
                        long bulk = 1L << 24 + j;
                        int n = i;
                        external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                        external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    continue;
                }
                long mask = 15L << 4 * i;
                long bulk = 1L << 24 + i;
                int n = i;
                external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s CONSD: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.method_11016()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
                Auxiliaries.logWarn(String.format("UCON: %s CONRT: ext:%08x | ext:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.method_11016()), external_connection_flags, external_connected_routes[0], external_connected_routes[1], external_connected_routes[2], external_connected_routes[3], external_connected_routes[4], external_connected_routes[5]));
            }
            HashSet used_sides = new HashSet();
            for (int i = 0; i < 6; ++i) {
                if (external_connected_routes[i] == 0L) continue;
                HashSet<class_2350> power_sides = new HashSet<class_2350>();
                HashSet<class_2350> internal_sides = new HashSet<class_2350>();
                ArrayList<class_2338> block_positions = new ArrayList<class_2338>(6);
                ArrayList<class_2350> block_sides = new ArrayList<class_2350>(6);
                for (int j = 0; j < 6; ++j) {
                    long mask = 15L << 4 * j;
                    long bulk = 1L << 24 + j;
                    class_2350 side2 = defs.connections.CONNECTION_BIT_ORDER[j];
                    if ((internal_connected_sides[i] & mask) != 0L) {
                        internal_sides.add(side2);
                    }
                    if ((external_connected_routes[i] & mask) != 0L) {
                        for (int k = 0; k < 4; ++k) {
                            long wire_bit = 1L << 4 * j + k;
                            if ((external_connected_routes[i] & wire_bit) == 0L) continue;
                            class_3545<class_2350, class_2350> side_dir = defs.connections.getWireBitSideAndDirection(wire_bit);
                            class_2350 tsid = (class_2350)side_dir.method_15442();
                            class_2350 tdir = (class_2350)side_dir.method_15441();
                            class_2338 wire_pos = this.method_11016().method_10093(tdir);
                            class_2680 wire_state = this.method_10997().method_8320(wire_pos);
                            boolean diagonal_check = false;
                            if (wire_state.method_27852((class_2248)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tsid, tdir.method_10153());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((class_1922)this.method_10997(), wire_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tsid);
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    track_connection_updates.add(adj_te);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.method_27852(class_2246.field_10091)) {
                                if (side2 != class_2350.field_11033) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tdir.method_10153());
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.method_26219()) {
                                block_positions.add(wire_pos);
                                block_sides.add(tdir.method_10153());
                                internal_sides.add(side2);
                                power_sides.add(tdir);
                                continue;
                            }
                            class_2338 track_pos = wire_pos.method_10093(tsid);
                            class_2680 track_state = this.method_10997().method_8320(track_pos);
                            if (track_state.method_27852((class_2248)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tdir.method_10153(), tsid.method_10153());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((class_1922)this.method_10997(), track_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) continue;
                                block_positions.add(track_pos);
                                block_sides.add(tdir.method_10153());
                                power_sides.add(tdir);
                                internal_sides.add(side2);
                                track_connection_updates.add(adj_te);
                                continue;
                            }
                            if (this.isRedstoneInsulator(wire_state, wire_pos)) continue;
                            block_positions.add(wire_pos);
                            block_sides.add(tdir.method_10153());
                            internal_sides.add(side2);
                            power_sides.add(tdir);
                        }
                    }
                    if ((external_connected_routes[i] & bulk) == 0L) continue;
                    class_2338 bulk_pos = this.method_11016().method_10093(side2);
                    class_2680 bulk_state = this.method_10997().method_8320(bulk_pos);
                    if (this.isRedstoneInsulator(bulk_state, bulk_pos)) continue;
                    block_positions.add(bulk_pos);
                    block_sides.add(side2.method_10153());
                    internal_sides.add(side2);
                    power_sides.add(side2);
                }
                if (block_positions.isEmpty()) continue;
                TrackNet net2 = new TrackNet(block_positions, block_sides, new ArrayList<class_2350>(internal_sides), new ArrayList<class_2350>(power_sides));
                net2.power = net2.internal_sides.stream().mapToInt(side -> current_side_powers[side.ordinal()]).max().orElse(0);
                this.nets_.add(net2);
                used_sides.addAll(internal_sides);
            }
            Arrays.stream(class_2350.values()).filter(side -> !used_sides.contains(side)).forEach(side -> this.setSidePower((class_2350)side, 0));
            this.method_5431();
            if (this.trace_) {
                String poss = this.posstr(this.method_11016());
                for (TrackNet net3 : this.nets_) {
                    ArrayList<CallSite> ss = new ArrayList<CallSite>();
                    for (int i = 0; i < net3.neighbour_positions.size(); ++i) {
                        ss.add((CallSite)((Object)(this.posstr(net3.neighbour_positions.get(i)) + ":" + net3.neighbour_sides.get(i).toString())));
                    }
                    String int_sides = net3.internal_sides.stream().map(class_2350::toString).collect(Collectors.joining(","));
                    String pwr_sides = net3.power_sides.stream().map(class_2350::toString).collect(Collectors.joining(","));
                    Auxiliaries.logWarn(String.format("UCON: %s adj:%s | ints:%s | pwrs:%s", poss, String.join((CharSequence)", ", ss), int_sides, pwr_sides));
                }
            }
            if (recursion_left > 0) {
                for (TrackBlockEntity te : track_connection_updates) {
                    if (this.trace_) {
                        Auxiliaries.logWarn(String.format("UCON: %s UPDATE NET OF %s", this.posstr(this.method_11016()), this.posstr(te.method_11016())));
                    }
                    te.updateConnections(recursion_left - 1);
                }
            }
            this.nets_.stream().filter(net -> net.power > 0).forEach(net -> all_neighbours.addAll(net.neighbour_positions));
            class_1937 world = this.method_10997();
            class_2680 state = this.method_11010();
            all_neighbours.forEach(pos -> {
                class_2680 st = world.method_8320(pos);
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("UCON: %s UPDATE TRACK CHANGES TO %s.", this.posstr(this.method_11016()), this.posstr((class_2338)pos)));
                }
                st.method_26181(world, pos, state.method_26204(), this.method_11016(), false);
                world.method_8452(pos, st.method_26204());
            });
        }

        public static class TrackNet {
            public final List<class_2338> neighbour_positions;
            public final List<class_2350> neighbour_sides;
            public final List<class_2350> internal_sides;
            public final List<class_2350> power_sides;
            public int power;

            public TrackNet(List<class_2338> positions, List<class_2350> ext_sides, List<class_2350> int_sides, List<class_2350> pwr_sides) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = 0;
            }

            public TrackNet(List<class_2338> positions, List<class_2350> ext_sides, List<class_2350> int_sides, List<class_2350> pwr_sides, int power_setval) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = power_setval;
            }
        }
    }

    public static class RedstoneTrackBlock
    extends StandardBlocks.WaterLoggable
    implements class_2343 {
        private boolean can_provide_power_ = true;

        public RedstoneTrackBlock(long config, class_4970.class_2251 builder) {
            super(config, builder.method_50012(class_3619.field_15971));
        }

        public static Optional<TrackBlockEntity> tile(class_1922 world, class_2338 pos) {
            class_2586 te = world.method_8321(pos);
            return te instanceof TrackBlockEntity && !te.method_11015() ? Optional.of((TrackBlockEntity)te) : Optional.empty();
        }

        public static boolean canBePlacedOnFace(class_2680 state, class_1937 world, class_2338 pos, class_2350 face) {
            if (state.method_26204() instanceof class_2665) {
                class_2350 pface = (class_2350)state.method_11654((class_2769)class_2665.field_10927);
                return face != pface;
            }
            if (state.method_26204() instanceof class_2667) {
                return true;
            }
            if (state.method_27852(class_2246.field_10312)) {
                return face == class_2350.field_11036;
            }
            return state.method_26206((class_1922)world, pos, face);
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
        }

        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new TrackBlockEntity(pos, state);
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<class_1799> dropList(class_2680 state, class_1937 world, @Nullable class_2586 te, boolean explosion) {
            if (!(te instanceof TrackBlockEntity)) {
                return Collections.emptyList();
            }
            int num_connections = ((TrackBlockEntity)te).getRedstoneDustCount();
            if (num_connections <= 0) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new class_1799((class_1935)class_1802.field_8725, num_connections));
        }

        @Override
        @Nullable
        public class_2680 method_9605(class_1750 context) {
            return context.method_8045().method_8320(context.method_8037()).method_26166(context) ? super.method_9605(context) : null;
        }

        public class_1792 method_8389() {
            return class_1802.field_8725;
        }

        @Override
        public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
            return true;
        }

        @Override
        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            int wires = RedstoneTrackBlock.tile(world, pos).map(TrackBlockEntity::getWireFlags).orElse(0);
            int faces = ((wires & 0xF) != 0 ? 1 : 0) | ((wires & 0xF0) != 0 ? 2 : 0) | ((wires & 0xF00) != 0 ? 4 : 0) | ((wires & 0xF000) != 0 ? 8 : 0) | ((wires & 0xF0000) != 0 ? 16 : 0) | ((wires & 0xF00000) != 0 ? 32 : 0);
            return defs.shape.get(faces);
        }

        @Override
        public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return class_259.method_1073();
        }

        @Override
        public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
            return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
        }

        public boolean method_9526(class_2680 state) {
            return true;
        }

        @Deprecated
        public int method_9505(class_2680 state, class_1922 worldIn, class_2338 pos) {
            return 0;
        }

        @Deprecated
        public class_2464 method_9604(class_2680 state) {
            return class_2464.field_11456;
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            return true;
        }

        @Deprecated
        public boolean canConnectRedstone(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_2350 side) {
            return side != null && RedstoneTrackBlock.tile(world, pos).map(te -> te.hasVanillaRedstoneConnection(side.method_10153())).orElse(false) != false;
        }

        public boolean method_9506(class_2680 state) {
            return this.can_provide_power_;
        }

        public boolean method_9498(class_2680 state) {
            return false;
        }

        public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
            return 0;
        }

        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, true)).orElse(0) : 0;
        }

        public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, false)).orElse(0) : 0;
        }

        @Override
        public boolean shouldCheckWeakPower(class_2680 state, class_4538 level, class_2338 pos, class_2350 side) {
            return false;
        }

        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
            if (!RedstoneTrackBlock.tile((class_1922)world, pos).map(te -> te.sync(false)).orElse(false).booleanValue()) {
                world.method_8650(pos, false);
            }
        }

        @Override
        public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 pos, class_2338 facingPos) {
            if (!world.method_8608()) {
                if (RedstoneTrackBlock.tile((class_1922)world, pos).map(te -> te.handlePostPlacement(facing, facingState, facingPos)).orElse(true).booleanValue()) {
                    world.method_39279(pos, (class_2248)this, 1);
                } else {
                    world.method_8650(pos, false);
                }
            }
            return super.method_9559(state, facing, facingState, world, pos, facingPos);
        }

        public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        }

        @Override
        public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
            if (isMoving || state.method_27852(newState.method_26204())) {
                return;
            }
            super.method_9536(state, world, pos, newState, isMoving);
            if (world.method_8608()) {
                return;
            }
            this.notifyAdjacent(world, pos);
        }

        public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rtr) {
            if (player.method_5998(hand).method_31574(class_1802.field_8688)) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                class_2586 class_25862 = world.method_8321(pos);
                if (class_25862 instanceof TrackBlockEntity) {
                    TrackBlockEntity te = (TrackBlockEntity)class_25862;
                    te.toggle_trace(player);
                }
                return class_1269.field_21466;
            }
            return this.onBlockActivated(state, world, pos, player, hand, rtr, false);
        }

        public class_1269 onBlockActivated(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rtr, boolean remove_only) {
            TrackBlockEntity te;
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960() && stack.method_7909() != class_1802.field_8725 && !RedstonePenItem.isPen(stack)) {
                class_2338 behind_pos = pos.method_10093(rtr.method_17780());
                class_2680 behind_state = world.method_8320(behind_pos);
                if (behind_state.method_26212((class_1922)world, behind_pos)) {
                    return behind_state.method_26204().method_9534(behind_state, world, behind_pos, player, hand, rtr);
                }
                return class_1269.field_5811;
            }
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            if (!RedstonePenItem.hasEnoughRedstone(player.method_5998(hand), 1, player)) {
                remove_only = true;
            }
            if ((te = (TrackBlockEntity)RedstoneTrackBlock.tile((class_1922)world, pos).orElse(null)) == null) {
                return class_1269.field_5814;
            }
            int redstone_use = te.handleActivation(pos, player, hand, rtr.method_17780(), rtr.method_17784(), remove_only);
            if (redstone_use == 0) {
                return class_1269.field_5811;
            }
            if (redstone_use < 0) {
                RedstonePenItem.pushRedstone(player.method_5998(hand), -redstone_use, player);
                if (te.getWireFlags() == 0) {
                    world.method_8652(pos, state.method_26227().method_15759(), 3);
                } else {
                    Map<class_2338, class_2338> blocks_to_update = te.updateAllPowerValuesFromAdjacent();
                    for (Map.Entry<class_2338, class_2338> update_pos : blocks_to_update.entrySet()) {
                        world.method_8492(update_pos.getKey(), (class_2248)this, update_pos.getValue());
                    }
                }
                world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 0.4f, 2.0f);
            } else {
                RedstonePenItem.popRedstone(player.method_5998(hand), redstone_use, player, hand);
                world.method_8396(null, pos, class_3417.field_15167, class_3419.field_15245, 0.4f, 2.4f);
            }
            this.updateNeighbourShapes(state, world, pos);
            this.notifyAdjacent(world, pos);
            return class_1269.field_21466;
        }

        public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
            block5: {
                if (world.method_8608()) {
                    return;
                }
                Map blocks_to_update = RedstoneTrackBlock.tile((class_1922)world, pos).map(te -> te.handleNeighborChanged(fromPos)).orElse(Collections.emptyMap());
                if (blocks_to_update.isEmpty()) {
                    return;
                }
                try {
                    for (Map.Entry update_pos : blocks_to_update.entrySet()) {
                        world.method_8492((class_2338)update_pos.getKey(), (class_2248)this, (class_2338)update_pos.getValue());
                    }
                }
                catch (Throwable ex) {
                    Auxiliaries.logError("Track neighborChanged recursion detected, dropping!");
                    int num_redstone = RedstoneTrackBlock.tile((class_1922)world, pos).map(TrackBlockEntity::getRedstoneDustCount).orElse(0);
                    if (num_redstone <= 0) break block5;
                    class_243 p = class_243.method_24953((class_2382)pos);
                    world.method_8649((class_1297)new class_1542(world, p.field_1352, p.field_1351, p.field_1350, new class_1799((class_1935)class_1802.field_8725, num_redstone)));
                    world.method_8652(pos, world.method_8320(pos).method_26227().method_15759(), 18);
                }
            }
        }

        public void method_9517(class_2680 state, class_1936 worldIn, class_2338 pos, int flags, int recursionLeft) {
        }

        @Environment(value=EnvType.CLIENT)
        private void spawnPoweredParticle(class_1937 world, class_5819 rand, class_2338 pos, class_243 color, class_2350 from, class_2350 to, float minChance, float maxChance) {
            float f = maxChance - minChance;
            if (rand.method_43057() < 0.3f * f) {
                double c1 = 0.4375;
                double c2 = minChance + f * rand.method_43057();
                double p0 = 0.5 + c1 * (double)from.method_10148() + c2 * 0.4 * (double)to.method_10148();
                double p1 = 0.5 + c1 * (double)from.method_10164() + c2 * 0.4 * (double)to.method_10164();
                double p2 = 0.5 + c1 * (double)from.method_10165() + c2 * 0.4 * (double)to.method_10165();
                world.method_8406((class_2394)new class_2390(new Vector3f((Vector3fc)color.method_46409()), 1.0f), (double)pos.method_10263() + p0, (double)pos.method_10264() + p1, (double)pos.method_10260() + p2, 0.0, 0.0, 0.0);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
            if ((double)rand.method_43057() > 0.4) {
                return;
            }
            TrackBlockEntity te = RedstoneTrackBlock.tile((class_1922)world, pos).orElse(null);
            if (te == null || (te.getStateFlags() & 0xFFFFFF00000000L) == 0L) {
                return;
            }
            class_243 color = new class_243((double)0.6f, 0.0, 0.0);
            for (class_2350 side : class_2350.values()) {
                int p = te.getSidePower(side);
                if (p == 0) continue;
                this.spawnPoweredParticle(world, rand, pos, color, side, side.method_10153(), -0.5f, 0.5f);
            }
        }

        public void checkSmartPlacement(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rtr) {
            class_2350 odir;
            class_2338 opos;
            class_2680 ostate;
            if (world.method_8608()) {
                return;
            }
            class_1799 pen = player.method_5998(hand);
            if (!RedstonePenItem.hasEnoughRedstone(pen, 2, player)) {
                return;
            }
            TrackBlockEntity te = RedstoneTrackBlock.tile((class_1922)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            class_3545<class_2350, class_2350> side_dir = defs.connections.getWireBitSideAndDirection(te.getWireFlags());
            class_2350 face = (class_2350)side_dir.method_15442();
            class_2350 dir = (class_2350)side_dir.method_15441();
            if (face == class_2350.field_11033 && dir == class_2350.field_11033) {
                return;
            }
            int num_placed = 0;
            long flags_to_add = 0L;
            for (class_2350 d : class_2350.values()) {
                TrackBlockEntity ote;
                class_2680 ostate2;
                if (!RedstonePenItem.hasEnoughRedstone(pen, num_placed, player)) {
                    return;
                }
                if (d == face || d == face.method_10153() || d == dir || !(ostate2 = world.method_8320(pos.method_10093(d))).method_27852((class_2248)this) || (ote = (TrackBlockEntity)RedstoneTrackBlock.tile((class_1922)world, pos.method_10093(d)).orElse(null)) == null) continue;
                int oflags = ote.getWireFlags();
                if ((defs.connections.getWireBit(face, d.method_10153()) & (long)oflags) == 0L) continue;
                flags_to_add |= defs.connections.getWireBit(face, d);
                ++num_placed;
            }
            if (num_placed == 0 && !RsSignals.hasSignalConnector(ostate = world.method_8320(opos = pos.method_10093(odir = dir.method_10153())), (class_1922)world, opos, dir)) {
                flags_to_add |= defs.connections.getWireBit(face, odir);
                ++num_placed;
            }
            if (num_placed > 0) {
                int n_added = te.addWireFlags(flags_to_add);
                te.sync(true);
                RedstonePenItem.popRedstone(pen, n_added, player, hand);
                te.updateConnections(2);
                te.updateAllPowerValuesFromAdjacent();
                this.updateNeighbourShapes(state, world, pos);
                this.notifyAdjacent(world, pos);
            }
        }

        private void disablePower(boolean disable) {
            this.can_provide_power_ = !disable;
        }

        private void updateNeighbourShapes(class_2680 state, class_1937 world, class_2338 pos) {
            state.method_30101((class_1936)world, pos, 3);
        }

        public void notifyAdjacent(class_1937 world, class_2338 pos) {
            world.method_8452(pos, (class_2248)this);
            for (class_2350 dir0 : class_4970.field_23157) {
                class_2338 ppos = pos.method_10093(dir0);
                world.method_8508(ppos, world.method_8320(ppos).method_26204(), dir0.method_10153());
                for (class_2350 dir1 : class_4970.field_23157) {
                    class_2680 diagonal_state;
                    if (dir0 == dir1.method_10153()) {
                        return;
                    }
                    ppos = pos.method_10093(dir0).method_10093(dir1);
                    if (ppos == pos || (diagonal_state = world.method_8320(ppos)).method_26204() != this) continue;
                    world.method_8492(ppos, (class_2248)this, pos);
                }
            }
        }
    }

    public static final class defs {
        public static final long STATE_FLAG_WIR_MASK = 0xFFFFFFL;
        public static final long STATE_FLAG_CON_MASK = 0x3F000000L;
        public static final long STATE_FLAG_PWR_MASK = 0xFFFFFF00000000L;
        public static final int STATE_FLAG_WIR_COUNT = 24;
        public static final int STATE_FLAG_CON_COUNT = 6;
        public static final int STATE_FLAG_WIR_POS = 0;
        public static final int STATE_FLAG_CON_POS = 24;
        public static final int STATE_FLAG_PWR_POS = 32;
        public static final class_2350[] REDSTONE_UPDATE_DIRECTIONS = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035};

        public static final class models {
            public static final ImmutableMap<Long, String> STATE_WIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)1L, (Object)"dn").put((Object)2L, (Object)"ds").put((Object)4L, (Object)"de").put((Object)8L, (Object)"dw").put((Object)16L, (Object)"un").put((Object)32L, (Object)"us").put((Object)64L, (Object)"ue").put((Object)128L, (Object)"uw").put((Object)256L, (Object)"nu").put((Object)512L, (Object)"nd").put((Object)1024L, (Object)"ne").put((Object)2048L, (Object)"nw").put((Object)4096L, (Object)"su").put((Object)8192L, (Object)"sd").put((Object)16384L, (Object)"se").put((Object)32768L, (Object)"sw").put((Object)65536L, (Object)"eu").put((Object)131072L, (Object)"ed").put((Object)262144L, (Object)"en").put((Object)524288L, (Object)"es").put((Object)0x100000L, (Object)"wu").put((Object)0x200000L, (Object)"wd").put((Object)0x400000L, (Object)"wn").put((Object)0x800000L, (Object)"ws").build();
            public static final ImmutableMap<Long, String> STATE_CONNECT_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dc").put((Object)0x2000000L, (Object)"uc").put((Object)0x4000000L, (Object)"nc").put((Object)0x8000000L, (Object)"sc").put((Object)0x10000000L, (Object)"ec").put((Object)0x20000000L, (Object)"wc").build();
            public static final ImmutableMap<Long, String> STATE_CNTWIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dm").put((Object)0x2000000L, (Object)"um").put((Object)0x4000000L, (Object)"nm").put((Object)0x8000000L, (Object)"sm").put((Object)0x10000000L, (Object)"em").put((Object)0x20000000L, (Object)"wm").build();
        }

        public static class shape {
            private static final double SHAPE_LAYER_THICKNESS = 0.01;
            private static final double SHAPE_TRACK_HALFWIDTH = 1.0;
            private static final class_265 DOWN_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 0.01, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 16.0, 0.01, 9.0));
            private static final class_265 UP_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 15.99, 0.0, 9.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 15.99, 7.0, 16.0, 16.0, 9.0));
            private static final class_265 WEST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 0.01, 16.0, 9.0), Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 0.01, 9.0, 16.0));
            private static final class_265 EAST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(15.99, 0.0, 7.0, 16.0, 16.0, 9.0), Auxiliaries.getPixeledAABB(15.99, 7.0, 0.0, 16.0, 9.0, 16.0));
            private static final class_265 NORTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 16.0, 9.0, 0.01), Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 16.0, 0.01));
            private static final class_265 SOUTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 15.99, 16.0, 9.0, 16.0), Auxiliaries.getPixeledAABB(7.0, 0.0, 15.99, 9.0, 16.0, 16.0));
            private static final class_265[] shape_cache = new class_265[64];

            public static class_265 get(int faces) {
                if (shape_cache[faces] == null) {
                    class_265 shape2 = class_259.method_1073();
                    if ((faces & 1) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)DOWN_SHAPE, (class_247)class_247.field_1366);
                    }
                    if ((faces & 2) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)UP_SHAPE, (class_247)class_247.field_1366);
                    }
                    if ((faces & 4) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)NORTH_SHAPE, (class_247)class_247.field_1366);
                    }
                    if ((faces & 8) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)SOUTH_SHAPE, (class_247)class_247.field_1366);
                    }
                    if ((faces & 0x10) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)EAST_SHAPE, (class_247)class_247.field_1366);
                    }
                    if ((faces & 0x20) != 0) {
                        shape2 = class_259.method_1072((class_265)shape2, (class_265)WEST_SHAPE, (class_247)class_247.field_1366);
                    }
                    shape.shape_cache[faces] = shape2;
                }
                return shape_cache[faces];
            }
        }

        public static final class connections {
            public static final class_2350[] CONNECTION_BIT_ORDER = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
            public static final ImmutableMap<class_2350, Integer> CONNECTION_BIT_ORDER_REV = new ImmutableMap.Builder().put((Object)class_2350.field_11033, (Object)0).put((Object)class_2350.field_11036, (Object)1).put((Object)class_2350.field_11043, (Object)2).put((Object)class_2350.field_11035, (Object)3).put((Object)class_2350.field_11034, (Object)4).put((Object)class_2350.field_11039, (Object)5).build();
            public static final ImmutableMap<Long, class_2350> BULK_FACE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)class_2350.field_11033).put((Object)0x1000000L, (Object)class_2350.field_11033).put((Object)0x2000000L, (Object)class_2350.field_11036).put((Object)0x4000000L, (Object)class_2350.field_11043).put((Object)0x8000000L, (Object)class_2350.field_11035).put((Object)0x10000000L, (Object)class_2350.field_11034).put((Object)0x20000000L, (Object)class_2350.field_11039).build();
            public static final ImmutableMap<class_2350, Long> BULK_FACE_MAPPING_REV = new ImmutableMap.Builder().put((Object)class_2350.field_11033, (Object)0x1000000L).put((Object)class_2350.field_11036, (Object)0x2000000L).put((Object)class_2350.field_11043, (Object)0x4000000L).put((Object)class_2350.field_11035, (Object)0x8000000L).put((Object)class_2350.field_11034, (Object)0x10000000L).put((Object)class_2350.field_11039, (Object)0x20000000L).build();
            public static final ImmutableMap<Long, class_3545<class_2350, class_2350>> WIRE_FACE_DIRECTION_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11033)).put((Object)1L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11043)).put((Object)2L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11035)).put((Object)4L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11034)).put((Object)8L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11039)).put((Object)16L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11043)).put((Object)32L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11035)).put((Object)64L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11034)).put((Object)128L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11039)).put((Object)256L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11036)).put((Object)512L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11033)).put((Object)1024L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11034)).put((Object)2048L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11039)).put((Object)4096L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11036)).put((Object)8192L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11033)).put((Object)16384L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11034)).put((Object)32768L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11039)).put((Object)65536L, (Object)new class_3545((Object)class_2350.field_11034, (Object)class_2350.field_11036)).put((Object)131072L, (Object)new class_3545((Object)class_2350.field_11034, (Object)class_2350.field_11033)).put((Object)262144L, (Object)new class_3545((Object)class_2350.field_11034, (Object)class_2350.field_11043)).put((Object)524288L, (Object)new class_3545((Object)class_2350.field_11034, (Object)class_2350.field_11035)).put((Object)0x100000L, (Object)new class_3545((Object)class_2350.field_11039, (Object)class_2350.field_11036)).put((Object)0x200000L, (Object)new class_3545((Object)class_2350.field_11039, (Object)class_2350.field_11033)).put((Object)0x400000L, (Object)new class_3545((Object)class_2350.field_11039, (Object)class_2350.field_11043)).put((Object)0x800000L, (Object)new class_3545((Object)class_2350.field_11039, (Object)class_2350.field_11035)).build();
            public static final ImmutableMap<Long, class_3545<class_2350, class_2350>> INTERNAL_EDGE_CONNECTION_MAPPING = new ImmutableMap.Builder().put((Object)513L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11043)).put((Object)8194L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11035)).put((Object)131076L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11034)).put((Object)0x200008L, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11039)).put((Object)272L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11043)).put((Object)4128L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11035)).put((Object)65600L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11034)).put((Object)0x100080L, (Object)new class_3545((Object)class_2350.field_11036, (Object)class_2350.field_11039)).put((Object)263168L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11034)).put((Object)0x400800L, (Object)new class_3545((Object)class_2350.field_11043, (Object)class_2350.field_11039)).put((Object)540672L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11034)).put((Object)0x808000L, (Object)new class_3545((Object)class_2350.field_11035, (Object)class_2350.field_11039)).build();

            public static long getBulkConnectorBit(class_2350 face) {
                return (Long)BULK_FACE_MAPPING_REV.get((Object)face);
            }

            public static long getWireBit(class_2350 face, class_2350 wire_direction) {
                return WIRE_FACE_DIRECTION_MAPPING.entrySet().stream().filter(kv -> ((class_3545)kv.getValue()).method_15442() == face && ((class_3545)kv.getValue()).method_15441() == wire_direction).findFirst().map(Map.Entry::getKey).orElse(0L);
            }

            public static class_3545<class_2350, class_2350> getWireBitSideAndDirection(long wirebit) {
                return (class_3545)WIRE_FACE_DIRECTION_MAPPING.getOrDefault((Object)wirebit, (Object)new class_3545((Object)class_2350.field_11033, (Object)class_2350.field_11033));
            }

            public static List<class_2350> getVanillaWireConnectionDirections(long mask) {
                if ((mask & 0xFL) == 0L) {
                    return Collections.emptyList();
                }
                ArrayList<class_2350> r = new ArrayList<class_2350>(4);
                if ((mask & 1L) != 0L) {
                    r.add(class_2350.field_11043);
                }
                if ((mask & 2L) != 0L) {
                    r.add(class_2350.field_11035);
                }
                if ((mask & 4L) != 0L) {
                    r.add(class_2350.field_11034);
                }
                if ((mask & 8L) != 0L) {
                    r.add(class_2350.field_11039);
                }
                return r;
            }

            public static boolean hasVanillaWireConnection(long mask, class_2350 side) {
                return switch (side) {
                    case class_2350.field_11043 -> {
                        if ((mask & 1L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11035 -> {
                        if ((mask & 2L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11034 -> {
                        if ((mask & 4L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11039 -> {
                        if ((mask & 8L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            public static boolean hasBulkConnection(long mask, class_2350 side) {
                return ((Long)BULK_FACE_MAPPING_REV.get((Object)side) & mask) != 0L;
            }

            public static boolean hasRedstoneConnection(long mask, class_2350 side) {
                return switch (side) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_2350.field_11033 -> {
                        if ((mask & 0x1222200L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11036 -> {
                        if ((mask & 0x2111100L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11043 -> {
                        if ((mask & 0x4440011L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11035 -> {
                        if ((mask & 0x8880022L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11034 -> {
                        if ((mask & 0x10004444L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case class_2350.field_11039 -> (mask & 0x20008888L) != 0L;
                };
            }

            public static long getWireElementsOnFace(class_2350 face) {
                return 15L << (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face) * 4 + 0;
            }

            public static long getAllElementsOnFace(class_2350 face) {
                int index = (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face);
                return 15L << index * 4 + 0 | 1L << index + 24;
            }
        }
    }
}

