/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import wile.api.rca.FmmRedstoneClientAdapter;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.CircuitComponents;
import wile.redstonepen.detail.RcaSync;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.GuiTextEditing;
import wile.redstonepen.libmc.Guis;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.NetworkingClient;
import wile.redstonepen.libmc.Registries;
import wile.redstonepen.libmc.StandardEntityBlocks;
import wile.redstonepen.libmc.TooltipDisplay;

public class ControlBox {

    private static class ControlBoxLogic {
        private ControlBoxLogic() {
        }

        public static class MathExpr {

            public static class ParsedLine {
                public final Expr expression;
                public final String assignment_symbol;
                public final String error;
                public final String line;
                public final Set<String> symbols = new HashSet<String>();
                public int pe = -1;
                public char c = (char)32;
                public final Map<String, ExprFuncDef> functions = new HashMap<String, ExprFuncDef>();

                public static ParsedLine of(String line) {
                    return ParsedLine.of(line, "");
                }

                public static ParsedLine of(String line, String default_assignment_variable) {
                    return ParsedLine.of(line, default_assignment_variable, Collections.emptyList());
                }

                public static ParsedLine of(String line, String default_assignment_variable, Collection<ExprFuncDef> functions) {
                    return new ParsedLine(line, default_assignment_variable, functions);
                }

                public String toString() {
                    return "ParsedLine{ line:\"" + this.line.replaceAll("\"", "\\\"") + "\"," + (String)(this.error.isEmpty() ? "" : " error:\"" + this.error.replaceAll("\"", "\\\"") + " @pos=" + this.pe + "\",") + " sym:\"" + String.join((CharSequence)",", this.symbols) + "\", expr:\"" + this.expression + "\" }";
                }

                private ParsedLine(String line, String default_assignment_variable, Collection<ExprFuncDef> functions) {
                    this.line = line;
                    Expr exp = Expr.EMPTY;
                    String err = "";
                    String assign = "";
                    functions.forEach(def -> this.functions.put(def.name.toLowerCase(), (ExprFuncDef)def));
                    if (!line.matches("^[\\s]*#.*")) {
                        try {
                            this.adv();
                            exp = this.expr_assign(default_assignment_variable);
                            if (this.pe < line.length()) {
                                exp = Expr.EMPTY;
                                err = "invalid_character";
                            } else {
                                assign = exp.name.toLowerCase();
                            }
                        }
                        catch (Exception e) {
                            err = "parse_error";
                        }
                    }
                    this.expression = exp;
                    this.assignment_symbol = assign;
                    this.error = err;
                }

                private void adv() {
                    if (++this.pe >= this.line.length()) {
                        this.c = '\u0000';
                    } else if (this.c == '\n' || this.c == '\r' || this.c == '#') {
                        this.pe = this.line.length();
                        this.c = '\u0000';
                    } else {
                        char ci = this.line.charAt(this.pe);
                        if (ci > '\u007f') {
                            throw new RuntimeException("invalid_character");
                        }
                        this.c = Character.toLowerCase(ci);
                    }
                }

                private boolean adv(char match) {
                    while (this.c == ' ' || this.c == '\t' || this.c == '#') {
                        this.adv();
                    }
                    if (this.c != match) {
                        return false;
                    }
                    this.adv();
                    return true;
                }

                private boolean adv(String match) {
                    while (this.c == ' ' || this.c == '\t' || this.c == '#') {
                        this.adv();
                    }
                    if (!this.line.regionMatches(true, this.pe, match, 0, match.length())) {
                        return false;
                    }
                    this.pe += match.length() - 1;
                    this.adv();
                    return true;
                }

                private Expr expr_assign(String default_assignment_variable) {
                    String ref = default_assignment_variable;
                    if (this.line.matches("^[\\s]*[a-zA-Z][\\w.]*[\\s]*[=][^=].*")) {
                        ref = this.const_literal();
                        if (!this.adv('=')) {
                            throw new RuntimeException("expected_assignment");
                        }
                        if (this.functions.containsKey(ref.toLowerCase())) {
                            throw new RuntimeException("symbol_readonly");
                        }
                    }
                    this.symbols.add(ref);
                    return new ExprAssign(ref, this.expr());
                }

                private Expr expr() {
                    return this.expr_or();
                }

                private Expr expr_or() {
                    Expr x = this.expr_xor();
                    while (true) {
                        if (this.adv("or")) {
                            x = new ExprOr(List.of(x, this.expr_xor()));
                            continue;
                        }
                        if (this.adv("||")) {
                            x = new ExprOr(List.of(x, this.expr_xor()));
                            continue;
                        }
                        if (!this.adv('|')) break;
                        x = new ExprOr(List.of(x, this.expr_xor()));
                    }
                    return x;
                }

                private Expr expr_xor() {
                    Expr x = this.expr_and();
                    while (true) {
                        if (this.adv("xor")) {
                            x = new ExprXor(List.of(x, this.expr_and()));
                            continue;
                        }
                        if (!this.adv('^')) break;
                        x = new ExprXor(List.of(x, this.expr_and()));
                    }
                    return x;
                }

                private Expr expr_and() {
                    Expr x = this.expr_rel();
                    while (true) {
                        if (this.adv("and")) {
                            x = new ExprAnd(List.of(x, this.expr_rel()));
                            continue;
                        }
                        if (this.adv("&&")) {
                            x = new ExprAnd(List.of(x, this.expr_rel()));
                            continue;
                        }
                        if (!this.adv('&')) break;
                        x = new ExprAnd(List.of(x, this.expr_rel()));
                    }
                    return x;
                }

                private Expr expr_rel() {
                    Expr x = this.arith_add();
                    while (true) {
                        if (this.adv("!=")) {
                            x = new ExprNeq(List.of(x, this.arith_add()));
                        }
                        if (this.adv("<>")) {
                            x = new ExprNeq(List.of(x, this.arith_add()));
                        }
                        if (this.adv("==")) {
                            x = new ExprEq(List.of(x, this.arith_add()));
                        }
                        if (this.adv(">=")) {
                            x = new ExprGe(List.of(x, this.arith_add()));
                        }
                        if (this.adv("<=")) {
                            x = new ExprLe(List.of(x, this.arith_add()));
                        }
                        if (this.adv('>')) {
                            x = new ExprGt(List.of(x, this.arith_add()));
                        }
                        if (!this.adv('<')) break;
                        x = new ExprLt(List.of(x, this.arith_add()));
                    }
                    return x;
                }

                private Expr arith_add() {
                    Expr x = this.arith_mpy();
                    while (true) {
                        if (this.adv('+')) {
                            x = new ExprAdd(List.of(x, this.arith_mpy()));
                            continue;
                        }
                        if (!this.adv('-')) break;
                        x = new ExprSub(List.of(x, this.arith_mpy()));
                    }
                    return x;
                }

                private Expr arith_mpy() {
                    Expr x = this.arith_fact();
                    while (true) {
                        if (this.adv('*')) {
                            x = new ExprMpy(List.of(x, this.arith_fact()));
                            continue;
                        }
                        if (this.adv('/')) {
                            x = new ExprDiv(List.of(x, this.arith_fact()));
                            continue;
                        }
                        if (!this.adv('%')) break;
                        x = new ExprMod(List.of(x, this.arith_fact()));
                    }
                    return x;
                }

                private Expr arith_fact() {
                    if (this.adv('+')) {
                        this.adv();
                    }
                    if (this.adv('-') && !this.adv('-')) {
                        return new ExprNeg(List.of(this.arith_fact()));
                    }
                    if (this.adv('!')) {
                        return new ExprNot(List.of(this.arith_fact()));
                    }
                    if (this.adv('(')) {
                        Expr e = this.expr();
                        if (!this.adv(')')) {
                            throw new RuntimeException("missing_closing_parenthesis");
                        }
                        return e;
                    }
                    if (this.c >= '0' && this.c <= '9') {
                        return new ExprConst(this.const_number());
                    }
                    if (this.c >= 'a' && this.c <= 'z') {
                        String sym = this.const_literal();
                        if (sym.equals("not")) {
                            return new ExprNot(List.of(this.expr()));
                        }
                        if (this.adv('(')) {
                            ExprFuncDef fn;
                            ArrayList<Expr> args = new ArrayList<Expr>();
                            if (!this.adv(')')) {
                                args.add(this.expr());
                                while (this.adv(',')) {
                                    args.add(this.expr());
                                }
                                if (!this.adv(')')) {
                                    throw new RuntimeException("missing_closing_function_parenthesis");
                                }
                            }
                            if ((fn = (ExprFuncDef)this.functions.getOrDefault(sym, null)) == null) {
                                throw new RuntimeException("unknown_function");
                            }
                            return new ExprFunc(fn.name, fn.nargs, fn.func, args);
                        }
                        if (this.functions.containsKey(sym)) {
                            throw new RuntimeException("missing_function_arguments");
                        }
                        this.symbols.add(sym);
                        return new ExprVarRef(sym);
                    }
                    throw new RuntimeException("unexpected_character");
                }

                private String const_literal() {
                    if (this.c < 'a' || this.c > 'z') {
                        return "";
                    }
                    int p0 = this.pe;
                    while (this.c >= 'a' && this.c <= 'z' || this.c >= '0' && this.c <= '9' || this.c == '.' || this.c == '_') {
                        this.adv();
                    }
                    return this.line.substring(p0, this.pe).toLowerCase();
                }

                private int const_number() {
                    int p0 = this.pe;
                    while (this.c >= '0' && this.c <= '9') {
                        this.adv();
                    }
                    return Integer.parseInt(this.line.substring(p0, this.pe));
                }
            }

            public static class ExprFuncDef {
                public final String name;
                public final BiFunction<Expr[], Map<String, Integer>, Integer> func;
                public final int nargs;

                ExprFuncDef(String name, int nargs, BiFunction<Expr[], Map<String, Integer>, Integer> func) {
                    this.name = name;
                    this.func = func;
                    this.nargs = nargs;
                }
            }

            public static class ExprAssign
            extends Expr {
                public final Expr value;

                public ExprAssign(String ref, Expr value) {
                    super(ExprType.ASSIGN, ref);
                    this.value = value;
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    int res = this.value.calc(mem);
                    if (!this.name.isEmpty()) {
                        mem.put(this.name, res);
                    }
                    return res;
                }

                @Override
                public String toString() {
                    return "ASSIGN{'" + this.name + "'," + this.value + "}";
                }
            }

            public static class ExprLt
            extends ExprOp {
                public ExprLt(List<Expr> args) {
                    super(ExprType.LT, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) < ((Expr)this.arguments.get(1)).calc(mem) ? ExprLt.bool_true() : ExprLt.bool_false();
                }
            }

            public static class ExprGt
            extends ExprOp {
                public ExprGt(List<Expr> args) {
                    super(ExprType.GT, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) > ((Expr)this.arguments.get(1)).calc(mem) ? ExprGt.bool_true() : ExprGt.bool_false();
                }
            }

            public static class ExprLe
            extends ExprOp {
                public ExprLe(List<Expr> args) {
                    super(ExprType.LE, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) <= ((Expr)this.arguments.get(1)).calc(mem) ? ExprLe.bool_true() : ExprLe.bool_false();
                }
            }

            public static class ExprGe
            extends ExprOp {
                public ExprGe(List<Expr> args) {
                    super(ExprType.GE, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) >= ((Expr)this.arguments.get(1)).calc(mem) ? ExprGe.bool_true() : ExprGe.bool_false();
                }
            }

            public static class ExprEq
            extends ExprOp {
                public ExprEq(List<Expr> args) {
                    super(ExprType.EQ, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) == ((Expr)this.arguments.get(1)).calc(mem) ? ExprEq.bool_true() : ExprEq.bool_false();
                }
            }

            public static class ExprNeq
            extends ExprOp {
                public ExprNeq(List<Expr> args) {
                    super(ExprType.NEQ, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) != ((Expr)this.arguments.get(1)).calc(mem) ? ExprNeq.bool_true() : ExprNeq.bool_false();
                }
            }

            public static class ExprXor
            extends ExprOp {
                public ExprXor(List<Expr> args) {
                    super(ExprType.XOR, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) > 0 ^ ((Expr)this.arguments.get(1)).calc(mem) > 0 ? ExprXor.bool_true() : ExprXor.bool_false();
                }
            }

            public static class ExprOr
            extends ExprOp {
                public ExprOr(List<Expr> args) {
                    super(ExprType.OR, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) > 0 || ((Expr)this.arguments.get(1)).calc(mem) > 0 ? ExprOr.bool_true() : ExprOr.bool_false();
                }
            }

            public static class ExprAnd
            extends ExprOp {
                public ExprAnd(List<Expr> args) {
                    super(ExprType.AND, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) > 0 && ((Expr)this.arguments.get(1)).calc(mem) > 0 ? ExprAnd.bool_true() : ExprAnd.bool_false();
                }
            }

            public static class ExprSub
            extends ExprOp {
                public ExprSub(List<Expr> args) {
                    super(ExprType.SUB, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) - ((Expr)this.arguments.get(1)).calc(mem);
                }
            }

            public static class ExprAdd
            extends ExprOp {
                public ExprAdd(List<Expr> args) {
                    super(ExprType.ADD, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) + ((Expr)this.arguments.get(1)).calc(mem);
                }
            }

            public static class ExprMod
            extends ExprOp {
                public ExprMod(List<Expr> args) {
                    super(ExprType.MOD, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    int b = ((Expr)this.arguments.get(1)).calc(mem);
                    return b <= 0 ? 0 : ((Expr)this.arguments.get(0)).calc(mem) % b;
                }
            }

            public static class ExprDiv
            extends ExprOp {
                public ExprDiv(List<Expr> args) {
                    super(ExprType.DIV, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    int b = ((Expr)this.arguments.get(1)).calc(mem);
                    return b <= 0 ? 0 : ((Expr)this.arguments.get(0)).calc(mem) / b;
                }
            }

            public static class ExprMpy
            extends ExprOp {
                public ExprMpy(List<Expr> args) {
                    super(ExprType.MPY, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) * ((Expr)this.arguments.get(1)).calc(mem);
                }
            }

            public static class ExprNot
            extends ExprOp {
                public ExprNot(List<Expr> args) {
                    super(ExprType.NOT, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return ((Expr)this.arguments.get(0)).calc(mem) == 0 ? ExprNot.bool_true() : ExprNot.bool_false();
                }
            }

            public static class ExprNeg
            extends ExprOp {
                public ExprNeg(List<Expr> args) {
                    super(ExprType.NEG, args);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return -((Expr)this.arguments.get(0)).calc(mem);
                }
            }

            public static class ExprFunc
            extends Expr {
                protected final List<Expr> arguments;
                protected final int num_arguments;
                private final BiFunction<Expr[], Map<String, Integer>, Integer> func;

                public ExprFunc(String name, int nargs, BiFunction<Expr[], Map<String, Integer>, Integer> fn, List<Expr> args) {
                    super(ExprType.FUNC, name);
                    this.arguments = args;
                    this.func = fn;
                    this.num_arguments = nargs;
                    if (nargs >= 0 && nargs != args.size()) {
                        throw new RuntimeException("invalid_number_of_arguments");
                    }
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return this.func.apply(this.arguments.toArray(new Expr[0]), mem);
                }

                @Override
                public String toString() {
                    return "FN{'" + this.name + "'(" + this.arguments.stream().map(Object::toString).collect(Collectors.joining(",")) + ")}";
                }

                public int nargs() {
                    return this.num_arguments;
                }
            }

            public static class ExprVarRef
            extends Expr {
                public ExprVarRef(String ref) {
                    super(ExprType.VARREF, ref);
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return mem.getOrDefault(this.name, 0);
                }

                @Override
                public String toString() {
                    return "SYM{'" + this.name + "'}";
                }
            }

            public static class ExprConst
            extends Expr {
                private final int value;

                public ExprConst(int val) {
                    super(ExprType.CONST, "<CONST>");
                    this.value = val;
                }

                @Override
                public int calc(Map<String, Integer> mem) {
                    return this.value;
                }

                @Override
                public String toString() {
                    return "CONST{" + this.value + "}";
                }
            }

            public static abstract class ExprOp
            extends Expr {
                public final List<Expr> arguments;

                public ExprOp(ExprType type, List<Expr> args) {
                    super(type, type.toString());
                    this.arguments = args;
                }

                @Override
                public abstract int calc(Map<String, Integer> var1);

                @Override
                public String toString() {
                    return this.name + "{" + this.arguments.stream().map(Object::toString).collect(Collectors.joining(",")) + "}";
                }
            }

            public static class Expr {
                public static final Expr EMPTY = new Expr(ExprType.VOID, "<EMPTY>");
                public final ExprType type;
                public final String name;

                protected Expr(ExprType type, String name) {
                    this.type = type;
                    this.name = name;
                }

                public int calc(Map<String, Integer> mem) {
                    return 0;
                }

                public String toString() {
                    return "{VOID}";
                }

                public static int bool_true() {
                    return 15;
                }

                public static int bool_false() {
                    return 0;
                }

                public static int assignment_sanitize(int x) {
                    return x;
                }
            }

            private static enum ExprType {
                VOID,
                CONST,
                VARREF,
                FUNC,
                NEG,
                NOT,
                MPY,
                DIV,
                MOD,
                ADD,
                SUB,
                AND,
                OR,
                XOR,
                NEQ,
                EQ,
                LE,
                GE,
                LT,
                GT,
                ASSIGN;

            }
        }

        public static class MultiLineMathExpr {
            public static final MultiLineMathExpr EMPTY = new MultiLineMathExpr();
            public final List<Entry> entries;
            public final List<Entry> invalid_entries;
            public final Set<String> symbols;
            public final Set<String> assignments;

            public static MultiLineMathExpr of(String code) {
                return MultiLineMathExpr.of(code, "", Collections.emptyList());
            }

            public static MultiLineMathExpr of(String code, String assignment_variable) {
                return MultiLineMathExpr.of(code, assignment_variable, Collections.emptyList());
            }

            public static MultiLineMathExpr of(String code, String assignment_variable, Collection<MathExpr.ExprFuncDef> functions) {
                if (code.trim().isEmpty()) {
                    return EMPTY;
                }
                ArrayList<Entry> entries = new ArrayList<Entry>();
                String[] lines = code.replace("[\\r\\n\\s]+$", "").split("[\\r]?[\\n]");
                ArrayList<Entry> parse_errors = new ArrayList<Entry>();
                HashSet<String> symbols = new HashSet<String>();
                HashSet<String> assignments = new HashSet<String>();
                int line_index = 0;
                int offset = 0;
                for (String line : lines) {
                    if (!line.trim().isEmpty()) {
                        Entry entry = new Entry(line_index, offset, MathExpr.ParsedLine.of(line, assignment_variable, functions));
                        if (!entry.parsed.error.isEmpty()) {
                            parse_errors.add(entry);
                        } else {
                            symbols.addAll(entry.parsed.symbols);
                            if (entry.parsed.expression.type == MathExpr.ExprType.ASSIGN) {
                                entries.add(entry);
                                assignments.add(entry.parsed.assignment_symbol);
                            }
                        }
                    }
                    ++line_index;
                    offset += 1 + line.length();
                }
                return entries.isEmpty() && parse_errors.isEmpty() ? EMPTY : new MultiLineMathExpr(entries, parse_errors, symbols, assignments);
            }

            public MultiLineMathExpr() {
                this(Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), Collections.emptySet());
            }

            public MultiLineMathExpr(List<Entry> lines, List<Entry> parse_error_entries, Set<String> symbols, Set<String> assignments) {
                this.entries = lines;
                this.invalid_entries = parse_error_entries;
                this.symbols = symbols;
                this.assignments = assignments;
            }

            public boolean isEmpty() {
                return this.entries.isEmpty();
            }

            public Map<String, Integer> recalculate(Map<String, Integer> mem, BiFunction<Entry, Map<String, Integer>, Integer> assignment_post_processor) {
                HashMap<String, Integer> assigned = new HashMap<String, Integer>();
                for (Entry entry : this.entries) {
                    entry.last_result = entry.parsed.expression.calc(mem);
                    if (entry.parsed.assignment_symbol.isEmpty()) continue;
                    assigned.put(entry.parsed.assignment_symbol, assignment_post_processor.apply(entry, mem));
                }
                return assigned;
            }

            public static class Entry {
                public final int line_index;
                public final int offset;
                public final MathExpr.ParsedLine parsed;
                public int last_result = 0;

                public Entry(int line_index, int offset, MathExpr.ParsedLine parsed) {
                    this.line_index = line_index;
                    this.offset = offset;
                    this.parsed = parsed;
                }
            }
        }

        private static class Logic {
            public int input_mask = 0;
            public int input_data = 0;
            public int output_mask = 0;
            public int output_data = 0;
            public int intr_redges = 0;
            public int intr_fedges = 0;
            public long rca_input_mask = 0L;
            public long rca_input_data = 0L;
            public long rca_output_mask = 0L;
            public long rca_output_data = 0L;
            private static final List<MathExpr.ExprFuncDef> functions_ = Logic.make_functions();
            private final Map<String, Integer> symbols_ = new HashMap<String, Integer>();
            private MultiLineMathExpr expressions_ = MultiLineMathExpr.EMPTY;
            private String code_ = "";

            private Logic() {
            }

            private static int counter_function(String sym, MathExpr.Expr[] x, Map<String, Integer> m) {
                int nargs = x.length;
                if (nargs <= 0) {
                    return 0;
                }
                int q = m.getOrDefault(sym, 0);
                if (nargs >= 5 && x[4].calc(m) > 0) {
                    q = 0;
                } else if (nargs == 1) {
                    if (x[0].calc(m) > 0) {
                        ++q;
                    }
                } else {
                    int x0 = x[0].calc(m);
                    int x1 = x[1].calc(m);
                    if (x0 > 0 && x1 <= 0) {
                        ++q;
                    } else if (x0 <= 0 && x1 > 0) {
                        --q;
                    }
                }
                q = nargs >= 4 ? class_3532.method_15340((int)q, (int)x[2].calc(m), (int)x[3].calc(m)) : (nargs >= 3 ? class_3532.method_15340((int)q, (int)0, (int)x[2].calc(m)) : class_3532.method_15340((int)q, (int)0, (int)Integer.MAX_VALUE));
                m.put(sym, q);
                return q;
            }

            private static int timer_on_function(String sym, MathExpr.Expr[] x, Map<String, Integer> m) {
                if (x.length != 2) {
                    m.remove("." + sym + ".clk");
                    m.remove(sym + ".et");
                    m.remove(sym + ".pt");
                    return 0;
                }
                int in = x[0].calc(m);
                int pt = x[1].calc(m);
                if (in <= 0) {
                    m.remove("." + sym + ".clk");
                    m.put(sym + ".et", 0);
                    return MathExpr.Expr.bool_false();
                }
                if (pt <= 0) {
                    return MathExpr.Expr.bool_true();
                }
                int now = m.getOrDefault(".clock", 0);
                int et = m.getOrDefault(sym + ".et", 0);
                if (et >= pt) {
                    return MathExpr.Expr.bool_true();
                }
                if (et <= 0) {
                    m.put("." + sym + ".clk", now);
                    m.put(sym + ".et", 1);
                    m.put(sym + ".pt", pt);
                    m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt));
                    return MathExpr.Expr.bool_false();
                }
                et = Math.min(now - m.getOrDefault("." + sym + ".clk", now), pt);
                m.put(sym + ".et", et);
                if (et >= pt) {
                    m.remove("." + sym + ".clk");
                    return MathExpr.Expr.bool_true();
                }
                m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt - et));
                return MathExpr.Expr.bool_false();
            }

            private static int timer_off_function(String sym, MathExpr.Expr[] x, Map<String, Integer> m) {
                if (x.length != 2) {
                    m.remove("." + sym + ".clk");
                    m.remove(sym + ".et");
                    m.remove(sym + ".pt");
                    return 0;
                }
                int in = x[0].calc(m);
                int pt = x[1].calc(m);
                if (in > 0) {
                    m.remove("." + sym + ".clk");
                    m.put(sym + ".et", 0);
                    return MathExpr.Expr.bool_true();
                }
                if (pt <= 0) {
                    return MathExpr.Expr.bool_true();
                }
                int now = m.getOrDefault(".clock", 0);
                int et = m.getOrDefault(sym + ".et", 0);
                if (et >= pt) {
                    return MathExpr.Expr.bool_false();
                }
                if (et <= 0) {
                    m.put("." + sym + ".clk", now);
                    m.put(sym + ".et", 1);
                    m.put(sym + ".pt", pt);
                    m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt));
                    return MathExpr.Expr.bool_true();
                }
                et = Math.min(now - m.getOrDefault("." + sym + ".clk", now), pt);
                m.put(sym + ".et", et);
                if (et >= pt) {
                    m.remove("." + sym + ".clk");
                    return MathExpr.Expr.bool_false();
                }
                m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt - et));
                return MathExpr.Expr.bool_true();
            }

            private static int timer_pulse_function(String sym, MathExpr.Expr[] x, Map<String, Integer> m) {
                if (x.length != 2) {
                    m.remove("." + sym + ".clk");
                    m.remove(sym + ".et");
                    m.remove(sym + ".pt");
                    return 0;
                }
                int in = x[0].calc(m);
                int pt = x[1].calc(m);
                if (pt <= 0) {
                    return in > 0 ? MathExpr.Expr.bool_true() : MathExpr.Expr.bool_false();
                }
                int et = m.getOrDefault(sym + ".et", 0);
                if (et > 0) {
                    if (et >= pt) {
                        if (in <= 0) {
                            m.put(sym + ".et", 0);
                        }
                        return MathExpr.Expr.bool_false();
                    }
                    int now = m.getOrDefault(".clock", 0);
                    et = Math.min(now - m.getOrDefault("." + sym + ".clk", now), pt);
                    m.put(sym + ".et", et);
                    if (et >= pt) {
                        m.remove("." + sym + ".clk");
                        return MathExpr.Expr.bool_false();
                    }
                    m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt - et));
                    return MathExpr.Expr.bool_true();
                }
                if (in > 0) {
                    m.put("." + sym + ".clk", m.getOrDefault(".clock", 0));
                    m.put(sym + ".et", 1);
                    m.put(sym + ".pt", pt);
                    m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), pt));
                    return MathExpr.Expr.bool_true();
                }
                return MathExpr.Expr.bool_false();
            }

            private static int timer_interval_function(String sym, MathExpr.Expr[] x, Map<String, Integer> m) {
                int clk;
                int en;
                if (x.length < 1 || x.length > 2) {
                    m.remove(sym + ".clk");
                    return 0;
                }
                int n = en = x.length < 2 ? 15 : x[1].calc(m);
                if (en <= 0) {
                    m.remove(sym + ".clk");
                    return 0;
                }
                int pt = x[0].calc(m);
                if (pt <= 2) {
                    return MathExpr.Expr.bool_false();
                }
                int now = m.getOrDefault(".clock", 0);
                if (Math.abs(now - (clk = m.getOrDefault(sym + ".clk", now - pt).intValue())) >= pt) {
                    m.put(sym + ".clk", now);
                    m.put(".deadline", 1);
                    return MathExpr.Expr.bool_true();
                }
                m.put(".deadline", Math.min(m.getOrDefault(".deadline", 20), clk - now + pt));
                return MathExpr.Expr.bool_false();
            }

            private static List<MathExpr.ExprFuncDef> make_functions() {
                return Arrays.asList(new MathExpr.ExprFuncDef("inv", 1, (x, m) -> Math.min(15, Math.max(0, 15 - x[0].calc((Map<String, Integer>)m)))), new MathExpr.ExprFuncDef("max", -1, (x, m) -> Arrays.stream(x).mapToInt(e -> e.calc((Map<String, Integer>)m)).max().orElse(0)), new MathExpr.ExprFuncDef("min", -1, (x, m) -> Arrays.stream(x).mapToInt(e -> e.calc((Map<String, Integer>)m)).min().orElse(0)), new MathExpr.ExprFuncDef("lim", -1, (x, m) -> switch (((MathExpr.Expr[])x).length) {
                    case 0 -> 0;
                    case 1 -> Math.min(15, Math.max(0, x[0].calc((Map<String, Integer>)m)));
                    case 2 -> Math.min(x[1].calc((Map<String, Integer>)m), Math.max(0, x[0].calc((Map<String, Integer>)m)));
                    default -> Math.min(x[2].calc((Map<String, Integer>)m), Math.max(x[1].calc((Map<String, Integer>)m), x[0].calc((Map<String, Integer>)m)));
                }), new MathExpr.ExprFuncDef("if", -1, (x, m) -> switch (((MathExpr.Expr[])x).length) {
                    case 0 -> 0;
                    case 1 -> x[0].calc((Map<String, Integer>)m) > 0 ? 15 : 0;
                    case 2 -> x[0].calc((Map<String, Integer>)m) > 0 ? x[1].calc((Map<String, Integer>)m) : 0;
                    default -> x[0].calc((Map<String, Integer>)m) > 0 ? x[1].calc((Map<String, Integer>)m) : x[2].calc((Map<String, Integer>)m);
                }), new MathExpr.ExprFuncDef("mean", -1, (x, m) -> ((MathExpr.Expr[])x).length == 0 ? 0 : Arrays.stream(x).mapToInt(e -> e.calc((Map<String, Integer>)m)).sum() / ((MathExpr.Expr[])x).length), new MathExpr.ExprFuncDef("rnd", 0, (x, m) -> (int)(Math.random() * 16.0)), new MathExpr.ExprFuncDef("clock", 0, (x, m) -> m.getOrDefault(".clock", 0)), new MathExpr.ExprFuncDef("time", 0, (x, m) -> m.getOrDefault(".time", 0)), new MathExpr.ExprFuncDef("tiv1", -1, (x, m) -> Logic.timer_interval_function(".tiv1", x, m)), new MathExpr.ExprFuncDef("tiv2", -1, (x, m) -> Logic.timer_interval_function(".tiv2", x, m)), new MathExpr.ExprFuncDef("tiv3", -1, (x, m) -> Logic.timer_interval_function(".tiv3", x, m)), new MathExpr.ExprFuncDef("cnt1", -1, (x, m) -> Logic.counter_function(".cnt1", x, m)), new MathExpr.ExprFuncDef("cnt2", -1, (x, m) -> Logic.counter_function(".cnt2", x, m)), new MathExpr.ExprFuncDef("cnt3", -1, (x, m) -> Logic.counter_function(".cnt3", x, m)), new MathExpr.ExprFuncDef("cnt4", -1, (x, m) -> Logic.counter_function(".cnt4", x, m)), new MathExpr.ExprFuncDef("cnt5", -1, (x, m) -> Logic.counter_function(".cnt5", x, m)), new MathExpr.ExprFuncDef("ton1", 2, (x, m) -> Logic.timer_on_function("ton1", x, m)), new MathExpr.ExprFuncDef("ton2", 2, (x, m) -> Logic.timer_on_function("ton2", x, m)), new MathExpr.ExprFuncDef("ton3", 2, (x, m) -> Logic.timer_on_function("ton3", x, m)), new MathExpr.ExprFuncDef("ton4", 2, (x, m) -> Logic.timer_on_function("ton4", x, m)), new MathExpr.ExprFuncDef("ton5", 2, (x, m) -> Logic.timer_on_function("ton5", x, m)), new MathExpr.ExprFuncDef("tof1", 2, (x, m) -> Logic.timer_off_function("tof1", x, m)), new MathExpr.ExprFuncDef("tof2", 2, (x, m) -> Logic.timer_off_function("tof2", x, m)), new MathExpr.ExprFuncDef("tof3", 2, (x, m) -> Logic.timer_off_function("tof3", x, m)), new MathExpr.ExprFuncDef("tof4", 2, (x, m) -> Logic.timer_off_function("tof4", x, m)), new MathExpr.ExprFuncDef("tof5", 2, (x, m) -> Logic.timer_off_function("tof5", x, m)), new MathExpr.ExprFuncDef("tp1", 2, (x, m) -> Logic.timer_pulse_function("tp1", x, m)), new MathExpr.ExprFuncDef("tp2", 2, (x, m) -> Logic.timer_pulse_function("tp2", x, m)), new MathExpr.ExprFuncDef("tp3", 2, (x, m) -> Logic.timer_pulse_function("tp3", x, m)), new MathExpr.ExprFuncDef("tp4", 2, (x, m) -> Logic.timer_pulse_function("tp4", x, m)), new MathExpr.ExprFuncDef("tp5", 2, (x, m) -> Logic.timer_pulse_function("tp5", x, m)));
            }

            public boolean valid() {
                return this.expressions_.invalid_entries.isEmpty();
            }

            public MultiLineMathExpr expressions() {
                return this.expressions_;
            }

            public Map<Integer, String> errors() {
                return this.expressions_.invalid_entries.stream().collect(Collectors.toMap(e -> e.offset + e.parsed.pe, e -> e.parsed.error));
            }

            public void symbol(String key, int value) {
                this.symbols_.put(key.toLowerCase(), value);
            }

            public int symbol(String key) {
                return this.symbols_.getOrDefault(key.toLowerCase(), 0);
            }

            public Map<String, Integer> symbols() {
                return this.symbols_;
            }

            public String code() {
                return this.code_;
            }

            public boolean code(String new_code) {
                if (this.code_.equals(new_code) && !this.expressions_.isEmpty()) {
                    return this.expressions_.invalid_entries.isEmpty();
                }
                this.code_ = new_code;
                this.expressions_ = MultiLineMathExpr.of(this.code_, "", functions_);
                this.input_mask = 0;
                this.output_mask = 0;
                this.rca_input_mask = 0L;
                this.rca_output_mask = 0L;
                this.symbols_.clear();
                String[] suffixes = new String[]{"", ".re", ".fe", ".co", ".co.re", ".co.fe"};
                for (int i = 0; i < Defs.PORT_NAMES.size(); ++i) {
                    String port = Defs.PORT_NAMES.get(i);
                    if (this.expressions_.symbols.contains(port + ".co.re") || this.expressions_.symbols.contains(port + ".co.fe")) {
                        this.expressions_.symbols.add(port + ".co");
                    }
                    if (this.expressions_.assignments.contains(port)) {
                        this.output_mask |= 15 << 4 * i;
                        continue;
                    }
                    if (!Arrays.stream(suffixes).map(s -> port + s).anyMatch(this.expressions_.symbols::contains)) continue;
                    this.input_mask |= 15 << 4 * i;
                }
                this.expressions_.symbols.forEach(esym -> {
                    if (esym.matches("^d[io][1]?[\\d][\\d]?$")) {
                        int channel = Integer.parseInt(esym.substring(2));
                        if (channel > 15) {
                            return;
                        }
                        if (esym.charAt(1) == 'i') {
                            this.rca_input_mask |= 15L << channel * 4;
                        } else {
                            this.rca_output_mask |= 15L << channel * 4;
                        }
                    }
                });
                this.rca_input_data &= this.rca_input_mask;
                this.rca_output_data &= this.rca_output_mask;
                this.output_data &= this.output_mask;
                this.input_data &= this.input_mask;
                return this.expressions_.invalid_entries.isEmpty();
            }

            public void tick() {
                int i;
                int i2;
                for (i2 = 0; i2 < Defs.PORT_NAMES.size(); ++i2) {
                    if ((this.input_mask & 15 << 4 * i2) == 0) continue;
                    this.symbol(Defs.PORT_NAMES.get(i2), this.input_data >> 4 * i2 & 0xF);
                }
                if (this.rca_input_mask != 0L) {
                    for (i2 = 0; i2 < 16; ++i2) {
                        if ((this.rca_input_mask & 15L << 4 * i2) == 0L) continue;
                        this.symbol("di" + i2, (int)(this.rca_input_data >> 4 * i2 & 0xFL));
                    }
                }
                this.expressions_.symbols.forEach(esym -> {
                    if (!esym.contains(".")) {
                        return;
                    }
                    boolean isrising = esym.endsWith(".re");
                    if (isrising || esym.endsWith(".fe")) {
                        String symref;
                        Map<String, Integer> syms = this.symbols();
                        if (!syms.containsKey(symref = esym.substring(0, esym.length() - 3)) && !Defs.PORT_NAMES.contains(symref)) {
                            return;
                        }
                        String symlast = "." + esym + ".d";
                        int q1 = syms.getOrDefault(symref, 0) > 0 ? 15 : 0;
                        boolean edge = false;
                        if (syms.containsKey(symlast)) {
                            int q0;
                            int n = q0 = syms.getOrDefault(symlast, 0) > 0 ? 15 : 0;
                            edge = isrising ? q0 <= 0 && q1 > 0 : q0 > 0 && q1 <= 0;
                        }
                        this.symbol((String)esym, edge ? 15 : 0);
                        this.symbol(symlast, q1);
                    }
                });
                for (i2 = 0; i2 < Defs.PORT_NAMES.size(); ++i2) {
                    int port_mask = 15 << 4 * i2;
                    if ((this.intr_redges & port_mask) != 0) {
                        this.symbol(Defs.PORT_NAMES.get(i2) + ".re", 15);
                    }
                    if ((this.intr_fedges & port_mask) == 0) continue;
                    this.symbol(Defs.PORT_NAMES.get(i2) + ".fe", 15);
                }
                this.intr_redges = 0;
                this.intr_fedges = 0;
                this.symbol(".deadline", 40);
                Map<String, Integer> assigned = this.expressions_.recalculate(this.symbols_, (entry, mem) -> switch (entry.parsed.assignment_symbol) {
                    case "r", "b", "y", "g", "u", "d" -> Math.max(0, Math.min(15, entry.last_result));
                    default -> entry.last_result;
                });
                assigned.forEach(this::symbol);
                this.output_data = 0;
                for (i = 0; i < Defs.PORT_NAMES.size(); ++i) {
                    this.output_data |= (this.symbol(Defs.PORT_NAMES.get(i)) & 0xF) << 4 * i;
                }
                this.output_data &= this.output_mask;
                if (this.rca_output_mask != 0L) {
                    this.rca_output_data = 0L;
                    for (i = 0; i < 16; ++i) {
                        if ((this.rca_output_mask & 15L << 4 * i) == 0L) continue;
                        this.rca_output_data |= (long)Math.min(15, Math.max(0, this.symbol("do" + i))) << 4 * i;
                    }
                }
                this.rca_output_data &= this.rca_output_mask;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ControlBoxGui
    extends Guis.ContainerGui<ControlBoxUiContainer> {
        private final int VALUE_UPDATE_INTERVAL = 2;
        private final String tooltip_prefix = ModContent.references.CONTROLBOX_BLOCK.method_9539();
        private final GuiTextEditing.MultiLineTextBox textbox;
        private final Guis.CheckBox start_stop;
        private final Guis.ImageButton cb_copy_all;
        private final Guis.ImageButton cb_paste_all;
        private final Guis.Image cb_error_indicator;
        private final Guis.Image rca_enabled_indicator;
        private final List<Guis.TextBox> port_stati;
        private final List<Guis.Image> port_stati_i_indicators;
        private final List<Guis.Image> port_stati_o_indicators;
        private final Map<String, Integer> symbols_ = new HashMap<String, Integer>();
        private final List<class_3545<Integer, String>> errors_ = new ArrayList<class_3545<Integer, String>>();
        private int update_counter_ = 0;
        private boolean focus_editor_ = false;
        private boolean debug_enabled_ = false;
        private boolean code_requested_ = false;
        private class_2561 activating_player_ = class_2561.method_43473();

        public ControlBoxGui(ControlBoxUiContainer container, class_1661 player_inventory, class_2561 title) {
            super(container, player_inventory, title, "textures/gui/control_box_gui.png", 238, 206);
            this.field_25267 = 17;
            this.field_25268 = -10;
            this.start_stop = new Guis.CheckBox(this.getBackgroundImage(), 12, 12, Guis.Coord2d.of(15, 213), Guis.Coord2d.of(28, 213));
            this.cb_copy_all = new Guis.ImageButton(this.getBackgroundImage(), 12, 12, Guis.Coord2d.of(41, 213));
            this.cb_paste_all = new Guis.ImageButton(this.getBackgroundImage(), 12, 12, Guis.Coord2d.of(54, 213));
            this.cb_error_indicator = new Guis.Image(this.getBackgroundImage(), 5, 2, Guis.Coord2d.of(68, 213));
            this.rca_enabled_indicator = new Guis.Image(this.getBackgroundImage(), 7, 7, Guis.Coord2d.of(90, 215));
            this.textbox = new GuiTextEditing.MultiLineTextBox(29, 12, 156, 170, (class_2561)class_2561.method_43470((String)"Code"));
            this.port_stati = new ArrayList<Guis.TextBox>();
            this.port_stati_i_indicators = new ArrayList<Guis.Image>();
            this.port_stati_o_indicators = new ArrayList<Guis.Image>();
        }

        @Override
        public void method_25426() {
            super.method_25426();
            this.textbox.init((class_437)this, Guis.Coord2d.of(29, 12)).setFontColor(0xDDDDDD).setCursorColor(0xDDDDDD).setLineHeight(7).onValueChanged(tb -> this.push_code(this.textbox.getValue()));
            this.method_37063(this.textbox);
            this.start_stop.init((class_437)this, Guis.Coord2d.of(196, 14)).tooltip((class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".tooltips.runstop"));
            this.start_stop.onclick(cb -> {
                class_2487 nbt = new class_2487();
                FmmRedstoneClientAdapter.Adapter rca = FmmRedstoneClientAdapter.Adapter.instance();
                if (rca != null && rca.isOpen()) {
                    nbt.method_10556("withrca", true);
                }
                ((ControlBoxUiContainer)this.method_17577()).onGuiAction("enabled", nbt);
                this.focus_editor_ = true;
            });
            this.method_37063((class_364)this.start_stop);
            this.cb_copy_all.init((class_437)this, Guis.Coord2d.of(212, 14)).tooltip((class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".tooltips.copyall"));
            this.cb_copy_all.onclick(cb -> {
                Auxiliaries.setClipboard(this.textbox.getValue());
                this.focus_editor_ = true;
            });
            this.cb_copy_all.field_22764 = false;
            this.method_37063((class_364)this.cb_copy_all);
            this.cb_paste_all.init((class_437)this, Guis.Coord2d.of(212, 14)).tooltip((class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".tooltips.pasteall"));
            this.cb_paste_all.onclick(cb -> {
                this.textbox.setValue(Auxiliaries.getClipboard().orElse(""));
                this.push_code(this.textbox.getValue());
                this.focus_editor_ = true;
            });
            this.cb_paste_all.field_22764 = false;
            this.method_37063((class_364)this.cb_paste_all);
            this.cb_error_indicator.init((class_437)this, Guis.Coord2d.of(230, 14));
            this.cb_error_indicator.field_22764 = false;
            this.method_37063((class_364)this.cb_error_indicator);
            this.rca_enabled_indicator.init((class_437)this, Guis.Coord2d.of(194, 40));
            this.rca_enabled_indicator.field_22764 = false;
            this.rca_enabled_indicator.tooltip(rcae -> Auxiliaries.localizable(this.tooltip_prefix + ".tooltips.rcaplayer", this.activating_player_));
            this.method_37063((class_364)this.rca_enabled_indicator);
            int ygap = 12;
            int x0 = this.getGuiLeft() + 205;
            int y0 = this.getGuiTop() + 56;
            int[] liney_map = new int[]{5 * ygap, 4 * ygap, 0, 2 * ygap, 3 * ygap, ygap};
            this.port_stati.clear();
            this.port_stati_i_indicators.clear();
            this.port_stati_o_indicators.clear();
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[0], 30, 10, (class_2561)class_2561.method_43470((String)"down"), this.field_22793));
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[1], 30, 10, (class_2561)class_2561.method_43470((String)"up"), this.field_22793));
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[2], 30, 10, (class_2561)class_2561.method_43470((String)"red"), this.field_22793));
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[3], 30, 10, (class_2561)class_2561.method_43470((String)"yellow"), this.field_22793));
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[4], 30, 10, (class_2561)class_2561.method_43470((String)"green"), this.field_22793));
            this.port_stati.add(new Guis.TextBox(x0, y0 + liney_map[5], 30, 10, (class_2561)class_2561.method_43470((String)"blue"), this.field_22793));
            for (int i = 0; i < this.port_stati.size(); ++i) {
                Guis.TextBox tb2 = this.port_stati.get(i);
                tb2.method_1888(false);
                tb2.method_1858(false);
                tb2.method_1868(-2236963);
                tb2.method_1860(-2236963);
                tb2.method_1852(String.format("%1s=00", Defs.PORT_NAMES.get(i).toUpperCase()));
                this.method_37063((class_364)tb2);
                Guis.Image img = new Guis.Image(this.getBackgroundImage(), 3, 6, Guis.Coord2d.of(78, 215));
                img.init((class_437)this, Guis.Coord2d.of(191, 56 + liney_map[i]));
                this.port_stati_i_indicators.add(img);
                this.method_37063((class_364)img);
                img = new Guis.Image(this.getBackgroundImage(), 3, 6, Guis.Coord2d.of(84, 215));
                img.init((class_437)this, Guis.Coord2d.of(189, 56 + liney_map[i]));
                this.port_stati_o_indicators.add(img);
                this.method_37063((class_364)img);
            }
            ArrayList<TooltipDisplay.TipRange> tooltips = new ArrayList<TooltipDisplay.TipRange>();
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 200, this.getGuiTop() + 36, 36, 16, () -> {
                class_5250 c = class_2561.method_43470((String)"");
                this.symbols_.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(arg_0 -> this.lambda$init$5((class_2561)c, arg_0));
                return c;
            }));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 196, this.getGuiTop() + 14, 16, 16, () -> this.errors_.isEmpty() ? class_2561.method_43473() : Auxiliaries.localizable(this.tooltip_prefix + ".error." + (String)this.errors_.get(0).method_15441())));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 12, 5, 8, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.1")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 22, 5, 3, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.2")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 27, 5, 5, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.3")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 34, 5, 5, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.4")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 41, 5, 6, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.5")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 49, 5, 4, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.6")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 55, 5, 5, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.7")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 62, 5, 3, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.8")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 67, 5, 7, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.9")));
            tooltips.add(new TooltipDisplay.TipRange(this.getGuiLeft() + 18, this.getGuiTop() + 76, 5, 3, (class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".help.10")));
            this.tooltip_.init(tooltips).delay(50);
            this.method_48265(this.textbox);
            this.method_25395(this.textbox);
            this.textbox.field_22763 = false;
            ((ControlBoxUiContainer)this.method_17577()).onGuiAction("serverdata");
        }

        protected void method_37432() {
            class_2487 nbt = ((ControlBoxUiContainer)this.method_17577()).fetchReceivedServerData();
            if (!nbt.method_33133()) {
                int i;
                int mask;
                if (nbt.method_10545("ports")) {
                    mask = nbt.method_10550("inputs") | nbt.method_10550("outputs");
                    int io = nbt.method_10550("ports");
                    for (int i2 = 0; i2 < Defs.PORT_NAMES.size(); ++i2) {
                        if ((mask & 15 << 4 * i2) == 0) continue;
                        this.port_stati.get(i2).method_1852(String.format("%1s=%02d", Defs.PORT_NAMES.get(i2).toUpperCase(), io >> 4 * i2 & 0xF));
                    }
                }
                if (nbt.method_10545("code")) {
                    this.textbox.setValue(nbt.method_10558("code"));
                    this.focus_editor_ = true;
                }
                if (nbt.method_10545("enabled")) {
                    this.start_stop.checked(nbt.method_10577("enabled"));
                    this.focus_editor_ = true;
                }
                if (nbt.method_10545("debug")) {
                    this.debug_enabled_ = nbt.method_10577("debug");
                }
                if (nbt.method_10545("inputs")) {
                    mask = nbt.method_10550("inputs");
                    for (i = 0; i < Defs.PORT_NAMES.size(); ++i) {
                        this.port_stati_i_indicators.get((int)i).field_22764 = (mask & 0xF) != 0;
                        mask >>= 4;
                    }
                }
                if (nbt.method_10545("outputs")) {
                    mask = nbt.method_10550("outputs");
                    for (i = 0; i < Defs.PORT_NAMES.size(); ++i) {
                        this.port_stati_o_indicators.get((int)i).field_22764 = (mask & 0xF) != 0;
                        mask >>= 4;
                    }
                }
                if (nbt.method_10573("symbols", 10)) {
                    class_2487 sym_nbt = nbt.method_10562("symbols");
                    this.symbols_.clear();
                    sym_nbt.method_10541().forEach(k -> this.symbols_.put((String)k, sym_nbt.method_10550(k)));
                }
                if (nbt.method_10573("errors", 10)) {
                    class_2487 err_nbt = nbt.method_10562("errors");
                    this.errors_.clear();
                    err_nbt.method_10541().forEach(k -> {
                        try {
                            this.errors_.add((class_3545<Integer, String>)new class_3545((Object)Integer.parseInt(k), (Object)err_nbt.method_10558(k)));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    if (this.errors_.isEmpty()) {
                        this.cb_error_indicator.field_22764 = false;
                        this.cb_error_indicator.method_46421(0);
                        this.cb_error_indicator.method_46419(0);
                        this.cb_error_indicator.tooltip((class_2561)class_2561.method_43473());
                    } else {
                        Guis.Coord2d exy = this.textbox.getCoordinatesAtIndex((Integer)this.errors_.get(0).method_15442());
                        this.cb_error_indicator.tooltip((class_2561)Auxiliaries.localizable(this.tooltip_prefix + ".error." + (String)this.errors_.get(0).method_15441()));
                        this.cb_error_indicator.field_22764 = true;
                        this.cb_error_indicator.method_46421(exy.x);
                        this.cb_error_indicator.method_46419(exy.y + this.textbox.getLineHeight());
                    }
                }
                if (nbt.method_10573("player", 8)) {
                    String player_name = nbt.method_10558("player");
                    if (player_name.isEmpty()) {
                        this.activating_player_ = class_2561.method_43473();
                        this.rca_enabled_indicator.field_22764 = false;
                        this.rca_enabled_indicator.field_22763 = false;
                    } else {
                        this.activating_player_ = class_2561.method_43470((String)player_name);
                        this.rca_enabled_indicator.field_22764 = true;
                        this.rca_enabled_indicator.field_22763 = true;
                    }
                }
            } else if (--this.update_counter_ <= 0) {
                this.update_counter_ = 2;
                if (!this.code_requested_) {
                    this.code_requested_ = true;
                    ((ControlBoxUiContainer)this.method_17577()).onGuiAction("serverdata");
                } else {
                    ((ControlBoxUiContainer)this.method_17577()).onGuiAction("servervalues");
                }
            }
            this.start_stop.field_22763 = this.errors_.isEmpty();
            if (!this.start_stop.field_22763) {
                this.start_stop.checked(false);
            } else {
                this.cb_error_indicator.field_22764 = false;
            }
            this.textbox.field_22763 = !this.start_stop.checked();
            this.textbox.setFontColor(this.textbox.field_22763 ? 0xEEEEEE : 0x999999);
            this.cb_paste_all.field_22764 = this.textbox.field_22763 && this.textbox.getValue().trim().isEmpty();
            boolean bl = this.cb_copy_all.field_22764 = !this.cb_paste_all.field_22764;
            if (this.focus_editor_) {
                this.focus_editor_ = false;
                if (!this.method_25397() && !this.textbox.method_25370()) {
                    this.method_25396().forEach(child -> {
                        if (child != this.textbox && child instanceof class_339) {
                            class_339 wg = (class_339)child;
                            wg.method_25365(false);
                        }
                    });
                    this.method_25395(this.textbox);
                }
            }
        }

        @Override
        public void method_25394(class_332 gg, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(gg, mouseX, mouseY, partialTicks);
        }

        @Override
        protected void method_2388(class_332 gg, int x, int y) {
            gg.method_27535(this.field_22793, this.field_22785, this.field_25267 + 1, this.field_25268 + 1, 0x303030);
            gg.method_27535(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x707070);
        }

        protected void method_2383(class_1735 hoveredSlot, int hoveredIndex, int no, class_1713 clickType) {
        }

        private void push_code(String text) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("code", text);
            ((ControlBoxUiContainer)this.method_17577()).onGuiAction("codeupdate", nbt);
        }

        private /* synthetic */ void lambda$init$5(class_2561 c, Map.Entry kv) {
            String k = (String)kv.getKey();
            if (!this.debug_enabled_ && (k.startsWith(".") || Defs.PORT_NAMES.contains(k) || k.endsWith(".re") || k.endsWith(".fe"))) {
                return;
            }
            String lf = c.method_10855().isEmpty() ? "" : "\n";
            c.method_10855().add(class_2561.method_43470((String)String.format("%s%s = %d", lf, k.toUpperCase(), kv.getValue())));
        }
    }

    public static class ControlBoxUiContainer
    extends class_1703
    implements Networking.INetworkSynchronisableContainer {
        protected static final int NUM_OF_SLOTS = 1;
        protected final class_1657 player_;
        protected final class_1263 inventory_;
        protected final class_3914 wpc_;
        private final class_3913 fields_;
        private volatile class_2487 received_server_data_ = new class_2487();

        public int field(int index) {
            return this.fields_.method_17390(index);
        }

        public class_1657 player() {
            return this.player_;
        }

        public class_1263 inventory() {
            return this.inventory_;
        }

        public class_1937 world() {
            return this.player_.method_37908();
        }

        @Nullable
        public ControlBoxBlockEntity te() {
            return this.wpc_.method_17395((w, p) -> {
                ControlBoxBlockEntity cbte;
                class_2586 te = w.method_8321(p);
                return te instanceof ControlBoxBlockEntity ? (cbte = (ControlBoxBlockEntity)te) : null;
            }).orElse(null);
        }

        public ControlBoxUiContainer(int cid, class_1661 player_inventory) {
            this(cid, player_inventory, (class_1263)new class_1277(1), class_3914.field_17304, (class_3913)new class_3919(1));
        }

        private ControlBoxUiContainer(int cid, class_1661 player_inventory, class_1263 block_inventory, class_3914 wpc, class_3913 fields) {
            super(Registries.getMenuTypeOfBlock("control_box"), cid);
            this.player_ = player_inventory.field_7546;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.wpc_.method_17393((w, p) -> this.inventory_.method_5435(this.player_));
            this.fields_ = fields;
            this.method_17360(this.fields_);
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)player_inventory, x, 28 + x * 18, 183));
            }
        }

        public boolean method_7597(class_1657 player) {
            return this.inventory_.method_5443(player);
        }

        public void method_7595(class_1657 player) {
            super.method_7595(player);
            this.inventory_.method_5432(player);
        }

        public void method_34252() {
            super.method_34252();
            if (this.world().field_9236 || this.te() == null) {
                return;
            }
            Networking.PacketContainerSyncServerToClient.sendToListeners(this.world(), this, this.composeServerData(this.te(), true));
        }

        public class_1799 method_7601(class_1657 player, int slot) {
            return class_1799.field_8037;
        }

        @Environment(value=EnvType.CLIENT)
        public void onGuiAction(String message) {
            this.onGuiAction(message, new class_2487());
        }

        @Environment(value=EnvType.CLIENT)
        public void onGuiAction(String message, class_2487 nbt) {
            nbt.method_10582("action", message);
            NetworkingClient.PacketContainerSyncClientToServer.sendToServer(this.field_7763, nbt);
        }

        public class_2487 composeServerData(ControlBoxBlockEntity te, boolean full) {
            ControlBoxLogic.Logic logic = this.te().logic_;
            class_2487 nbt = new class_2487();
            nbt.method_10582("action", "serverdata");
            nbt.method_10556("enabled", te.getEnabled());
            nbt.method_10569("inputs", logic.input_mask);
            nbt.method_10569("outputs", logic.output_mask);
            nbt.method_10569("ports", logic.input_data & logic.input_mask | logic.output_data & logic.output_mask);
            if (!logic.symbols().isEmpty()) {
                class_2487 sym_nbt = new class_2487();
                logic.symbols().forEach((arg_0, arg_1) -> ((class_2487)sym_nbt).method_10569(arg_0, arg_1));
                nbt.method_10566("symbols", (class_2520)sym_nbt);
            }
            if (!logic.valid()) {
                class_2487 err_nbt = new class_2487();
                logic.errors().forEach((e, l) -> err_nbt.method_10582(e.toString(), l));
                nbt.method_10566("errors", (class_2520)err_nbt);
            } else {
                nbt.method_10566("errors", (class_2520)new class_2487());
            }
            if (!full) {
                return nbt;
            }
            nbt.method_10556("debug", te.trace_enabled());
            nbt.method_10582("code", te.getCode());
            if (this.te().activating_player_ != null) {
                class_1657 run_player = this.world().method_18470(this.te().activating_player_);
                nbt.method_10582("player", run_player == null ? "" : run_player.method_5820());
            }
            return nbt;
        }

        public class_2487 fetchReceivedServerData() {
            class_2487 received = this.received_server_data_;
            this.received_server_data_ = new class_2487();
            return received;
        }

        @Override
        public void onServerPacketReceived(int windowId, class_2487 nbt) {
            switch (nbt.method_10558("action")) {
                case "serverdata": {
                    this.received_server_data_ = nbt;
                }
            }
        }

        @Override
        public void onClientPacketReceived(int windowId, class_1657 player, class_2487 nbt) {
            ControlBoxBlockEntity te = this.te();
            if (te == null) {
                return;
            }
            int sync = 0;
            switch (nbt.method_10558("action")) {
                case "codeupdate": {
                    te.setCode(nbt.method_10558("code"));
                    break;
                }
                case "serverdata": {
                    sync = 2;
                    break;
                }
                case "servervalues": {
                    sync = 1;
                    break;
                }
                case "enabled": {
                    te.setEnabled(!te.getEnabled());
                    te.setRcaPlayerUUID(te.getEnabled() && nbt.method_10577("withrca") ? player.method_5667() : null);
                    sync = 2;
                    break;
                }
                default: {
                    int slotId;
                    int n = slotId = nbt.method_10545("slot") ? nbt.method_10550("slot") : -1;
                    if (sync <= 0) break;
                    this.inventory_.method_5431();
                    player.method_31548().method_5431();
                    this.method_7623();
                }
            }
            if (sync > 0) {
                Networking.PacketContainerSyncServerToClient.sendToListeners(this.world(), this, this.composeServerData(te, sync > 1));
            }
        }
    }

    public static class ControlBoxBlockEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements class_3908,
    class_1275,
    Networking.IPacketTileNotifyReceiver {
        public static final int TICK_INTERVAL = 4;
        private final class_1263 block_inventory_ = new class_1277(1);
        private final ControlBoxLogic.Logic logic_ = new ControlBoxLogic.Logic();
        private UUID activating_player_ = null;
        private class_2561 custom_name_ = null;
        private boolean trace_ = false;
        private int tick_timer_ = 0;
        private int num_signal_updates_received_ = 0;
        private int tick_interval_ = 0;

        public ControlBoxBlockEntity(class_2338 pos, class_2680 state) {
            super(Registries.getBlockEntityTypeOfBlock(state.method_26204()), pos, state);
        }

        public void readnbt(class_2487 nbt) {
            if (nbt.method_10573("name", 8)) {
                this.custom_name_ = Auxiliaries.unserializeTextComponent(nbt.method_10558("name"));
            }
            class_2487 logic_data = nbt.method_10573("logic", 10) ? nbt.method_10562("logic") : new class_2487();
            this.logic_.code(logic_data.method_10558("code"));
            this.logic_.input_data = logic_data.method_10550("input");
            this.logic_.output_data = logic_data.method_10550("output");
            class_2487 logic_symbols = logic_data.method_10573("symbols", 10) ? logic_data.method_10562("symbols") : new class_2487();
            this.logic_.symbols_.clear();
            logic_symbols.method_10541().forEach(k -> this.logic_.symbols_.put((String)k, logic_symbols.method_10550(k)));
            this.activating_player_ = nbt.method_25928("player") ? nbt.method_25926("player") : null;
        }

        private void writenbt(class_2487 nbt) {
            if (this.custom_name_ != null) {
                nbt.method_10582("name", Auxiliaries.serializeTextComponent(this.custom_name_));
            }
            class_2487 logic_data = new class_2487();
            logic_data.method_10582("code", this.logic_.code());
            logic_data.method_10569("input", this.logic_.input_data);
            logic_data.method_10569("output", this.logic_.output_data);
            class_2487 logic_symbols = new class_2487();
            for (Map.Entry<String, Integer> e : this.logic_.symbols_.entrySet()) {
                logic_symbols.method_10569(e.getKey(), e.getValue().intValue());
            }
            logic_data.method_10566("symbols", (class_2520)logic_symbols);
            nbt.method_10566("logic", (class_2520)logic_data);
            if (this.activating_player_ != null) {
                nbt.method_25927("player", this.activating_player_);
            }
        }

        public void method_11014(class_2487 nbt) {
            super.method_11014(nbt);
            this.readnbt(nbt);
        }

        protected void method_11007(class_2487 nbt) {
            super.method_11007(nbt);
            this.writenbt(nbt);
        }

        public void method_11012() {
            super.method_11012();
        }

        public class_2561 method_5477() {
            if (this.custom_name_ != null) {
                return this.custom_name_;
            }
            return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
        }

        @Nullable
        public class_2561 method_5797() {
            return this.custom_name_;
        }

        public boolean method_16914() {
            return this.custom_name_ != null;
        }

        public void setCustomName(class_2561 name) {
            this.custom_name_ = name;
        }

        public class_2561 method_5476() {
            return super.method_5476();
        }

        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return new ControlBoxUiContainer(id, inventory, this.block_inventory_, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867), (class_3913)new class_3919(1));
        }

        @Override
        public void tick() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = this.tick_interval_ > 0 ? this.tick_interval_ : 4;
            long tick = System.nanoTime();
            class_1937 world = this.method_10997();
            class_2680 device_state = this.method_11010();
            class_2338 device_pos = this.method_11016();
            boolean device_enabled = (Integer)device_state.method_11654((class_2769)ControlBoxBlock.STATE) > 0;
            class_2248 class_22482 = device_state.method_26204();
            if (!(class_22482 instanceof ControlBoxBlock)) {
                return;
            }
            ControlBoxBlock device_block = (ControlBoxBlock)class_22482;
            Set<String> esyms = this.logic_.expressions().symbols;
            int last_output_data = this.logic_.output_data;
            int last_input_data = this.logic_.input_data;
            RcaSync.RcaData rca_data = (this.logic_.rca_input_mask | this.logic_.rca_output_mask) == 0L ? RcaSync.CommonRca.EMPTY : RcaSync.CommonRca.ofPlayer(this.activating_player_, false);
            try {
                class_2350 world_dir;
                this.logic_.input_data = 0;
                for (class_2350 d : class_2350.values()) {
                    String port_name;
                    world_dir = ControlBoxBlock.getForwardStateMappedFacing(device_state, d);
                    if (device_enabled && esyms.contains((port_name = Defs.PORT_NAMES.get(d.ordinal())) + ".co")) {
                        class_2338 target_pos = device_pos.method_10093(world_dir);
                        class_2680 target_state = world.method_8320(target_pos);
                        if (target_state.method_26221()) {
                            int cov = target_state.method_26204().method_9572(target_state, world, target_pos);
                            this.logic_.symbol(port_name + ".co", cov);
                        } else {
                            this.logic_.symbol(port_name + ".co", 0);
                        }
                    }
                    if ((this.logic_.output_mask & 15 << 4 * d.ordinal()) != 0) continue;
                    int p = world.method_49808(device_pos.method_10093(world_dir), world_dir);
                    this.logic_.input_data |= (p & 0xF) << 4 * d.ordinal();
                }
                if (this.logic_.rca_input_mask != 0L && rca_data != RcaSync.CommonRca.EMPTY) {
                    this.logic_.rca_input_data = rca_data.client_inputs() & this.logic_.rca_input_mask;
                }
                if (this.trace_) {
                    this.logic_.symbol(".perf1", (int)class_3532.method_15363((float)(System.nanoTime() - tick), (float)0.0f, (float)2.1474836E9f) / 1000);
                }
                if (!device_enabled) {
                    this.logic_.output_data = 0;
                } else {
                    this.logic_.symbol(".clock", (int)(world.method_8510() & Integer.MAX_VALUE));
                    this.logic_.symbol(".time", (int)(world.method_8532() % 24000L));
                    this.logic_.tick();
                    if (this.logic_.rca_output_mask != 0L && rca_data != RcaSync.CommonRca.EMPTY) {
                        rca_data.server_outputs(this.logic_.rca_output_data);
                    }
                }
                if (this.logic_.output_data != last_output_data) {
                    for (class_2350 d : class_2350.values()) {
                        if ((this.logic_.output_mask & 15 << 4 * d.ordinal()) == 0) continue;
                        world_dir = ControlBoxBlock.getForwardStateMappedFacing(device_state, d);
                        device_block.notifyOutputNeighbourOfStateChange(device_state, world, device_pos, world_dir);
                    }
                }
                if (this.logic_.output_data != last_output_data || this.logic_.input_data != last_input_data) {
                    world.method_8524(device_pos);
                }
            }
            catch (Throwable ex) {
                Auxiliaries.logError("RLC tick exception!" + ex);
                world.method_8650(this.method_11016(), true);
                return;
            }
            if (this.logic_.symbols().containsKey("tickrate")) {
                this.tick_interval_ = class_3532.method_15340((int)this.logic_.symbols().getOrDefault("tickrate", 0), (int)0, (int)200);
                if (this.tick_interval_ == 0) {
                    this.tick_interval_ = 4;
                }
            }
            this.tick_timer_ = this.tick_interval_;
            int dl = this.logic_.symbol(".deadline");
            if (dl > 0 && dl < this.tick_timer_) {
                this.tick_timer_ = dl;
            }
            this.logic_.intr_redges = 0;
            this.logic_.intr_fedges = 0;
            if (this.trace_) {
                this.logic_.symbol(".perf2", (int)class_3532.method_15363((float)(System.nanoTime() - tick), (float)0.0f, (float)2.1474836E9f) / 1000);
            }
        }

        @Override
        public void onServerPacketReceived(class_2487 nbt) {
            this.readnbt(nbt);
        }

        public boolean getEnabled() {
            return (Integer)this.method_11010().method_11654((class_2769)ControlBoxBlock.STATE) != 0;
        }

        public void setEnabled(boolean en) {
            if (en == this.getEnabled()) {
                return;
            }
            this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)ControlBoxBlock.STATE, (Comparable)Integer.valueOf(en ? 1 : 0)), 17);
            if (!en) {
                RcaSync.RcaData rca_data;
                this.logic_.symbols_.clear();
                RcaSync.RcaData rcaData = rca_data = this.logic_.rca_output_mask == 0L ? RcaSync.CommonRca.EMPTY : RcaSync.CommonRca.ofPlayer(this.activating_player_, false);
                if (rca_data != RcaSync.CommonRca.EMPTY) {
                    rca_data.server_outputs(0L);
                }
            }
        }

        public void setRcaPlayerUUID(@Nullable UUID puid) {
            this.activating_player_ = puid == null ? null : UUID.fromString(puid.toString());
        }

        public String getCode() {
            return this.logic_.code();
        }

        public void setCode(String text) {
            this.logic_.code(text);
        }

        public void signal_update(class_2350 from_world_side, class_2350 from_mapped_side) {
            int signal_data;
            if (this.tick_interval_ > 0) {
                return;
            }
            int shift = 4 * from_mapped_side.ordinal();
            int mask = 15 << shift;
            if ((this.logic_.input_mask & mask) == 0) {
                return;
            }
            int signal_intr = mask & this.method_10997().method_49808(this.method_11016().method_10093(from_world_side), from_world_side) << shift;
            if (signal_intr == (signal_data = mask & this.logic_.input_data)) {
                return;
            }
            ++this.num_signal_updates_received_;
            if (signal_intr != 0 && signal_data == 0) {
                this.logic_.intr_redges |= mask;
                this.tick_timer_ = 0;
            } else if (signal_intr == 0) {
                this.logic_.intr_fedges |= mask;
                this.tick_timer_ = 0;
            }
        }

        public void toggle_trace(@Nullable class_1657 player) {
            boolean bl = this.trace_ = !this.trace_;
            if (player != null) {
                Auxiliaries.playerChatMessage(player, "Trace: " + this.trace_);
            }
        }

        public boolean trace_enabled() {
            return this.trace_;
        }
    }

    public static class ControlBoxBlock
    extends CircuitComponents.DirectedComponentBlock
    implements StandardEntityBlocks.IStandardEntityBlock<ControlBoxBlockEntity> {
        public ControlBoxBlock(long config, class_4970.class_2251 builder, class_238[] aabb) {
            super(config, builder, aabb);
        }

        @Override
        public List<class_1799> dropList(class_2680 state, class_1937 world, @Nullable class_2586 te, boolean explosion) {
            class_1799 stack = new class_1799((class_1935)this.method_8389());
            if (te instanceof ControlBoxBlockEntity) {
                ControlBoxBlockEntity cb = (ControlBoxBlockEntity)te;
                class_2487 tedata = new class_2487();
                cb.method_11007(tedata);
                if (tedata.method_10545("logic") && !tedata.method_10562("logic").method_10558("code").trim().isEmpty()) {
                    stack.method_7948().method_10566("tedata", (class_2520)tedata);
                }
            }
            return Collections.singletonList(stack);
        }

        @Override
        public boolean isBlockEntityTicking(class_1937 world, class_2680 state) {
            return true;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 flag) {
            if (Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true)) {
                return;
            }
            if (stack.method_7969() == null || !stack.method_7969().method_10545("tedata") || !stack.method_7969().method_10562("tedata").method_10545("logic")) {
                return;
            }
            Arrays.stream(stack.method_7969().method_10562("tedata").method_10562("logic").method_10558("code").split("\\n")).map(s -> s.replaceAll("#.*$", "").trim()).filter(s -> !s.isEmpty()).map(s -> class_2561.method_43470((String)s).method_27692(class_124.field_1077)).forEach(tooltip::add);
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2487 te_nbt;
            if (world.field_9236 || !stack.method_7985()) {
                return;
            }
            class_2586 te = world.method_8321(pos);
            if (!(te instanceof ControlBoxBlockEntity)) {
                return;
            }
            ControlBoxBlockEntity cbe = (ControlBoxBlockEntity)te;
            class_2487 nbt = stack.method_7969();
            if (nbt != null && nbt.method_10545("tedata") && !(te_nbt = nbt.method_10562("tedata")).method_33133()) {
                cbe.readnbt(te_nbt);
            }
            cbe.setCustomName(Auxiliaries.getItemLabel(stack));
            te.method_5431();
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            class_2586 class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof ControlBoxBlockEntity)) {
                return 0;
            }
            ControlBoxBlockEntity cb = (ControlBoxBlockEntity)class_25862;
            class_2350 internal_side = ControlBoxBlock.getReverseStateMappedFacing(state, redstone_side.method_10153());
            return cb.logic_.output_data >> 4 * internal_side.ordinal() & 0xF;
        }

        @Override
        public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return this.method_9524(state, world, pos, redstone_side);
        }

        public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rayTraceResult) {
            if (player.method_5998(hand).method_31574(class_1802.field_8688)) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                class_2586 class_25862 = world.method_8321(pos);
                if (class_25862 instanceof ControlBoxBlockEntity) {
                    ControlBoxBlockEntity te = (ControlBoxBlockEntity)class_25862;
                    te.toggle_trace(player);
                }
                return class_1269.field_21466;
            }
            return this.useOpenGui(state, world, pos, player);
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            if (world.field_9236) {
                return state;
            }
            class_2586 class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof ControlBoxBlockEntity)) {
                return state;
            }
            ControlBoxBlockEntity cb = (ControlBoxBlockEntity)class_25862;
            if (fromPos == null) {
                cb.tick_timer_ = 0;
                return state;
            }
            class_2338 dp = fromPos.method_10059((class_2382)pos);
            class_2350 world_side = class_2350.method_50026((int)dp.method_10263(), (int)dp.method_10264(), (int)dp.method_10260());
            if (world_side != null) {
                cb.signal_update(world_side, ControlBoxBlock.getReverseStateMappedFacing(state, world_side));
            }
            return state;
        }
    }

    public static class Defs {
        public static final List<String> PORT_NAMES = Arrays.asList("d", "u", "r", "y", "g", "b");
    }
}

