/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardBlocks;

public class CircuitComponents {

    public static class BridgeRelayBlock
    extends RelayBlock {
        private int power_update_recursion_level_ = 0;

        public BridgeRelayBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            super(config, builder, aabb);
        }

        protected int getInputPower(class_1937 world, class_2338 relay_pos, class_2350 redstone_side) {
            class_2338 pos = relay_pos.method_10093(redstone_side);
            class_2680 state = world.method_8320(pos);
            int p = 0;
            if (this.power_update_recursion_level_ < 32) {
                ++this.power_update_recursion_level_;
                if (state.method_27852(class_2246.field_10091)) {
                    p = Math.max(0, state.method_26203((class_1922)world, pos, redstone_side) - 2);
                } else if (state.method_27852((class_2248)ModContent.references.TRACK_BLOCK)) {
                    p = Math.max(0, RedstoneTrack.RedstoneTrackBlock.tile((class_1922)world, pos).map(te -> te.getRedstonePower(redstone_side, true)).orElse(0) - 2);
                } else if (state.method_27852((class_2248)ModContent.references.BRIDGE_RELAY_BLOCK)) {
                    p = state.method_11654((class_2769)FACING) != world.method_8320(relay_pos).method_11654((class_2769)FACING) ? 0 : (((Integer)state.method_11654((class_2769)ROTATION) & 1) != ((Integer)world.method_8320(relay_pos).method_11654((class_2769)ROTATION) & 1) ? 0 : this.getInputPower(world, pos, redstone_side));
                } else {
                    p = state.method_26195((class_1922)world, pos, redstone_side);
                    if (p < 15 && !state.method_26219() && RsSignals.canEmitWeakPower(state, world, pos, redstone_side)) {
                        for (class_2350 d : class_2350.values()) {
                            if (d != redstone_side.method_10153() && (p = Math.max(p, world.method_8320(pos.method_10093(d)).method_26203((class_1922)world, pos.method_10093(d), d))) >= 15) break;
                        }
                    }
                }
                if (--this.power_update_recursion_level_ < 0) {
                    this.power_update_recursion_level_ = 0;
                }
            }
            return p;
        }

        protected boolean isWireConnected(class_1937 world, class_2338 relay_pos, class_2350 side) {
            class_2338 pos = relay_pos.method_10093(side);
            class_2680 state = world.method_8320(pos);
            return state.method_27852(class_2246.field_10091) || state.method_27852((class_2248)ModContent.references.TRACK_BLOCK);
        }

        protected boolean isSidePowered(class_1937 world, class_2338 pos, class_2350 side) {
            return world.method_49808(pos.method_10093(side), side) > 0;
        }

        @Override
        protected boolean isPowered(class_2680 state, class_1937 world, class_2338 pos) {
            return this.isSidePowered(world, pos, (class_2350)state.method_11654((class_2769)FACING)) || this.isSidePowered(world, pos, BridgeRelayBlock.getOutputFacing(state).method_10153());
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            if (redstone_side == BridgeRelayBlock.getOutputFacing(state).method_10153()) {
                return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
            }
            if (!(world instanceof class_3218)) {
                return 0;
            }
            class_3218 sworld = (class_3218)world;
            class_2350 left = BridgeRelayBlock.getLeftFacing(state);
            class_2350 right = BridgeRelayBlock.getRightFacing(state);
            if (redstone_side != left && redstone_side != right) {
                return 0;
            }
            if (this.isWireConnected((class_1937)sworld, pos, redstone_side)) {
                return this.getInputPower((class_1937)sworld, pos, redstone_side);
            }
            if (world.method_8320(pos.method_10093(redstone_side)).method_26219()) {
                return this.getInputPower((class_1937)sworld, pos, left);
            }
            return 0;
        }

        @Override
        public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return this.method_9524(state, world, pos, redstone_side);
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
                if (!world.method_8397().method_8674(pos, (Object)this)) {
                    if (powered) {
                        state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
                        world.method_8652(pos, state, 18);
                        world.method_8492(pos.method_10093(BridgeRelayBlock.getOutputFacing(state)), (class_2248)this, pos);
                    } else {
                        world.method_39279(pos, (class_2248)this, 2);
                    }
                }
                return state;
            }
            if (fromPos != null) {
                class_2338 v = pos.method_10059((class_2382)fromPos);
                class_2350 redstone_side = class_2350.method_10147((float)v.method_10263(), (float)v.method_10264(), (float)v.method_10260());
                class_2350 left = BridgeRelayBlock.getLeftFacing(state);
                class_2350 right = BridgeRelayBlock.getRightFacing(state);
                if (redstone_side != left && redstone_side != right) {
                    return state;
                }
                this.power_update_recursion_level_ = 0;
                class_2338 npos = pos.method_10093(redstone_side);
                world.method_8320(npos).method_26181(world, npos, (class_2248)this, pos, false);
                int pr = this.getInputPower(world, pos, right);
                int pl = this.getInputPower(world, pos, left);
                boolean track_powered = pr > 0 || pl > 0;
                if (track_powered != ((Integer)state.method_11654((class_2769)STATE) == 1)) {
                    state = (class_2680)state.method_11657((class_2769)STATE, (Comparable)Integer.valueOf(track_powered ? 1 : 0));
                    world.method_8652(pos, state, 18);
                }
            }
            return state;
        }
    }

    public static class PulseRelayBlock
    extends RelayBlock {
        public PulseRelayBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return (Integer)state.method_11654((class_2769)STATE) == 0 || redstone_side != PulseRelayBlock.getOutputFacing(state).method_10153() ? 0 : 15;
        }

        @Override
        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
            if ((Integer)state.method_11654((class_2769)STATE) == 0) {
                return;
            }
            state = (class_2680)state.method_11657((class_2769)STATE, (Comparable)Integer.valueOf(0));
            world.method_8652(pos, state, 18);
            this.notifyOutputNeighbourOfStateChange(state, (class_1937)world, pos);
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
                state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered));
                if (powered) {
                    boolean trig = (Integer)state.method_11654((class_2769)STATE) == 0;
                    state = (class_2680)state.method_11657((class_2769)STATE, (Comparable)Integer.valueOf(1));
                    world.method_8652(pos, state, 18);
                    if (trig) {
                        this.notifyOutputNeighbourOfStateChange(state, world, pos);
                    }
                } else {
                    world.method_8652(pos, state, 18);
                }
            }
            if (!world.method_8397().method_8674(pos, (Object)this)) {
                world.method_39279(pos, (class_2248)this, 2);
            }
            return state;
        }
    }

    public static class BistableRelayBlock
    extends RelayBlock {
        public BistableRelayBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return (Integer)state.method_11654((class_2769)STATE) == 0 || redstone_side != BistableRelayBlock.getOutputFacing(state).method_10153() ? 0 : 15;
        }

        @Override
        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            boolean pwstate;
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (pwstate = ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue())) {
                return state;
            }
            state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered && !pwstate) {
                state = (class_2680)state.method_11657((class_2769)STATE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)STATE) == 0 ? 1 : 0));
                world.method_8652(pos, state, 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else if (!powered && pwstate) {
                world.method_8652(pos, state, 18);
            }
            return state;
        }
    }

    public static class InvertedRelayBlock
    extends RelayBlock {
        public InvertedRelayBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return (Boolean)state.method_11654((class_2769)POWERED) != false || redstone_side != InvertedRelayBlock.getOutputFacing(state).method_10153() ? 0 : 15;
        }

        @Override
        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
            boolean powered = this.isPowered(state, (class_1937)world, pos);
            if (powered == (Boolean)state.method_11654((class_2769)POWERED)) {
                return;
            }
            if (powered) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 18);
                this.notifyOutputNeighbourOfStateChange(state, (class_1937)world, pos);
            }
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.method_11654((class_2769)POWERED)) {
                return state;
            }
            if (world.method_8397().method_8674(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.method_39279(pos, (class_2248)this, 2);
            } else {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            }
            return state;
        }
    }

    public static class RelayBlock
    extends DirectedComponentBlock {
        protected boolean isPowered(class_2680 state, class_1937 world, class_2338 pos) {
            class_2350 output_side = RelayBlock.getOutputFacing(state);
            class_2350 mount_side = (class_2350)state.method_11654((class_2769)FACING);
            for (class_2350 side : class_2350.values()) {
                if (side == output_side || side == mount_side.method_10153() || world.method_49808(pos.method_10093(side), side) <= 0) continue;
                return true;
            }
            return false;
        }

        public RelayBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return (Boolean)state.method_11654((class_2769)POWERED) == false || redstone_side != RelayBlock.getOutputFacing(state).method_10153() ? 0 : 15;
        }

        @Override
        public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return this.method_9524(state, world, pos, redstone_side);
        }

        @Override
        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
            boolean powered = this.isPowered(state, (class_1937)world, pos);
            if (powered == (Boolean)state.method_11654((class_2769)POWERED)) {
                return;
            }
            if (!powered) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 18);
                this.notifyOutputNeighbourOfStateChange(state, (class_1937)world, pos);
            }
        }

        @Override
        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.method_11654((class_2769)POWERED)) {
                return state;
            }
            if (world.method_8397().method_8674(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else {
                world.method_39279(pos, (class_2248)this, 2);
            }
            return state;
        }
    }

    public static class DirectedComponentBlockItem
    extends class_1747 {
        public DirectedComponentBlockItem(class_2248 block, class_1792.class_1793 builder) {
            super(block, builder);
        }

        public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int itemSlot, boolean isSelected) {
            if (!(isSelected && world.field_9236 && entity instanceof class_1657)) {
                return;
            }
            class_1657 player = (class_1657)entity;
            class_3965 hr = DirectedComponentBlockItem.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
            class_1750 pc = new class_1750(new class_1838(player, class_1268.field_5808, hr));
            if (!pc.method_7716()) {
                return;
            }
            class_2680 state = this.method_7711().method_9605(pc);
            if (state == null) {
                return;
            }
            Overlay.show(state, pc.method_8037());
        }
    }

    public static class DirectedComponentBlock
    extends StandardBlocks.WaterLoggable {
        public static final class_2753 FACING = class_2741.field_12525;
        public static final class_2758 ROTATION = class_2758.method_11867((String)"rotation", (int)0, (int)3);
        public static final class_2746 POWERED = class_2741.field_12484;
        public static final class_2758 STATE = class_2758.method_11867((String)"state", (int)0, (int)1);
        private static final List<class_2350> facing_mapping_ = DirectedComponentBlock.make_facing_mappings();
        private static final class_2350[][][] facing_fwd_state_mapping_ = new class_2350[6][4][6];
        private static final class_2350[][][] facing_rev_state_mapping_ = new class_2350[6][4][6];
        protected final Map<class_2680, class_265> shapes_ = new HashMap<class_2680, class_265>();

        private static List<class_2350> make_facing_mappings() {
            ArrayList<class_2350> maps = new ArrayList<class_2350>();
            Arrays.stream(class_2350.values()).forEach(face -> {
                switch (face) {
                    case field_11033: 
                    case field_11036: {
                        maps.add(class_2350.field_11043);
                        maps.add(class_2350.field_11034);
                        maps.add(class_2350.field_11035);
                        maps.add(class_2350.field_11039);
                        break;
                    }
                    case field_11043: {
                        maps.add(class_2350.field_11036);
                        maps.add(class_2350.field_11034);
                        maps.add(class_2350.field_11033);
                        maps.add(class_2350.field_11039);
                        break;
                    }
                    case field_11034: {
                        maps.add(class_2350.field_11036);
                        maps.add(class_2350.field_11035);
                        maps.add(class_2350.field_11033);
                        maps.add(class_2350.field_11043);
                        break;
                    }
                    case field_11035: {
                        maps.add(class_2350.field_11036);
                        maps.add(class_2350.field_11039);
                        maps.add(class_2350.field_11033);
                        maps.add(class_2350.field_11034);
                        break;
                    }
                    case field_11039: {
                        maps.add(class_2350.field_11036);
                        maps.add(class_2350.field_11043);
                        maps.add(class_2350.field_11033);
                        maps.add(class_2350.field_11035);
                    }
                }
            });
            return maps;
        }

        private static void fill_state_facing_lookups(ImmutableList<class_2680> states) {
            if (facing_fwd_state_mapping_[0][0][0] != null && facing_rev_state_mapping_[0][0][0] != null) {
                return;
            }
            for (class_2680 state : states) {
                for (class_2350 world_side : class_2350.values()) {
                    class_2350 sm;
                    DirectedComponentBlock.facing_fwd_state_mapping_[((class_2350)state.method_11654((class_2769)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.method_11654((class_2769)DirectedComponentBlock.ROTATION)).intValue()][world_side.ordinal()] = sm = (switch (world_side) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.field_11033 -> DirectedComponentBlock.getDownFacing(state);
                        case class_2350.field_11036 -> DirectedComponentBlock.getUpFacing(state);
                        case class_2350.field_11043 -> DirectedComponentBlock.getFrontFacing(state);
                        case class_2350.field_11035 -> DirectedComponentBlock.getBackFacing(state);
                        case class_2350.field_11039 -> DirectedComponentBlock.getLeftFacing(state);
                        case class_2350.field_11034 -> DirectedComponentBlock.getRightFacing(state);
                    });
                    DirectedComponentBlock.facing_rev_state_mapping_[((class_2350)state.method_11654((class_2769)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.method_11654((class_2769)DirectedComponentBlock.ROTATION)).intValue()][sm.ordinal()] = world_side;
                }
            }
        }

        protected static class_265 mapped_shape(class_2680 state, class_238[] aabb) {
            switch ((class_2350)state.method_11654((class_2769)FACING)) {
                case field_11033: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 2));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 3));
                        }
                    }
                }
                case field_11036: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 0), class_2350.class_2351.field_11052));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 1), class_2350.class_2351.field_11052));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 2), class_2350.class_2351.field_11052));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 3), class_2350.class_2351.field_11052));
                        }
                    }
                }
                case field_11043: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11035), class_2350.field_11033));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11039), class_2350.field_11033));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11043), class_2350.field_11033));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11034), class_2350.field_11033));
                        }
                    }
                }
                case field_11034: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11036), class_2350.field_11039), 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11039), class_2350.field_11033), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11035), class_2350.field_11036), 3));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11039), class_2350.field_11036), 3));
                        }
                    }
                }
                case field_11035: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11043), class_2350.field_11036));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11034), class_2350.field_11036));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11035), class_2350.field_11036));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11039), class_2350.field_11036));
                        }
                    }
                }
                case field_11039: {
                    switch ((Integer)state.method_11654((class_2769)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11036), class_2350.field_11034));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11034), class_2350.field_11036), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11033), class_2350.field_11039));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, class_2350.field_11039), class_2350.field_11036), 1));
                        }
                    }
                }
            }
            return class_259.method_1077();
        }

        public DirectedComponentBlock(long config, class_4970.class_2251 builder, class_238[] aabbs) {
            super(config, builder.method_50012(class_3619.field_15971));
            this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)super.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)STATE, (Comparable)Integer.valueOf(0)));
            this.field_10647.method_11662().forEach(state -> this.shapes_.put((class_2680)state, DirectedComponentBlock.mapped_shape(state, aabbs)));
            DirectedComponentBlock.fill_state_facing_lookups((ImmutableList<class_2680>)this.field_10647.method_11662());
        }

        public DirectedComponentBlock(long config, class_4970.class_2251 builder, class_238 aabb) {
            this(config, builder, new class_238[]{aabb});
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
            builder.method_11667(new class_2769[]{FACING, ROTATION, POWERED, STATE});
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<class_1799> dropList(class_2680 state, class_1937 world, @Nullable class_2586 te, boolean explosion) {
            return Collections.singletonList(new class_1799((class_1935)this.method_8389()));
        }

        @Override
        public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
            return true;
        }

        @Override
        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return this.shapes_.getOrDefault(state, class_259.method_1077());
        }

        @Override
        public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return this.method_9530(state, world, pos, context);
        }

        public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
            return this.shapes_.getOrDefault(state, class_259.method_1077());
        }

        @Override
        public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
            return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
        }

        public boolean canConnectRedstone(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_2350 side) {
            return side == null || side != state.method_11654((class_2769)FACING);
        }

        public boolean method_9506(class_2680 state) {
            return true;
        }

        public boolean method_9498(class_2680 state) {
            return false;
        }

        public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
            return 0;
        }

        public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return 0;
        }

        public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 redstone_side) {
            return 0;
        }

        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rnd) {
        }

        @Override
        @Nullable
        public class_2680 method_9605(class_1750 context) {
            class_2680 state = super.method_9605(context);
            if (state == null) {
                return null;
            }
            class_2350 face = context.method_8038().method_10153();
            class_243 hit_r = context.method_17698().method_1020(class_243.method_24953((class_2382)context.method_8037()));
            class_243 hit = switch (face) {
                case class_2350.field_11039, class_2350.field_11034 -> hit_r.method_18805(0.0, 1.0, 1.0);
                case class_2350.field_11043, class_2350.field_11035 -> hit_r.method_18805(1.0, 1.0, 0.0);
                default -> hit_r.method_18805(1.0, 0.0, 1.0);
            };
            class_2350 dir = class_2350.method_10142((double)hit.method_10216(), (double)hit.method_10214(), (double)hit.method_10215());
            int rotation = 0;
            block4 : switch (face) {
                case field_11033: 
                case field_11036: {
                    switch (dir) {
                        case field_11034: {
                            rotation = 1;
                            break block4;
                        }
                        case field_11035: {
                            rotation = 2;
                            break block4;
                        }
                        case field_11039: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case field_11043: {
                    switch (dir) {
                        case field_11034: {
                            rotation = 1;
                            break block4;
                        }
                        case field_11033: {
                            rotation = 2;
                            break block4;
                        }
                        case field_11039: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case field_11034: {
                    switch (dir) {
                        case field_11035: {
                            rotation = 1;
                            break block4;
                        }
                        case field_11033: {
                            rotation = 2;
                            break block4;
                        }
                        case field_11043: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case field_11035: {
                    switch (dir) {
                        case field_11039: {
                            rotation = 1;
                            break block4;
                        }
                        case field_11033: {
                            rotation = 2;
                            break block4;
                        }
                        case field_11034: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case field_11039: {
                    switch (dir) {
                        case field_11043: {
                            rotation = 1;
                            break block4;
                        }
                        case field_11033: {
                            rotation = 2;
                            break block4;
                        }
                        case field_11035: {
                            rotation = 3;
                            break block4;
                        }
                    }
                }
            }
            state = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)face)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)STATE, (Comparable)Integer.valueOf(0));
            if (!this.method_9558(state, (class_4538)context.method_8045(), context.method_8037())) {
                return null;
            }
            return state;
        }

        @Override
        public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 pos, class_2338 facingPos) {
            class_2680 class_26802;
            if ((state = super.method_9559(state, facing, facingState, world, pos, facingPos)) == null) {
                return state;
            }
            if (!this.method_9558(state, (class_4538)world, pos)) {
                return class_2246.field_10124.method_9564();
            }
            if (world instanceof class_3218) {
                class_3218 sworld = (class_3218)world;
                class_26802 = this.update(state, (class_1937)sworld, pos, facingPos);
            } else {
                class_26802 = state;
            }
            return class_26802;
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2350 face = (class_2350)state.method_11654((class_2769)FACING);
            class_2338 adj_pos = pos.method_10093(face);
            return world.method_8320(adj_pos).method_26206((class_1922)world, adj_pos, face.method_10153());
        }

        public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
            this.update(state, world, pos, null);
        }

        @Override
        public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
            if (isMoving || state.method_27852(newState.method_26204())) {
                return;
            }
            super.method_9536(state, world, pos, newState, isMoving);
            if (!world.method_8608()) {
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                world.method_8452(pos, (class_2248)this);
            }
        }

        @Override
        public boolean shouldCheckWeakPower(class_2680 state, class_4538 level, class_2338 pos, class_2350 side) {
            return false;
        }

        public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
            this.update(state, world, pos, fromPos);
        }

        @Environment(value=EnvType.CLIENT)
        private void spawnPoweredParticle(class_1937 world, class_5819 rand, class_2338 pos, class_243 color, class_2350 side, float chance) {
            if (rand.method_43057() < chance) {
                double c2 = chance * rand.method_43057();
                double p0 = 0.5 + (double)side.method_10148() * 0.4 + c2 * 0.1;
                double p1 = 0.5 + (double)side.method_10164() * 0.4 + c2 * 0.1;
                double p2 = 0.5 + (double)side.method_10165() * 0.4 + c2 * 0.1;
                world.method_8406((class_2394)new class_2390(new Vector3f((float)color.field_1352, (float)color.field_1351, (float)color.field_1350), 1.0f), (double)pos.method_10263() + p0, (double)pos.method_10264() + p1, (double)pos.method_10260() + p2, 0.0, 0.0, 0.0);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
            if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() || (double)rand.method_43057() > 0.4) {
                return;
            }
            class_243 color = new class_243((double)0.6f, 0.0, 0.0);
            class_2350 side = (class_2350)state.method_11654((class_2769)FACING);
            this.spawnPoweredParticle(world, rand, pos, color, side, 0.3f);
        }

        protected static class_2350 getOutputFacing(class_2680 state) {
            return DirectedComponentBlock.getFrontFacing(state);
        }

        protected static class_2350 getFrontFacing(class_2680 state) {
            return facing_mapping_.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146() * 4 + ((Integer)state.method_11654((class_2769)ROTATION) & 3));
        }

        protected static class_2350 getRightFacing(class_2680 state) {
            return facing_mapping_.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146() * 4 + ((Integer)state.method_11654((class_2769)ROTATION) + 1 & 3));
        }

        protected static class_2350 getBackFacing(class_2680 state) {
            return facing_mapping_.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146() * 4 + ((Integer)state.method_11654((class_2769)ROTATION) + 2 & 3));
        }

        protected static class_2350 getLeftFacing(class_2680 state) {
            return facing_mapping_.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146() * 4 + ((Integer)state.method_11654((class_2769)ROTATION) + 3 & 3));
        }

        protected static class_2350 getUpFacing(class_2680 state) {
            return ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        }

        protected static class_2350 getDownFacing(class_2680 state) {
            return (class_2350)state.method_11654((class_2769)FACING);
        }

        protected static class_2350 getForwardStateMappedFacing(class_2680 state, class_2350 internal_side) {
            return facing_fwd_state_mapping_[((class_2350)state.method_11654((class_2769)FACING)).ordinal()][(Integer)state.method_11654((class_2769)ROTATION)][internal_side.ordinal()];
        }

        protected static class_2350 getReverseStateMappedFacing(class_2680 state, class_2350 world_side) {
            return facing_rev_state_mapping_[((class_2350)state.method_11654((class_2769)FACING)).ordinal()][(Integer)state.method_11654((class_2769)ROTATION)][world_side.ordinal()];
        }

        protected void notifyOutputNeighbourOfStateChange(class_2680 state, class_1937 world, class_2338 pos) {
            this.notifyOutputNeighbourOfStateChange(state, world, pos, DirectedComponentBlock.getOutputFacing(state));
        }

        protected void notifyOutputNeighbourOfStateChange(class_2680 state, class_1937 world, class_2338 pos, class_2350 facing) {
            class_2338 adjacent_pos = pos.method_10093(facing);
            class_2680 adjacent_state = world.method_8320(adjacent_pos);
            try {
                adjacent_state.method_26181(world, adjacent_pos, (class_2248)this, pos, false);
                if (RsSignals.canEmitWeakPower(adjacent_state, world, adjacent_pos, facing)) {
                    world.method_8508(adjacent_pos, state.method_26204(), facing.method_10153());
                }
            }
            catch (Throwable ex) {
                Auxiliaries.logError("Curcuit neighborChanged recursion detected, dropping!");
                class_243 p = class_243.method_24953((class_2382)pos);
                world.method_8649((class_1297)new class_1542(world, p.field_1352, p.field_1351, p.field_1350, new class_1799((class_1935)this, 1)));
                world.method_8652(pos, world.method_8320(pos).method_26227().method_15759(), 18);
            }
        }

        public class_2680 update(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2338 fromPos) {
            return state;
        }
    }
}

