/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotm.mod.world;

import com.github.hotm.mod.HotMLog;
import com.github.hotm.mod.block.HotMBlocks;
import com.github.hotm.mod.block.HotMPointOfInterestTypes;
import com.github.hotm.mod.world.HotMDimensions;
import com.github.hotm.mod.world.HotMLocationConversions;
import com.github.hotm.mod.world.HotMPortalFinders;
import com.github.hotm.mod.world.HotMPortalFinders$getNonNecterePortalPlacementsForChunk$;
import com.github.hotm.mod.world.HotMPortalFinders$locateNonNectereSidePortalStructure$;
import com.github.hotm.mod.world.HotMPortalGenPositions;
import com.github.hotm.mod.world.HotMPortalOffsets;
import com.github.hotm.mod.world.biome.NecterePortalData;
import com.github.hotm.mod.world.gen.HotMPortalGen;
import com.github.hotm.mod.world.gen.structure.HotMStructures;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6872;
import net.minecraft.class_6880;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003IJKB\t\b\u0002\u00a2\u0006\u0004\bG\u0010HJ'\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ;\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J;\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0013\u0010\u0011JA\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ1\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J'\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u007f\u0010>\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010-\"\u0004\b\u0001\u0010.2\u0006\u0010$\u001a\u00020/2\u0006\u00101\u001a\u0002002\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000003022\u0006\u00105\u001a\u00020)2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u0002082\u0006\u0010\u0015\u001a\u00020\u00142\u001e\u0010=\u001a\u001a\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010<0:\u00a2\u0006\u0004\b>\u0010?J'\u0010A\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\bA\u0010BJ!\u0010D\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010C\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bD\u0010EJ\u001f\u0010F\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bF\u0010'\u00a8\u0006L"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders;", "", "Lnet/minecraft/class_3218;", "nonNectereWorld", "Lnet/minecraft/class_2338;", "testPos", "Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;", "portalHolder", "findNonNecterePortal", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;)Lnet/minecraft/class_2338;", "srcWorld", "portalPos", "nectereWorld", "Lkotlin/Function1;", "", "callback", "findOrCreateNecterePortal", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_3218;Lkotlin/jvm/functions/Function1;)V", "destWorld", "findOrCreateNonNecterePortal", "Lnet/minecraft/class_6872;", "placement", "Lnet/minecraft/class_7869;", "calculator", "Lnet/minecraft/class_1923;", "currentPos", "necterePos", "getNonNecterePortalPlacementForBiome", "(Lnet/minecraft/class_6872;Lnet/minecraft/class_7869;Lnet/minecraft/class_1923;Lnet/minecraft/class_3218;Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;Lnet/minecraft/class_1923;)Lnet/minecraft/class_2338;", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "currentWorldKey", "Lkotlin/sequences/Sequence;", "Lcom/github/hotm/mod/world/HotMPortalFinders$PortalPlacementResult;", "getNonNecterePortalPlacementsForChunk", "(Lnet/minecraft/class_5321;Lnet/minecraft/class_1923;Lnet/minecraft/class_3218;)Lkotlin/sequences/Sequence;", "world", "", "isValidPortal", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Z", "currentWorld", "", "radius", "locateNonNectereSidePortalStructure", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;I)Lnet/minecraft/class_2338;", "T", "R", "Lnet/minecraft/class_4538;", "Lnet/minecraft/class_5138;", "structureManager", "", "Lcom/github/hotm/mod/world/HotMPortalFinders$LocatePos;", "startChunks", "maxRadius", "", "seed", "Lnet/minecraft/class_3195;", "structure", "Lkotlin/Function2;", "Lnet/minecraft/class_3449;", "Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult;", "found", "multiLocate", "(Lnet/minecraft/class_4538;Lnet/minecraft/class_5138;Ljava/util/List;IJLnet/minecraft/class_3195;Lnet/minecraft/class_6872;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "pos", "preloadChunks", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;I)V", "destPos", "tempFindDepositSpace", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "tempIsValidDepositSpace", "<init>", "()V", "FindResult", "LocatePos", "PortalPlacementResult", "heart-of-the-machine"})
@SourceDebugExtension(value={"SMAP\nHotMPortalFinders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotMPortalFinders.kt\ncom/github/hotm/mod/world/HotMPortalFinders\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,473:1\n1821#2,14:474\n473#2:488\n473#2:489\n1821#2,14:492\n1821#2,14:506\n1002#3,2:490\n*S KotlinDebug\n*F\n+ 1 HotMPortalFinders.kt\ncom/github/hotm/mod/world/HotMPortalFinders\n*L\n110#1:474,14\n253#1:488\n419#1:489\n71#1:492,14\n150#1:506,14\n440#1:490,2\n*E\n"})
public final class HotMPortalFinders {
    @NotNull
    public static final HotMPortalFinders INSTANCE = new HotMPortalFinders();

    private HotMPortalFinders() {
    }

    public final void findOrCreateNonNecterePortal(@NotNull class_3218 nectereWorld, @NotNull class_2338 portalPos, @NotNull class_3218 destWorld, @NotNull Function1<? super class_2338, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)nectereWorld, (String)"nectereWorld");
        Intrinsics.checkNotNullParameter((Object)portalPos, (String)"portalPos");
        Intrinsics.checkNotNullParameter((Object)destWorld, (String)"destWorld");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Optional optional = nectereWorld.method_23753(portalPos).method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"nectereWorld.getBiome(portalPos).key");
        class_5321 biomeKey = (class_5321)OptionalsKt.getOrNull((Optional)optional);
        if (biomeKey == null) {
            callback.invoke(null);
            return;
        }
        NecterePortalData.Holder portalHolder = NecterePortalData.Companion.getBIOMES_BY_ID().get(biomeKey);
        if (portalHolder == null) {
            callback.invoke(null);
            return;
        }
        class_2338 nonPos = HotMLocationConversions.INSTANCE.nectere2StartNon(portalPos, portalHolder.getData());
        int radius = RangesKt.coerceAtLeast((int)((int)Math.ceil(portalHolder.getData().getCoordinateFactor())), (int)1);
        this.preloadChunks(destWorld, nonPos, radius);
        HotMPortalGen.INSTANCE.pregenPortal(destWorld, new class_1923(nonPos));
        MinecraftServer minecraftServer = destWorld.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"destWorld.server");
        MinecraftServer server = minecraftServer;
        server.method_18858((Runnable)new class_3738(server.method_3780(), () -> HotMPortalFinders.findOrCreateNonNecterePortal$lambda$2(destWorld, nonPos, radius, callback)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final class_2338 findNonNecterePortal(@NotNull class_3218 nonNectereWorld, @NotNull class_2338 testPos, @NotNull NecterePortalData.Holder portalHolder) {
        Object v1;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)nonNectereWorld, (String)"nonNectereWorld");
        Intrinsics.checkNotNullParameter((Object)testPos, (String)"testPos");
        Intrinsics.checkNotNullParameter((Object)portalHolder, (String)"portalHolder");
        int radius = RangesKt.coerceAtLeast((int)((int)Math.ceil(portalHolder.getData().getCoordinateFactor())), (int)1);
        class_2784 worldBorder = nonNectereWorld.method_8621();
        Stream stream = nonNectereWorld.method_19494().method_22383(HotMPortalFinders::findNonNecterePortal$lambda$3, testPos, radius, class_4153.class_4155.field_18489);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"nonNectereWorld.pointOfI\u2026ationStatus.ANY\n        )");
        Sequence sequence = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<class_4156, Boolean>(worldBorder, nonNectereWorld){
            final /* synthetic */ class_2784 $worldBorder;
            final /* synthetic */ class_3218 $nonNectereWorld;
            {
                this.$worldBorder = $worldBorder;
                this.$nonNectereWorld = $nonNectereWorld;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(class_4156 it) {
                boolean bl;
                if (this.$worldBorder.method_11952(it.method_19141())) {
                    class_2338 class_23382 = it.method_19141();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"it.pos");
                    if (HotMPortalFinders.access$isValidPortal(HotMPortalFinders.INSTANCE, this.$nonNectereWorld, class_23382)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                class_4156 it = (class_4156)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_19141().method_10262((class_2382)testPos);
                do {
                    Object e$iv = iterator$iv.next();
                    class_4156 it2 = (class_4156)e$iv;
                    $i$a$-minByOrNull-HotMPortalFinders$findNonNecterePortal$3 = false;
                    double v$iv = it2.method_19141().method_10262((class_2382)testPos);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        class_4156 class_41562 = v1;
        return class_41562 != null ? class_41562.method_19141() : null;
    }

    public final void findOrCreateNecterePortal(@NotNull class_3218 srcWorld, @NotNull class_2338 portalPos, @NotNull class_3218 nectereWorld, @NotNull Function1<? super class_2338, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)srcWorld, (String)"srcWorld");
        Intrinsics.checkNotNullParameter((Object)portalPos, (String)"portalPos");
        Intrinsics.checkNotNullParameter((Object)nectereWorld, (String)"nectereWorld");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        for (NecterePortalData.Holder portalHolder : NecterePortalData.Companion.getBIOMES_BY_WORLD().get((Object)srcWorld.method_27983())) {
            class_2338 necterePos = HotMLocationConversions.INSTANCE.non2StartNectere(portalPos, portalHolder.getData());
            int radius = RangesKt.coerceAtLeast((int)((int)Math.ceil(1.0 / portalHolder.getData().getCoordinateFactor())), (int)1);
            this.preloadChunks(nectereWorld, necterePos, radius);
        }
        MinecraftServer minecraftServer = srcWorld.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"srcWorld.server");
        MinecraftServer server = minecraftServer;
        server.method_18858((Runnable)new class_3738(server.method_3780(), () -> HotMPortalFinders.findOrCreateNecterePortal$lambda$6(nectereWorld, srcWorld, callback, portalPos)));
    }

    private final void preloadChunks(class_3218 world, class_2338 pos, int radius) {
        Iterator iterator = class_1923.method_19280((class_1923)new class_1923(pos), (int)class_3532.method_48116((int)radius, (int)16)).iterator();
        while (iterator.hasNext()) {
            class_1923 chunkPos = (class_1923)iterator.next();
            world.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803);
        }
        world.method_19494().method_22439((class_4538)world, pos, radius);
    }

    private final boolean isValidPortal(class_3218 world, class_2338 portalPos) {
        return world.method_8320(portalPos.method_10074()).method_27852((class_2248)HotMBlocks.INSTANCE.getGLOWY_OBELISK_PART());
    }

    private final class_2338 tempFindDepositSpace(class_3218 destWorld, class_2338 destPos) {
        class_2338.class_2339 mutable = destPos.method_25503();
        for (int radius = 0; radius < destWorld.method_31605(); ++radius) {
            mutable.method_33098(destPos.method_10264() + radius);
            Intrinsics.checkNotNullExpressionValue((Object)mutable, (String)"mutable");
            if (this.tempIsValidDepositSpace(destWorld, (class_2338)mutable)) {
                return mutable.method_10062();
            }
            mutable.method_33098(destPos.method_10264() - radius);
            if (!this.tempIsValidDepositSpace(destWorld, (class_2338)mutable)) continue;
            return mutable.method_10062();
        }
        return null;
    }

    private final boolean tempIsValidDepositSpace(class_3218 destWorld, class_2338 testPos) {
        return destWorld.method_8320(testPos).method_26215() && destWorld.method_8320(testPos.method_10084()).method_26215() && !destWorld.method_8320(testPos.method_10074()).method_26215();
    }

    @NotNull
    public final Sequence<PortalPlacementResult> getNonNecterePortalPlacementsForChunk(@NotNull class_5321<class_1937> currentWorldKey, @NotNull class_1923 currentPos, @NotNull class_3218 nectereWorld) {
        Intrinsics.checkNotNullParameter(currentWorldKey, (String)"currentWorldKey");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)nectereWorld, (String)"nectereWorld");
        if (Intrinsics.areEqual(currentWorldKey, HotMDimensions.INSTANCE.getNECTERE_KEY())) {
            throw new IllegalArgumentException("Cannot get non-Nectere portal gen coords in a Nectere world");
        }
        class_3195 structure = (class_3195)nectereWorld.method_30349().method_30530(class_7924.field_41246).method_29107(HotMStructures.INSTANCE.getNECTERE_PORTAL());
        if (structure == null) {
            HotMLog.INSTANCE.getLOG().error("No 'hotm:nectere_portal' structure registered");
            return SequencesKt.emptySequence();
        }
        class_7869 calculator = nectereWorld.method_14178().method_46642();
        List placements = calculator.method_46708(class_6880.method_40223((Object)structure));
        Intrinsics.checkNotNullExpressionValue((Object)placements, (String)"placements");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)placements);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getNonNecterePortalPlacementsForChunk$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        class_6872 placement = (class_6872)SequencesKt.firstOrNull((Sequence)sequence);
        if (placement == null) {
            HotMLog.INSTANCE.getLOG().error("No random spread structure placements for 'hotm:nectere_portal' registered");
            return SequencesKt.emptySequence();
        }
        if (placements.size() > 1) {
            HotMLog.INSTANCE.getLOG().warn("Multiple structure placements for 'hotm:nectere_portal' found, ignoring all but first.");
        }
        Collection collection = NecterePortalData.Companion.getBIOMES_BY_WORLD().get(currentWorldKey);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"NecterePortalData.BIOMES\u2026ORLD.get(currentWorldKey)");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<NecterePortalData.Holder, Sequence<? extends PortalPlacementResult>>(currentPos, placement, calculator, nectereWorld){
            final /* synthetic */ class_1923 $currentPos;
            final /* synthetic */ class_6872 $placement;
            final /* synthetic */ class_7869 $calculator;
            final /* synthetic */ class_3218 $nectereWorld;
            {
                this.$currentPos = $currentPos;
                this.$placement = $placement;
                this.$calculator = $calculator;
                this.$nectereWorld = $nectereWorld;
                super(1);
            }

            @NotNull
            public final Sequence<PortalPlacementResult> invoke(NecterePortalData.Holder portalHolder) {
                return SequencesKt.mapNotNull(HotMLocationConversions.INSTANCE.non2AllNectere(this.$currentPos, portalHolder.getData()), (Function1)((Function1)new Function1<class_1923, PortalPlacementResult>(this.$placement, this.$calculator, this.$currentPos, this.$nectereWorld, portalHolder){
                    final /* synthetic */ class_6872 $placement;
                    final /* synthetic */ class_7869 $calculator;
                    final /* synthetic */ class_1923 $currentPos;
                    final /* synthetic */ class_3218 $nectereWorld;
                    final /* synthetic */ NecterePortalData.Holder $portalHolder;
                    {
                        this.$placement = $placement;
                        this.$calculator = $calculator;
                        this.$currentPos = $currentPos;
                        this.$nectereWorld = $nectereWorld;
                        this.$portalHolder = $portalHolder;
                        super(1);
                    }

                    @Nullable
                    public final PortalPlacementResult invoke(@NotNull class_1923 necterePos) {
                        PortalPlacementResult portalPlacementResult;
                        Intrinsics.checkNotNullParameter((Object)necterePos, (String)"necterePos");
                        class_7869 class_78692 = this.$calculator;
                        Intrinsics.checkNotNullExpressionValue((Object)class_78692, (String)"calculator");
                        NecterePortalData.Holder holder = this.$portalHolder;
                        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"portalHolder");
                        class_2338 class_23382 = HotMPortalFinders.access$getNonNecterePortalPlacementForBiome(HotMPortalFinders.INSTANCE, this.$placement, class_78692, this.$currentPos, this.$nectereWorld, holder, necterePos);
                        if (class_23382 != null) {
                            class_2338 class_23383 = class_23382;
                            NecterePortalData.Holder holder2 = this.$portalHolder;
                            class_2338 it = class_23383;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)holder2, (String)"portalHolder");
                            portalPlacementResult = new PortalPlacementResult(it, holder2);
                        } else {
                            portalPlacementResult = null;
                        }
                        return portalPlacementResult;
                    }
                }));
            }
        }));
    }

    private final class_2338 getNonNecterePortalPlacementForBiome(class_6872 placement, class_7869 calculator, class_1923 currentPos, class_3218 nectereWorld, NecterePortalData.Holder portalHolder, class_1923 necterePos) {
        class_1923 startChunk = placement.method_40169(calculator.method_46714(), necterePos.field_9181, necterePos.field_9180);
        class_2338 necterePortalPos = new class_2338(HotMPortalGenPositions.INSTANCE.chunk2PortalX(startChunk.field_9181), 64, HotMPortalGenPositions.INSTANCE.chunk2PortalZ(startChunk.field_9180));
        Optional optional = nectereWorld.method_23753(necterePortalPos).method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"nectereWorld.getBiome(necterePortalPos).key");
        class_5321 biomeId = (class_5321)OptionalsKt.getOrNull((Optional)optional);
        if (!Intrinsics.areEqual((Object)biomeId, portalHolder.getBiome())) {
            return null;
        }
        class_2338 portalPos = HotMLocationConversions.INSTANCE.nectere2StartNon(necterePortalPos, portalHolder.getData());
        return portalPos.method_10263() >> 4 == currentPos.field_9181 && portalPos.method_10260() >> 4 == currentPos.field_9180 ? portalPos : null;
    }

    @Nullable
    public final <T, R> R multiLocate(@NotNull class_4538 world, @NotNull class_5138 structureManager, @NotNull List<LocatePos<T>> startChunks, int maxRadius, long seed, @NotNull class_3195 structure, @NotNull class_6872 placement, @NotNull Function2<? super class_3449, ? super T, FindResult<R>> found2) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)structureManager, (String)"structureManager");
        Intrinsics.checkNotNullParameter(startChunks, (String)"startChunks");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        Intrinsics.checkNotNullParameter(found2, (String)"found");
        int spacing = placement.method_41632();
        block0: for (int curRadius = 0; curRadius <= maxRadius; ++curRadius) {
            System.out.println((Object)("Searching radius: " + curRadius));
            int structX = -curRadius;
            int n = curRadius;
            if (structX > n) continue;
            while (true) {
                boolean xBorder = structX == -curRadius || structX == curRadius;
                int structZ = -curRadius;
                int n2 = curRadius;
                if (structZ <= n2) {
                    while (true) {
                        boolean zBorder;
                        boolean bl = zBorder = structZ == -curRadius || structZ == curRadius;
                        if (xBorder || zBorder) {
                            for (LocatePos<T> startChunk : startChunks) {
                                FindResult res;
                                int curChunkX = startChunk.getStartChunk().field_9181 + spacing * structX;
                                int curChunkZ = startChunk.getStartChunk().field_9180 + spacing * structZ;
                                class_1923 chunkPos = placement.method_40169(seed, curChunkX, curChunkZ);
                                class_2791 chunk = world.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423);
                                class_3449 structureStart = structureManager.method_26975(class_4076.method_18681((class_1923)chunk.method_12004(), (int)0), structure, (class_2810)chunk);
                                if (structureStart == null || !structureStart.method_16657() || (res = (FindResult)found2.invoke((Object)structureStart, startChunk.getData())).isKeepSearching()) continue;
                                return (R)res.get();
                            }
                            if (curRadius == 0) break;
                        }
                        if (structZ == n2) break;
                        ++structZ;
                    }
                }
                if (curRadius == 0 || structX == n) continue block0;
                ++structX;
            }
        }
        return null;
    }

    @Nullable
    public final class_2338 locateNonNectereSidePortalStructure(@NotNull class_3218 currentWorld, @NotNull class_2338 currentPos, int radius) {
        List locatePoses2;
        Intrinsics.checkNotNullParameter((Object)currentWorld, (String)"currentWorld");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        MinecraftServer minecraftServer = currentWorld.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"currentWorld.server");
        class_3218 nectereWorld = HotMDimensions.INSTANCE.getNectere(minecraftServer);
        class_2378 structureRegistry = nectereWorld.method_30349().method_30530(class_7924.field_41246);
        Optional optional = structureRegistry.method_40264(HotMStructures.INSTANCE.getNECTERE_PORTAL());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"structureRegistry.getHol\u2026tructures.NECTERE_PORTAL)");
        class_6880.class_6883 structureHolder = (class_6880.class_6883)OptionalsKt.getOrNull((Optional)optional);
        if (structureHolder == null) {
            HotMLog.INSTANCE.getLOG().error("No 'hotm:nectere_portal' structure registered");
            return null;
        }
        class_7869 calculator = nectereWorld.method_14178().method_46642();
        List placements = calculator.method_46708((class_6880)structureHolder);
        Intrinsics.checkNotNullExpressionValue((Object)placements, (String)"placements");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)placements);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)locateNonNectereSidePortalStructure$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        class_6872 placement = (class_6872)SequencesKt.firstOrNull((Sequence)sequence);
        if (placement == null) {
            HotMLog.INSTANCE.getLOG().error("No random spread structure placements for 'hotm:nectere_portal' registered");
            return null;
        }
        if (placements.size() > 1) {
            HotMLog.INSTANCE.getLOG().warn("Multiple structure placements for 'hotm:nectere_portal' found, ignoring all but first.");
        }
        System.out.println((Object)"========");
        System.out.println((Object)"Locate non-nectere side portal");
        System.out.println((Object)("current pos: " + currentPos));
        System.out.println((Object)("radius: " + radius));
        Collection collection = NecterePortalData.Companion.getBIOMES_BY_WORLD().get((Object)currentWorld.method_27983());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"NecterePortalData.BIOMES\u2026currentWorld.registryKey)");
        List $this$sortBy$iv = locatePoses2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<NecterePortalData.Holder, LocatePos<NecterePortalData.Holder>>(currentPos){
            final /* synthetic */ class_2338 $currentPos;
            {
                this.$currentPos = $currentPos;
                super(1);
            }

            @NotNull
            public final LocatePos<NecterePortalData.Holder> invoke(NecterePortalData.Holder portalHolder) {
                class_2338 necterePos = HotMLocationConversions.INSTANCE.non2StartNectere(this.$currentPos, portalHolder.getData());
                return new LocatePos<NecterePortalData.Holder>(new class_1923(necterePos), portalHolder);
            }
        })));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LocatePos it = (LocatePos)a;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(((NecterePortalData.Holder)it.getData()).getData().getCoordinateFactor());
                    it = (LocatePos)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(((NecterePortalData.Holder)it.getData()).getData().getCoordinateFactor()));
                }
            });
        }
        class_4538 class_45382 = (class_4538)nectereWorld;
        class_5138 class_51382 = nectereWorld.method_27056();
        Intrinsics.checkNotNullExpressionValue((Object)class_51382, (String)"nectereWorld.structureManager");
        long l = nectereWorld.method_8412();
        Object object = structureHolder.comp_349();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"structureHolder.value()");
        return (class_2338)this.multiLocate(class_45382, class_51382, locatePoses2, radius, l, (class_3195)object, placement, (Function2)new Function2<class_3449, NecterePortalData.Holder, FindResult<class_2338>>(nectereWorld){
            final /* synthetic */ class_3218 $nectereWorld;
            {
                this.$nectereWorld = $nectereWorld;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FindResult<class_2338> invoke(@NotNull class_3449 structureStart, NecterePortalData.Holder portalHolder) {
                Intrinsics.checkNotNullParameter((Object)structureStart, (String)"structureStart");
                class_1923 class_19232 = structureStart.method_34000();
                Intrinsics.checkNotNullExpressionValue((Object)class_19232, (String)"structureStart.pos");
                class_2338 portalPos = HotMPortalGenPositions.INSTANCE.chunk2PortalXZ(class_19232);
                Optional foundBiome = this.$nectereWorld.method_23753(portalPos).method_40230();
                class_5321<class_1959> class_53212 = portalHolder.getBiome();
                Intrinsics.checkNotNullExpressionValue((Object)foundBiome, (String)"foundBiome");
                if (Intrinsics.areEqual(class_53212, (Object)OptionalsKt.getOrNull((Optional)foundBiome))) {
                    class_2338 nonNecterePos;
                    NecterePortalData.Companion companion = NecterePortalData.Companion;
                    Optional optionalBiome$iv = foundBiome;
                    boolean $i$f$ifData = false;
                    if (optionalBiome$iv.isEmpty()) {
                        v2 = null;
                    } else {
                        void this_$iv;
                        T t = optionalBiome$iv.get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"optionalBiome.get()");
                        class_5321 biome$iv = (class_5321)t;
                        if (this_$iv.getBIOMES_BY_ID().containsKey(biome$iv)) {
                            NecterePortalData.Holder holder = this_$iv.getBIOMES_BY_ID().get(biome$iv);
                            Intrinsics.checkNotNull((Object)holder);
                            NecterePortalData.Holder portalHolder2 = holder;
                            boolean bl = false;
                            v2 = HotMLocationConversions.INSTANCE.nectere2StartNon(portalPos, portalHolder2.getData());
                        } else {
                            v2 = nonNecterePos = null;
                        }
                    }
                    if (nonNecterePos != null) {
                        class_2338 nonNectereStructurePos = HotMPortalOffsets.INSTANCE.portal2StructurePos(nonNecterePos);
                        return FindResult.Companion.done(nonNectereStructurePos);
                    }
                }
                return FindResult.Companion.keepSearching();
            }
        });
    }

    private static final boolean findOrCreateNonNecterePortal$lambda$2$lambda$0(class_6880 it) {
        Optional optional = it.method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"it.key");
        return Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), HotMPointOfInterestTypes.INSTANCE.getNECTERE_PORTAL());
    }

    /*
     * WARNING - void declaration
     */
    private static final void findOrCreateNonNecterePortal$lambda$2(class_3218 $destWorld, class_2338 $nonPos, int $radius, Function1 $callback) {
        Object v1;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)$destWorld, (String)"$destWorld");
        Intrinsics.checkNotNullParameter((Object)$nonPos, (String)"$nonPos");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        class_2784 worldBorder = $destWorld.method_8621();
        Stream stream = $destWorld.method_19494().method_22383(HotMPortalFinders::findOrCreateNonNecterePortal$lambda$2$lambda$0, $nonPos, $radius, class_4153.class_4155.field_18489);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"destWorld.pointOfInteres\u2026nStatus.ANY\n            )");
        Sequence sequence = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<class_4156, Boolean>(worldBorder, $destWorld){
            final /* synthetic */ class_2784 $worldBorder;
            final /* synthetic */ class_3218 $destWorld;
            {
                this.$worldBorder = $worldBorder;
                this.$destWorld = $destWorld;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(class_4156 poi2) {
                boolean bl;
                if (this.$worldBorder.method_11952(poi2.method_19141())) {
                    class_2338 class_23382 = poi2.method_19141();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"poi.pos");
                    if (HotMPortalFinders.access$isValidPortal(HotMPortalFinders.INSTANCE, this.$destWorld, class_23382)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                class_4156 it = (class_4156)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_19141().method_10262((class_2382)$nonPos);
                do {
                    Object e$iv = iterator$iv.next();
                    class_4156 it2 = (class_4156)e$iv;
                    $i$a$-minByOrNull-HotMPortalFinders$findOrCreateNonNecterePortal$1$poi$3 = false;
                    double v$iv = it2.method_19141().method_10262((class_2382)$nonPos);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        class_4156 poi2 = v1;
        if (poi2 == null) {
            if (worldBorder.method_11952($nonPos)) {
                class_2338 class_23382 = INSTANCE.tempFindDepositSpace($destWorld, $nonPos);
                if (class_23382 == null) {
                    class_23382 = $nonPos;
                }
                class_2338 outPos = class_23382;
                $destWorld.method_8501(outPos, HotMBlocks.INSTANCE.getNECTERE_PORTAL().method_9564());
                $destWorld.method_8501(outPos.method_10084(), (class_2680)HotMBlocks.INSTANCE.getNECTERE_PORTAL().method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033));
                $destWorld.method_8501(outPos.method_10074(), HotMBlocks.INSTANCE.getGLOWY_OBELISK_PART().method_9564());
                $destWorld.method_8501(outPos.method_10086(2), HotMBlocks.INSTANCE.getGLOWY_OBELISK_PART().method_9564());
                $callback.invoke((Object)outPos);
            } else {
                $callback.invoke(null);
            }
        } else {
            $callback.invoke((Object)poi2.method_19141());
        }
    }

    private static final boolean findNonNecterePortal$lambda$3(class_6880 it) {
        Optional optional = it.method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"it.key");
        return Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), HotMPointOfInterestTypes.INSTANCE.getNECTERE_PORTAL());
    }

    /*
     * WARNING - void declaration
     */
    private static final void findOrCreateNecterePortal$lambda$6(class_3218 $nectereWorld, class_3218 $srcWorld, Function1 $callback, class_2338 $portalPos) {
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0016\u0010\u0004\u00a8\u0006\u0019"}, d2={"com/github/hotm/mod/world/HotMPortalFinders.findOrCreateNecterePortal.1.Found", "", "Lnet/minecraft/class_2338;", "component1", "()Lnet/minecraft/class_2338;", "component2", "foundPos", "necterePos", "copy", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)Lcom/github/hotm/mod/world/HotMPortalFinders$findOrCreateNecterePortal$1$Found;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2338;", "getFoundPos", "getNecterePos", "<init>", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)V", "heart-of-the-machine"})
        public final class Found {
            @NotNull
            private final class_2338 foundPos;
            @NotNull
            private final class_2338 necterePos;

            public Found(@NotNull class_2338 foundPos, @NotNull class_2338 necterePos) {
                Intrinsics.checkNotNullParameter((Object)foundPos, (String)"foundPos");
                Intrinsics.checkNotNullParameter((Object)necterePos, (String)"necterePos");
                this.foundPos = foundPos;
                this.necterePos = necterePos;
            }

            @NotNull
            public final class_2338 getFoundPos() {
                return this.foundPos;
            }

            @NotNull
            public final class_2338 getNecterePos() {
                return this.necterePos;
            }

            @NotNull
            public final class_2338 component1() {
                return this.foundPos;
            }

            @NotNull
            public final class_2338 component2() {
                return this.necterePos;
            }

            @NotNull
            public final Found copy(@NotNull class_2338 foundPos, @NotNull class_2338 necterePos) {
                Intrinsics.checkNotNullParameter((Object)foundPos, (String)"foundPos");
                Intrinsics.checkNotNullParameter((Object)necterePos, (String)"necterePos");
                return new Found(foundPos, necterePos);
            }

            public static /* synthetic */ Found copy$default(Found found2, class_2338 class_23382, class_2338 class_23383, int n, Object object) {
                if ((n & 1) != 0) {
                    class_23382 = found2.foundPos;
                }
                if ((n & 2) != 0) {
                    class_23383 = found2.necterePos;
                }
                return found2.copy(class_23382, class_23383);
            }

            @NotNull
            public String toString() {
                return "Found(foundPos=" + this.foundPos + ", necterePos=" + this.necterePos + ")";
            }

            public int hashCode() {
                int result = this.foundPos.hashCode();
                result = result * 31 + this.necterePos.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Found)) {
                    return false;
                }
                Found found2 = (Found)other;
                if (!Intrinsics.areEqual((Object)this.foundPos, (Object)found2.foundPos)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.necterePos, (Object)found2.necterePos);
            }
        }
        Object v1;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)$nectereWorld, (String)"$nectereWorld");
        Intrinsics.checkNotNullParameter((Object)$srcWorld, (String)"$srcWorld");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$portalPos, (String)"$portalPos");
        class_2784 worldborder = $nectereWorld.method_8621();
        Collection collection = NecterePortalData.Companion.getBIOMES_BY_WORLD().get((Object)$srcWorld.method_27983());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"NecterePortalData.BIOMES\u2026get(srcWorld.registryKey)");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<NecterePortalData.Holder, Found>($portalPos, $nectereWorld, worldborder){
            final /* synthetic */ class_2338 $portalPos;
            final /* synthetic */ class_3218 $nectereWorld;
            final /* synthetic */ class_2784 $worldborder;
            {
                this.$portalPos = $portalPos;
                this.$nectereWorld = $nectereWorld;
                this.$worldborder = $worldborder;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Found invoke(NecterePortalData.Holder portalHolder) {
                Found found2;
                Object v1;
                void $this$minByOrNull$iv;
                class_2338 necterePos = HotMLocationConversions.INSTANCE.non2StartNectere(this.$portalPos, portalHolder.getData());
                int radius = RangesKt.coerceAtLeast((int)((int)Math.ceil(1.0 / portalHolder.getData().getCoordinateFactor())), (int)1);
                Stream stream = this.$nectereWorld.method_19494().method_22383(findOrCreateNecterePortal.1.found.1::invoke$lambda$0, necterePos, radius, class_4153.class_4155.field_18489);
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"nectereWorld.pointOfInte\u2026ANY\n                    )");
                Sequence sequence = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<class_4156, Boolean>(this.$worldborder, this.$nectereWorld, portalHolder){
                    final /* synthetic */ class_2784 $worldborder;
                    final /* synthetic */ class_3218 $nectereWorld;
                    final /* synthetic */ NecterePortalData.Holder $portalHolder;
                    {
                        this.$worldborder = $worldborder;
                        this.$nectereWorld = $nectereWorld;
                        this.$portalHolder = $portalHolder;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(class_4156 poi2) {
                        boolean bl;
                        if (this.$worldborder.method_11952(poi2.method_19141())) {
                            class_2338 class_23382 = poi2.method_19141();
                            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"poi.pos");
                            if (HotMPortalFinders.access$isValidPortal(HotMPortalFinders.INSTANCE, this.$nectereWorld, class_23382)) {
                                Optional optional = this.$nectereWorld.method_23753(poi2.method_19141()).method_40230();
                                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"nectereWorld.getBiome(poi.pos).key");
                                if (Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), this.$portalHolder.getBiome())) {
                                    bl = true;
                                    return bl;
                                }
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }));
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    E minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = minElem$iv;
                    } else {
                        class_4156 it = (class_4156)minElem$iv;
                        boolean bl = false;
                        double minValue$iv = it.method_19141().method_10262((class_2382)necterePos);
                        do {
                            E e$iv = iterator$iv.next();
                            class_4156 it2 = (class_4156)e$iv;
                            $i$a$-minByOrNull-HotMPortalFinders$findOrCreateNecterePortal$1$found$1$3 = false;
                            double v$iv = it2.method_19141().method_10262((class_2382)necterePos);
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = minElem$iv;
                    }
                }
                class_4156 class_41562 = v1;
                if (class_41562 != null) {
                    class_4156 it = class_41562;
                    boolean bl = false;
                    class_2338 class_23382 = it.method_19141();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"it.pos");
                    found2 = new Found(class_23382, necterePos);
                } else {
                    found2 = null;
                }
                return found2;
            }

            private static final boolean invoke$lambda$0(class_6880 it) {
                Optional optional = it.method_40230();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"it.key");
                return Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), HotMPointOfInterestTypes.INSTANCE.getNECTERE_PORTAL());
            }
        }));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Found it = (Found)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getFoundPos().method_10262((class_2382)it.getNecterePos());
                do {
                    Object e$iv = iterator$iv.next();
                    Found it2 = (Found)e$iv;
                    $i$a$-minByOrNull-HotMPortalFinders$findOrCreateNecterePortal$1$found$2 = false;
                    double v$iv = it2.getFoundPos().method_10262((class_2382)it2.getNecterePos());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Found found2 = v1;
        if (found2 != null) {
            $callback.invoke((Object)found2.getFoundPos());
        } else {
            Collection collection2 = NecterePortalData.Companion.getBIOMES_BY_WORLD().get((Object)$srcWorld.method_27983());
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"NecterePortalData.BIOMES\u2026get(srcWorld.registryKey)");
            List necterePoses2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)((Function1)new Function1<NecterePortalData.Holder, class_2338>($portalPos, $nectereWorld){
                final /* synthetic */ class_2338 $portalPos;
                final /* synthetic */ class_3218 $nectereWorld;
                {
                    this.$portalPos = $portalPos;
                    this.$nectereWorld = $nectereWorld;
                    super(1);
                }

                @Nullable
                public final class_2338 invoke(NecterePortalData.Holder it) {
                    class_2338 necterePos = HotMLocationConversions.INSTANCE.non2StartNectere(this.$portalPos, it.getData());
                    Optional optional = this.$nectereWorld.method_23753(necterePos).method_40230();
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"nectereWorld.getBiome(necterePos).key");
                    if (!Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), it.getBiome())) {
                        return null;
                    }
                    return necterePos;
                }
            })), (Function1)((Function1)new Function1<class_2338, Boolean>(worldborder){
                final /* synthetic */ class_2784 $worldborder;
                {
                    this.$worldborder = $worldborder;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull class_2338 it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$worldborder.method_11952(it);
                }
            })));
            class_2338 necterePos = (class_2338)CollectionsKt.randomOrNull((Collection)necterePoses2, (Random)((Random)Random.Default));
            if (necterePos != null) {
                class_2338 class_23382 = INSTANCE.tempFindDepositSpace($nectereWorld, necterePos);
                if (class_23382 == null) {
                    class_23382 = necterePos;
                }
                class_2338 outPos = class_23382;
                $nectereWorld.method_8501(outPos, HotMBlocks.INSTANCE.getNECTERE_PORTAL().method_9564());
                $nectereWorld.method_8501(outPos.method_10084(), (class_2680)HotMBlocks.INSTANCE.getNECTERE_PORTAL().method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033));
                $nectereWorld.method_8501(outPos.method_10074(), HotMBlocks.INSTANCE.getGLOWY_OBELISK_PART().method_9564());
                $nectereWorld.method_8501(outPos.method_10086(2), HotMBlocks.INSTANCE.getGLOWY_OBELISK_PART().method_9564());
                $callback.invoke((Object)outPos);
            } else {
                $callback.invoke(null);
            }
        }
    }

    public static final /* synthetic */ boolean access$isValidPortal(HotMPortalFinders $this, class_3218 world, class_2338 portalPos) {
        return $this.isValidPortal(world, portalPos);
    }

    public static final /* synthetic */ class_2338 access$getNonNecterePortalPlacementForBiome(HotMPortalFinders $this, class_6872 placement, class_7869 calculator, class_1923 currentPos, class_3218 nectereWorld, NecterePortalData.Holder portalHolder, class_1923 necterePos) {
        return $this.getNonNecterePortalPlacementForBiome(placement, calculator, currentPos, nectereWorld, portalHolder, necterePos);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \r*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\r\u000eB\u0013\b\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0006\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult;", "T", "", "get", "()Ljava/lang/Object;", "", "isKeepSearching", "Z", "()Z", "obj", "Ljava/lang/Object;", "<init>", "(Ljava/lang/Object;)V", "Companion", "KeepSearching", "heart-of-the-machine"})
    public static final class FindResult<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Object obj;
        private final boolean isKeepSearching;

        private FindResult(Object obj) {
            this.obj = obj;
            this.isKeepSearching = Intrinsics.areEqual((Object)this.obj, (Object)KeepSearching.INSTANCE);
        }

        public final boolean isKeepSearching() {
            return this.isKeepSearching;
        }

        public final T get() {
            if (Intrinsics.areEqual((Object)this.obj, (Object)KeepSearching.INSTANCE)) {
                throw new IllegalStateException("Called get on non-done find result");
            }
            return (T)this.obj;
        }

        public /* synthetic */ FindResult(Object obj, DefaultConstructorMarker $constructor_marker) {
            this(obj);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\"\u0004\b\u0001\u0010\u00022\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\"\u0004\b\u0001\u0010\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult$Companion;", "", "T", "obj", "Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult;", "done", "(Ljava/lang/Object;)Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult;", "keepSearching", "()Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult;", "<init>", "()V", "heart-of-the-machine"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T> FindResult<T> done(T obj) {
                return new FindResult(obj, null);
            }

            @NotNull
            public final <T> FindResult<T> keepSearching() {
                return new FindResult(KeepSearching.INSTANCE, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders$FindResult$KeepSearching;", "", "<init>", "()V", "heart-of-the-machine"})
        private static final class KeepSearching {
            @NotNull
            public static final KeepSearching INSTANCE = new KeepSearching();

            private KeepSearching() {
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u0004\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u0019\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders$LocatePos;", "T", "", "Lnet/minecraft/class_1923;", "component1", "()Lnet/minecraft/class_1923;", "component2", "()Ljava/lang/Object;", "startChunk", "data", "copy", "(Lnet/minecraft/class_1923;Ljava/lang/Object;)Lcom/github/hotm/mod/world/HotMPortalFinders$LocatePos;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getData", "Lnet/minecraft/class_1923;", "getStartChunk", "<init>", "(Lnet/minecraft/class_1923;Ljava/lang/Object;)V", "heart-of-the-machine"})
    public static final class LocatePos<T> {
        @NotNull
        private final class_1923 startChunk;
        private final T data;

        public LocatePos(@NotNull class_1923 startChunk, T data) {
            Intrinsics.checkNotNullParameter((Object)startChunk, (String)"startChunk");
            this.startChunk = startChunk;
            this.data = data;
        }

        @NotNull
        public final class_1923 getStartChunk() {
            return this.startChunk;
        }

        public final T getData() {
            return this.data;
        }

        @NotNull
        public final class_1923 component1() {
            return this.startChunk;
        }

        public final T component2() {
            return this.data;
        }

        @NotNull
        public final LocatePos<T> copy(@NotNull class_1923 startChunk, T data) {
            Intrinsics.checkNotNullParameter((Object)startChunk, (String)"startChunk");
            return new LocatePos<T>(startChunk, data);
        }

        public static /* synthetic */ LocatePos copy$default(LocatePos locatePos, class_1923 class_19232, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                class_19232 = locatePos.startChunk;
            }
            if ((n & 2) != 0) {
                object = locatePos.data;
            }
            return locatePos.copy(class_19232, object);
        }

        @NotNull
        public String toString() {
            return "LocatePos(startChunk=" + this.startChunk + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result = this.startChunk.hashCode();
            result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocatePos)) {
                return false;
            }
            LocatePos locatePos = (LocatePos)other;
            if (!Intrinsics.areEqual((Object)this.startChunk, (Object)locatePos.startChunk)) {
                return false;
            }
            return Intrinsics.areEqual(this.data, locatePos.data);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004\u00a8\u0006\u001c"}, d2={"Lcom/github/hotm/mod/world/HotMPortalFinders$PortalPlacementResult;", "", "Lnet/minecraft/class_2338;", "component1", "()Lnet/minecraft/class_2338;", "Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;", "component2", "()Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;", "portalXZ", "portalHolder", "copy", "(Lnet/minecraft/class_2338;Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;)Lcom/github/hotm/mod/world/HotMPortalFinders$PortalPlacementResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;", "getPortalHolder", "Lnet/minecraft/class_2338;", "getPortalXZ", "<init>", "(Lnet/minecraft/class_2338;Lcom/github/hotm/mod/world/biome/NecterePortalData$Holder;)V", "heart-of-the-machine"})
    public static final class PortalPlacementResult {
        @NotNull
        private final class_2338 portalXZ;
        @NotNull
        private final NecterePortalData.Holder portalHolder;

        public PortalPlacementResult(@NotNull class_2338 portalXZ, @NotNull NecterePortalData.Holder portalHolder) {
            Intrinsics.checkNotNullParameter((Object)portalXZ, (String)"portalXZ");
            Intrinsics.checkNotNullParameter((Object)portalHolder, (String)"portalHolder");
            this.portalXZ = portalXZ;
            this.portalHolder = portalHolder;
        }

        @NotNull
        public final class_2338 getPortalXZ() {
            return this.portalXZ;
        }

        @NotNull
        public final NecterePortalData.Holder getPortalHolder() {
            return this.portalHolder;
        }

        @NotNull
        public final class_2338 component1() {
            return this.portalXZ;
        }

        @NotNull
        public final NecterePortalData.Holder component2() {
            return this.portalHolder;
        }

        @NotNull
        public final PortalPlacementResult copy(@NotNull class_2338 portalXZ, @NotNull NecterePortalData.Holder portalHolder) {
            Intrinsics.checkNotNullParameter((Object)portalXZ, (String)"portalXZ");
            Intrinsics.checkNotNullParameter((Object)portalHolder, (String)"portalHolder");
            return new PortalPlacementResult(portalXZ, portalHolder);
        }

        public static /* synthetic */ PortalPlacementResult copy$default(PortalPlacementResult portalPlacementResult, class_2338 class_23382, NecterePortalData.Holder holder, int n, Object object) {
            if ((n & 1) != 0) {
                class_23382 = portalPlacementResult.portalXZ;
            }
            if ((n & 2) != 0) {
                holder = portalPlacementResult.portalHolder;
            }
            return portalPlacementResult.copy(class_23382, holder);
        }

        @NotNull
        public String toString() {
            return "PortalPlacementResult(portalXZ=" + this.portalXZ + ", portalHolder=" + this.portalHolder + ")";
        }

        public int hashCode() {
            int result = this.portalXZ.hashCode();
            result = result * 31 + this.portalHolder.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PortalPlacementResult)) {
                return false;
            }
            PortalPlacementResult portalPlacementResult = (PortalPlacementResult)other;
            if (!Intrinsics.areEqual((Object)this.portalXZ, (Object)portalPlacementResult.portalXZ)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.portalHolder, (Object)portalPlacementResult.portalHolder);
        }
    }
}

