/*
 * Decompiled with CFR 0.152.
 */
package com.adibarra.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ADConfig {
    private final Map<String, String> config = new HashMap<String, String>();
    private final Logger LOGGER;
    private final String PREFIX;
    private File configFile;

    public ADConfig(String name, String configPath, String internalDefaultConfigPath) {
        this.LOGGER = LogManager.getLogger((String)name);
        this.PREFIX = "[" + name + "] [ADConfig] ";
        this.request(configPath, internalDefaultConfigPath);
    }

    private void request(String configPath, String internalDefaultConfigPath) {
        String filename = configPath.substring(configPath.lastIndexOf(47) + 1);
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve(filename).toFile();
        this.createConfig(this.configFile, internalDefaultConfigPath);
        List<String> configLines = this.loadFile(this.configFile);
        if (configLines.isEmpty()) {
            this.LOGGER.warn(this.PREFIX + "Config '{}' is blank! It is probably broken...", (Object)this.configFile.getName());
            this.deleteFile(this.configFile);
            return;
        }
        this.parseConfig(configLines, this.configFile.getName());
    }

    private void createConfig(File configFile, String internalDefaultConfigPath) {
        if (!configFile.exists()) {
            this.LOGGER.warn(this.PREFIX + "Failed to find '{}'. Generating default...", (Object)configFile.getName());
            try {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            catch (IOException e) {
                this.LOGGER.error(this.PREFIX + "Failed to create '{}'!", (Object)configFile.getName());
                this.LOGGER.trace((Object)e);
                return;
            }
            List<String> defaultConfigLines = this.loadInternalFile(internalDefaultConfigPath);
            if (defaultConfigLines == null) {
                this.LOGGER.error(this.PREFIX + "Failed to load default config file!");
                this.LOGGER.error(this.PREFIX + "Please report this to the mod author!");
                return;
            }
            if (this.writeFile(configFile, defaultConfigLines)) {
                this.LOGGER.info(this.PREFIX + "Generated new '{}'!", (Object)configFile.getName());
            }
        }
    }

    private boolean writeFile(File file, List<String> lines) {
        try {
            PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);
            writer.write(String.join((CharSequence)"\n", lines));
            writer.close();
            return true;
        }
        catch (IOException e) {
            this.LOGGER.error(this.PREFIX + "Failed to write '{}'!", (Object)file.getName());
            this.LOGGER.trace((Object)e);
            return false;
        }
    }

    private List<String> loadFile(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            List<String> lines = br.lines().collect(Collectors.toList());
            br.close();
            return lines;
        }
        catch (IOException e) {
            this.LOGGER.error(this.PREFIX + "Failed to load '{}'!", (Object)file.getName());
            this.LOGGER.trace((Object)e);
            return Collections.emptyList();
        }
    }

    private List<String> loadInternalFile(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(is)).lines().toList();
    }

    private void deleteFile(File file) {
        try {
            if (file.delete()) {
                this.LOGGER.info(this.PREFIX + "Deleted '{}'. Restart the game to regenerate it.", (Object)file.getName());
                return;
            }
            this.LOGGER.error(this.PREFIX + "Failed to delete '{}'! Is it in use?", (Object)file.getName());
        }
        catch (Exception e) {
            this.LOGGER.error(this.PREFIX + "Failed to delete '{}'!", (Object)file.getName());
            this.LOGGER.trace((Object)e);
        }
    }

    private void replaceValue(File file, String key, String value) {
        List<String> lines = this.loadFile(this.configFile);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.trim().toLowerCase().startsWith(key + "=")) continue;
            String spaces = line.substring(0, line.indexOf(key));
            lines.set(i, spaces + key + "=" + value);
            this.writeFile(this.configFile, lines);
            return;
        }
    }

    private void parseConfig(List<String> lines, String filename) {
        int lineNum = 0;
        for (String line : lines) {
            ++lineNum;
            if ((line = line.trim().toLowerCase()).isEmpty() || line.startsWith("#")) continue;
            String[] keyPair = line.split("=");
            if (keyPair.length != 2) {
                this.LOGGER.warn(this.PREFIX + "'{}' line {}: Found a syntax error! Skipping line...", (Object)filename, (Object)lineNum);
                continue;
            }
            this.config.put(keyPair[0].trim(), keyPair[1].trim());
        }
    }

    public boolean set(String key, String value) {
        if (this.config.containsKey(key)) {
            this.config.put(key, value);
            this.replaceValue(this.configFile, key, value);
            return true;
        }
        return false;
    }

    public List<Map.Entry<String, String>> getEntries() {
        return new ArrayList<Map.Entry<String, String>>(this.config.entrySet());
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.config.keySet());
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.config.values());
    }

    public String getOrDefault(String key, String def) {
        String val = this.config.get(key);
        return val == null ? def : val;
    }

    public boolean getOrDefault(String key, boolean def) {
        try {
            return Boolean.parseBoolean(this.config.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getOrDefault(String key, int def) {
        try {
            return Integer.parseInt(this.config.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getOrDefault(String key, double def) {
        try {
            return Double.parseDouble(this.config.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public float getOrDefault(String key, float def) {
        try {
            return Float.parseFloat(this.config.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }
}

