/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.modpatcher.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javassist.ClassPool;
import me.nallar.javapatcher.mappings.Mappings;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.javapatcher.patcher.Patches;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.minimallycorrect.mixin.internal.ApplicationType;
import org.minimallycorrect.mixin.internal.MixinApplicator;
import org.minimallycorrect.modpatcher.api.ClassLoaderPool;
import org.minimallycorrect.modpatcher.api.LaunchClassLoaderUtil;
import org.minimallycorrect.modpatcher.api.MCPMappings;
import org.minimallycorrect.modpatcher.api.PatcherLog;
import org.minimallycorrect.modpatcher.api.tweaker.ModPatcherTweaker;

public class ModPatcherTransformer {
    private static final String MOD_PATCHES_DIRECTORY = "./ModPatches/";
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.ModPatcher.alreadyLoaded";
    private static final String DUMP_PROPERTY_NAME = "nallar.ModPatcher.dump";
    private static final boolean DUMP = !System.getProperty("nallar.ModPatcher.dump", "").isEmpty();
    private static boolean classLoaderInitialised = false;
    private static boolean haveTransformedClasses;
    private static Patcher patcher;
    private static MixinApplicator mixinApplicator;

    private static Error logError(String message, Throwable t) {
        PatcherLog.error(message, t);
        return new Error(message, t);
    }

    private static void checkForMultipleClassLoads() {
        if (System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null) {
            Error e = ModPatcherTransformer.logError("Detected multiple classloads of ModPatcher - classloading issue?", new Throwable());
            if (!System.getProperty(ALREADY_LOADED_PROPERTY_NAME).equals("breakEverything")) {
                throw e;
            }
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
    }

    public static Patcher getPatcher() {
        if (patcher == null) {
            if (haveTransformedClasses) {
                throw new IllegalStateException("Too late to initialise patcher");
            }
            patcher = new Patcher((ClassPool)new ClassLoaderPool(), Patches.class, (Mappings)new MCPMappings());
        }
        return patcher;
    }

    private static void recursivelyAddXmlFiles(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        try {
            for (File f : files) {
                if (f.isDirectory()) {
                    ModPatcherTransformer.recursivelyAddXmlFiles(f);
                    continue;
                }
                if (f.getName().endsWith(".xml")) {
                    ModPatcherTransformer.getPatcher().readPatchesFromXmlInputStream((InputStream)new FileInputStream(f));
                    continue;
                }
                if (!f.getName().endsWith(".json")) continue;
                ModPatcherTransformer.getPatcher().readPatchesFromJsonInputStream((InputStream)new FileInputStream(f));
            }
        }
        catch (IOException e) {
            PatcherLog.warn("Failed to load patch", e);
        }
    }

    public static IClassTransformer getInstance() {
        return ClassTransformer.INSTANCE;
    }

    static void initialiseClassLoader(LaunchClassLoader classLoader) {
        if (classLoaderInitialised) {
            return;
        }
        classLoaderInitialised = true;
        LaunchClassLoaderUtil.instance = classLoader;
        ModPatcherTweaker.add();
        classLoader.addTransformerExclusion("org.minimallycorrect.modpatcher");
        classLoader.addTransformerExclusion("org.minimallycorrect.javatransformer");
        classLoader.addTransformerExclusion("org.minimallycorrect.mixin");
        classLoader.addTransformerExclusion("me.nallar.javapatcher");
        classLoader.addTransformerExclusion("javassist");
        classLoader.addTransformerExclusion("com.github.javaparser");
        LaunchClassLoaderUtil.addTransformer(ModPatcherTransformer.getInstance());
    }

    static String getDefaultPatchesDirectory() {
        return MOD_PATCHES_DIRECTORY;
    }

    static MixinApplicator getMixinApplicator() {
        MixinApplicator mixinApplicator = ModPatcherTransformer.mixinApplicator;
        if (mixinApplicator == null) {
            if (haveTransformedClasses) {
                throw new IllegalStateException("Too late to initialise mixin applicator");
            }
            ModPatcherTransformer.mixinApplicator = mixinApplicator = new MixinApplicator();
            mixinApplicator.setApplicationType(ApplicationType.FINAL_PATCH);
            mixinApplicator.setNoMixinIsError(true);
            mixinApplicator.setLog(PatcherLog::info);
        }
        return mixinApplicator;
    }

    static {
        PatcherLog.info("ModPatcher running under classloader " + ModPatcherTransformer.class.getClassLoader().getClass().getName());
        ModPatcherTransformer.checkForMultipleClassLoads();
        try {
            ModPatcherTransformer.recursivelyAddXmlFiles(new File(MOD_PATCHES_DIRECTORY));
        }
        catch (Throwable t) {
            throw ModPatcherTransformer.logError("Failed to load patches from ./ModPatches/", t);
        }
    }

    private static class ClassTransformer
    implements IClassTransformer {
        static IClassTransformer INSTANCE = new ClassTransformer();

        private ClassTransformer() {
        }

        private static void dumpIfEnabled(String name, byte[] data) {
            if (!DUMP || !name.contains("net.minecraft")) {
                return;
            }
            Path path = Paths.get("./DUMP/" + name + ".class", new String[0]);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, data, new OpenOption[0]);
            }
            catch (IOException e) {
                PatcherLog.error("Failed to dump class " + name, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] transform(String name, String transformedName, byte[] bytes) {
            Patcher patcher;
            haveTransformedClasses = true;
            ClassTransformer.dumpIfEnabled(transformedName + "_unpatched", bytes);
            byte[] originalBytes = bytes;
            MixinApplicator mixinApplicator = mixinApplicator;
            if (mixinApplicator != null) {
                bytes = (byte[])mixinApplicator.getMixinTransformer().transformClass(() -> originalBytes, transformedName).get();
            }
            if ((patcher = patcher) != null) {
                LaunchClassLoaderUtil.cacheSrgBytes(transformedName, bytes);
                try {
                    bytes = patcher.patch(transformedName, bytes);
                }
                catch (Throwable t) {
                    PatcherLog.error("Failed to patch " + transformedName, t);
                }
                finally {
                    LaunchClassLoaderUtil.releaseSrgBytes(transformedName);
                }
            }
            if (originalBytes != bytes) {
                ClassTransformer.dumpIfEnabled(transformedName, bytes);
            }
            return bytes;
        }
    }
}

