/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.modpatcher.api;

import LZMA.LzmaInputStream;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.nallar.javapatcher.mappings.ClassDescription;
import me.nallar.javapatcher.mappings.FieldDescription;
import me.nallar.javapatcher.mappings.Mappings;
import me.nallar.javapatcher.mappings.MethodDescription;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.minimallycorrect.modpatcher.api.PatcherLog;

class MCPMappings
extends Mappings {
    private static final Pattern classObfuscatePattern = Pattern.compile("\\^class:([^\\^]+)\\^", 40);
    private static final Pattern methodObfuscatePattern = Pattern.compile("\\^method:([^\\^/]+)/([^\\^/]+)\\^", 40);
    private static final Pattern fieldObfuscatePattern = Pattern.compile("\\^field:([^\\^/]+)/([^\\^/]+)\\^", 40);
    private final Map<String, String> methodSeargeMappings = new HashMap<String, String>();
    private final Map<String, String> fieldSeargeMappings = new HashMap<String, String>();
    private final BiMap<ClassDescription, ClassDescription> classMappings = HashBiMap.create();
    private final BiMap<MethodDescription, MethodDescription> methodMappings = HashBiMap.create();
    private final BiMap<MethodDescription, MethodDescription> methodSrgMappings = HashBiMap.create();
    private final Map<FieldDescription, FieldDescription> fieldSrgMappings = new HashMap<FieldDescription, FieldDescription>();
    private final Map<String, MethodDescription> parameterlessSrgMethodMappings = new HashMap<String, MethodDescription>();
    private final Map<String, String> shortClassNameToFullName = new HashMap<String, String>();
    private final Map<String, List<String>> extendsMap = new HashMap<String, List<String>>();

    MCPMappings() {
        try {
            MCPMappings.loadExtends((InputStream)new LzmaInputStream(Mappings.class.getResourceAsStream("/extendsMap.obj.lzma")), this.extendsMap);
            MCPMappings.loadCsv((InputStream)new LzmaInputStream(Mappings.class.getResourceAsStream("/methods.csv.lzma")), this.methodSeargeMappings);
            MCPMappings.loadCsv((InputStream)new LzmaInputStream(Mappings.class.getResourceAsStream("/fields.csv.lzma")), this.fieldSeargeMappings);
            this.loadSrg((InputStream)new LzmaInputStream(FMLInjectionData.class.getResourceAsStream("/deobfuscation_data-" + FMLInjectionData.data()[4] + ".lzma")));
        }
        catch (Exception e) {
            PatcherLog.error("Failed to load MCP mappings", e);
        }
        this.methodSeargeMappings.clear();
        this.fieldSeargeMappings.clear();
    }

    static void loadCsv(InputStream mappingsCsv, Map<String, String> seargeMappings) throws IOException {
        try (Scanner in = new Scanner(mappingsCsv);){
            in.useDelimiter(",");
            while (in.hasNextLine()) {
                String seargeName = in.next();
                String name = in.next();
                String side = in.next();
                in.nextLine();
                if (!"2".equals(side) && !"0".equals(side)) continue;
                seargeMappings.put(seargeName, name);
            }
        }
        mappingsCsv.close();
    }

    static void loadExtends(InputStream resourceAsStream, Map<String, List<String>> extendsMap) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                int split;
                if (line.isEmpty() || (split = line.indexOf(94)) == -1) continue;
                String a = line.substring(0, split);
                String b = line.substring(split + 1);
                extendsMap.computeIfAbsent(b, k -> new ArrayList()).add(a);
            }
        }
    }

    public MethodDescription map(MethodDescription methodDescription) {
        MethodDescription obfuscated = (MethodDescription)this.methodSrgMappings.get((Object)methodDescription);
        if (obfuscated == null) {
            obfuscated = this.parameterlessSrgMethodMappings.get(methodDescription.getShortName());
            if (methodDescription.isExact() || obfuscated == null) {
                obfuscated = methodDescription;
                obfuscated.obfuscateClasses();
            }
        }
        return obfuscated;
    }

    public MethodDescription unmap(MethodDescription methodDescription) {
        return (MethodDescription)this.methodSrgMappings.inverse().get((Object)methodDescription);
    }

    private String shortClassNameToFullClassName(String shortName) {
        return this.shortClassNameToFullName.get(shortName);
    }

    public ClassDescription map(ClassDescription classDescription) {
        return classDescription;
    }

    public FieldDescription map(FieldDescription fieldDescription) {
        return this.fieldSrgMappings.get(fieldDescription);
    }

    private String classStringToClassName(String name) {
        String mapped = this.shortClassNameToFullClassName(name);
        if (mapped != null) {
            name = mapped;
        }
        return this.map((ClassDescription)new ClassDescription((String)name)).name;
    }

    public String obfuscate(String code) {
        MethodDescription mapped;
        String className;
        StringBuffer result = new StringBuffer();
        Matcher methodMatcher = methodObfuscatePattern.matcher(code);
        while (methodMatcher.find()) {
            className = this.shortClassNameToFullClassName(methodMatcher.group(1));
            String methodDescriptionString = methodMatcher.group(2);
            if (className == null && !(className = methodMatcher.group(1)).contains(".")) {
                PatcherLog.error("Could not find " + methodMatcher.group(1));
                continue;
            }
            MethodDescription methodDescription = MethodDescription.fromString((String)className, (String)methodDescriptionString);
            mapped = this.map(methodDescription);
            methodMatcher.appendReplacement(result, mapped.name);
        }
        methodMatcher.appendTail(result);
        Matcher fieldMatcher = fieldObfuscatePattern.matcher(result);
        result = new StringBuffer();
        while (fieldMatcher.find()) {
            className = this.shortClassNameToFullClassName(fieldMatcher.group(1));
            String fieldName = fieldMatcher.group(2);
            if (className == null && !(className = fieldMatcher.group(1)).contains(".")) {
                PatcherLog.error("Could not find " + fieldMatcher.group(1));
                continue;
            }
            FieldDescription fieldDescription = new FieldDescription(className, fieldName);
            mapped = this.map(fieldDescription);
            if (mapped == null) {
                PatcherLog.error("Could not map " + fieldName);
                fieldMatcher.appendReplacement(result, fieldName);
                continue;
            }
            fieldMatcher.appendReplacement(result, mapped.name);
        }
        fieldMatcher.appendTail(result);
        Matcher classMatcher = classObfuscatePattern.matcher(result);
        result = new StringBuffer();
        while (classMatcher.find()) {
            className = this.classStringToClassName(classMatcher.group(1));
            if (className == null) {
                PatcherLog.error("Could not find " + classMatcher.group(1));
                continue;
            }
            classMatcher.appendReplacement(result, className);
        }
        classMatcher.appendTail(result);
        return result.toString();
    }

    private void loadSrg(InputStream mappings) throws IOException {
        Scanner srgScanner = new Scanner(mappings);
        while (srgScanner.hasNextLine()) {
            if (srgScanner.hasNext("CL:")) {
                srgScanner.next();
                String fromClass = srgScanner.next().replace('/', '.');
                String toClass = srgScanner.next().replace('/', '.');
                ClassDescription obfuscatedClass = new ClassDescription(fromClass);
                ClassDescription deobfuscatedClass = new ClassDescription(toClass);
                this.shortClassNameToFullName.put(deobfuscatedClass.name.substring(deobfuscatedClass.name.lastIndexOf(46) + 1), deobfuscatedClass.name);
                this.classMappings.put((Object)deobfuscatedClass, (Object)obfuscatedClass);
                continue;
            }
            if (srgScanner.hasNext("FD:")) {
                srgScanner.next();
                String obfuscatedMCPName = srgScanner.next();
                String seargeName = srgScanner.next();
                seargeName = seargeName.substring(seargeName.lastIndexOf(47) + 1);
                String deobfuscatedName = this.fieldSeargeMappings.get(seargeName);
                if (deobfuscatedName == null) {
                    deobfuscatedName = seargeName;
                }
                FieldDescription obfuscatedField = new FieldDescription(obfuscatedMCPName);
                FieldDescription deobfuscatedField = new FieldDescription(((ClassDescription)this.classMappings.inverse().get((Object)new ClassDescription((String)obfuscatedField.className))).name, deobfuscatedName);
                FieldDescription srgField = new FieldDescription(deobfuscatedField.className, seargeName);
                this.fieldSrgMappings.put(deobfuscatedField, srgField);
                this.recursiveExtendFieldMappings(deobfuscatedField, srgField);
                continue;
            }
            if (srgScanner.hasNext("MD:")) {
                srgScanner.next();
                String obfuscatedName = srgScanner.next();
                String obfuscatedTypeInfo = srgScanner.next();
                String seargeName = srgScanner.next();
                String deobfuscatedTypeInfo = srgScanner.next();
                String obfuscatedClassName = obfuscatedName.substring(0, obfuscatedName.lastIndexOf(47)).replace('/', '.');
                obfuscatedName = obfuscatedName.substring(obfuscatedName.lastIndexOf(47) + 1);
                String deobfuscatedClassName = seargeName.substring(0, seargeName.lastIndexOf(47)).replace('/', '.');
                seargeName = seargeName.substring(seargeName.lastIndexOf(47) + 1);
                String deobfuscatedName = this.methodSeargeMappings.get(seargeName);
                if (deobfuscatedName == null) {
                    deobfuscatedName = seargeName;
                }
                MethodDescription deobfuscatedMethodDescription = new MethodDescription(deobfuscatedClassName, deobfuscatedName, deobfuscatedTypeInfo);
                MethodDescription obfuscatedMethodDescription = new MethodDescription(obfuscatedClassName, obfuscatedName, obfuscatedTypeInfo);
                MethodDescription srgMethodDescription = new MethodDescription(deobfuscatedClassName, seargeName, deobfuscatedTypeInfo);
                this.methodMappings.put((Object)deobfuscatedMethodDescription, (Object)obfuscatedMethodDescription);
                this.methodSrgMappings.put((Object)deobfuscatedMethodDescription, (Object)srgMethodDescription);
                this.parameterlessSrgMethodMappings.put(deobfuscatedMethodDescription.getShortName(), srgMethodDescription);
                continue;
            }
            srgScanner.nextLine();
        }
        mappings.close();
    }

    private void recursiveExtendFieldMappings(FieldDescription deobfuscatedField, FieldDescription srgField) {
        List<String> extendedBy = this.extendsMap.get(deobfuscatedField.className);
        if (extendedBy == null) {
            return;
        }
        for (String className : extendedBy) {
            FieldDescription newDeobf = new FieldDescription(className, deobfuscatedField.name);
            FieldDescription newSrgField = new FieldDescription(className, srgField.name);
            this.fieldSrgMappings.put(newDeobf, newSrgField);
            this.recursiveExtendFieldMappings(newDeobf, newSrgField);
        }
    }
}

