/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.armorunder.ArmorUnderwear;
import org.jwaresoftware.mcmods.armorunder.ModConfig;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.JR;

public final class TLinedArmorRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final String _TAN = "toughasnails:";
    private static final String _MOD = "armorunder:";
    @GameRegistry.ItemStackHolder(value="toughasnails:wool_helmet")
    public static final ItemStack TAN_WARMER_LINING_HELMET = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:wool_chestplate")
    public static final ItemStack TAN_WARMER_LINING_CHESTPLATE = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:wool_leggings")
    public static final ItemStack TAN_WARMER_LINING_LEGGINGS = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:wool_boots")
    public static final ItemStack TAN_WARMER_LINING_BOOTS = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:jelled_slime_helmet")
    public static final ItemStack TAN_COOLER_LINING_HELMET = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:jelled_slime_chestplate")
    public static final ItemStack TAN_COOLER_LINING_CHESTPLATE = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:jelled_slime_leggings")
    public static final ItemStack TAN_COOLER_LINING_LEGGINGS = null;
    @GameRegistry.ItemStackHolder(value="toughasnails:jelled_slime_boots")
    public static final ItemStack TAN_COOLER_LINING_BOOTS = null;
    @GameRegistry.ItemStackHolder(value="armorunder:warm_helmet_liner")
    public static final ItemStack WARMER_LINING_HELMET = null;
    @GameRegistry.ItemStackHolder(value="armorunder:warm_chestplate_liner")
    public static final ItemStack WARMER_LINING_CHESTPLATE = null;
    @GameRegistry.ItemStackHolder(value="armorunder:warm_leggings_liner")
    public static final ItemStack WARMER_LINING_LEGGINGS = null;
    @GameRegistry.ItemStackHolder(value="armorunder:warm_boots_liner")
    public static final ItemStack WARMER_LINING_BOOTS = null;
    @GameRegistry.ItemStackHolder(value="armorunder:cool_helmet_liner")
    public static final ItemStack COOLER_LINING_HELMET = null;
    @GameRegistry.ItemStackHolder(value="armorunder:cool_chestplate_liner")
    public static final ItemStack COOLER_LINING_CHESTPLATE = null;
    @GameRegistry.ItemStackHolder(value="armorunder:cool_leggings_liner")
    public static final ItemStack COOLER_LINING_LEGGINGS = null;
    @GameRegistry.ItemStackHolder(value="armorunder:cool_boots_liner")
    public static final ItemStack COOLER_LINING_BOOTS = null;
    private static final List<Item> _LININGS = new ArrayList<Item>();
    private static final List<Item> _LININGS_WARMUP = new ArrayList<Item>();
    private static boolean ENABLED = false;
    private static boolean TAN_ENABLED = false;
    private final IRecipe _impl;
    private final int _max_thickness;

    private static boolean check(ItemStack ingredient, boolean warm) {
        boolean ok = false;
        if (!ItemStacks.isEmpty((ItemStack)ingredient)) {
            Item key = ingredient.func_77973_b();
            if (warm) {
                _LININGS_WARMUP.add(key);
            }
            ok = _LININGS.add(key);
        }
        return ok;
    }

    static final boolean initFinal(ModConfig config) {
        if (!TLinedArmorRecipe.check(WARMER_LINING_HELMET, true)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(WARMER_LINING_CHESTPLATE, true)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(WARMER_LINING_LEGGINGS, true)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(WARMER_LINING_BOOTS, true)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(COOLER_LINING_HELMET, false)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(COOLER_LINING_CHESTPLATE, false)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(COOLER_LINING_LEGGINGS, false)) {
            return false;
        }
        if (!TLinedArmorRecipe.check(COOLER_LINING_BOOTS, false)) {
            return false;
        }
        ENABLED = true;
        if (!config.isSuperCompatibilityMode() && ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            TLinedArmorRecipe.check(TAN_WARMER_LINING_HELMET, true);
            TLinedArmorRecipe.check(TAN_WARMER_LINING_CHESTPLATE, true);
            TLinedArmorRecipe.check(TAN_WARMER_LINING_LEGGINGS, true);
            TLinedArmorRecipe.check(TAN_WARMER_LINING_BOOTS, true);
            TLinedArmorRecipe.check(TAN_COOLER_LINING_HELMET, false);
            TLinedArmorRecipe.check(TAN_COOLER_LINING_CHESTPLATE, false);
            TLinedArmorRecipe.check(TAN_COOLER_LINING_LEGGINGS, false);
            TLinedArmorRecipe.check(TAN_COOLER_LINING_BOOTS, false);
            TAN_ENABLED = TAN_COOLER_LINING_BOOTS != null && TAN_WARMER_LINING_BOOTS != null;
        }
        Map<String, Item[]> others = config.getUnderwearReadyArmorAll();
        for (Map.Entry<String, Item[]> e : others.entrySet()) {
            for (Item item : e.getValue()) {
                if (!SharedGlue.isDefined((Item)item)) continue;
                ItemStack any_durability = new ItemStack(item, 1, Short.MAX_VALUE);
                OreDictionary.registerOre((String)e.getKey(), (ItemStack)any_durability);
                OreDictionary.registerOre((String)"itemArmor", (ItemStack)any_durability);
            }
        }
        if (config.isDebugMode()) {
            TLinedArmorRecipe.dumpDict();
        }
        return ENABLED;
    }

    static final List<IRecipe> addSampleRecipes(List<IRecipe> recipes) {
        if (ENABLED) {
            TLinedArmorRecipe.addRecipes(WARMER_LINING_HELMET, "itemHelmet", Armory.TLining.WARM, 2, recipes);
            TLinedArmorRecipe.addRecipes(COOLER_LINING_HELMET, "itemHelmet", Armory.TLining.COOL, 2, recipes);
            TLinedArmorRecipe.addRecipes(WARMER_LINING_BOOTS, "itemBoots", Armory.TLining.WARM, 1, recipes);
            TLinedArmorRecipe.addRecipes(COOLER_LINING_BOOTS, "itemBoots", Armory.TLining.COOL, 1, recipes);
            TLinedArmorRecipe.addRecipes(WARMER_LINING_CHESTPLATE, "itemChestplate", Armory.TLining.WARM, 3, recipes);
            TLinedArmorRecipe.addRecipes(COOLER_LINING_CHESTPLATE, "itemChestplate", Armory.TLining.COOL, 3, recipes);
            TLinedArmorRecipe.addRecipes(WARMER_LINING_LEGGINGS, "itemLeggings", Armory.TLining.WARM, 3, recipes);
            TLinedArmorRecipe.addRecipes(COOLER_LINING_LEGGINGS, "itemLeggings", Armory.TLining.COOL, 3, recipes);
            if (TAN_ENABLED) {
                TLinedArmorRecipe.addRecipes(TAN_WARMER_LINING_HELMET, "itemHelmet", Armory.TLining.WARM, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_COOLER_LINING_HELMET, "itemHelmet", Armory.TLining.COOL, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_WARMER_LINING_BOOTS, "itemBoots", Armory.TLining.WARM, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_COOLER_LINING_BOOTS, "itemBoots", Armory.TLining.COOL, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_WARMER_LINING_CHESTPLATE, "itemChestplate", Armory.TLining.WARM, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_COOLER_LINING_CHESTPLATE, "itemChestplate", Armory.TLining.COOL, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_WARMER_LINING_LEGGINGS, "itemLeggings", Armory.TLining.WARM, 1, recipes);
                TLinedArmorRecipe.addRecipes(TAN_COOLER_LINING_LEGGINGS, "itemLeggings", Armory.TLining.COOL, 1, recipes);
            }
        }
        return recipes;
    }

    TLinedArmorRecipe(Armory.TLining limit, IRecipe template) {
        this._impl = template;
        this._max_thickness = limit != Armory.TLining.NONE ? limit.getThickness() : Integer.MAX_VALUE;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStacks.NULLSTACK();
    }

    @Nullable
    private Armory.TLining newLining(ItemStack lining, ItemStack armorpiece) {
        int modifier;
        Armory.TLining cur_lining = Armory.getTLining((ItemStack)armorpiece);
        int n = modifier = _LININGS_WARMUP.contains(lining.func_77973_b()) ? 1 : -1;
        if (cur_lining != Armory.TLining.NONE) {
            boolean warm_lining;
            boolean bl = warm_lining = cur_lining.getOffsetModifier() > 0;
            if (warm_lining && modifier < 0) {
                return null;
            }
            if (!warm_lining && modifier > 0) {
                return null;
            }
        }
        Armory.TLining new_lining = cur_lining.adjust(modifier);
        int max_thickness = Math.min(ModConfig.getInstance().getLiningThicknessLimit(), this._max_thickness);
        return new_lining.equals((Object)cur_lining) || new_lining.getThickness() > max_thickness ? null : new_lining;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        boolean match;
        boolean bl = match = ENABLED && this._impl.func_77569_a(grid, world);
        if (match) {
            boolean found_armor = false;
            boolean found_lining = false;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next)) continue;
                Item item = next.func_77973_b();
                if (_LININGS.contains(item)) {
                    if (found_lining) {
                        return false;
                    }
                    found_lining = true;
                    continue;
                }
                if (!(item instanceof ItemArmor)) continue;
                if (found_armor) {
                    return false;
                }
                found_armor = true;
            }
            if (!found_armor || !found_lining) {
                match = false;
            }
        }
        return match;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = ItemStacks.NULLSTACK();
        if (ENABLED) {
            Armory.TLining new_lining;
            ItemStack lining = null;
            ItemStack armorpiece = null;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next)) continue;
                Item item = next.func_77973_b();
                if (_LININGS.contains(item)) {
                    if (next.func_77951_h() && ItemStacks.getDurabilityLeft((ItemStack)next) < 0.75f) {
                        return out;
                    }
                    lining = next;
                    continue;
                }
                if (!(item instanceof ItemArmor)) continue;
                armorpiece = next;
            }
            if (lining != null && armorpiece != null && !Armory.hasXLining((Armory.XLining)Armory.XLining.TEMPERATURE_REGULATOR, armorpiece) && (new_lining = this.newLining(lining, armorpiece)) != null) {
                out = ItemStacks.copyItemStackSingle(armorpiece);
                out = Armory.setTLining((ItemStack)out, (Armory.TLining)new_lining);
            }
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
    }

    private static final void dumpDict() {
        String[] dictKeys;
        Logger log = ArmorUnderwear.runtime.getLog();
        for (String k : dictKeys = new String[]{"itemBoots", "itemChestplate", "itemHelmet", "itemLeggings"}) {
            for (ItemStack a : OreDictionary.getOres((String)k, (boolean)false)) {
                log.info("Di: {}: {}", (Object)k, a.func_77973_b().getRegistryName() != null ? a.func_77973_b().getRegistryName() : a);
            }
        }
    }

    private static final void addRecipes(ItemStack lining, String shared_key, Armory.TLining lining_type, int max, List<IRecipe> recipes) {
        int direction = lining_type.getDirection();
        for (ItemStack unlined : OreDictionary.getOres((String)shared_key, (boolean)false)) {
            ItemStack input = ItemStacks.copyItemStackSingle((ItemStack)unlined);
            Item item = input.func_77973_b();
            if (_LININGS.contains(item) || !(item instanceof ItemArmor)) continue;
            input.func_77964_b(0);
            ItemStack lined_curr = input.func_77946_l();
            ItemStack lined_next = Armory.setTLining((ItemStack)input.func_77946_l(), (Armory.TLining)lining_type);
            ShapelessOreRecipe r = new ShapelessOreRecipe(null, lined_next, new Object[]{lined_curr, lining});
            recipes.add((IRecipe)r);
            if (max == 1) continue;
            lined_curr = lined_next;
            lined_next = Armory.setTLining((ItemStack)input.func_77946_l(), (Armory.TLining)lining_type.adjust(1 * direction));
            r = new ShapelessOreRecipe(null, lined_next, new Object[]{lined_curr, lining});
            recipes.add((IRecipe)r);
            if (max == 2) continue;
            lined_curr = lined_next;
            lined_next = Armory.setTLining((ItemStack)input.func_77946_l(), (Armory.TLining)lining_type.adjust(2 * direction));
            r = new ShapelessOreRecipe(null, lined_next, new Object[]{lined_curr, lining});
            recipes.add((IRecipe)r);
        }
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            Armory.TLining limit = Armory.TLining.NONE;
            String modifiername = JsonUtils.func_151219_a((JsonObject)json, (String)"limit", (String)"");
            if (!modifiername.isEmpty()) {
                limit = Armory.TLining.findOrNone((String)modifiername);
            }
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            impl = new JR.LegacyShapelessOreRecipe(null, impl);
            return new TLinedArmorRecipe(limit, (IRecipe)impl);
        }
    }
}

