/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers.entities;

import funwayguy.epicsiegemod.capabilities.modified.CapabilityModifiedHandler;
import funwayguy.epicsiegemod.capabilities.modified.IModifiedHandler;
import funwayguy.epicsiegemod.config.EsmConfigGlobal;
import funwayguy.epicsiegemod.config.props.CfgProps;
import funwayguy.epicsiegemod.core.ESM;
import java.io.File;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class GeneralEntityHandler {
    private final ResourceLocation DIM_MODIFIER = new ResourceLocation("epicsiegemod", "general_spawn");
    private final UUID attModHP = UUID.fromString("74dcd479-97f3-4a04-b84a-0ffab0863a4f");
    private final UUID attModSP = UUID.fromString("2e1a9c33-bbd9-4daf-a723-e598e41ddeb9");
    private final UUID attModAT = UUID.fromString("7dd7b301-055b-4bf1-b94a-2a47a6338ca1");
    private final UUID attModKB = UUID.fromString("321eab99-4946-4375-a693-c0dce3706b6d");
    private static float curBossMod = 0.0f;
    private File worldDir = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        double creeperJocky;
        if (event.getWorld().field_72995_K || event.getEntity().field_70128_L || event.isCanceled() || !(event.getEntity() instanceof EntityMob)) {
            return;
        }
        EntityMob entityMob = (EntityMob)event.getEntity();
        EntityEntry ee = EntityRegistry.getEntry(entityMob.getClass());
        if (ee == null || EsmConfigGlobal.AIExempt.contains(ee.getRegistryName())) {
            return;
        }
        IModifiedHandler modHandler = (IModifiedHandler)entityMob.getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
        if (modHandler == null) {
            return;
        }
        double healthMult = ((Number)CfgProps.MOD_HEALTH.get((Entity)entityMob)).doubleValue() + ((Boolean)CfgProps.BOSS_HEALTH.get((Entity)entityMob) != false ? (double)curBossMod : 0.0);
        double damageMult = ((Number)CfgProps.MOD_DAMAGE.get((Entity)entityMob)).doubleValue() + ((Boolean)CfgProps.BOSS_DAMAGE.get((Entity)entityMob) != false ? (double)curBossMod : 0.0);
        double speedMult = ((Number)CfgProps.MOD_SPEED.get((Entity)entityMob)).doubleValue() + ((Boolean)CfgProps.BOSS_SPEED.get((Entity)entityMob) != false ? (double)curBossMod : 0.0);
        double knockbackMult = ((Number)CfgProps.MOD_KNOCKBACK.get((Entity)entityMob)).doubleValue() + ((Boolean)CfgProps.BOSS_KNOCKBACK.get((Entity)entityMob) != false ? (double)curBossMod : 0.0);
        if (!modHandler.getModificationData(this.DIM_MODIFIER).func_74767_n("hasModifiers")) {
            if (healthMult != 1.0) {
                boolean fullHeal = entityMob.func_110143_aJ() < entityMob.func_110138_aP();
                entityMob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(this.attModHP, "ESM_TWEAK_1", healthMult, 1));
                if (fullHeal) {
                    entityMob.func_70606_j(entityMob.func_110138_aP());
                }
            }
            if (speedMult != 1.0) {
                entityMob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(this.attModSP, "ESM_TWEAK_2", speedMult, 1));
            }
            if (damageMult != 1.0) {
                entityMob.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(this.attModAT, "ESM_TWEAK_3", damageMult, 1));
            }
            if (knockbackMult != 1.0) {
                entityMob.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(this.attModKB, "ESM_TWEAK_4", knockbackMult, 1));
            }
            modHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("hasModifiers", true);
        }
        if ((creeperJocky = ((Number)CfgProps.CR_JOCKY.get((Entity)entityMob)).doubleValue()) > 0.0 && !modHandler.getModificationData(this.DIM_MODIFIER).func_74767_n("checkMobBomb") && entityMob.func_184188_bt().size() == 0 && entityMob.func_184187_bx() == null && entityMob.field_70170_p.field_72996_f.size() < 512 && (creeperJocky >= 100.0 || entityMob.func_70681_au().nextDouble() * 100.0 < creeperJocky)) {
            EntityCreeper passenger = new EntityCreeper(entityMob.field_70170_p);
            IModifiedHandler passHandler = (IModifiedHandler)passenger.getCapability(CapabilityModifiedHandler.MODIFIED_HANDLER_CAPABILITY, null);
            if (passHandler != null) {
                passHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("checkMobBomb", true);
            }
            passenger.func_70012_b(entityMob.field_70165_t, entityMob.field_70163_u, entityMob.field_70161_v, entityMob.field_70177_z, 0.0f);
            passenger.func_180482_a(entityMob.field_70170_p.func_175649_E(new BlockPos((Entity)entityMob)), null);
            entityMob.field_70170_p.func_72838_d((Entity)passenger);
            passenger.func_184220_m((Entity)entityMob);
            for (EntityPlayer playersNear : entityMob.field_70170_p.field_73010_i) {
                if (!(playersNear instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)playersNear).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers((Entity)passenger));
            }
        }
        modHandler.getModificationData(this.DIM_MODIFIER).func_74757_a("checkMobBomb", true);
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || event.getEntity().func_184222_aU()) {
            return;
        }
        curBossMod = Math.min(EsmConfigGlobal.bossModCap, curBossMod + EsmConfigGlobal.bossModifier);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || this.worldDir != null) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71278_l()) {
            return;
        }
        this.worldDir = ESM.proxy.isClient() ? server.func_71209_f("saves/" + server.func_71270_I()) : server.func_71209_f(server.func_71270_I());
        try {
            NBTTagCompound wmTag = CompressedStreamTools.func_74797_a((File)new File(this.worldDir, "ESM.dat"));
            curBossMod = wmTag == null ? 0.0f : Math.min(EsmConfigGlobal.bossModCap, wmTag.func_74760_g("BossModifier"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71278_l()) {
            curBossMod = 0.0f;
            this.worldDir = null;
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K || this.worldDir == null) {
            return;
        }
        try {
            NBTTagCompound wmTag = new NBTTagCompound();
            wmTag.func_74776_a("BossModifier", curBossMod);
            CompressedStreamTools.func_74795_b((NBTTagCompound)wmTag, (File)new File(this.worldDir, "ESM.dat"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

