/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import funwayguy.epicsiegemod.ai.ESM_EntityAIPillarUp;
import funwayguy.epicsiegemod.config.EsmConfig;
import funwayguy.epicsiegemod.config.EsmConfigGlobal;
import funwayguy.epicsiegemod.config.EsmJsonConfig;
import funwayguy.epicsiegemod.config.JsonHelper;
import funwayguy.epicsiegemod.config.props.CfgProps;
import funwayguy.epicsiegemod.core.ESM;
import java.io.File;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static Configuration config;
    private static final String CAT_MAIN = "General";
    private static final String CAT_ADVANCED = "Other";
    private static final String CAT_DEBUG = "Debug";

    public static void initConfigs() {
        JsonObject aiJson;
        if (config == null) {
            ESM.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
            return;
        }
        config.load();
        EsmConfigGlobal.hardDay = config.getInt("Hardcore Day Cycle", CAT_MAIN, 8, 0, Integer.MAX_VALUE, "The interval in which 'hard' days will occur where mob spawning is increased and lighting is ignored (0 = off, default = 8/full moon)");
        EsmConfigGlobal.TargetCap = config.getInt("Pathing Cap", CAT_MAIN, 16, 0, 128, "Maximum number of attackers per target");
        EsmConfigGlobal.AllowSleep = config.getBoolean("Allow Sleep", CAT_MAIN, false, "Prevents players skipping the night through sleep");
        EsmConfigGlobal.ResistanceCoolDown = config.getInt("Resistance Cooldown", CAT_MAIN, 200, 0, Integer.MAX_VALUE, "Temporary invulnerability in ticks when respawning and teleporting");
        EsmConfigGlobal.AIExempt.clear();
        for (String s : config.getStringList("AI Blacklist", CAT_MAIN, new String[]{"minecraft:villager_golem"}, "Mobs that are exempt from AI modifications")) {
            EsmConfigGlobal.AIExempt.add(new ResourceLocation(s));
        }
        EsmConfigGlobal.altChunkCache = config.getBoolean("Alt Chunk Caching", CAT_ADVANCED, true, "Can fix some issues with long distance navigation pathing through unloaded chunks");
        EsmConfigGlobal.bossModifier = config.getFloat("Boss Kill Modifier", CAT_ADVANCED, 0.1f, 0.0f, Float.MAX_VALUE, "The factor by which mob health and damage multipliers will be increased when bosses are killed");
        EsmConfigGlobal.bossModCap = config.getFloat("Boss Modifier Cap", CAT_ADVANCED, 3.0f, 0.0f, Float.MAX_VALUE, "The upper limit of the Boss Kill Modifier");
        EsmJsonConfig cfgSet = EsmConfig.getConfig(null);
        File cfgFile = new File("config/esm/entity_ai.json");
        if (cfgFile.exists()) {
            aiJson = JsonHelper.readFromFile(cfgFile);
            cfgSet.readJson(aiJson);
            ConfigHandler.migrateOld();
        } else {
            cfgSet.resetToDefault();
            ConfigHandler.migrateOld();
            aiJson = cfgSet.writeJson(new JsonObject());
        }
        JsonHelper.writeToFile(cfgFile, (JsonElement)aiJson);
        config.save();
        ESM_EntityAIPillarUp.updateBlock = true;
    }

    private static void migrateOld() {
        ConfigCategory catOther;
        ConfigCategory catMain = config.getCategory(CAT_MAIN);
        if (catMain.containsKey("Awareness Radius")) {
            CfgProps.AWARENESS.setDef(catMain.get("Awareness Radius").getInt());
            catMain.remove((Object)"Awareness Radius");
        }
        if (config.hasKey(CAT_MAIN, "Xray Mobs")) {
            CfgProps.XRAY_VIEW.setDef(catMain.get("Xray Mobs").getInt());
            catMain.remove((Object)"Xray Mobs");
        }
        if (catMain.containsKey("Villager Targeting")) {
            CfgProps.ATK_VILLAGER.setDef(catMain.get("Villager Targeting").getBoolean());
            catMain.remove((Object)"Villager Targeting");
        }
        if (catMain.containsKey("Chaos Mode")) {
            CfgProps.ATK_ALL.setDef(catMain.get("Chaos Mode").getBoolean());
            catMain.remove((Object)"Attack Pets");
        }
        if (catMain.containsKey("Attack Pets")) {
            CfgProps.ATK_PETS.setDef(catMain.get("Attack Pets").getBoolean());
            catMain.remove((Object)"Attack Pets");
        }
        if (config.hasCategory("Creepers")) {
            ConfigCategory catCreeper = config.getCategory("Creepers");
            if (catCreeper.containsKey("Breaching")) {
                CfgProps.CR_BREACH.setDef(catCreeper.get("Breaching").getBoolean());
                catCreeper.remove((Object)"Breaching");
            }
            if (catCreeper.containsKey("Napalm")) {
                CfgProps.CR_FIRE.setDef(catCreeper.get("Napalm").getBoolean());
                catCreeper.remove((Object)"Napalm");
            }
            if (catCreeper.containsKey("Powered Rarity")) {
                CfgProps.CR_POWERED.setDef((double)catCreeper.get("Powered Rarity").getInt() / 100.0);
                catCreeper.remove((Object)"Powered Rarity");
            }
            if (catCreeper.containsKey("Walking Fuse")) {
                CfgProps.CR_FUSE.setDef(catCreeper.get("Walking Fuse").getBoolean());
                catCreeper.remove((Object)"Walking Fuse");
            }
            if (catCreeper.containsKey("Creeper")) {
                CfgProps.CR_CENA.setDef((double)catCreeper.get("Creeper").getInt() / 100.0);
                catCreeper.remove((Object)"Creeper");
            } else if (catCreeper.containsKey("Cena Creeper")) {
                CfgProps.CR_CENA.setDef((double)catCreeper.get("Cena Creeper").getInt() / 100.0);
                catCreeper.remove((Object)"Cena Creeper");
            }
            if (catCreeper.containsKey("Creeper Jockey Chance")) {
                String[] crJocks;
                double val = (double)catCreeper.get("Creeper Jockey Chance").getInt() / 100.0;
                if (catCreeper.containsKey("All Creeper Jockeys")) {
                    CfgProps.CR_JOCKY.setDef(val);
                } else if (catCreeper.containsKey("Creeper Jocky Mobs") && (crJocks = catCreeper.get("Creeper Jocky Mobs").getStringList()) != null && crJocks.length > 0) {
                    for (String s : crJocks) {
                        try {
                            CfgProps.CR_JOCKY.set(new ResourceLocation(s), null, val);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catCreeper.remove((Object)"Creeper Jockey Chance");
            catCreeper.remove((Object)"All Creeper Jockeys");
            catCreeper.remove((Object)"Creeper Jocky Mobs");
            config.removeCategory(catCreeper);
        }
        if (config.hasCategory("Skeletons")) {
            ConfigCategory catSkele = config.getCategory("Skeletons");
            if (catSkele.containsKey("Arrow Error")) {
                CfgProps.RANGE_ERR.setDef(catSkele.get("Arrow Error").getInt());
                catSkele.remove((Object)"Arrow Error");
            }
            if (catSkele.containsKey("Fire Distance")) {
                CfgProps.RANGE_DIST.setDef(catSkele.get("Fire Distance").getInt());
                catSkele.remove((Object)"Fire Distance");
            }
            if (catSkele.containsKey("Wither Skeleton Chance")) {
                CfgProps.WITHER_SKEL.setDef((double)catSkele.get("Wither Skeleton Chance").getInt() / 100.0);
                catSkele.remove((Object)"Wither Skeleton Chance");
            }
            config.removeCategory(catSkele);
        }
        if ((catOther = config.getCategory(CAT_ADVANCED)).containsKey("Evasive AI")) {
            CfgProps.STRAFE.setDef(catOther.get("Evasive AI").getBoolean());
            catOther.remove((Object)"Evasive AI");
        }
        if (catOther.containsKey("Boss Mod Damage")) {
            CfgProps.BOSS_DAMAGE.setDef(catOther.get("Boss Mod Damage").getBoolean());
            catOther.remove((Object)"Boss Mod Damage");
        }
        if (catOther.containsKey("Boss Mod Health")) {
            CfgProps.BOSS_HEALTH.setDef(catOther.get("Boss Mod Health").getBoolean());
            catOther.remove((Object)"Boss Mod Health");
        }
        if (catOther.containsKey("Boss Mod Speed")) {
            CfgProps.BOSS_SPEED.setDef(catOther.get("Boss Mod Speed").getBoolean());
            catOther.remove((Object)"Boss Mod Speed");
        }
        if (catOther.containsKey("Boss Mod Knockback Resist")) {
            CfgProps.BOSS_KNOCKBACK.setDef(catOther.get("Boss Mod Knockback Resist").getBoolean());
            catOther.remove((Object)"Boss Mod Knockback Resist");
        }
        if (catOther.containsKey("Animals Retaliate")) {
            CfgProps.ANIMAL_RET.setDef(catOther.get("Animals Retaliate").getBoolean());
            catOther.remove((Object)"Animals Retaliate");
        }
        if (catOther.containsKey("Neutral Mobs")) {
            CfgProps.PASSIVE.setDef(catOther.get("Neutral Mobs").getBoolean());
            catOther.remove((Object)"Neutral Mobs");
        }
        if (catOther.containsKey("Digging Mobs")) {
            String[] digList = catOther.get("Digging Mobs").getStringList();
            if (digList != null && digList.length > 0) {
                for (String s : digList) {
                    try {
                        ResourceLocation res = new ResourceLocation(s);
                        CfgProps.DIGGING.set(res, null, true);
                        CfgProps.GRIEF.set(res, null, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catOther.remove((Object)"Digging Mobs");
        }
        if (catOther.containsKey("Digging Tools Only")) {
            CfgProps.DIG_TOOLS.setDef(catOther.get("Digging Tools Only").getBoolean());
            catOther.remove((Object)"Digging Tools Only");
        }
        if (catOther.containsKey("Invert Digging Blacklist")) {
            CfgProps.DIG_BL_INV.setDef(catOther.get("Invert Digging Blacklist").getBoolean());
            catOther.remove((Object)"Invert Digging Blacklist");
        }
        if (catOther.containsKey("Digging Blacklist")) {
            String[] digBL = catOther.get("Digging Blacklist").getStringList();
            if (digBL != null && digBL.length > 0) {
                CfgProps.DIG_BL.setDef((String)((Object)Arrays.asList(digBL)));
            }
            catOther.remove((Object)"Digging Blacklist");
        }
        if (catOther.containsKey("Demolition Mobs") && catOther.containsKey("Demolition Chance")) {
            double demoChance = (double)catOther.get("Demolition Chance").getInt() / 100.0;
            String[] digList = catOther.get("Demolition Mobs").getStringList();
            if (digList != null && digList.length > 0) {
                for (String s : digList) {
                    try {
                        CfgProps.DEMOLITION.set(new ResourceLocation(s), null, demoChance);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catOther.remove((Object)"Demolition Mobs");
        catOther.remove((Object)"Demolition Chance");
        if (catOther.containsKey("General Griefable Blocks")) {
            String[] griefList = catOther.get("General Griefable Blocks").getStringList();
            if (griefList != null && griefList.length > 0) {
                CfgProps.GRIEF_BLOCKS.setDef((String)((Object)Arrays.asList(griefList)));
            }
            catOther.remove((Object)"General Griefable Blocks");
        }
        if (catOther.containsKey("Building Mobs")) {
            String[] digList = catOther.get("Building Mobs").getStringList();
            if (digList != null && digList.length > 0) {
                for (String s : digList) {
                    try {
                        CfgProps.PILLAR.set(new ResourceLocation(s), null, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catOther.remove((Object)"Building Mobs");
        }
        if (catOther.containsKey("Pillar Block")) {
            CfgProps.PILLAR_BLOCK.setDef(catOther.get("Pillar Block").getString());
            catOther.remove((Object)"Building Block");
        }
        if (catOther.containsKey("Player Teleport")) {
            CfgProps.EN_TELE.setDef(catOther.get("Player Teleport").getBoolean());
            catOther.remove((Object)"Player Teleport");
        }
        if (catOther.containsKey("Webbing Chance")) {
            double val = (double)catOther.get("Webbing Chance").getInt() / 100.0;
            CfgProps.SP_WEB.set(new ResourceLocation("minecraft", "spider"), null, val);
            CfgProps.SP_WEB.set(new ResourceLocation("minecraft", "cave_spider"), null, val);
            catOther.remove((Object)"Webbing Chance");
        }
        if (catOther.containsKey("Infectious Zombies")) {
            CfgProps.INFECTIONS.set(new ResourceLocation("minecraft", "zombie"), null, catOther.get("Infectious Zombies").getBoolean());
            catOther.remove((Object)"Infectious Zombies");
        }
        if (catOther.containsKey("Witch Potions")) {
            String[] pots = catOther.get("Witch Potions").getStringList();
            if (pots != null && pots.length > 0) {
                CfgProps.POTION_TH.setDef((String)((Object)Arrays.asList(pots)));
            }
            catOther.remove((Object)"Witch Potions");
        }
    }
}

