/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config.props;

import funwayguy.epicsiegemod.config.CfgCategory;
import funwayguy.epicsiegemod.config.CfgProperty;
import funwayguy.epicsiegemod.config.types.CfgPropBoolean;
import funwayguy.epicsiegemod.config.types.CfgPropList;
import funwayguy.epicsiegemod.config.types.CfgPropNumber;
import funwayguy.epicsiegemod.config.types.CfgPropString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;

public class CfgProps {
    public static final CfgCategory CAT_ROOT = new CfgCategory(null);
    public static final CfgCategory CAT_DIGGING = new CfgCategory("Digging");
    public static final CfgCategory CAT_BUILDING = new CfgCategory("Building");
    public static final CfgCategory CAT_CREEPER = new CfgCategory("Creepers");
    public static final CfgCategory CAT_RANGED = new CfgCategory("Ranged");
    public static final CfgCategory CAT_ATTRIBUTE = new CfgCategory("Attributes");
    private static final List<String> POT_DEF = Arrays.asList(PotionTypes.field_185252_x.getRegistryName() + ":1:0", PotionTypes.field_185246_r.getRegistryName() + ":200:0", MobEffects.field_76440_q.getRegistryName() + ":200:0", MobEffects.field_76436_u.getRegistryName() + ":200:0", MobEffects.field_76437_t.getRegistryName() + ":200:1", MobEffects.field_76419_f.getRegistryName() + ":200:2");
    private static final List<String> GRF_DEF = Arrays.asList("minecraft:chest", "minecraft:furnace", "minecraft:crafting_table", "minecraft:melon_stem", "minecraft:pumpkin_stem", "minecraft:fence_gate", "minecraft:melon_block", "minecraft:pumpkin", "minecraft:glass", "minecraft:glass_pane", "minecraft:stained_glass", "minecraft:stained_glass_pane", "minecraft:carrots", "minecraft:potatoes", "minecraft:brewing_stand", "minecraft:enchanting_table", "minecraft:cake", "minecraft:ladder", "minecraft:wooden_door", "minecraft:farmland", "minecraft:bookshelf", "minecraft:sapling", "minecraft:bed", "minecraft:fence", "minecraft:planks");
    private static final List<CfgProperty> ALL_CFGS = new ArrayList<CfgProperty>();
    public static final CfgPropNumber AWARENESS = CfgProps.addConfig(new CfgPropNumber("Awareness Radius", 64));
    public static final CfgPropNumber XRAY_VIEW = CfgProps.addConfig(new CfgPropNumber("Xray Distance", 64));
    public static final CfgPropBoolean ATK_ALL = CfgProps.addConfig(new CfgPropBoolean("Attack Everything", false));
    public static final CfgPropBoolean ATK_PETS = CfgProps.addConfig(new CfgPropBoolean("Attack Pets", true));
    public static final CfgPropBoolean ATK_VILLAGER = CfgProps.addConfig(new CfgPropBoolean("Attack Villagers", true));
    public static final CfgPropBoolean PASSIVE = CfgProps.addConfig(new CfgPropBoolean("Neutral Mob", false));
    public static final CfgPropBoolean STRAFE = CfgProps.addConfig(new CfgPropBoolean("Strafe Evade", false));
    public static final CfgPropBoolean ANIMAL_RET = CfgProps.addConfig(new CfgPropBoolean("Animal Retaliate", true));
    public static final CfgPropNumber RANGE_DIST = CfgProps.addConfig(new CfgPropNumber("Ranged Atk Dist", 48), CAT_RANGED);
    public static final CfgPropNumber RANGE_ERR = CfgProps.addConfig(new CfgPropNumber("Ranged Atk Error", 0), CAT_RANGED);
    public static final CfgPropList<String> ARROW_POT = CfgProps.addConfig(CfgPropList.asString("Arrow Tips", Collections.singletonList("minecraft:slowness:60:0")), CAT_RANGED);
    public static final CfgPropList<String> POTION_TH = CfgProps.addConfig(CfgPropList.asString("Thrown Potions", POT_DEF), CAT_RANGED);
    public static final CfgPropBoolean PILLAR = CfgProps.addConfig(new CfgPropBoolean("Pillaring", false), CAT_BUILDING);
    public static final CfgPropString PILLAR_BLOCK = CfgProps.addConfig(new CfgPropString("Pillar Block", "minecraft:cobblestone:0"), CAT_BUILDING);
    public static final CfgPropBoolean DIGGING = CfgProps.addConfig(new CfgPropBoolean("Digging", false), CAT_DIGGING);
    public static final CfgPropList<String> DIG_BL = CfgProps.addConfig(CfgPropList.asString("Digging Blacklist", Collections.emptyList()), CAT_DIGGING);
    public static final CfgPropBoolean DIG_BL_INV = CfgProps.addConfig(new CfgPropBoolean("Invert Blacklist", false), CAT_DIGGING);
    public static final CfgPropBoolean DIG_TOOLS = CfgProps.addConfig(new CfgPropBoolean("Requires Tools", true), CAT_DIGGING);
    public static final CfgPropBoolean GRIEF = CfgProps.addConfig(new CfgPropBoolean("Griefing", false), CAT_DIGGING);
    public static final CfgPropList<String> GRIEF_BLOCKS = CfgProps.addConfig(CfgPropList.asString("Grief Targets", GRF_DEF), CAT_DIGGING);
    public static final CfgPropNumber DEMOLITION = CfgProps.addConfig(new CfgPropNumber("Demolition", 0.1), CAT_DIGGING);
    public static final CfgPropNumber SP_WEB = CfgProps.addConfig(new CfgPropNumber("Spider Webbing", 25.0));
    public static final CfgPropBoolean EN_TELE = CfgProps.addConfig(new CfgPropBoolean("Ender-Tele-Target", true));
    public static final CfgPropBoolean INFECTIONS = CfgProps.addConfig(new CfgPropBoolean("Infectious", false));
    public static final CfgPropNumber WITHER_SKEL = CfgProps.addConfig(new CfgPropNumber("Wither Skeletons", 0.1));
    public static final CfgPropNumber CR_JOCKY = CfgProps.addConfig(new CfgPropNumber("Jockey", 0.0), CAT_CREEPER);
    public static final CfgPropNumber CR_POWERED = CfgProps.addConfig(new CfgPropNumber("Powered", 0.1), CAT_CREEPER);
    public static final CfgPropBoolean CR_FUSE = CfgProps.addConfig(new CfgPropBoolean("Walking Fuse", true), CAT_CREEPER);
    public static final CfgPropBoolean CR_FIRE = CfgProps.addConfig(new CfgPropBoolean("Napalm", true), CAT_CREEPER);
    public static final CfgPropBoolean CR_BREACH = CfgProps.addConfig(new CfgPropBoolean("Breaching", true), CAT_CREEPER);
    public static final CfgPropNumber CR_CENA = CfgProps.addConfig(new CfgPropNumber("Cena", 0.01), CAT_CREEPER);
    public static final CfgPropNumber MOD_HEALTH = CfgProps.addConfig(new CfgPropNumber("Health", 1.0), CAT_ATTRIBUTE);
    public static final CfgPropNumber MOD_DAMAGE = CfgProps.addConfig(new CfgPropNumber("Damage", 1.0), CAT_ATTRIBUTE);
    public static final CfgPropNumber MOD_SPEED = CfgProps.addConfig(new CfgPropNumber("Speed", 1.0), CAT_ATTRIBUTE);
    public static final CfgPropNumber MOD_KNOCKBACK = CfgProps.addConfig(new CfgPropNumber("Knockback", 1.0), CAT_ATTRIBUTE);
    public static final CfgPropBoolean BOSS_HEALTH = CfgProps.addConfig(new CfgPropBoolean("Boss Mod Health", false), CAT_ATTRIBUTE);
    public static final CfgPropBoolean BOSS_DAMAGE = CfgProps.addConfig(new CfgPropBoolean("Boss Mod Damage", false), CAT_ATTRIBUTE);
    public static final CfgPropBoolean BOSS_SPEED = CfgProps.addConfig(new CfgPropBoolean("Boss Mod Speed", false), CAT_ATTRIBUTE);
    public static final CfgPropBoolean BOSS_KNOCKBACK = CfgProps.addConfig(new CfgPropBoolean("Boss Mod Knockback", false), CAT_ATTRIBUTE);
    public static final CfgPropBoolean DEBUG_TARGET = CfgProps.addConfig(new CfgPropBoolean("Debug Targets", false));

    public static <T extends CfgProperty> T addConfig(T cfg) {
        ALL_CFGS.add(cfg);
        return cfg;
    }

    public static <T extends CfgProperty> T addConfig(T cfg, CfgCategory cat) {
        ALL_CFGS.add(cfg.setCategory(cat));
        return cfg;
    }

    public static void resetAllConfigs() {
        ALL_CFGS.forEach(CfgProperty::resetDef);
    }
}

