/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config;

import com.google.gson.JsonObject;
import funwayguy.epicsiegemod.config.EsmJsonConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EsmConfig {
    private static final Map<String, EsmJsonConfig> DIM_MAP = new HashMap<String, EsmJsonConfig>();
    private static final EsmJsonConfig DIM_DEFAULT = new EsmJsonConfig();

    public static EsmJsonConfig getConfig(@Nullable String dim) {
        return dim == null ? DIM_DEFAULT : DIM_MAP.getOrDefault(dim, DIM_DEFAULT);
    }

    public static void loadDimConfig(@Nonnull String dim, @Nonnull JsonObject json) {
        DIM_MAP.computeIfAbsent(dim, key -> EsmConfig.createFromDefault()).readJson(json);
    }

    private static EsmJsonConfig createFromDefault() {
        return DIM_DEFAULT.copyInto(new EsmJsonConfig());
    }
}

