/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config;

import com.google.gson.JsonObject;
import funwayguy.epicsiegemod.config.CfgCategory;
import funwayguy.epicsiegemod.config.EsmConfig;
import funwayguy.epicsiegemod.config.EsmJsonConfig;
import funwayguy.epicsiegemod.config.props.CfgProps;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CfgProperty<T> {
    private final String key;
    private CfgCategory cat;
    private final Function<JsonObject, T> funcGet;
    private final BiConsumer<JsonObject, T> funcSet;
    private final T def;

    public CfgProperty(String key, T def, Function<JsonObject, T> funcGet, BiConsumer<JsonObject, T> funcSet) {
        this(key, CfgProps.CAT_ROOT, def, funcGet, funcSet);
    }

    public CfgProperty(String key, CfgCategory cat, T def, Function<JsonObject, T> funcGet, BiConsumer<JsonObject, T> funcSet) {
        this.cat = cat;
        this.key = key;
        this.def = def;
        this.funcGet = funcGet;
        this.funcSet = funcSet;
    }

    public CfgProperty<T> setCategory(@Nonnull CfgCategory cat) {
        this.cat = cat;
        return this;
    }

    public String getKeyName() {
        return this.key;
    }

    public T get(@Nonnull Entity entity) {
        EntityEntry ee = EntityRegistry.getEntry(entity.getClass());
        return ee == null || ee.getRegistryName() == null ? this.def : this.get(ee.getRegistryName(), "dim_" + entity.field_70170_p.field_73011_w.getDimension());
    }

    @Deprecated
    public T get(@Nullable ResourceLocation idName) {
        return this.get(idName, null);
    }

    public T get(@Nullable ResourceLocation idName, @Nullable String dim) {
        JsonObject conf = EsmConfig.getConfig(dim).get(idName);
        return conf == null ? this.def : this.funcGet.apply(conf);
    }

    public void set(@Nonnull Entity entity, T value) {
        EntityEntry ee = EntityRegistry.getEntry(entity.getClass());
        if (ee != null && ee.getRegistryName() != null) {
            this.set(ee.getRegistryName(), "dim_" + entity.field_70170_p.field_73011_w.getDimension(), value);
        }
    }

    @Deprecated
    public void set(@Nullable ResourceLocation idName, T value) {
        this.set(idName, null, value);
    }

    public void set(@Nullable ResourceLocation idName, @Nullable String dim, T value) {
        EsmJsonConfig dimConfig = EsmConfig.getConfig(dim);
        JsonObject conf = dimConfig.getOrCreate(idName);
        if (conf != null) {
            this.funcSet.accept(conf, (JsonObject)value);
        }
    }

    public void setDef(T value) {
        this.set(null, null, value);
    }

    public void resetDef() {
        this.setDef(this.def);
    }
}

