/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import funwayguy.epicsiegemod.config.EsmConfig;
import funwayguy.epicsiegemod.config.JsonHelper;
import funwayguy.epicsiegemod.core.ESM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CfgCategory {
    public final String catKey;
    private final CfgCategory catParent;
    private List<String> parCache;

    public CfgCategory(@Nullable String catKey) {
        this(catKey, null);
    }

    public CfgCategory(@Nullable String catKey, @Nullable CfgCategory catParent) {
        this.catKey = catKey;
        this.catParent = catParent;
    }

    public JsonObject findProperty(Entity entity, String key) {
        EntityEntry ee = EntityRegistry.getEntry(entity.getClass());
        return ee == null || ee.getRegistryName() == null ? this.findProperty(null, null, key) : this.findProperty(ee.getRegistryName(), "dim_" + entity.field_70170_p.field_73011_w.getDimension(), key);
    }

    @Nullable
    public JsonObject findProperty(@Nullable ResourceLocation idName, @Nullable String dim, String key) {
        JsonObject[] opts = new JsonObject[4];
        opts[3] = EsmConfig.getConfig(dim).get(idName);
        opts[2] = EsmConfig.getConfig(dim).get(null);
        opts[1] = EsmConfig.getConfig(null).get(idName);
        opts[0] = EsmConfig.getConfig(null).get(null);
        if (this.parCache == null) {
            if (this.catParent == null) {
                this.parCache = Collections.emptyList();
            } else {
                this.parCache = new ArrayList<String>();
                CfgCategory cat = this;
                while (cat != null) {
                    this.parCache.add(cat.catKey);
                    cat = cat.catParent;
                }
            }
        }
        block1: for (int i = opts.length - 1; i >= 0; --i) {
            if (opts[i] == null) continue;
            JsonObject subCat = opts[i];
            for (int j = this.parCache.size() - 1; j >= 0; --j) {
                String s = this.parCache.get(j);
                if (!subCat.has(s)) continue block1;
                subCat = JsonHelper.getObject(subCat, s);
            }
            if (!subCat.has(key)) continue;
            return subCat;
        }
        StringBuilder sb = new StringBuilder("Failed to find key: root");
        for (int j = this.parCache.size() - 1; j >= 0; --j) {
            sb.append(" > ").append(this.parCache.get(j));
        }
        sb.append(" > ").append(key);
        ESM.logger.warn(sb.toString());
        return null;
    }

    public JsonObject getOrCreate(@Nullable ResourceLocation idName, @Nullable String dim) {
        if (this.parCache == null) {
            if (this.catKey == null) {
                this.parCache = Collections.emptyList();
            } else {
                this.parCache = new ArrayList<String>();
                CfgCategory cat = this;
                while (cat != null) {
                    this.parCache.add(cat.catKey);
                    cat = cat.catParent;
                }
            }
        }
        JsonObject subCat = EsmConfig.getConfig(dim).getOrCreate(idName);
        for (int j = this.parCache.size() - 1; j >= 0; --j) {
            String s = this.parCache.get(j);
            if (!subCat.has(s)) {
                JsonObject json = new JsonObject();
                subCat.add(s, (JsonElement)json);
                subCat = json;
                continue;
            }
            subCat = JsonHelper.getObject(subCat, s);
        }
        return subCat;
    }
}

