/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai;

import funwayguy.epicsiegemod.config.props.CfgProps;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;

public class ESM_EntityAIAttackMelee
extends EntityAIBase {
    private EntityLiving attacker;
    int attackTick = 0;
    private double speedTowardsTarget;
    private boolean longMemory;
    private Path entityPathEntity;
    private int delayCounter;
    private boolean strafeClockwise;
    private boolean canStrafe;

    public ESM_EntityAIAttackMelee(EntityLiving creature, double speedIn, boolean useLongMemory) {
        this.attacker = creature;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
        this.strafeClockwise = true;
        this.canStrafe = creature.func_70681_au().nextInt(10) != 0;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        float dist = this.attacker.func_70032_d((Entity)target);
        if (--this.delayCounter > 0 || dist <= MathHelper.func_76133_a((double)this.getAtkRangeSq(target))) {
            return true;
        }
        this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)target);
        this.delayCounter = Math.max(4 + this.attacker.func_70681_au().nextInt(7), (int)Math.ceil((double)dist / 8.0) * 10);
        return this.entityPathEntity != null;
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (!this.longMemory && this.attacker.func_70032_d((Entity)target) > (float)((Number)CfgProps.XRAY_VIEW.get((Entity)this.attacker)).intValue()) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (this.attacker instanceof EntityCreature && !((EntityCreature)this.attacker).func_180485_d(target.func_180425_c())) {
            return false;
        }
        return !(target instanceof EntityPlayer) || !((EntityPlayer)target).func_175149_v() && !((EntityPlayer)target).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target instanceof EntityPlayer && (((EntityPlayer)target).func_175149_v() || ((EntityPlayer)target).func_184812_l_())) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return;
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        double distSq = this.attacker.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        float dist = MathHelper.func_76133_a((double)distSq);
        double atkRangeSq = this.getAtkRangeSq(target);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)target)) && this.delayCounter <= 0 && (distSq >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            int pathingPenalty = 0;
            boolean onTarget = false;
            if (this.attacker.func_70661_as().func_75505_d() != null) {
                PathPoint finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c();
                if (finalPathPoint != null && target.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0) {
                    onTarget = true;
                } else {
                    pathingPenalty = (int)Math.ceil((double)dist / 8.0) * 10;
                }
            } else {
                pathingPenalty = (int)Math.ceil((double)dist / 8.0) * 10;
            }
            this.delayCounter += pathingPenalty;
            if (!onTarget && !this.attacker.func_70661_as().func_75497_a((Entity)target, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
            if (this.delayCounter >= 60) {
                this.delayCounter = 60;
            }
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.canStrafe && ((Boolean)CfgProps.STRAFE.get((Entity)this.attacker)).booleanValue() && this.attackTick > 0 && dist < 2.0f && this.attacker.func_70685_l((Entity)target)) {
            this.attacker.func_70605_aq().func_188488_a(0.5f, this.strafeClockwise ? 0.5f : -0.5f);
            this.attacker.func_70625_a((Entity)target, 30.0f, 30.0f);
        }
        if (distSq <= atkRangeSq && this.attackTick <= 0) {
            this.strafeClockwise = this.attacker.func_70681_au().nextBoolean();
            this.attackTick = 10 + this.attacker.func_70681_au().nextInt(10);
            this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            if (this.attacker instanceof EntityAnimal) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), 1.0f);
            } else {
                this.attacker.func_70652_k((Entity)target);
            }
            this.delayCounter = 0;
        }
    }

    private double getAtkRangeSq(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

